/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSCertificateException;
import gurux.dlms.asn.CertificateVersion;
import gurux.dlms.asn.GXAsn1BitString;
import gurux.dlms.asn.GXAsn1Context;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1ObjectIdentifier;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.asn.enums.GXOid;
import gurux.dlms.asn.enums.PkcsObjectIdentifier;
import gurux.dlms.asn.enums.PkcsType;
import gurux.dlms.asn.enums.X9ObjectIdentifier;
import gurux.dlms.internal.GXCommon;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

public class GXPkcs8 {
    private byte[] rawData;
    private CertificateVersion version;
    private GXOid algorithm;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public GXPkcs8() {
        this.version = CertificateVersion.V1;
        this.algorithm = X9ObjectIdentifier.IdECPublicKey;
    }

    public GXPkcs8(KeyPair keys) {
        this();
        this.privateKey = keys.getPrivate();
        this.publicKey = keys.getPublic();
    }

    public GXPkcs8(byte[] data) {
        this.init(data);
    }

    public GXPkcs8(PrivateKey priv) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this();
        this.privateKey = priv;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(priv.getEncoded());
        KeyFactory kf = KeyFactory.getInstance("EC");
        this.publicKey = kf.generatePublic(keySpec);
    }

    public GXPkcs8(String data) {
        String START = "PRIVATE KEY-----\n";
        String END = "-----END";
        String tmp = data.replace("\r\n", "\n");
        int start = tmp.indexOf("PRIVATE KEY-----\n");
        if (start == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        int end = tmp.indexOf("-----END");
        if (end == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        this.init(GXCommon.fromBase64(tmp.substring(start + "PRIVATE KEY-----\n".length(), end)));
    }

    public static GXPkcs8 fromPem(String data) {
        String START = "PRIVATE KEY-----\n";
        String END = "-----END";
        String tmp = data.replace("\r\n", "\n");
        int start = tmp.indexOf("PRIVATE KEY-----\n");
        if (start == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        int end = tmp.indexOf("-----END");
        if (end == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        return GXPkcs8.fromDer(tmp.substring(start + "PRIVATE KEY-----\n".length(), end));
    }

    public static GXPkcs8 fromDer(String data) {
        GXPkcs8 cert = new GXPkcs8();
        cert.init(GXCommon.fromBase64(data));
        return cert;
    }

    private void init(byte[] data) {
        KeyFactory eckf;
        List tmp;
        GXAsn1Sequence seq;
        block15: {
            this.rawData = data;
            seq = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(data);
            if (seq.size() < 3) {
                throw new IllegalArgumentException("Wrong number of elements in sequence.");
            }
            if (!(seq.get(0) instanceof Byte)) {
                PkcsType type = GXAsn1Converter.getCertificateType(data, seq);
                switch (type) {
                    case PKCS_10: {
                        throw new GXDLMSCertificateException("Invalid Certificate. This is PKCS 10 certification requests, not PKCS 8.");
                    }
                    case x509_CERTIFICATE: {
                        throw new GXDLMSCertificateException("Invalid Certificate. This is PKCS x509 certificate, not PKCS 8.");
                    }
                }
                throw new GXDLMSCertificateException("Invalid Certificate Version.");
            }
            this.version = CertificateVersion.forValue(((Number)seq.get(0)).intValue());
            tmp = (List)seq.get(1);
            this.algorithm = X9ObjectIdentifier.forValue(tmp.get(0).toString());
            if (this.algorithm == null) {
                this.algorithm = PkcsObjectIdentifier.forValue(tmp.get(0).toString());
            }
            try {
                String name = this.algorithm.toString().toLowerCase();
                if (name.contains("rsa")) {
                    eckf = KeyFactory.getInstance("RSA");
                    break block15;
                }
                if (name.endsWith("ecdsa")) {
                    eckf = KeyFactory.getInstance("EC");
                    break block15;
                }
                if (name.contains("ec")) {
                    eckf = KeyFactory.getInstance("EC");
                    break block15;
                }
                throw new IllegalStateException("Unknown algorithm:" + this.algorithm.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(this.algorithm.toString().substring(0, 2) + "key factory not present in runtime");
            }
        }
        try {
            PKCS8EncodedKeySpec ecpks = new PKCS8EncodedKeySpec(data, tmp.get(0).toString());
            this.privateKey = eckf.generatePrivate(ecpks);
            tmp = (List)seq.get(2);
            this.privateKey = GXAsn1Converter.getPrivateKey((byte[])tmp.get(1));
            if (tmp.size() > 2) {
                tmp = (List)tmp.get(2);
                GXByteBuffer tmp2 = new GXByteBuffer();
                tmp2.set(((GXAsn1BitString)tmp.get(0)).getValue());
                this.publicKey = GXAsn1Converter.getPublicKey(tmp2.subArray(1, tmp2.size() - 1));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final CertificateVersion getVersion() {
        return this.version;
    }

    public final void setVersion(CertificateVersion value) {
        this.version = value;
    }

    public final GXOid getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(GXOid value) {
        this.algorithm = value;
    }

    public final String toString() {
        StringBuilder bb = new StringBuilder();
        bb.append("PKCS #8:");
        bb.append("\r\n");
        bb.append("Version: ");
        bb.append(this.version.toString());
        bb.append("\r\n");
        bb.append("Algorithm: ");
        if (this.algorithm != null) {
            bb.append(this.algorithm.toString());
        }
        bb.append("\r\n");
        return bb.toString();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public static GXPkcs8 load(Path path) throws IOException {
        return GXPkcs8.fromPem(Files.readString(path));
    }

    public void save(Path path) throws IOException {
        Files.write(path, this.toPem().getBytes(), StandardOpenOption.CREATE);
    }

    public String toPem() {
        StringBuilder sb = new StringBuilder();
        if (this.privateKey == null) {
            throw new IllegalArgumentException("Private key is not set.");
        }
        sb.append("-----BEGIN PRIVATE KEY-----");
        sb.append(System.lineSeparator());
        sb.append(this.toDer());
        sb.append(System.lineSeparator());
        sb.append("-----END PRIVATE KEY-----");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public String toDer() {
        if (this.rawData != null) {
            return GXCommon.toBase64(this.rawData);
        }
        GXAsn1Sequence d = new GXAsn1Sequence();
        d.add(this.version.getValue());
        GXAsn1Sequence d1 = new GXAsn1Sequence();
        d1.add(new GXAsn1ObjectIdentifier(this.algorithm.getValue()));
        d1.add(new GXAsn1ObjectIdentifier("1.2.840.10045.3.1.7"));
        d.add(d1);
        GXAsn1Sequence d2 = new GXAsn1Sequence();
        d2.add((byte)1);
        d2.add(GXAsn1Converter.rawValue(this.privateKey));
        GXAsn1Context d3 = new GXAsn1Context();
        d3.setIndex(1);
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(4);
        bb.set(GXAsn1Converter.rawValue(this.publicKey));
        d3.add(new GXAsn1BitString(bb.array(), 0));
        d2.add(d3);
        d.add(GXAsn1Converter.toByteArray(d2));
        return GXCommon.toBase64(GXAsn1Converter.toByteArray(d));
    }
}

