/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn.enums;

import java.util.HashSet;
import java.util.Set;

public enum KeyUsage {
    NONE(0),
    DIGITAL_SIGNATURE(1),
    NON_REPUDIATION(2),
    KEY_ENCIPHERMENT(4),
    DATA_ENCIPHERMENT(8),
    KEY_AGREEMENT(16),
    KEY_CERT_SIGN(32),
    CRL_SIGN(64),
    ENCIPHER_ONLY(128),
    DECIPHER_ONLY(256);

    private int value;

    private KeyUsage(int forValue) {
        this.value = forValue;
    }

    public int getValue() {
        return this.value;
    }

    private static KeyUsage[] getEnumConstants() {
        return new KeyUsage[]{DIGITAL_SIGNATURE, NON_REPUDIATION, KEY_ENCIPHERMENT, DATA_ENCIPHERMENT, KEY_AGREEMENT, KEY_CERT_SIGN, CRL_SIGN, ENCIPHER_ONLY, DECIPHER_ONLY};
    }

    public static Set<KeyUsage> forValue(int value) {
        HashSet<KeyUsage> types = new HashSet<KeyUsage>();
        KeyUsage[] enums = KeyUsage.getEnumConstants();
        for (int pos = 0; pos != enums.length; ++pos) {
            if ((enums[pos].value & value) != enums[pos].value) continue;
            types.add(enums[pos]);
        }
        return types;
    }

    public static int toInteger(Set<KeyUsage> value) {
        int tmp = 0;
        for (KeyUsage it : value) {
            tmp |= it.getValue();
        }
        return tmp;
    }
}

