/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.internal;

import gurux.dlms.GXArray;
import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXCryptoKeyParameter;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDate;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXEnum;
import gurux.dlms.GXStructure;
import gurux.dlms.GXTime;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt64;
import gurux.dlms.GXUInt8;
import gurux.dlms.enums.ClockStatus;
import gurux.dlms.enums.CryptoKeyType;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.DateTimeExtraInfo;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.Standard;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.SecuritySuite;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public final class GXCommon {
    private static String zeroes = "00000000000000000000000000000000";
    private static char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] BASE_64_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};
    public static final byte[] LLC_SEND_BYTES = new byte[]{-26, -26, 0};
    public static final byte[] LLC_REPLY_BYTES = new byte[]{-26, -25, 0};
    static final int CONTENTS_DESCRIPTION = 65384;
    static final int ARRAY_CONTENTS = 65385;
    static final int DATA_TYPE_OFFSET = 0xFF0000;

    private GXCommon() {
    }

    public static byte[] getBytes(String value) {
        if (value == null) {
            return new byte[0];
        }
        return value.getBytes(StandardCharsets.US_ASCII);
    }

    private static byte getValue(byte c) {
        byte value = -1;
        if (c > 47 && c < 58) {
            value = (byte)(c - 48);
        } else if (c > 64 && c < 71) {
            value = (byte)(c - 65 + 10);
        } else if (c > 96 && c < 103) {
            value = (byte)(c - 97 + 10);
        }
        return value;
    }

    private static boolean isHex(byte c) {
        return GXCommon.getValue(c) != -1;
    }

    public static byte[] hexToBytes(String value) {
        if (value == null || value.length() == 0) {
            return new byte[0];
        }
        int len = value.length() / 2;
        if (value.length() % 2 != 0) {
            ++len;
        }
        byte[] buffer = new byte[len];
        int lastValue = -1;
        int index = 0;
        for (byte ch : value.getBytes()) {
            if (GXCommon.isHex(ch)) {
                if (lastValue == -1) {
                    lastValue = GXCommon.getValue(ch);
                    continue;
                }
                if (lastValue == -1) continue;
                buffer[index] = (byte)(lastValue << 4 | GXCommon.getValue(ch));
                lastValue = -1;
                ++index;
                continue;
            }
            if (lastValue != -1 && ch == 32) {
                buffer[index] = GXCommon.getValue(ch);
                lastValue = -1;
                ++index;
                continue;
            }
            lastValue = -1;
        }
        if (lastValue != -1) {
            buffer[index] = (byte)lastValue;
            ++index;
        }
        if (buffer.length == index) {
            return buffer;
        }
        byte[] tmp = new byte[index];
        System.arraycopy(buffer, 0, tmp, 0, index);
        return tmp;
    }

    public static String toHex(byte[] bytes) {
        return GXCommon.toHex(bytes, true);
    }

    public static String toHex(byte[] bytes, boolean addSpace) {
        if (bytes == null) {
            return "";
        }
        return GXCommon.toHex(bytes, addSpace, 0, bytes.length);
    }

    public static String toHex(byte[] bytes, boolean addSpace, int index, int count) {
        if (bytes == null || bytes.length == 0 || count == 0) {
            return "";
        }
        char[] str = addSpace ? new char[count * 3] : new char[count * 2];
        int len = 0;
        for (int pos = 0; pos != count; ++pos) {
            int tmp = bytes[index + pos] & 0xFF;
            str[len] = hexArray[tmp >>> 4];
            str[++len] = hexArray[tmp & 0xF];
            ++len;
            if (!addSpace) continue;
            str[len] = 32;
            ++len;
        }
        if (addSpace) {
            --len;
        }
        return new String(str, 0, len);
    }

    public static boolean isHexString(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        for (int pos = 0; pos != value.length(); ++pos) {
            char ch = value.charAt(pos);
            if (ch == ' ' || ch > '@' && ch < 'G' || ch > '`' && ch < 'g' || ch > '/' && ch < ':') continue;
            return false;
        }
        return true;
    }

    public static String toBase64(byte[] value) {
        StringBuilder str = new StringBuilder(value.length * 4 / 3);
        for (int pos = 0; pos < value.length; pos += 3) {
            int b = (value[pos] & 0xFC) >> 2;
            str.append(BASE_64_ARRAY[b]);
            b = (value[pos] & 3) << 4;
            if (pos + 1 < value.length) {
                str.append(BASE_64_ARRAY[b |= (value[pos + 1] & 0xF0) >> 4]);
                b = (value[pos + 1] & 0xF) << 2;
                if (pos + 2 < value.length) {
                    str.append(BASE_64_ARRAY[b |= (value[pos + 2] & 0xC0) >> 6]);
                    b = value[pos + 2] & 0x3F;
                    str.append(BASE_64_ARRAY[b]);
                    continue;
                }
                str.append(BASE_64_ARRAY[b]);
                str.append('=');
                continue;
            }
            str.append(BASE_64_ARRAY[b]);
            str.append("==");
        }
        return str.toString();
    }

    private static int getIndex(char ch) {
        if (ch == '+') {
            return 62;
        }
        if (ch == '/') {
            return 63;
        }
        if (ch == '=') {
            return 64;
        }
        if (ch < ':') {
            return 52 + (ch - 48);
        }
        if (ch < '[') {
            return ch - 65;
        }
        if (ch < '{') {
            return 26 + (ch - 97);
        }
        throw new IllegalArgumentException("fromBase64");
    }

    public static byte[] fromBase64(String input) {
        String tmp = input.replace("\r\n", "").replace("\n", "");
        if (tmp.length() % 4 != 0) {
            throw new IllegalArgumentException("Invalid base64 input");
        }
        int len = tmp.length() * 3 / 4;
        int pos = tmp.indexOf(61);
        if (pos > 0) {
            len -= tmp.length() - pos;
        }
        byte[] decoded = new byte[len];
        char[] inChars = new char[4];
        int j = 0;
        int[] b = new int[4];
        for (pos = 0; pos != tmp.length(); pos += 4) {
            tmp.getChars(pos, pos + 4, inChars, 0);
            b[0] = GXCommon.getIndex(inChars[0]);
            b[1] = GXCommon.getIndex(inChars[1]);
            b[2] = GXCommon.getIndex(inChars[2]);
            b[3] = GXCommon.getIndex(inChars[3]);
            decoded[j++] = (byte)(b[0] << 2 | b[1] >> 4);
            if (b[2] >= 64) continue;
            decoded[j++] = (byte)(b[1] << 4 | b[2] >> 2);
            if (b[3] >= 64) continue;
            decoded[j++] = (byte)(b[2] << 6 | b[3]);
        }
        return decoded;
    }

    public static int intValue(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).intValue() & 0xFF;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue() & 0xFFFF;
        }
        return ((Number)value).intValue();
    }

    public static void insertObjectCount(int count, GXByteBuffer buff, int index) {
        if (count < 128) {
            buff.move(index, index + 1, buff.size());
            buff.size(buff.size() - index);
            buff.setUInt8(index, (byte)count);
        } else if (count < 256) {
            buff.move(index, index + 2, buff.size());
            buff.size(buff.size() - index);
            buff.setUInt8(index, 129);
            buff.setUInt8(index + 1, (byte)count);
        } else if (count < 65536) {
            buff.move(index, index + 4, buff.size());
            buff.size(buff.size() - index);
            buff.setUInt8(index, 130);
            buff.setUInt16(index + 1, count);
        } else {
            buff.move(index, index + 5, buff.size());
            buff.size(buff.size() - index);
            buff.setUInt8(index, 132);
            buff.setUInt32(index + 1, count);
        }
    }

    public static int getObjectCount(GXByteBuffer data) {
        short cnt = data.getUInt8();
        if (cnt > 128) {
            if (cnt == 129) {
                return data.getUInt8();
            }
            if (cnt == 130) {
                return data.getUInt16();
            }
            if (cnt == 131) {
                return data.getUInt24();
            }
            if (cnt == 132) {
                return (int)data.getUInt32();
            }
            throw new IllegalArgumentException("Invalid count.");
        }
        return cnt;
    }

    public static int getObjectCountSizeInBytes(int count) {
        if (count < 128) {
            return 1;
        }
        if (count < 256) {
            return 2;
        }
        if (count < 65536) {
            return 3;
        }
        return 5;
    }

    public static void addString(String value, GXByteBuffer bb) {
        bb.setUInt8((byte)DataType.OCTET_STRING.getValue());
        if (value == null) {
            GXCommon.setObjectCount(0, bb);
        } else {
            GXCommon.setObjectCount(value.length(), bb);
            bb.set(value.getBytes());
        }
    }

    public static byte setObjectCount(int count, GXByteBuffer buff) {
        if (count < 128) {
            buff.setUInt8(count);
            return 1;
        }
        if (count < 256) {
            buff.setUInt8(129);
            buff.setUInt8(count);
            return 2;
        }
        if (count < 65536) {
            buff.setUInt8(130);
            buff.setUInt16(count);
            return 3;
        }
        buff.setUInt8(132);
        buff.setUInt32(count);
        return 5;
    }

    public static boolean compare(byte[] arr1, byte[] arr2) {
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int pos = 0; pos != arr2.length; ++pos) {
            if (arr1[pos] == arr2[pos]) continue;
            return false;
        }
        return true;
    }

    public static void toBitString(StringBuilder sb, byte value, int count) {
        int count2 = count;
        if (count2 > 0) {
            if (count2 > 8) {
                count2 = 8;
            }
            for (int pos = 7; pos != 8 - count2 - 1; --pos) {
                if ((value & 1 << pos) != 0) {
                    sb.append('1');
                    continue;
                }
                sb.append('0');
            }
        }
    }

    public static Object getData(GXDLMSSettings settings, GXByteBuffer data, GXDataInfo info) {
        boolean knownType;
        Object value = null;
        int startIndex = data.position();
        if (data.position() == data.size()) {
            info.setComplete(false);
            return null;
        }
        info.setComplete(true);
        boolean bl = knownType = info.getType() != DataType.NONE;
        if (!knownType) {
            info.setType(DataType.forValue(data.getUInt8()));
        }
        if (info.getType() == DataType.NONE) {
            if (info.getXml() != null) {
                info.getXml().appendLine("<" + info.getXml().getDataType(info.getType()) + " />");
            }
            return value;
        }
        if (data.position() == data.size()) {
            info.setComplete(false);
            return null;
        }
        switch (info.getType()) {
            case ARRAY: 
            case STRUCTURE: {
                value = GXCommon.getArray(settings, data, info, startIndex);
                break;
            }
            case BOOLEAN: {
                value = GXCommon.getBoolean(data, info);
                break;
            }
            case BITSTRING: {
                value = GXCommon.getBitString(data, info);
                break;
            }
            case INT32: {
                value = GXCommon.getInt32(data, info);
                break;
            }
            case UINT32: {
                value = GXCommon.getUInt32(settings, data, info);
                break;
            }
            case STRING: {
                value = GXCommon.getString(data, info, knownType);
                break;
            }
            case STRING_UTF8: {
                value = GXCommon.getUtfString(data, info, knownType);
                break;
            }
            case OCTET_STRING: {
                value = GXCommon.getOctetString(settings, data, info, knownType);
                break;
            }
            case BCD: {
                value = GXCommon.getBcd(data, info);
                break;
            }
            case INT8: {
                value = GXCommon.getInt8(data, info);
                break;
            }
            case INT16: {
                value = GXCommon.getInt16(data, info);
                break;
            }
            case UINT8: {
                value = GXCommon.getUInt8(settings, data, info);
                break;
            }
            case UINT16: {
                value = GXCommon.getUInt16(settings, data, info);
                break;
            }
            case COMPACT_ARRAY: {
                value = GXCommon.getCompactArray(settings, data, info);
                break;
            }
            case INT64: {
                value = GXCommon.getInt64(data, info);
                break;
            }
            case UINT64: {
                value = GXCommon.getUInt64(settings, data, info);
                break;
            }
            case ENUM: {
                value = GXCommon.getEnum(data, info);
                break;
            }
            case FLOAT32: {
                value = GXCommon.getFloat(data, info);
                break;
            }
            case FLOAT64: {
                value = GXCommon.getDouble(data, info);
                break;
            }
            case DATETIME: {
                value = GXCommon.getDateTime(settings, data, info);
                break;
            }
            case DATE: {
                value = GXCommon.getDate(data, info);
                break;
            }
            case TIME: {
                value = GXCommon.getTime(data, info);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type.");
            }
        }
        return value;
    }

    public static String integerToHex(Object value, int desimals) {
        long tmp = value instanceof Byte ? (long)((Byte)value & 0xFF) : (value instanceof Short ? (long)((Short)value & 0xFFFF) : (value instanceof Long ? (Long)value & 0xFFFFFFFFFFFFFFFFL : (value instanceof GXUInt8 ? (long)(((GXUInt8)value).byteValue() & 0xFF) : (value instanceof GXUInt16 ? (long)(((GXUInt16)value).shortValue() & 0xFFFF) : (value instanceof GXUInt32 ? ((GXUInt32)value).longValue() & 0xFFFFFFFFFFFFFFFFL : ((Number)value).longValue())))));
        String str = Long.toString(tmp, 16).toUpperCase();
        if (desimals == 0 || str.length() >= desimals || str.length() == zeroes.length()) {
            return str;
        }
        return zeroes.substring(0, desimals - str.length()) + str;
    }

    public static String integerString(Object value, int desimals) {
        String str = Long.toString(((Number)value).longValue());
        if (desimals == 0 || str.length() == zeroes.length()) {
            return str;
        }
        return zeroes.substring(0, desimals - str.length()) + str;
    }

    private static Object getArray(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info, int index) {
        int pos;
        if (info.getCount() == 0) {
            info.setCount(GXCommon.getObjectCount(buff));
        }
        if (info.getXml() != null) {
            info.getXml().appendStartTag(info.getXml().getDataType(info.getType()), "Qty", info.getXml().integerToHex(info.getCount(), 2));
        }
        int size = buff.size() - buff.position();
        if (info.getCount() != 0 && size < 1) {
            info.setComplete(false);
            return null;
        }
        int startIndex = index;
        ArrayList arr = info.getType() == DataType.ARRAY ? new GXArray() : new GXStructure();
        for (pos = info.getIndex(); pos != info.getCount(); ++pos) {
            GXDataInfo info2 = new GXDataInfo();
            info2.setXml(info.getXml());
            Object tmp = GXCommon.getData(settings, buff, info2);
            if (!info2.isComplete()) {
                buff.position(startIndex);
                info.setComplete(false);
                break;
            }
            if (info2.getCount() != info2.getIndex()) continue;
            startIndex = buff.position();
            arr.add(tmp);
        }
        if (info.getXml() != null) {
            info.getXml().appendEndTag(info.getXml().getDataType(info.getType()));
        }
        info.setIndex(pos);
        return arr;
    }

    private static Object getTime(GXByteBuffer buff, GXDataInfo info) {
        String str;
        GXTime value;
        block6: {
            value = null;
            if (buff.size() - buff.position() < 4) {
                info.setComplete(false);
                return null;
            }
            str = null;
            if (info.getXml() != null) {
                str = GXCommon.toHex(buff.getData(), false, buff.position(), 4);
            }
            try {
                GXTime dt;
                short hour = buff.getUInt8();
                short minute = buff.getUInt8();
                short second = buff.getUInt8();
                int ms = buff.getUInt8();
                ms = ms != 255 ? (ms *= 10) : -1;
                value = dt = new GXTime(hour, minute, second, ms);
            }
            catch (Exception ex) {
                if (info.getXml() != null) break block6;
                throw ex;
            }
        }
        if (info.getXml() != null) {
            if (value != null) {
                info.getXml().appendComment(String.valueOf(value));
            }
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, str);
        }
        return value;
    }

    private static Object getDate(GXByteBuffer buff, GXDataInfo info) {
        String str;
        GXDate value;
        block17: {
            value = null;
            if (buff.size() - buff.position() < 5) {
                info.setComplete(false);
                return null;
            }
            str = null;
            if (info.getXml() != null) {
                str = GXCommon.toHex(buff.getData(), false, buff.position(), 5);
            }
            try {
                GXDate dt;
                int year = buff.getUInt16();
                short month = buff.getUInt8();
                HashSet<DateTimeExtraInfo> extra = new HashSet<DateTimeExtraInfo>();
                HashSet<DateTimeSkips> skip = new HashSet<DateTimeSkips>();
                if (month == 0 || month == 255) {
                    month = 1;
                    skip.add(DateTimeSkips.MONTH);
                } else if (month == 254) {
                    month = 1;
                    extra.add(DateTimeExtraInfo.DST_BEGIN);
                } else if (month == 253) {
                    month = 1;
                    extra.add(DateTimeExtraInfo.DST_END);
                }
                short day = buff.getUInt8();
                if (day == 253) {
                    day = 1;
                    extra.add(DateTimeExtraInfo.LAST_DAY2);
                } else if (day == 254) {
                    day = 1;
                    extra.add(DateTimeExtraInfo.LAST_DAY);
                } else if (day < 1 || day == 255) {
                    day = 1;
                    skip.add(DateTimeSkips.DAY);
                }
                value = dt = new GXDate(year, month, day);
                dt.setExtra(extra);
                dt.getSkip().addAll(skip);
                if (buff.getUInt8() == 255) {
                    dt.getSkip().add(DateTimeSkips.DAY_OF_WEEK);
                }
            }
            catch (Exception ex) {
                if (info.getXml() != null) break block17;
                throw ex;
            }
        }
        if (info.getXml() != null) {
            if (value != null) {
                info.getXml().appendComment(String.valueOf(value));
            }
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, str);
        }
        return value;
    }

    public static int daysInMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1);
        return cal.getActualMaximum(5);
    }

    private static Object getDateTime(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info) {
        GXDateTime dt;
        String str;
        GXDateTime value;
        block34: {
            value = null;
            HashSet<DateTimeSkips> skip = new HashSet<DateTimeSkips>();
            if (buff.size() - buff.position() < 12) {
                info.setComplete(false);
                return null;
            }
            str = null;
            if (info.getXml() != null) {
                str = GXCommon.toHex(buff.getData(), false, buff.position(), 12);
            }
            dt = new GXDateTime();
            try {
                boolean ignoreDeviation;
                Calendar tm;
                int year = buff.getUInt16();
                int month = buff.getUInt8();
                if (month == 0 || month == 255) {
                    month = 1;
                    skip.add(DateTimeSkips.MONTH);
                } else if (month == 254) {
                    month = 1;
                    dt.getExtra().add(DateTimeExtraInfo.DST_BEGIN);
                } else if (month == 253) {
                    month = 1;
                    dt.getExtra().add(DateTimeExtraInfo.DST_END);
                }
                short day = buff.getUInt8();
                if (day == 253) {
                    day = 1;
                    dt.getExtra().add(DateTimeExtraInfo.LAST_DAY2);
                } else if (day == 254) {
                    day = 1;
                    dt.getExtra().add(DateTimeExtraInfo.LAST_DAY);
                } else if (day < 1 || day == 255) {
                    day = 1;
                    skip.add(DateTimeSkips.DAY);
                }
                short dayOfWeek = buff.getUInt8();
                if (dayOfWeek == 255) {
                    skip.add(DateTimeSkips.DAY_OF_WEEK);
                } else {
                    dt.setDayOfWeek(dayOfWeek);
                }
                short hour = buff.getUInt8();
                short minute = buff.getUInt8();
                short second = buff.getUInt8();
                int ms = buff.getUInt8() & 0xFF;
                ms = ms != 255 ? (ms *= 10) : -1;
                short deviation = buff.getInt16();
                if (deviation == Short.MIN_VALUE) {
                    skip.add(DateTimeSkips.DEVIATION);
                }
                short status = buff.getUInt8();
                dt.setStatus(ClockStatus.forValue(status));
                if (year < 1 || year == 65535) {
                    skip.add(DateTimeSkips.YEAR);
                    tm = Calendar.getInstance();
                    year = tm.get(1);
                }
                if (month != 254 && month != 253) {
                    if (month < 1 || month > 12) {
                        skip.add(DateTimeSkips.MONTH);
                        month = 0;
                    } else {
                        --month;
                    }
                }
                if (day != 254 && day != 253 && (day == -1 || day == 0 || day > 31)) {
                    skip.add(DateTimeSkips.DAY);
                    day = 1;
                }
                if (hour < 0 || hour > 24) {
                    skip.add(DateTimeSkips.HOUR);
                    hour = 0;
                }
                if (minute < 0 || minute > 60) {
                    skip.add(DateTimeSkips.MINUTE);
                    minute = 0;
                }
                if (second < 0 || second > 60) {
                    skip.add(DateTimeSkips.SECOND);
                    second = 0;
                }
                if (ms < 0 || ms > 1000) {
                    skip.add(DateTimeSkips.MILLISECOND);
                    ms = 0;
                }
                if (settings != null && settings.getUseUtc2NormalTime() && deviation != Short.MIN_VALUE) {
                    deviation = -deviation;
                }
                boolean bl = ignoreDeviation = deviation == Short.MIN_VALUE;
                if (!ignoreDeviation && settings != null && settings.getDateTimeSkipsOnRead().contains((Object)DateTimeSkips.DEVIATION)) {
                    ignoreDeviation = true;
                }
                if (ignoreDeviation) {
                    tm = Calendar.getInstance();
                } else {
                    TimeZone tz = GXDateTime.getTimeZone(-deviation, dt.getStatus().contains((Object)ClockStatus.DAYLIGHT_SAVE_ACTIVE));
                    tm = Calendar.getInstance(tz);
                }
                tm.set(year, month, day, hour, minute, second);
                if (skip.contains((Object)DateTimeSkips.MILLISECOND)) {
                    tm.set(14, 0);
                } else {
                    tm.set(14, ms);
                }
                dt.setMeterCalendar(tm);
                dt.getSkip().addAll(skip);
                value = dt;
            }
            catch (Exception ex) {
                if (info.getXml() != null) break block34;
                throw ex;
            }
        }
        if (info.getXml() != null) {
            if (!dt.getSkip().contains((Object)DateTimeSkips.YEAR) && value != null) {
                info.getXml().appendComment(String.valueOf(value));
            }
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, str);
        }
        return value;
    }

    private static Object getDouble(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 8) {
            info.setComplete(false);
            return null;
        }
        Double value = buff.getDouble();
        if (info.getXml() != null) {
            if (info.getXml().isComments()) {
                info.getXml().appendComment(String.format("%.2f", value));
            }
            GXByteBuffer tmp = new GXByteBuffer();
            GXCommon.setData(null, tmp, DataType.FLOAT64, value);
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, GXCommon.toHex(tmp.getData(), false, 1, tmp.size() - 1));
        }
        return value;
    }

    private static Object getFloat(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 4) {
            info.setComplete(false);
            return null;
        }
        Float value = Float.valueOf(buff.getFloat());
        if (info.getXml() != null) {
            if (info.getXml().isComments()) {
                info.getXml().appendComment(String.format("%.2f", value));
            }
            GXByteBuffer tmp = new GXByteBuffer();
            GXCommon.setData(null, tmp, DataType.FLOAT32, value);
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, GXCommon.toHex(tmp.getData(), false, 1, tmp.size() - 1));
        }
        return value;
    }

    private static Object getEnum(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 1) {
            info.setComplete(false);
            return null;
        }
        Short value = buff.getUInt8();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 2));
        }
        return new GXEnum(value.shortValue());
    }

    private static Object getUInt64(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 8) {
            info.setComplete(false);
            return null;
        }
        BigInteger value = buff.getUInt64();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 16));
        }
        if (settings == null || settings.getVersion() == 3) {
            return value;
        }
        return new GXUInt64(value);
    }

    private static Object getInt64(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 8) {
            info.setComplete(false);
            return null;
        }
        Long value = buff.getInt64();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 16));
        }
        return value;
    }

    private static Object getUInt16(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 2) {
            info.setComplete(false);
            return null;
        }
        Integer value = buff.getUInt16();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 4));
        }
        if (settings == null || settings.getVersion() == 3) {
            return value;
        }
        return new GXUInt16(value);
    }

    private static void getCompactArrayItem(GXDLMSSettings settings, GXByteBuffer buff, List<?> dt, List<Object> list, int len) {
        ArrayList<Object> tmp2 = new ArrayList<Object>();
        for (Object it : dt) {
            if (it instanceof DataType) {
                GXCommon.getCompactArrayItem(settings, buff, (DataType)((Object)it), tmp2, 1);
                continue;
            }
            GXCommon.getCompactArrayItem(settings, buff, (List)it, tmp2, 1);
        }
        list.add(tmp2.toArray());
    }

    private static void getCompactArrayItem(GXDLMSSettings settings, GXByteBuffer buff, DataType dt, List<Object> list, int len) {
        GXDataInfo tmp = new GXDataInfo();
        tmp.setType(dt);
        int start = buff.position();
        if (dt == DataType.STRING) {
            while (buff.position() - start < len) {
                tmp.clear();
                tmp.setType(dt);
                list.add(GXCommon.getString(buff, tmp, false));
                if (tmp.isComplete()) continue;
                break;
            }
        } else if (dt == DataType.OCTET_STRING) {
            while (buff.position() - start < len) {
                tmp.clear();
                tmp.setType(dt);
                list.add(GXCommon.getOctetString(settings, buff, tmp, false));
                if (tmp.isComplete()) continue;
                break;
            }
        } else {
            while (buff.position() - start < len) {
                tmp.clear();
                tmp.setType(dt);
                list.add(GXCommon.getData(settings, buff, tmp));
                if (tmp.isComplete()) continue;
                break;
            }
        }
    }

    private static void getDataTypes(GXByteBuffer buff, List<Object> cols, int len) {
        for (int pos = 0; pos != len; ++pos) {
            DataType dt = DataType.forValue(buff.getUInt8());
            if (dt == DataType.ARRAY) {
                int cnt = buff.getUInt16();
                ArrayList<Object> tmp = new ArrayList<Object>();
                ArrayList<Object> tmp2 = new ArrayList<Object>();
                GXCommon.getDataTypes(buff, tmp, 1);
                for (int i = 0; i != cnt; ++i) {
                    tmp2.addAll(tmp);
                }
                cols.add(tmp2);
                continue;
            }
            if (dt == DataType.STRUCTURE) {
                ArrayList<Object> tmp = new ArrayList<Object>();
                GXCommon.getDataTypes(buff, tmp, buff.getUInt8());
                cols.add(tmp.toArray(new Object[tmp.size()]));
                continue;
            }
            cols.add((Object)dt);
        }
    }

    private static void appendDataTypeAsXml(List<?> cols, GXDataInfo info) {
        for (Object it : cols) {
            if (it instanceof DataType) {
                info.getXml().appendEmptyTag(info.getXml().getDataType((DataType)((Object)it)));
                continue;
            }
            if (it instanceof GXStructure) {
                info.getXml().appendStartTag(0xFF0000 + DataType.STRUCTURE.getValue(), null, null);
                GXCommon.appendDataTypeAsXml((List)it, info);
                info.getXml().appendEndTag(0xFF0000 + DataType.STRUCTURE.getValue());
                continue;
            }
            if (!(it instanceof GXArray)) continue;
            info.getXml().appendStartTag(0xFF0000 + DataType.ARRAY.getValue(), null, null);
            GXCommon.appendDataTypeAsXml((List)it, info);
            info.getXml().appendEndTag(0xFF0000 + DataType.ARRAY.getValue());
        }
    }

    private static Object getCompactArray(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 2) {
            info.setComplete(false);
            return null;
        }
        DataType dt = DataType.forValue(buff.getUInt8());
        if (dt == DataType.ARRAY) {
            throw new IllegalArgumentException("Invalid compact array data.");
        }
        int len = GXCommon.getObjectCount(buff);
        ArrayList<Object> list = new ArrayList<Object>();
        if (dt == DataType.STRUCTURE) {
            GXStructure cols = new GXStructure();
            GXCommon.getDataTypes(buff, cols, len);
            len = GXCommon.getObjectCount(buff);
            if (info.getXml() != null) {
                info.getXml().appendStartTag(info.getXml().getDataType(DataType.COMPACT_ARRAY), null, null);
                info.getXml().appendStartTag(65384);
                GXCommon.appendDataTypeAsXml(cols, info);
                info.getXml().appendEndTag(65384);
                if (info.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML) {
                    info.getXml().appendStartTag(65385, true);
                    info.getXml().append(buff.remainingHexString(true));
                    info.getXml().appendEndTag(65385, true);
                    info.getXml().appendEndTag(info.getXml().getDataType(DataType.COMPACT_ARRAY));
                } else {
                    info.getXml().appendStartTag(65385);
                }
            }
            int n = buff.position();
            while (buff.position() - n < len) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int pos = 0; pos != cols.size(); ++pos) {
                    if (cols.get(pos) instanceof GXStructure) {
                        GXCommon.getCompactArrayItem(settings, buff, (List)cols.get(pos), row, 1);
                    } else if (cols.get(pos) instanceof GXArray) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        GXCommon.getCompactArrayItem(settings, buff, (List)cols.get(pos), arrayList, 1);
                        row.add((List)arrayList.get(0));
                    } else {
                        GXCommon.getCompactArrayItem(settings, buff, (DataType)((Object)cols.get(pos)), row, 1);
                    }
                    if (buff.position() == buff.size()) break;
                }
                if (row.size() < cols.size()) break;
                list.add(row);
            }
            if (info.getXml() != null && info.getXml().getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                StringBuilder sb = new StringBuilder();
                for (Object e : list) {
                    for (Object it : (List)e) {
                        if (it instanceof byte[]) {
                            sb.append(GXCommon.toHex((byte[])it));
                        } else if (it instanceof List) {
                            for (Object it2 : (List)it) {
                                if (it2 instanceof byte[]) {
                                    sb.append(GXCommon.toHex((byte[])it2));
                                } else {
                                    sb.append(String.valueOf(it2));
                                }
                                sb.append(";");
                            }
                            if (!((List)it).isEmpty()) {
                                sb.setLength(sb.length() - 1);
                            }
                        } else {
                            sb.append(String.valueOf(it));
                        }
                        sb.append(";");
                    }
                    if (sb.length() != 0) {
                        sb.setLength(sb.length() - 1);
                    }
                    info.getXml().appendLine(sb.toString());
                    sb.setLength(0);
                }
            }
            if (info.getXml() != null && info.getXml().getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                info.getXml().appendEndTag(65385);
                info.getXml().appendEndTag(info.getXml().getDataType(DataType.COMPACT_ARRAY));
            }
            return list;
        }
        if (info.getXml() != null) {
            info.getXml().appendStartTag(info.getXml().getDataType(DataType.COMPACT_ARRAY), null, null);
            info.getXml().appendStartTag(65384);
            info.getXml().appendEmptyTag(info.getXml().getDataType(dt));
            info.getXml().appendEndTag(65384);
            info.getXml().appendStartTag(65385, true);
            if (info.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML) {
                info.getXml().append(buff.remainingHexString(false));
                info.getXml().appendEndTag(65385, true);
                info.getXml().appendEndTag(info.getXml().getDataType(DataType.COMPACT_ARRAY));
            }
        }
        GXCommon.getCompactArrayItem(settings, buff, dt, list, len);
        if (info.getXml() != null && info.getXml().getOutputType() == TranslatorOutputType.SIMPLE_XML) {
            for (Object e : list) {
                if (e instanceof byte[]) {
                    info.getXml().append(GXCommon.toHex((byte[])e));
                } else {
                    info.getXml().append(String.valueOf(e));
                }
                info.getXml().append(";");
            }
            if (!list.isEmpty()) {
                info.getXml().setXmlLength(info.getXml().getXmlLength() - 1);
            }
            info.getXml().appendEndTag(65385, true);
            info.getXml().appendEndTag(info.getXml().getDataType(DataType.COMPACT_ARRAY));
        }
        return list;
    }

    private static Object getUInt8(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 1) {
            info.setComplete(false);
            return null;
        }
        int value = buff.getUInt8() & 0xFF;
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 2));
        }
        if (settings == null || settings.getVersion() == 3) {
            return value;
        }
        return new GXUInt8((short)value);
    }

    private static Object getInt16(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 2) {
            info.setComplete(false);
            return null;
        }
        Short value = buff.getInt16();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 4));
        }
        return value;
    }

    private static Object getInt8(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 1) {
            info.setComplete(false);
            return null;
        }
        Byte value = buff.getInt8();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 2));
        }
        return value;
    }

    private static Object getBcd(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 1) {
            info.setComplete(false);
            return null;
        }
        short value = buff.getUInt8();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 2));
        }
        return value;
    }

    private static Object getUtfString(GXByteBuffer buff, GXDataInfo info, boolean knownType) {
        String value;
        int len;
        if (knownType) {
            len = buff.size();
        } else {
            len = GXCommon.getObjectCount(buff);
            if (buff.size() - buff.position() < len) {
                info.setComplete(false);
                return null;
            }
        }
        if (len > 0) {
            value = buff.getString(buff.position(), len, "UTF-8");
            buff.position(buff.position() + len);
        } else {
            value = "";
        }
        if (info.getXml() != null) {
            if (info.getXml().getShowStringAsHex()) {
                info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, GXCommon.toHex(buff.getData(), false, buff.position() - len, len));
            } else {
                info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, value.toString());
            }
        }
        return value;
    }

    private static Object getOctetString(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info, boolean knownType) {
        int len;
        if (knownType) {
            len = buff.size();
        } else {
            len = GXCommon.getObjectCount(buff);
            if (buff.size() - buff.position() < len) {
                info.setComplete(false);
                return null;
            }
        }
        byte[] tmp = new byte[len];
        buff.get(tmp);
        byte[] value = tmp;
        if (info.getXml() != null) {
            if (info.getXml().isComments() && tmp.length != 0) {
                if (tmp.length == 6 && tmp[5] == -1) {
                    info.getXml().appendComment(GXCommon.toLogicalName(tmp));
                } else {
                    boolean isString = true;
                    if (tmp.length == 12 || tmp.length == 5 || tmp.length == 4) {
                        try {
                            DataType type = tmp.length == 12 ? DataType.DATETIME : (tmp.length == 5 ? DataType.DATE : DataType.TIME);
                            boolean useUtc = settings != null ? settings.getUseUtc2NormalTime() : false;
                            GXDateTime dt = (GXDateTime)GXDLMSClient.changeType(tmp, type, useUtc);
                            int year = dt.getMeterCalendar().get(1);
                            if (year > 1970 && year < 2100) {
                                info.getXml().appendComment(dt.toString());
                                isString = false;
                            }
                        }
                        catch (Exception e) {
                            isString = true;
                        }
                    }
                    if (isString) {
                        for (byte it : tmp) {
                            if (it >= 32 && it <= 126) continue;
                            isString = false;
                            break;
                        }
                        if (isString) {
                            info.getXml().appendComment(new String(tmp));
                        }
                    }
                }
            }
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, GXCommon.toHex(tmp, false));
        }
        return value;
    }

    private static String getString(GXByteBuffer buff, GXDataInfo info, boolean knownType) {
        int len;
        if (knownType) {
            len = buff.size();
        } else {
            len = GXCommon.getObjectCount(buff);
            if (buff.size() - buff.position() < len) {
                info.setComplete(false);
                return null;
            }
        }
        String value = len > 0 ? buff.getString(len) : "";
        if (info.getXml() != null) {
            if (info.getXml().getShowStringAsHex()) {
                info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, GXCommon.toHex(buff.getData(), false, buff.position() - len, len));
            } else {
                info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, value);
            }
        }
        return value;
    }

    private static Object getUInt32(GXDLMSSettings settings, GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 4) {
            info.setComplete(false);
            return null;
        }
        long value = buff.getUInt32();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 8));
        }
        if (settings == null || settings.getVersion() == 3) {
            return value;
        }
        return new GXUInt32(value);
    }

    private static Object getInt32(GXByteBuffer buff, GXDataInfo info) {
        if (buff.size() - buff.position() < 4) {
            info.setComplete(false);
            return null;
        }
        Integer value = buff.getInt32();
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, info.getXml().integerToHex(value, 8));
        }
        return value;
    }

    private static GXBitString getBitString(GXByteBuffer buff, GXDataInfo info) {
        int cnt = GXCommon.getObjectCount(buff);
        double t = cnt;
        t /= 8.0;
        if (cnt % 8 != 0) {
            t += 1.0;
        }
        int byteCnt = (int)Math.floor(t);
        if (buff.size() - buff.position() < byteCnt) {
            info.setComplete(false);
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (cnt > 0) {
            GXCommon.toBitString(sb, buff.getInt8(), cnt);
            cnt -= 8;
        }
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, sb.toString());
        }
        return new GXBitString(sb.toString());
    }

    private static Object getBoolean(GXByteBuffer buff, GXDataInfo info) {
        boolean value;
        if (buff.size() - buff.position() < 1) {
            info.setComplete(false);
            return null;
        }
        boolean bl = value = buff.getUInt8() != 0;
        if (info.getXml() != null) {
            info.getXml().appendLine(info.getXml().getDataType(info.getType()), null, String.valueOf(value));
        }
        return value;
    }

    public static int getHDLCAddress(GXByteBuffer buff) {
        int size = 0;
        for (int pos = buff.position(); pos != buff.size(); ++pos) {
            ++size;
            if ((buff.getUInt8(pos) & 1) == 1) break;
        }
        if (size == 1) {
            return (byte)((buff.getUInt8() & 0xFE) >>> 1);
        }
        if (size == 2) {
            size = buff.getUInt16();
            size = (size & 0xFE) >>> 1 | (size & 0xFE00) >>> 2;
            return size;
        }
        if (size == 4) {
            long tmp = buff.getUInt32();
            tmp = (tmp & 0xFEL) >> 1 | (tmp & 0xFE00L) >> 2 | (tmp & 0xFE0000L) >> 3 | (tmp & 0xFFFFFFFFFE000000L) >> 4;
            return (int)tmp;
        }
        throw new IllegalArgumentException("Wrong size.");
    }

    public static void setData(GXDLMSSettings settings, GXByteBuffer buff, DataType dataType, Object value) {
        if (value instanceof Enum) {
            throw new IllegalArgumentException("Value can't be enum. Give integer value.");
        }
        if ((dataType == DataType.ARRAY || dataType == DataType.STRUCTURE) && value instanceof byte[]) {
            buff.set((byte[])value);
            return;
        }
        buff.setUInt8(dataType.getValue());
        switch (dataType) {
            case NONE: {
                break;
            }
            case BOOLEAN: {
                if (Boolean.parseBoolean(value.toString())) {
                    buff.setUInt8(1);
                    break;
                }
                buff.setUInt8(0);
                break;
            }
            case INT8: 
            case UINT8: 
            case ENUM: {
                buff.setUInt8(((Number)value).byteValue());
                break;
            }
            case INT16: 
            case UINT16: {
                buff.setUInt16(((Number)value).shortValue());
                break;
            }
            case INT32: 
            case UINT32: {
                buff.setUInt32(((Number)value).intValue());
                break;
            }
            case INT64: 
            case UINT64: {
                buff.setUInt64(((Number)value).longValue());
                break;
            }
            case FLOAT32: {
                buff.setFloat(((Number)value).floatValue());
                break;
            }
            case FLOAT64: {
                buff.setDouble(((Number)value).doubleValue());
                break;
            }
            case BITSTRING: {
                GXCommon.setBitString(buff, value, true);
                break;
            }
            case STRING: {
                GXCommon.setString(buff, value);
                break;
            }
            case STRING_UTF8: {
                GXCommon.setUtfString(buff, value);
                break;
            }
            case OCTET_STRING: {
                if (value instanceof GXDate) {
                    buff.setUInt8(5);
                    GXCommon.setDate(settings, buff, value);
                    break;
                }
                if (value instanceof GXTime) {
                    buff.setUInt8(4);
                    GXCommon.setTime(settings, buff, value);
                    break;
                }
                if (value instanceof GXDateTime || value instanceof Date || value instanceof Calendar) {
                    buff.setUInt8(12);
                    GXCommon.setDateTime(settings, buff, value);
                    break;
                }
                GXCommon.setOctetString(buff, value);
                break;
            }
            case ARRAY: 
            case STRUCTURE: {
                GXCommon.setArray(settings, buff, value);
                break;
            }
            case BCD: {
                GXCommon.setBcd(buff, value);
                break;
            }
            case COMPACT_ARRAY: {
                throw new IllegalArgumentException("Invalid data type.");
            }
            case DATETIME: {
                GXCommon.setDateTime(settings, buff, value);
                break;
            }
            case DATE: {
                GXCommon.setDate(settings, buff, value);
                break;
            }
            case TIME: {
                GXCommon.setTime(settings, buff, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type.");
            }
        }
    }

    private static void setTime(GXDLMSSettings settings, GXByteBuffer buff, Object value) {
        Set<Object> skip = new HashSet();
        Calendar tm = Calendar.getInstance();
        if (value instanceof GXDateTime) {
            GXDateTime tmp = (GXDateTime)value;
            tm.setTime(tmp.getMeterCalendar().getTime());
            skip = tmp.getSkip();
        } else if (value instanceof Date) {
            tm.setTime((Date)value);
        } else if (value instanceof Calendar) {
            tm.setTime(((Calendar)value).getTime());
        } else if (value instanceof String) {
            SimpleDateFormat f = new SimpleDateFormat();
            try {
                tm.setTime(f.parse(value.toString()));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid date time value.\r\n" + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid date format.");
        }
        if (settings != null && !settings.getDateTimeSkips().isEmpty()) {
            skip.addAll(settings.getDateTimeSkips());
        }
        if (skip.contains((Object)DateTimeSkips.HOUR)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(11));
        }
        if (skip.contains((Object)DateTimeSkips.MINUTE)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(12));
        }
        if (skip.contains((Object)DateTimeSkips.SECOND)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(13));
        }
        if (skip.contains((Object)DateTimeSkips.MILLISECOND)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(14) / 10);
        }
    }

    private static void setDate(GXDLMSSettings settings, GXByteBuffer buff, Object value) {
        GXDateTime dt;
        if (value instanceof GXDateTime) {
            dt = (GXDateTime)value;
        } else if (value instanceof Date) {
            dt = new GXDateTime((Date)value);
        } else if (value instanceof Calendar) {
            dt = new GXDateTime(((Calendar)value).getTime());
        } else if (value instanceof String) {
            SimpleDateFormat f = new SimpleDateFormat();
            try {
                dt = new GXDateTime(f.parse(String.valueOf(value)));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid date format.");
        }
        Calendar tm = Calendar.getInstance();
        tm.setTime(dt.getMeterCalendar().getTime());
        if (settings != null && !settings.getDateTimeSkips().isEmpty()) {
            dt.getSkip().addAll(settings.getDateTimeSkips());
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.YEAR)) {
            buff.setUInt16(65535);
        } else {
            buff.setUInt16(tm.get(1));
        }
        if (dt.getExtra().contains((Object)DateTimeExtraInfo.DST_BEGIN)) {
            buff.setUInt8(254);
        } else if (dt.getExtra().contains((Object)DateTimeExtraInfo.DST_END)) {
            buff.setUInt8(253);
        } else if (dt.getSkip().contains((Object)DateTimeSkips.MONTH)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(2) + 1);
        }
        if (dt.getExtra().contains((Object)DateTimeExtraInfo.LAST_DAY)) {
            buff.setUInt8(254);
        } else if (dt.getExtra().contains((Object)DateTimeExtraInfo.LAST_DAY2)) {
            buff.setUInt8(253);
        } else if (dt.getSkip().contains((Object)DateTimeSkips.DAY)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(5));
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.DAY_OF_WEEK)) {
            buff.setUInt8(255);
        } else {
            int val = tm.get(7);
            if (val == 1) {
                val = 8;
            }
            buff.setUInt8(val - 1);
        }
    }

    public static GXDateTime getDateTime(Object value) {
        GXDateTime dt;
        if (value instanceof GXDateTime) {
            dt = (GXDateTime)value;
        } else if (value instanceof Date) {
            dt = new GXDateTime((Date)value);
            dt.getSkip().add(DateTimeSkips.MILLISECOND);
        } else if (value instanceof Calendar) {
            dt = new GXDateTime((Calendar)value);
            dt.getSkip().add(DateTimeSkips.MILLISECOND);
        } else if (value instanceof String) {
            SimpleDateFormat f = new SimpleDateFormat();
            try {
                dt = new GXDateTime(f.parse(value.toString()));
                dt.getSkip().add(DateTimeSkips.MILLISECOND);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid date time value." + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid date format.");
        }
        return dt;
    }

    private static void setDateTime(GXDLMSSettings settings, GXByteBuffer buff, Object value) {
        GXDateTime dt = GXCommon.getDateTime(value);
        Calendar tm = dt.getMeterCalendar();
        if (settings != null && !settings.getDateTimeSkips().isEmpty()) {
            dt.getSkip().addAll(settings.getDateTimeSkips());
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.YEAR)) {
            buff.setUInt16(65535);
        } else {
            buff.setUInt16(tm.get(1));
        }
        if (dt.getExtra().contains((Object)DateTimeExtraInfo.DST_BEGIN)) {
            buff.setUInt8(254);
        } else if (dt.getExtra().contains((Object)DateTimeExtraInfo.DST_END)) {
            buff.setUInt8(253);
        } else if (dt.getSkip().contains((Object)DateTimeSkips.MONTH)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(2) + 1);
        }
        if (dt.getExtra().contains((Object)DateTimeExtraInfo.LAST_DAY)) {
            buff.setUInt8(254);
        } else if (dt.getExtra().contains((Object)DateTimeExtraInfo.LAST_DAY2)) {
            buff.setUInt8(253);
        } else if (dt.getSkip().contains((Object)DateTimeSkips.DAY)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(5));
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.DAY_OF_WEEK)) {
            buff.setUInt8(255);
        } else if (dt.getDayOfWeek() == 0) {
            int val = tm.get(7);
            if (val == 1) {
                val = 8;
            }
            buff.setUInt8(val - 1);
        } else {
            buff.setUInt8(dt.getDayOfWeek());
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.HOUR)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(11));
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.MINUTE)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(12));
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.SECOND)) {
            buff.setUInt8(255);
        } else {
            buff.setUInt8(tm.get(13));
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.MILLISECOND)) {
            buff.setUInt8(255);
        } else {
            int ms = tm.get(14);
            if (ms != 0) {
                ms /= 10;
            }
            buff.setUInt8(ms);
        }
        if (dt.getSkip().contains((Object)DateTimeSkips.DEVIATION)) {
            buff.setUInt16(32768);
        } else {
            int deviation = (dt.getMeterCalendar().get(15) + dt.getMeterCalendar().get(16)) / 60000;
            if (settings != null && settings.getUseUtc2NormalTime()) {
                buff.setUInt16(deviation);
            } else {
                buff.setUInt16(-deviation);
            }
        }
        if (!dt.getSkip().contains((Object)DateTimeSkips.STATUS)) {
            if (dt.getMeterCalendar().getTimeZone().inDaylightTime(dt.getMeterCalendar().getTime()) || dt.getStatus().contains((Object)ClockStatus.DAYLIGHT_SAVE_ACTIVE)) {
                buff.setUInt8(ClockStatus.toInteger(dt.getStatus()) | ClockStatus.DAYLIGHT_SAVE_ACTIVE.getValue());
            } else {
                buff.setUInt8(ClockStatus.toInteger(dt.getStatus()));
            }
        } else {
            buff.setUInt8(255);
        }
    }

    private static void setBcd(GXByteBuffer buff, Object value) {
        buff.setUInt8(((Number)value).byteValue());
    }

    private static void setArray(GXDLMSSettings settings, GXByteBuffer buff, Object value) {
        if (value != null) {
            ArrayList<Object> arr;
            if (value instanceof List) {
                arr = (ArrayList<Object>)value;
            } else {
                ArrayList<Object> tmp = new ArrayList<Object>();
                tmp.addAll(Arrays.asList((Object[])value));
                arr = tmp;
            }
            int len = arr.size();
            GXCommon.setObjectCount(len, buff);
            for (Object e : arr) {
                GXCommon.setData(settings, buff, GXDLMSConverter.getDLMSDataType(e), e);
            }
        } else {
            GXCommon.setObjectCount(0, buff);
        }
    }

    public static List<String> split(String str, char[] separators) {
        int lastPos = 0;
        ArrayList<String> arr = new ArrayList<String>();
        block0: for (int pos = 0; pos != str.length(); ++pos) {
            char ch = str.charAt(pos);
            for (char sep : separators) {
                if (ch != sep) continue;
                if (lastPos != pos) {
                    arr.add(str.substring(lastPos, pos));
                }
                lastPos = pos + 1;
                continue block0;
            }
        }
        if (lastPos != str.length()) {
            arr.add(str.substring(lastPos, str.length()));
        }
        return arr;
    }

    public static List<String> split(String str, char separator) {
        ArrayList<String> arr = new ArrayList<String>();
        int pos = 0;
        int lastPos = 0;
        while ((pos = str.indexOf(separator, lastPos)) != -1) {
            arr.add(str.substring(lastPos, pos));
            lastPos = pos + 1;
        }
        if (str.length() > lastPos) {
            arr.add(str.substring(lastPos));
        } else {
            arr.add("");
        }
        return arr;
    }

    public static List<String> split(String str, String separator) {
        ArrayList<String> arr = new ArrayList<String>();
        int pos = 0;
        int lastPos = 0;
        while ((pos = str.indexOf(separator, lastPos)) != -1) {
            arr.add(str.substring(lastPos, pos));
            lastPos = pos + separator.length();
        }
        if (str.length() > lastPos) {
            arr.add(str.substring(lastPos));
        } else {
            arr.add("");
        }
        return arr;
    }

    private static void setOctetString(GXByteBuffer buff, Object value) {
        if (value instanceof String) {
            byte[] tmp = GXCommon.hexToBytes((String)value);
            GXCommon.setObjectCount(tmp.length, buff);
            buff.set(tmp);
        } else if (value instanceof byte[]) {
            GXCommon.setObjectCount(((byte[])value).length, buff);
            buff.set((byte[])value);
        } else if (value == null) {
            GXCommon.setObjectCount(0, buff);
        } else {
            throw new IllegalArgumentException("Invalid data type.");
        }
    }

    private static void setUtfString(GXByteBuffer buff, Object value) {
        if (value != null) {
            byte[] tmp = String.valueOf(value).getBytes(StandardCharsets.UTF_8);
            GXCommon.setObjectCount(tmp.length, buff);
            buff.set(tmp);
        } else {
            buff.setUInt8(0);
        }
    }

    private static void setString(GXByteBuffer buff, Object value) {
        if (value != null) {
            String str = String.valueOf(value);
            GXCommon.setObjectCount(str.length(), buff);
            buff.set(GXCommon.getBytes(str));
        } else {
            buff.setUInt8(0);
        }
    }

    public static void setBitString(GXByteBuffer buff, Object val1, boolean addCount) {
        Object value = val1;
        if (value instanceof GXBitString) {
            value = ((GXBitString)value).getValue();
        }
        if (value instanceof String) {
            int val = 0;
            String str = (String)value;
            if (addCount) {
                GXCommon.setObjectCount(str.length(), buff);
            }
            int index = 7;
            for (int pos = 0; pos != str.length(); ++pos) {
                char it = str.charAt(pos);
                if (it == '1') {
                    val = (byte)(val | (byte)(1 << index));
                } else if (it != '0') {
                    throw new IllegalArgumentException("Not a bit string.");
                }
                if (--index != -1) continue;
                index = 7;
                buff.setUInt8(val);
                val = 0;
            }
            if (index != 7) {
                buff.setUInt8(val);
            }
        } else if (value instanceof byte[]) {
            byte[] arr = (byte[])value;
            GXCommon.setObjectCount(8 * arr.length, buff);
            buff.set(arr);
        } else if (value instanceof Byte) {
            GXCommon.setObjectCount(8, buff);
            buff.setUInt8(((Byte)value).byteValue());
        } else if (value == null) {
            buff.setUInt8(0);
        } else {
            throw new IllegalArgumentException("BitString must give as string.");
        }
    }

    public static int getDataTypeSize(DataType type) {
        int size = -1;
        switch (type) {
            case BCD: {
                size = 1;
                break;
            }
            case BOOLEAN: {
                size = 1;
                break;
            }
            case DATE: {
                size = 5;
                break;
            }
            case DATETIME: {
                size = 12;
                break;
            }
            case ENUM: {
                size = 1;
                break;
            }
            case FLOAT32: {
                size = 4;
                break;
            }
            case FLOAT64: {
                size = 8;
                break;
            }
            case INT16: {
                size = 2;
                break;
            }
            case INT32: {
                size = 4;
                break;
            }
            case INT64: {
                size = 8;
                break;
            }
            case INT8: {
                size = 1;
                break;
            }
            case NONE: {
                size = 0;
                break;
            }
            case TIME: {
                size = 4;
                break;
            }
            case UINT16: {
                size = 2;
                break;
            }
            case UINT32: {
                size = 4;
                break;
            }
            case UINT64: {
                size = 8;
                break;
            }
            case UINT8: {
                size = 1;
                break;
            }
        }
        return size;
    }

    public static String toLogicalName(Object value) {
        if (value instanceof byte[]) {
            byte[] buff = (byte[])value;
            if (buff.length == 0) {
                buff = new byte[6];
            }
            if (buff.length == 6) {
                return (buff[0] & 0xFF) + "." + (buff[1] & 0xFF) + "." + (buff[2] & 0xFF) + "." + (buff[3] & 0xFF) + "." + (buff[4] & 0xFF) + "." + (buff[5] & 0xFF);
            }
            throw new IllegalArgumentException("Invalid Logical name.");
        }
        return (String)value;
    }

    public static byte[] logicalNameToBytes(String value) {
        if (value == null || value.length() == 0) {
            return new byte[6];
        }
        List<String> items = GXCommon.split(value, '.');
        if (items.size() != 6) {
            throw new IllegalArgumentException("Invalid Logical name.");
        }
        byte[] buff = new byte[6];
        int pos = 0;
        for (String it : items) {
            int v = Integer.parseInt(it);
            if (v < 0 || v > 255) {
                throw new IllegalArgumentException("Invalid Logical name.");
            }
            buff[pos] = (byte)v;
            pos = (byte)(pos + 1);
        }
        return buff;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        int pos = 0;
        for (Integer it : list) {
            ret[pos] = it;
            ++pos;
        }
        return ret;
    }

    public static short[] toShortArray(List<Short> list) {
        short[] ret = new short[list.size()];
        int pos = 0;
        for (Short it : list) {
            ret[pos] = it;
            ++pos;
        }
        return ret;
    }

    public static Date getGeneralizedTime(String dateString) {
        int second = 0;
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(4, 6)) - 1;
        int day = Integer.parseInt(dateString.substring(6, 8));
        int hour = Integer.parseInt(dateString.substring(8, 10));
        int minute = Integer.parseInt(dateString.substring(10, 12));
        if (dateString.endsWith("Z")) {
            if (dateString.length() > 13) {
                second = Integer.parseInt(dateString.substring(12, 14));
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.set(year, month, day, hour, minute, second);
            long v = calendar.getTimeInMillis();
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(v);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        if (dateString.length() > 17) {
            second = Integer.parseInt(dateString.substring(12, 14));
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + dateString.substring(dateString.length() - 4, dateString.length())));
        calendar.set(year, month, day, hour, minute, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String generalizedTime(GXDateTime date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(date.getMeterCalendar().getTimeInMillis());
        StringBuilder sb = new StringBuilder();
        sb.append(GXCommon.integerString(calendar.get(1), 4));
        sb.append(GXCommon.integerString(1 + calendar.get(2), 2));
        sb.append(GXCommon.integerString(calendar.get(5), 2));
        sb.append(GXCommon.integerString(calendar.get(11), 2));
        sb.append(GXCommon.integerString(calendar.get(12), 2));
        sb.append(GXCommon.integerString(calendar.get(13), 2));
        sb.append("Z");
        return sb.toString();
    }

    public static boolean isAscii(String value) {
        return StandardCharsets.US_ASCII.newEncoder().canEncode(value);
    }

    public static short swapBits(short value) {
        short ret = 0;
        for (int pos = 0; pos != 8; ++pos) {
            ret = (short)(ret << 1 | value & 1);
            value = (short)(value >> 1);
        }
        return ret;
    }

    public static int encryptManufacturer(String flagName) {
        if (flagName.length() != 3) {
            throw new IllegalArgumentException("Invalid Flag name.");
        }
        int value = flagName.charAt(0) - 64 & 0x1F;
        value <<= 5;
        value += flagName.charAt(0) - 64 & 0x1F;
        value <<= 5;
        return value += flagName.charAt(0) - 64 & 0x1F;
    }

    public static String decryptManufacturer(int value) {
        int tmp = value >> 8 | value << 8;
        char c = (char)((tmp & 0x1F) + 64);
        char c1 = (char)(((tmp >>= 5) & 0x1F) + 64);
        char c2 = (char)(((tmp >>= 5) & 0x1F) + 64);
        return new String(new char[]{c2, c1, c});
    }

    static String idisSystemTitleToString(byte[] st, boolean addComments) {
        StringBuilder sb = new StringBuilder();
        String newline = System.getProperty("line.separator");
        sb.append("IDIS system title:");
        sb.append(newline);
        sb.append("Manufacturer Code: ");
        sb.append(new String(new char[]{(char)st[0], (char)st[1], (char)st[2]}));
        sb.append(newline);
        sb.append(" Function type: ");
        int ft = st[4] >> 4;
        boolean add = false;
        if ((ft & 1) != 0) {
            sb.append("Disconnector");
            add = true;
        }
        if ((ft & 2) != 0) {
            if (add) {
                sb.append(", ");
            }
            add = true;
            sb.append("Load Management");
        }
        if ((ft & 4) != 0) {
            if (add) {
                sb.append(", ");
            }
            sb.append("Multi Utility");
        }
        int sn = (st[4] & 0xF) << 24;
        sn |= st[5] << 16;
        sn |= st[6] << 8;
        sb.append(newline);
        sb.append("Serial number: ");
        sb.append(String.valueOf(sn |= st[7]));
        sb.append(newline);
        return sb.toString();
    }

    static String dlmsSystemTitleToString(byte[] st, boolean addComments) {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(newline);
        sb.append("DLMS system title:");
        sb.append(newline);
        sb.append("Manufacturer Code: ");
        sb.append(new String(new char[]{(char)st[0], (char)st[1], (char)st[2]}));
        sb.append(newline);
        sb.append("Serial number: ");
        sb.append(new String(new char[]{(char)st[3], (char)st[4], (char)st[5], (char)st[6], (char)st[7]}));
        sb.append(newline);
        return sb.toString();
    }

    static String uniSystemTitleToString(byte[] st, boolean addComments) {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        if (addComments) {
            sb.append(newline);
            sb.append("UNI/TS system title:");
            sb.append(newline);
            sb.append("Manufacturer: ");
            int m = st[0] << 8 | st[1];
            sb.append(GXCommon.decryptManufacturer(m));
            sb.append(newline);
            sb.append("Serial number: ");
            sb.append(GXCommon.toHex(new byte[]{st[7], st[6], st[5], st[4], st[3], st[2]}, false));
            sb.append(newline);
        } else {
            int m = st[0] << 8 | st[1];
            sb.append(GXCommon.decryptManufacturer(m));
            sb.append(GXCommon.toHex(new byte[]{st[7], st[6], st[5], st[4], st[3], st[2]}, false));
        }
        return sb.toString();
    }

    private static boolean IsT1(byte value) {
        return value > 98 && value < 104;
    }

    private static boolean IsT2(byte value) {
        return (value & 0xF0) != 0;
    }

    public static String systemTitleToString(Standard standard, byte[] st, boolean addComments) {
        if (st == null || st.length != 8) {
            return "";
        }
        if (!(standard != Standard.ITALY && Character.isLetter(st[0]) && Character.isLetter(st[1]) && Character.isLetter(st[2]))) {
            return GXCommon.uniSystemTitleToString(st, addComments);
        }
        if (standard == Standard.IDIS || GXCommon.IsT1(st[3]) && GXCommon.IsT2(st[4])) {
            return GXCommon.idisSystemTitleToString(st, addComments);
        }
        return GXCommon.dlmsSystemTitleToString(st, addComments);
    }

    public static boolean isCiphered(short cmd) {
        switch (cmd) {
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 76: 
            case 78: 
            case 96: 
            case 97: 
            case 98: 
            case 200: 
            case 201: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 211: 
            case 212: 
            case 213: 
            case 215: 
            case 219: 
            case 220: 
            case 221: 
            case 223: {
                return true;
            }
        }
        return false;
    }

    public static byte[] crypt(GXDLMSSettings settings, CertificateType certificateType, byte[] Data, boolean encrypt, CryptoKeyType keyType, int command, Security security, SecuritySuite securitySuite, long invocationCounter) {
        if (settings.getCryptoNotifier() != null) {
            GXCryptoKeyParameter args = new GXCryptoKeyParameter();
            args.setEncrypt(encrypt);
            args.setKeyType(keyType);
            args.setCommand(command);
            args.setSystemTitle(settings.getCipher().getSystemTitle());
            args.setRecipientSystemTitle(settings.getSourceSystemTitle());
            args.setCertificateType(certificateType);
            args.setInvocationCounter(invocationCounter);
            args.setSecurity(security);
            args.setSecuritySuite(securitySuite);
            args.setSecurityPolicy(settings.getCipher().getSecurityPolicy());
            if (encrypt) {
                args.setPlainText(Data);
            } else {
                args.setEncrypted(Data);
            }
            args.setAuthenticationKey(settings.getCipher().getAuthenticationKey());
            if (settings.getCipher().getDedicatedKey() != null && settings.getCipher().getDedicatedKey().length == 16 && (settings.getConnected() & 2) != 0) {
                args.setBlockCipherKey(settings.getCipher().getDedicatedKey());
            } else {
                args.setBlockCipherKey(settings.getCipher().getBlockCipherKey());
            }
            settings.getCryptoNotifier().onCrypto(settings.getCryptoNotifier(), args);
            if (encrypt) {
                return args.getEncrypted();
            }
            return args.getPlainText();
        }
        return null;
    }
}

