/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.manufacturersettings;

import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.manufacturersettings.GXAuthentication;
import gurux.dlms.manufacturersettings.GXDLMSAttribute;
import gurux.dlms.manufacturersettings.GXDLMSAttributeSettings;
import gurux.dlms.manufacturersettings.GXManufacturer;
import gurux.dlms.manufacturersettings.GXObisCode;
import gurux.dlms.manufacturersettings.GXServerAddress;
import gurux.dlms.manufacturersettings.HDLCAddressType;
import gurux.dlms.manufacturersettings.InactivityMode;
import gurux.dlms.manufacturersettings.StartProtocolType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GXManufacturerCollection
extends ArrayList<GXManufacturer> {
    private static final long serialVersionUID = 1L;

    public final GXManufacturer findByIdentification(String id) {
        for (GXManufacturer it : this) {
            if (it.getIdentification().compareToIgnoreCase(id) != 0) continue;
            return it;
        }
        return null;
    }

    public static boolean isFirstRun(String path) {
        if (!new File(path).isDirectory() && !new File(path).mkdir()) {
            return true;
        }
        File file = new File(path, "files.xml");
        return !file.exists();
    }

    public static boolean isUpdatesAvailable(String path) {
        File file = new File(path, "files.xml");
        if (!file.exists()) {
            return true;
        }
        HashMap<String, Date> installed = new HashMap<String, Date>();
        HashMap<String, Date> available = new HashMap<String, Date>();
        SimpleDateFormat tmFormater = new SimpleDateFormat("MM-dd-yyyy");
        try {
            FileInputStream tmp = new FileInputStream(file);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(tmp);
            String data = "";
            String target = "";
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event == 1) {
                    data = xmlStreamReader.getAttributeValue(0);
                    continue;
                }
                if (event == 4) {
                    target = xmlStreamReader.getText();
                    continue;
                }
                if (event != 2 || data.equals("")) continue;
                installed.put(target, tmFormater.parse(data));
                data = "";
                target = "";
            }
            URL gurux = new URL("https://www.gurux.fi/obis/files.xml");
            URLConnection gx = gurux.openConnection();
            InputStream io = gx.getInputStream();
            xmlStreamReader = inputFactory.createXMLStreamReader(io);
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event == 1) {
                    data = xmlStreamReader.getAttributeValue(0);
                    continue;
                }
                if (event == 4) {
                    target = xmlStreamReader.getText();
                    continue;
                }
                if (event != 2 || data.equals("")) continue;
                available.put(target, tmFormater.parse(data));
                data = "";
                target = "";
            }
        }
        catch (Exception e) {
            return true;
        }
        for (Map.Entry it : available.entrySet()) {
            if (!installed.containsKey(it.getKey())) {
                return true;
            }
            if (((Date)it.getValue()).compareTo((Date)installed.get(it.getKey())) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateManufactureSettings(String directory) {
        File dir = new File(directory);
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        InputStream io = null;
        PrintWriter writer = null;
        XMLStreamReader xmlStreamReader = null;
        InputStreamReader r = null;
        try {
            String line;
            String path = directory + File.separator + "files.xml";
            URL gurux = new URL("https://www.gurux.fi/obis/files.xml");
            URLConnection gx = gurux.openConnection();
            io = gx.getInputStream();
            r = new InputStreamReader(io, "utf-8");
            BufferedReader reader = new BufferedReader(r);
            writer = new PrintWriter(path, "utf-8");
            String target = "";
            String data = "";
            String newline = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(newline);
            }
            r.close();
            writer.close();
            writer = null;
            io.close();
            io = null;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            FileInputStream tmp = new FileInputStream(path);
            xmlStreamReader = inputFactory.createXMLStreamReader(tmp);
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event == 1) {
                    data = "";
                    target = xmlStreamReader.getLocalName();
                    continue;
                }
                if (event == 4) {
                    data = xmlStreamReader.getText();
                    continue;
                }
                if (event != 2) continue;
                if (target.equalsIgnoreCase("file")) {
                    URL f = new URL("https://www.gurux.fi/obis/" + data);
                    URLConnection fc = f.openConnection();
                    BufferedReader in = new BufferedReader(new InputStreamReader(fc.getInputStream()));
                    try {
                        writer = new PrintWriter(directory + File.separator + data, "utf-8");
                        while ((line = in.readLine()) != null) {
                            writer.write(line);
                            writer.write(newline);
                        }
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                            writer = null;
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                target = "";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (io != null) {
                    io.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (writer != null) {
                writer.close();
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
    }

    public static void readManufacturerSettings(GXManufacturerCollection manufacturers, String path) {
        manufacturers.clear();
        File di = new File(path);
        String[] files = di.list();
        if (files != null) {
            for (String it : files) {
                if (!it.endsWith(".obx")) continue;
                try {
                    FileInputStream in = new FileInputStream(path + File.separator + it);
                    manufacturers.add(GXManufacturerCollection.parse(in));
                }
                catch (Exception e) {
                    Logger.getLogger(GXManufacturerCollection.class.getName()).log(Level.SEVERE, e.getMessage());
                }
            }
        }
    }

    private static GXManufacturer parse(InputStream in) throws Exception {
        GXManufacturer man = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(in);
        String target = null;
        String data = null;
        Attributes attributes = new Attributes();
        GXAuthentication authentication = null;
        GXServerAddress serveraddress = null;
        GXObisCode obisCode = null;
        GXDLMSAttributeSettings att = null;
        while (xmlStreamReader.hasNext()) {
            int event = xmlStreamReader.next();
            if (event == 1) {
                attributes.clear();
                data = null;
                target = xmlStreamReader.getLocalName();
                if (target.equalsIgnoreCase("GXManufacturer")) {
                    man = new GXManufacturer();
                } else if (target.equalsIgnoreCase("GXObisCode")) {
                    att = null;
                    obisCode = new GXObisCode();
                    man.getObisCodes().add(obisCode);
                } else if (target.equalsIgnoreCase("GXAuthentication")) {
                    att = null;
                    authentication = new GXAuthentication();
                    man.getSettings().add(authentication);
                } else if (target.equalsIgnoreCase("GXServerAddress")) {
                    serveraddress = new GXServerAddress();
                    man.getServerSettings().add(serveraddress);
                } else if (target.equalsIgnoreCase("GXDLMSAttributeSettings")) {
                    att = new GXDLMSAttribute();
                    obisCode.getAttributes().add(att);
                }
                for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                    attributes.putValue(xmlStreamReader.getAttributeLocalName(i), xmlStreamReader.getAttributeValue(i));
                }
                continue;
            }
            if (event == 4) {
                data = xmlStreamReader.getText();
                continue;
            }
            if (event != 2) continue;
            if (target.equalsIgnoreCase("Identification")) {
                man.setIdentification(data);
            } else if (target.equalsIgnoreCase("Name")) {
                if (att != null) {
                    att.setName(data);
                } else if (authentication != null) {
                    authentication.setName(data);
                } else {
                    man.setName(data);
                }
            } else if (target.equalsIgnoreCase("UseLN")) {
                man.setUseLogicalNameReferencing(Boolean.parseBoolean(data));
            } else if (target.equalsIgnoreCase("UseIEC47")) {
                man.setUseIEC47(Boolean.parseBoolean(data));
            } else if (target.equalsIgnoreCase("ClientID")) {
                if (authentication != null) {
                    authentication.setClientAddress(Integer.parseInt(data));
                }
            } else if (target.equalsIgnoreCase("PhysicalAddress")) {
                if (serveraddress != null) {
                    serveraddress.setPhysicalAddress(Integer.parseInt(data));
                }
            } else if (target.equalsIgnoreCase("LogicalAddress")) {
                if (serveraddress != null) {
                    serveraddress.setLogicalAddress(Integer.parseInt(data));
                }
            } else if (target.equalsIgnoreCase("Formula")) {
                if (serveraddress != null) {
                    serveraddress.setFormula(data);
                }
            } else if (target.equalsIgnoreCase("HDLCAddress")) {
                if (serveraddress != null) {
                    serveraddress.setHDLCAddress(HDLCAddressType.forValue(Integer.parseInt(data)));
                }
            } else {
                if (target.equalsIgnoreCase("Selected")) continue;
                if (target.equalsIgnoreCase("InactivityMode")) {
                    man.setInactivityMode(InactivityMode.valueOf(data.toUpperCase()));
                } else if (target.equalsIgnoreCase("Type")) {
                    if (authentication != null) {
                        authentication.setType(Authentication.valueOfString(data.toUpperCase()));
                    } else if (data.equals("BinaryCodedDesimal")) {
                        att.setType(DataType.BCD);
                    } else if (data.equals("OctetString")) {
                        att.setType(DataType.OCTET_STRING);
                    } else {
                        att.setType(DataType.valueOf(data.toUpperCase()));
                    }
                } else if (target.equalsIgnoreCase("UIType")) {
                    if (data.equals("BinaryCodedDesimal")) {
                        att.setType(DataType.BCD);
                    } else if (data.equals("OctetString")) {
                        att.setType(DataType.OCTET_STRING);
                    } else {
                        att.setUIType(DataType.valueOf(data.toUpperCase()));
                    }
                } else if (target.equalsIgnoreCase("GXAuthentication")) {
                    authentication = null;
                } else if (target.equalsIgnoreCase("LogicalName")) {
                    obisCode.setLogicalName(data);
                } else if (target.equalsIgnoreCase("Description")) {
                    obisCode.setDescription(data);
                } else if (target.equalsIgnoreCase("ObjectType")) {
                    obisCode.setObjectType(ObjectType.forValue(Integer.parseInt(data)));
                } else {
                    if (target.equalsIgnoreCase("Interface")) continue;
                    if (target.equalsIgnoreCase("Index")) {
                        att.setIndex(Integer.parseInt(data));
                    } else if (target.equalsIgnoreCase("StartProtocol")) {
                        man.setStartProtocol(StartProtocolType.valueOf(data.toUpperCase()));
                    } else if (target.equalsIgnoreCase("WebAddress")) {
                        man.setWebAddress(data);
                    } else if (target.equalsIgnoreCase("Info")) {
                        man.setInfo(data);
                    } else {
                        target = "";
                    }
                }
            }
            target = "";
        }
        return man;
    }
}

