/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXCreditChargeConfiguration;
import gurux.dlms.objects.GXCurrency;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXTokenGatewayConfiguration;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.AccountCreditStatus;
import gurux.dlms.objects.enums.AccountStatus;
import gurux.dlms.objects.enums.CreditCollectionConfiguration;
import gurux.dlms.objects.enums.Currency;
import gurux.dlms.objects.enums.PaymentMode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSAccount
extends GXDLMSObject
implements IGXDLMSBase {
    private PaymentMode paymentMode = PaymentMode.CREDIT;
    private AccountStatus accountStatus = AccountStatus.NEW_INACTIVE_ACCOUNT;
    private byte currentCreditInUse;
    private AccountCreditStatus currentCreditStatus;
    private int availableCredit;
    private int amountToClear;
    private int clearanceThreshold;
    private int aggregatedDebt;
    private List<String> creditReferences = new ArrayList<String>();
    private List<String> chargeReferences = new ArrayList<String>();
    private List<GXCreditChargeConfiguration> creditChargeConfigurations = new ArrayList<GXCreditChargeConfiguration>();
    private List<GXTokenGatewayConfiguration> tokenGatewayConfigurations = new ArrayList<GXTokenGatewayConfiguration>();
    private GXDateTime accountActivationTime;
    private GXDateTime accountClosureTime;
    private GXCurrency currency = new GXCurrency();
    private int lowCreditThreshold;
    private int nextCreditAvailableThreshold;
    private int maxProvision;
    private int maxProvisionPeriod;

    public final byte[][] activate(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    public final byte[][] close(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 2, 0, DataType.INT8);
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 3, 0, DataType.INT8);
    }

    public GXDLMSAccount() {
        this("0.0.19.0.0.255", 0);
    }

    public GXDLMSAccount(String ln) {
        this(ln, 0);
    }

    public GXDLMSAccount(String ln, int sn) {
        super(ObjectType.ACCOUNT, ln, sn);
        this.currentCreditStatus = AccountCreditStatus.IN_CREDIT;
    }

    public final PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public final void setPaymentMode(PaymentMode value) {
        this.paymentMode = value;
    }

    public final AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public final void setAccountStatus(AccountStatus value) {
        this.accountStatus = value;
    }

    public final byte getCurrentCreditInUse() {
        return this.currentCreditInUse;
    }

    public final void setCurrentCreditInUse(byte value) {
        this.currentCreditInUse = value;
    }

    public final AccountCreditStatus getCurrentCreditStatus() {
        return this.currentCreditStatus;
    }

    public final void setCurrentCreditStatus(AccountCreditStatus value) {
        this.currentCreditStatus = value;
    }

    public final int getAvailableCredit() {
        return this.availableCredit;
    }

    public final void setAvailableCredit(int value) {
        this.availableCredit = value;
    }

    public final int getAmountToClear() {
        return this.amountToClear;
    }

    public final void setAmountToClear(int value) {
        this.amountToClear = value;
    }

    public final int getClearanceThreshold() {
        return this.clearanceThreshold;
    }

    public final void setClearanceThreshold(int value) {
        this.clearanceThreshold = value;
    }

    public final int getAggregatedDebt() {
        return this.aggregatedDebt;
    }

    public final void setAggregatedDebt(int value) {
        this.aggregatedDebt = value;
    }

    public final List<String> getCreditReferences() {
        return this.creditReferences;
    }

    public final void setCreditReferences(List<String> value) {
        this.creditReferences = value;
    }

    public final List<String> getChargeReferences() {
        return this.chargeReferences;
    }

    public final void setChargeReferences(List<String> value) {
        this.chargeReferences = value;
    }

    public final List<GXCreditChargeConfiguration> getCreditChargeConfigurations() {
        return this.creditChargeConfigurations;
    }

    public final void setCreditChargeConfigurations(List<GXCreditChargeConfiguration> value) {
        this.creditChargeConfigurations = value;
    }

    public final List<GXTokenGatewayConfiguration> getTokenGatewayConfigurations() {
        return this.tokenGatewayConfigurations;
    }

    public final void setTokenGatewayConfigurations(List<GXTokenGatewayConfiguration> value) {
        this.tokenGatewayConfigurations = value;
    }

    public final GXDateTime getAccountActivationTime() {
        return this.accountActivationTime;
    }

    public final void setAccountActivationTime(GXDateTime value) {
        this.accountActivationTime = value;
    }

    public final GXDateTime getAccountClosureTime() {
        return this.accountClosureTime;
    }

    public final void setAccountClosureTime(GXDateTime value) {
        this.accountClosureTime = value;
    }

    public final GXCurrency getCurrency() {
        return this.currency;
    }

    public final void setCurrency(GXCurrency value) {
        this.currency = value;
    }

    public final int getLowCreditThreshold() {
        return this.lowCreditThreshold;
    }

    public final void setLowCreditThreshold(int value) {
        this.lowCreditThreshold = value;
    }

    public final int getNextCreditAvailableThreshold() {
        return this.nextCreditAvailableThreshold;
    }

    public final void setNextCreditAvailableThreshold(int value) {
        this.nextCreditAvailableThreshold = value;
    }

    public final int getMaxProvision() {
        return this.maxProvision;
    }

    public final void setMaxProvision(int value) {
        this.maxProvision = value;
    }

    public final int getMaxProvisionPeriod() {
        return this.maxProvisionPeriod;
    }

    public final void setMaxProvisionPeriod(int value) {
        this.maxProvisionPeriod = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), new Object[]{this.paymentMode, this.accountStatus}, this.currentCreditInUse, this.currentCreditStatus, this.availableCredit, this.amountToClear, this.clearanceThreshold, this.aggregatedDebt, this.creditReferences, this.chargeReferences, this.creditChargeConfigurations, this.tokenGatewayConfigurations, this.accountActivationTime, this.accountClosureTime, this.currency, this.lowCreditThreshold, this.nextCreditAvailableThreshold, this.maxProvision, this.maxProvisionPeriod};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.accountStatus = AccountStatus.ACTIVE;
        } else if (e.getIndex() == 2) {
            this.accountStatus = AccountStatus.CLOSED;
        } else if (e.getIndex() != 3) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (all || this.canRead(13)) {
            attributes.add(13);
        }
        if (all || this.canRead(14)) {
            attributes.add(14);
        }
        if (all || this.canRead(15)) {
            attributes.add(15);
        }
        if (all || this.canRead(16)) {
            attributes.add(16);
        }
        if (all || this.canRead(17)) {
            attributes.add(17);
        }
        if (all || this.canRead(18)) {
            attributes.add(18);
        }
        if (all || this.canRead(19)) {
            attributes.add(19);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 19;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.STRUCTURE;
            }
            case 3: {
                return DataType.UINT8;
            }
            case 4: {
                return DataType.BITSTRING;
            }
            case 5: {
                return DataType.INT32;
            }
            case 6: {
                return DataType.INT32;
            }
            case 7: {
                return DataType.INT32;
            }
            case 8: {
                return DataType.INT32;
            }
            case 9: {
                return DataType.ARRAY;
            }
            case 10: {
                return DataType.ARRAY;
            }
            case 11: {
                return DataType.ARRAY;
            }
            case 12: {
                return DataType.ARRAY;
            }
            case 13: {
                return DataType.OCTET_STRING;
            }
            case 14: {
                return DataType.OCTET_STRING;
            }
            case 15: {
                return DataType.STRUCTURE;
            }
            case 16: {
                return DataType.INT32;
            }
            case 17: {
                return DataType.INT32;
            }
            case 18: {
                return DataType.UINT16;
            }
            case 19: {
                return DataType.INT32;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(2);
                bb.setUInt8(DataType.ENUM.getValue());
                bb.setUInt8(this.paymentMode.getValue());
                bb.setUInt8(DataType.ENUM.getValue());
                bb.setUInt8(this.accountStatus.getValue());
                return bb.array();
            }
            case 3: {
                return this.currentCreditInUse;
            }
            case 4: {
                return GXBitString.toBitString(this.currentCreditStatus.getValue(), 8);
            }
            case 5: {
                return this.availableCredit;
            }
            case 6: {
                return this.amountToClear;
            }
            case 7: {
                return this.clearanceThreshold;
            }
            case 8: {
                return this.aggregatedDebt;
            }
            case 9: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.creditReferences == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.creditReferences.size(), bb);
                    for (String it : this.creditReferences) {
                        bb.setUInt8(DataType.OCTET_STRING.getValue());
                        bb.setUInt8(6);
                        bb.set(GXCommon.logicalNameToBytes(it));
                    }
                }
                return bb.array();
            }
            case 10: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.chargeReferences == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.chargeReferences.size(), bb);
                    for (String it : this.chargeReferences) {
                        bb.setUInt8(DataType.OCTET_STRING.getValue());
                        bb.setUInt8(6);
                        bb.set(GXCommon.logicalNameToBytes(it));
                    }
                }
                return bb.array();
            }
            case 11: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.creditChargeConfigurations == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.creditChargeConfigurations.size(), bb);
                    for (GXCreditChargeConfiguration it : this.creditChargeConfigurations) {
                        bb.setUInt8(DataType.STRUCTURE.getValue());
                        bb.setUInt8(3);
                        bb.setUInt8(DataType.OCTET_STRING.getValue());
                        bb.setUInt8(6);
                        bb.set(GXCommon.logicalNameToBytes(it.getCreditReference()));
                        bb.setUInt8(DataType.OCTET_STRING.getValue());
                        bb.setUInt8(6);
                        bb.set(GXCommon.logicalNameToBytes(it.getChargeReference()));
                        GXCommon.setData(settings, bb, DataType.BITSTRING, GXBitString.toBitString(CreditCollectionConfiguration.toInteger(it.getCollectionConfiguration()), 3));
                    }
                }
                return bb.array();
            }
            case 12: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.tokenGatewayConfigurations == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.tokenGatewayConfigurations.size(), bb);
                    for (GXTokenGatewayConfiguration it : this.tokenGatewayConfigurations) {
                        bb.setUInt8(DataType.STRUCTURE.getValue());
                        bb.setUInt8(2);
                        bb.setUInt8(DataType.OCTET_STRING.getValue());
                        bb.setUInt8(6);
                        bb.set(GXCommon.logicalNameToBytes(it.getCreditReference()));
                        bb.setUInt8(DataType.UINT8.getValue());
                        bb.setUInt8(it.getTokenProportion());
                    }
                }
                return bb.array();
            }
            case 13: {
                return this.accountActivationTime;
            }
            case 14: {
                return this.accountClosureTime;
            }
            case 15: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(3);
                GXCommon.setData(settings, bb, DataType.STRING_UTF8, this.currency.getName());
                GXCommon.setData(settings, bb, DataType.INT8, this.currency.getScale());
                GXCommon.setData(settings, bb, DataType.ENUM, this.currency.getUnit().getValue());
                return bb.array();
            }
            case 16: {
                return this.lowCreditThreshold;
            }
            case 17: {
                return this.nextCreditAvailableThreshold;
            }
            case 18: {
                return this.maxProvision;
            }
            case 19: {
                return this.maxProvisionPeriod;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.paymentMode = PaymentMode.forValue(((Number)((List)e.getValue()).get(0)).intValue());
                this.accountStatus = AccountStatus.forValue(((Number)((List)e.getValue()).get(1)).intValue());
                break;
            }
            case 3: {
                this.currentCreditInUse = ((Number)e.getValue()).byteValue();
                break;
            }
            case 4: {
                this.currentCreditStatus = AccountCreditStatus.forValue(((GXBitString)e.getValue()).toInteger());
                break;
            }
            case 5: {
                this.availableCredit = ((Number)e.getValue()).intValue();
                break;
            }
            case 6: {
                this.amountToClear = ((Number)e.getValue()).intValue();
                break;
            }
            case 7: {
                this.clearanceThreshold = ((Number)e.getValue()).intValue();
                break;
            }
            case 8: {
                this.aggregatedDebt = ((Number)e.getValue()).intValue();
                break;
            }
            case 9: {
                this.creditReferences.clear();
                if (e.getValue() == null) break;
                for (Object it : (List)e.getValue()) {
                    this.creditReferences.add(GXCommon.toLogicalName(it));
                }
                break;
            }
            case 10: {
                this.chargeReferences.clear();
                if (e.getValue() == null) break;
                for (Object it : (List)e.getValue()) {
                    this.chargeReferences.add(GXCommon.toLogicalName(it));
                }
                break;
            }
            case 11: {
                this.creditChargeConfigurations.clear();
                if (e.getValue() == null) break;
                for (Object it2 : (List)e.getValue()) {
                    List it = (List)it2;
                    GXCreditChargeConfiguration item = new GXCreditChargeConfiguration();
                    item.setCreditReference(GXCommon.toLogicalName(it.get(0)));
                    item.setChargeReference(GXCommon.toLogicalName(it.get(1)));
                    item.setCollectionConfiguration(CreditCollectionConfiguration.forValue(((GXBitString)it.get(2)).toInteger()));
                    this.creditChargeConfigurations.add(item);
                }
                break;
            }
            case 12: {
                this.tokenGatewayConfigurations.clear();
                if (e.getValue() == null) break;
                for (Object it2 : (List)e.getValue()) {
                    List it = (List)it2;
                    GXTokenGatewayConfiguration item = new GXTokenGatewayConfiguration();
                    item.setCreditReference(GXCommon.toLogicalName(it.get(0)));
                    item.setTokenProportion(((Number)it.get(1)).byteValue());
                    this.tokenGatewayConfigurations.add(item);
                }
                break;
            }
            case 13: {
                if (e.getValue() == null) {
                    this.accountActivationTime = new GXDateTime();
                    break;
                }
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.accountActivationTime = tmp;
                break;
            }
            case 14: {
                if (e.getValue() == null) {
                    this.accountClosureTime = new GXDateTime();
                    break;
                }
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.accountClosureTime = tmp;
                break;
            }
            case 15: {
                List tmp = (List)e.getValue();
                this.currency.setName((String)tmp.get(0));
                this.currency.setScale(((Number)tmp.get(1)).byteValue());
                this.currency.setUnit(Currency.forValue(((Number)tmp.get(2)).intValue()));
                break;
            }
            case 16: {
                this.lowCreditThreshold = ((Number)e.getValue()).intValue();
                break;
            }
            case 17: {
                this.nextCreditAvailableThreshold = ((Number)e.getValue()).intValue();
                break;
            }
            case 18: {
                this.maxProvision = ((Number)e.getValue()).intValue();
                break;
            }
            case 19: {
                this.maxProvisionPeriod = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    private static void loadReferences(GXXmlReader reader, String name, List<String> list) throws XMLStreamException {
        list.clear();
        if (reader.isStartElement(name, true)) {
            while (reader.isStartElement("Item", true)) {
                list.add(reader.readElementContentAsString("Name"));
            }
            reader.readEndElement(name);
        }
    }

    private static void loadCreditChargeConfigurations(GXXmlReader reader, List<GXCreditChargeConfiguration> list) throws XMLStreamException {
        list.clear();
        if (reader.isStartElement("CreditChargeConfigurations", true)) {
            while (reader.isStartElement("Item", true)) {
                GXCreditChargeConfiguration it = new GXCreditChargeConfiguration();
                it.setCreditReference(reader.readElementContentAsString("Credit"));
                it.setChargeReference(reader.readElementContentAsString("Charge"));
                it.setCollectionConfiguration(CreditCollectionConfiguration.forValue(reader.readElementContentAsInt("Configuration")));
                list.add(it);
            }
            reader.readEndElement("CreditChargeConfigurations");
        }
    }

    private static void loadTokenGatewayConfigurations(GXXmlReader reader, List<GXTokenGatewayConfiguration> list) throws XMLStreamException {
        list.clear();
        if (reader.isStartElement("TokenGatewayConfigurations", true)) {
            while (reader.isStartElement("Item", true)) {
                GXTokenGatewayConfiguration it = new GXTokenGatewayConfiguration();
                it.setCreditReference(reader.readElementContentAsString("Credit"));
                it.setTokenProportion((byte)reader.readElementContentAsInt("Token"));
                list.add(it);
            }
            reader.readEndElement("TokenGatewayConfigurations");
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.paymentMode = PaymentMode.forValue(reader.readElementContentAsInt("PaymentMode"));
        this.accountStatus = AccountStatus.forValue(reader.readElementContentAsInt("AccountStatus"));
        this.currentCreditInUse = (byte)reader.readElementContentAsInt("CurrentCreditInUse");
        this.currentCreditStatus = AccountCreditStatus.forValue(reader.readElementContentAsInt("CurrentCreditStatus"));
        this.availableCredit = reader.readElementContentAsInt("AvailableCredit");
        this.amountToClear = reader.readElementContentAsInt("AmountToClear");
        this.clearanceThreshold = reader.readElementContentAsInt("ClearanceThreshold");
        this.aggregatedDebt = reader.readElementContentAsInt("AggregatedDebt");
        GXDLMSAccount.loadReferences(reader, "CreditReferences", this.creditReferences);
        GXDLMSAccount.loadReferences(reader, "ChargeReferences", this.chargeReferences);
        GXDLMSAccount.loadCreditChargeConfigurations(reader, this.creditChargeConfigurations);
        GXDLMSAccount.loadTokenGatewayConfigurations(reader, this.tokenGatewayConfigurations);
        this.accountActivationTime = reader.readElementContentAsDateTime("AccountActivationTime");
        this.accountClosureTime = reader.readElementContentAsDateTime("AccountClosureTime");
        this.currency.setName(reader.readElementContentAsString("CurrencyName"));
        this.currency.setScale((byte)reader.readElementContentAsInt("CurrencyScale"));
        this.currency.setUnit(Currency.forValue(reader.readElementContentAsInt("CurrencyUnit")));
        this.lowCreditThreshold = reader.readElementContentAsInt("LowCreditThreshold");
        this.nextCreditAvailableThreshold = reader.readElementContentAsInt("NextCreditAvailableThreshold");
        this.maxProvision = reader.readElementContentAsInt("MaxProvision");
        this.maxProvisionPeriod = reader.readElementContentAsInt("MaxProvisionPeriod");
    }

    private void saveReferences(GXXmlWriter writer, List<String> list, String name) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement(name);
            for (String it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("Name", it);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveCreditChargeConfigurations(GXXmlWriter writer, List<GXCreditChargeConfiguration> list) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement("CreditChargeConfigurations");
            for (GXCreditChargeConfiguration it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("Credit", it.getCreditReference());
                writer.writeElementString("Charge", it.getChargeReference());
                writer.writeElementString("Configuration", CreditCollectionConfiguration.toInteger(it.getCollectionConfiguration()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveTokenGatewayConfigurations(GXXmlWriter writer, List<GXTokenGatewayConfiguration> list) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement("TokenGatewayConfigurations");
            for (GXTokenGatewayConfiguration it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("Credit", it.getCreditReference());
                writer.writeElementString("Token", it.getTokenProportion());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("PaymentMode", this.paymentMode.getValue());
        writer.writeElementString("AccountStatus", this.accountStatus.getValue());
        writer.writeElementString("CurrentCreditInUse", this.currentCreditInUse);
        if (this.currentCreditStatus != null) {
            writer.writeElementString("CurrentCreditStatus", this.currentCreditStatus.getValue());
        }
        writer.writeElementString("AvailableCredit", this.availableCredit);
        writer.writeElementString("AmountToClear", this.amountToClear);
        writer.writeElementString("ClearanceThreshold", this.clearanceThreshold);
        writer.writeElementString("AggregatedDebt", this.aggregatedDebt);
        this.saveReferences(writer, this.creditReferences, "CreditReferences");
        this.saveReferences(writer, this.chargeReferences, "ChargeReferences");
        this.saveCreditChargeConfigurations(writer, this.creditChargeConfigurations);
        this.saveTokenGatewayConfigurations(writer, this.tokenGatewayConfigurations);
        writer.writeElementString("AccountActivationTime", this.accountActivationTime);
        writer.writeElementString("AccountClosureTime", this.accountClosureTime);
        writer.writeElementString("CurrencyName", this.currency.getName());
        writer.writeElementString("CurrencyScale", this.currency.getScale());
        writer.writeElementString("CurrencyUnit", this.currency.getUnit().getValue());
        writer.writeElementString("LowCreditThreshold", this.lowCreditThreshold);
        writer.writeElementString("NextCreditAvailableThreshold", this.nextCreditAvailableThreshold);
        writer.writeElementString("MaxProvision", this.maxProvision);
        writer.writeElementString("MaxProvisionPeriod", this.maxProvisionPeriod);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "PaymentMode", "CurrentCreditInUse", "CurrentCreditStatus", "AvailableCredit", "AmountToClear", "ClearanceThreshold", "AggregatedDebt", "CreditReferences", "ChargeReferences", "CreditChargeConfigurations", "TokenGatewayConfigurations", "AccountActivationTime", "AccountClosureTime", "Currency", "LowCreditThreshold", "NextCreditAvailableThreshold", "MaxProvision", "MaxProvisionPeriod"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Activate account", "Close account", "Reset account"};
    }
}

