/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDate;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Standard;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSScriptTable;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.SingleActionScheduleType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSActionSchedule
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSScriptTable target;
    private int executedScriptSelector;
    private SingleActionScheduleType type = SingleActionScheduleType.SingleActionScheduleType1;
    private GXDateTime[] executionTime;

    public GXDLMSActionSchedule() {
        this("0.0.15.0.0.255", 0);
    }

    public GXDLMSActionSchedule(String ln) {
        this(ln, 0);
    }

    public GXDLMSActionSchedule(String ln, int sn) {
        super(ObjectType.ACTION_SCHEDULE, ln, sn);
    }

    public final GXDLMSScriptTable getTarget() {
        return this.target;
    }

    public final void setTarget(GXDLMSScriptTable value) {
        this.target = value;
    }

    public final int getExecutedScriptSelector() {
        return this.executedScriptSelector;
    }

    public final void setExecutedScriptSelector(int value) {
        this.executedScriptSelector = value;
    }

    public final SingleActionScheduleType getType() {
        return this.type;
    }

    public final void setType(SingleActionScheduleType value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid SingleActionScheduleType");
        }
        this.type = value;
    }

    public final GXDateTime[] getExecutionTime() {
        return this.executionTime;
    }

    public final void setExecutionTime(GXDateTime[] value) {
        this.executionTime = value;
    }

    @Override
    public final Object[] getValues() {
        String str = this.target != null ? this.target.getLogicalName() : "0.0.0.0.0.0";
        return new Object[]{this.getLogicalName(), str + " " + this.executedScriptSelector, this.getType(), this.getExecutionTime()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.ENUM;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            String str = this.target == null ? "0.0.0.0.0.0" : this.target.getLogicalName();
            GXByteBuffer stream = new GXByteBuffer();
            stream.setUInt8(DataType.STRUCTURE.getValue());
            stream.setUInt8(2);
            GXCommon.setData(settings, stream, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(str));
            GXCommon.setData(settings, stream, DataType.UINT16, this.executedScriptSelector);
            return stream.array();
        }
        if (e.getIndex() == 3) {
            return this.getType().getValue();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY.getValue());
            if (this.getExecutionTime() == null) {
                GXCommon.setObjectCount(0, bb);
            } else {
                GXCommon.setObjectCount(this.getExecutionTime().length, bb);
                for (GXDateTime it : this.getExecutionTime()) {
                    bb.setUInt8(DataType.STRUCTURE.getValue());
                    bb.setUInt8(2);
                    if (settings != null && settings.getStandard() == Standard.SAUDI_ARABIA) {
                        GXCommon.setData(settings, bb, DataType.TIME, new GXTime(it));
                        GXCommon.setData(settings, bb, DataType.DATE, new GXDate(it));
                        continue;
                    }
                    GXCommon.setData(settings, bb, DataType.OCTET_STRING, new GXTime(it));
                    GXCommon.setData(settings, bb, DataType.OCTET_STRING, new GXDate(it));
                }
            }
            return bb.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            String ln = GXCommon.toLogicalName(((List)e.getValue()).get(0));
            this.target = (GXDLMSScriptTable)settings.getObjects().findByLN(ObjectType.SCRIPT_TABLE, ln);
            if (this.target == null) {
                this.target = new GXDLMSScriptTable(ln);
            }
            this.setExecutedScriptSelector(((Number)((List)e.getValue()).get(1)).intValue());
        } else if (e.getIndex() == 3) {
            int tmp = ((Number)e.getValue()).intValue();
            if (tmp != 0) {
                this.setType(SingleActionScheduleType.forValue(tmp));
            }
        } else if (e.getIndex() == 4) {
            this.setExecutionTime(null);
            if (e.getValue() != null) {
                ArrayList<GXDateTime> items = new ArrayList<GXDateTime>();
                for (Object it : (List)e.getValue()) {
                    GXDateTime time = (GXDateTime)GXDLMSClient.changeType((byte[])((List)it).get(0), DataType.TIME, e.getSettings());
                    time.setSkip(DateTimeSkips.forValue(DateTimeSkips.toInteger(time.getSkip()) & ~(DateTimeSkips.YEAR.getValue() | DateTimeSkips.MONTH.getValue() | DateTimeSkips.DAY.getValue() | DateTimeSkips.DAY_OF_WEEK.getValue())));
                    GXDateTime date = (GXDateTime)GXDLMSClient.changeType((byte[])((List)it).get(1), DataType.DATE, e.getSettings());
                    date.setSkip(DateTimeSkips.forValue(DateTimeSkips.toInteger(date.getSkip()) & ~(DateTimeSkips.HOUR.getValue() | DateTimeSkips.MINUTE.getValue() | DateTimeSkips.SECOND.getValue() | DateTimeSkips.MILLISECOND.getValue())));
                    GXDateTime tmp = new GXDateTime(date);
                    tmp.getMeterCalendar().add(11, time.getMeterCalendar().get(11));
                    tmp.getMeterCalendar().add(12, time.getMeterCalendar().get(12));
                    tmp.getMeterCalendar().add(13, time.getMeterCalendar().get(13));
                    tmp.getSkip().addAll(date.getSkip());
                    tmp.getSkip().addAll(time.getSkip());
                    items.add(tmp);
                }
                this.setExecutionTime(items.toArray(new GXDateTime[items.size()]));
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
        String ln = reader.readElementContentAsString("LN");
        if (ot != ObjectType.NONE && ln != null) {
            this.target = (GXDLMSScriptTable)reader.getObjects().findByLN(ot, ln);
            if (this.target == null) {
                this.target = new GXDLMSScriptTable(ln);
            }
        }
        this.executedScriptSelector = reader.readElementContentAsInt("ExecutedScriptSelector");
        this.type = SingleActionScheduleType.forValue(reader.readElementContentAsInt("Type"));
        ArrayList<GXDateTime> list = new ArrayList<GXDateTime>();
        if (reader.isStartElement("ExecutionTime", true)) {
            while (reader.isStartElement("Time", false)) {
                GXDateTime it = reader.readElementContentAsDateTime("Time");
                list.add(it);
            }
            reader.readEndElement("ExecutionTime");
        }
        this.executionTime = list.toArray(new GXDateTime[list.size()]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.target != null) {
            writer.writeElementString("ObjectType", this.target.getObjectType().getValue());
            writer.writeElementString("LN", this.target.getLogicalName());
        }
        writer.writeElementString("ExecutedScriptSelector", this.executedScriptSelector);
        writer.writeElementString("Type", this.type.getValue());
        if (this.executionTime != null) {
            writer.writeStartElement("ExecutionTime");
            for (GXDateTime it : this.executionTime) {
                writer.writeElementString("Time", it);
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
        GXDLMSScriptTable t;
        if (this.target != null && (t = (GXDLMSScriptTable)reader.getObjects().findByLN(ObjectType.SCRIPT_TABLE, this.target.getLogicalName())) != null && this.target != t) {
            this.target = t;
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Executed Script Logical Name", "Type", "Execution Time"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

