/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSDayProfile;
import gurux.dlms.objects.GXDLMSDayProfileAction;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSSeasonProfile;
import gurux.dlms.objects.GXDLMSWeekProfile;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSActivityCalendar
extends GXDLMSObject
implements IGXDLMSBase {
    private String calendarNameActive;
    private String calendarNamePassive;
    private GXDLMSSeasonProfile[] seasonProfileActive;
    private GXDLMSWeekProfile[] weekProfileTableActive;
    private GXDLMSDayProfile[] dayProfileTableActive;
    private GXDLMSSeasonProfile[] seasonProfilePassive;
    private GXDLMSDayProfile[] dayProfileTablePassive;
    private GXDLMSWeekProfile[] weekProfileTablePassive;
    private GXDateTime time;
    private boolean isSec = false;

    public GXDLMSActivityCalendar() {
        this("0.0.13.0.0.255");
    }

    public GXDLMSActivityCalendar(String ln) {
        this(ln, 0);
    }

    public GXDLMSActivityCalendar(String ln, int sn) {
        super(ObjectType.ACTIVITY_CALENDAR, ln, sn);
    }

    public final String getCalendarNameActive() {
        return this.calendarNameActive;
    }

    public final void setCalendarNameActive(String value) {
        this.calendarNameActive = value;
    }

    public final GXDLMSSeasonProfile[] getSeasonProfileActive() {
        return this.seasonProfileActive;
    }

    public final void setSeasonProfileActive(GXDLMSSeasonProfile[] value) {
        this.seasonProfileActive = value;
    }

    public final GXDLMSWeekProfile[] getWeekProfileTableActive() {
        return this.weekProfileTableActive;
    }

    public final void setWeekProfileTableActive(GXDLMSWeekProfile[] value) {
        this.weekProfileTableActive = value;
    }

    public final GXDLMSDayProfile[] getDayProfileTableActive() {
        return this.dayProfileTableActive;
    }

    public final void setDayProfileTableActive(GXDLMSDayProfile[] value) {
        this.dayProfileTableActive = value;
    }

    public final String getCalendarNamePassive() {
        return this.calendarNamePassive;
    }

    public final void setCalendarNamePassive(String value) {
        this.calendarNamePassive = value;
    }

    public final GXDLMSSeasonProfile[] getSeasonProfilePassive() {
        return this.seasonProfilePassive;
    }

    public final void setSeasonProfilePassive(GXDLMSSeasonProfile[] value) {
        this.seasonProfilePassive = value;
    }

    public final GXDLMSWeekProfile[] getWeekProfileTablePassive() {
        return this.weekProfileTablePassive;
    }

    public final void setWeekProfileTablePassive(GXDLMSWeekProfile[] value) {
        this.weekProfileTablePassive = value;
    }

    public final GXDLMSDayProfile[] getDayProfileTablePassive() {
        return this.dayProfileTablePassive;
    }

    public final void setDayProfileTablePassive(GXDLMSDayProfile[] value) {
        this.dayProfileTablePassive = value;
    }

    public final GXDateTime getTime() {
        return this.time;
    }

    public final void setTime(GXDateTime value) {
        this.time = value;
    }

    public final byte[][] activatePassiveCalendar(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getCalendarNameActive(), this.getSeasonProfileActive(), this.getWeekProfileTableActive(), this.getDayProfileTableActive(), this.getCalendarNamePassive(), this.getSeasonProfilePassive(), this.getWeekProfileTablePassive(), this.getDayProfileTablePassive(), this.getTime()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 10;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.OCTET_STRING;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        if (index == 5) {
            return DataType.ARRAY;
        }
        if (index == 6) {
            return DataType.OCTET_STRING;
        }
        if (index == 7) {
            return DataType.ARRAY;
        }
        if (index == 8) {
            return DataType.ARRAY;
        }
        if (index == 9) {
            return DataType.ARRAY;
        }
        if (index == 10) {
            if (this.isSec) {
                return DataType.DATETIME;
            }
            return DataType.OCTET_STRING;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    static Object getSeasonProfile(GXDLMSSettings settings, GXDLMSSeasonProfile[] target) {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.ARRAY.getValue());
        if (target == null) {
            GXCommon.setObjectCount(0, data);
        } else {
            int cnt = target.length;
            GXCommon.setObjectCount(cnt, data);
            for (GXDLMSSeasonProfile it : target) {
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(3);
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getName());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getStart());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getWeekName());
            }
        }
        return data.array();
    }

    static Object getWeekProfileTable(GXDLMSSettings settings, GXDLMSWeekProfile[] target) {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.ARRAY.getValue());
        if (target == null) {
            GXCommon.setObjectCount(0, data);
        } else {
            GXCommon.setObjectCount(target.length, data);
            for (GXDLMSWeekProfile it : target) {
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(8);
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getName());
                GXCommon.setData(settings, data, DataType.UINT8, it.getMonday());
                GXCommon.setData(settings, data, DataType.UINT8, it.getTuesday());
                GXCommon.setData(settings, data, DataType.UINT8, it.getWednesday());
                GXCommon.setData(settings, data, DataType.UINT8, it.getThursday());
                GXCommon.setData(settings, data, DataType.UINT8, it.getFriday());
                GXCommon.setData(settings, data, DataType.UINT8, it.getSaturday());
                GXCommon.setData(settings, data, DataType.UINT8, it.getSunday());
            }
        }
        return data.array();
    }

    static Object getDayProfileTable(GXDLMSSettings settings, GXDLMSDayProfile[] target) {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.ARRAY.getValue());
        if (target == null) {
            GXCommon.setObjectCount(0, data);
        } else {
            GXCommon.setObjectCount(target.length, data);
            for (GXDLMSDayProfile it : target) {
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(2);
                GXCommon.setData(settings, data, DataType.UINT8, it.getDayId());
                data.setUInt8(DataType.ARRAY.getValue());
                GXCommon.setObjectCount(it.getDaySchedules().length, data);
                for (GXDLMSDayProfileAction action : it.getDaySchedules()) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, action.getStartTime());
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(action.getScriptLogicalName()));
                    GXCommon.setData(settings, data, DataType.UINT16, action.getScriptSelector());
                }
            }
        }
        return data.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                if (this.calendarNameActive == null) {
                    return null;
                }
                if (this.isSec) {
                    return GXCommon.hexToBytes(this.calendarNameActive);
                }
                return this.calendarNameActive.getBytes();
            }
            case 3: {
                return GXDLMSActivityCalendar.getSeasonProfile(settings, this.seasonProfileActive);
            }
            case 4: {
                return GXDLMSActivityCalendar.getWeekProfileTable(settings, this.weekProfileTableActive);
            }
            case 5: {
                return GXDLMSActivityCalendar.getDayProfileTable(settings, this.dayProfileTableActive);
            }
            case 6: {
                if (this.calendarNamePassive == null) {
                    return null;
                }
                if (this.isSec) {
                    return GXCommon.hexToBytes(this.calendarNamePassive);
                }
                return this.calendarNamePassive.getBytes();
            }
            case 7: {
                return GXDLMSActivityCalendar.getSeasonProfile(settings, this.seasonProfilePassive);
            }
            case 8: {
                return GXDLMSActivityCalendar.getWeekProfileTable(settings, this.weekProfileTablePassive);
            }
            case 9: {
                return GXDLMSActivityCalendar.getDayProfileTable(settings, this.dayProfileTablePassive);
            }
            case 10: {
                return this.getTime();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    static GXDLMSSeasonProfile[] getSeasonProfile(ValueEventArgs e, Object value) {
        ArrayList<GXDLMSSeasonProfile> items = new ArrayList<GXDLMSSeasonProfile>();
        if (value != null) {
            for (Object item : (List)value) {
                List arr = (List)item;
                GXDLMSSeasonProfile it = new GXDLMSSeasonProfile();
                it.setName((byte[])arr.get(0));
                it.setStart((GXDateTime)GXDLMSClient.changeType((byte[])arr.get(1), DataType.DATETIME, e.getSettings()));
                byte[] weekName = (byte[])arr.get(2);
                if (weekName != null && weekName.length == 1 && weekName[0] == 255) {
                    it.setWeekName("");
                } else {
                    it.setWeekName(weekName);
                }
                items.add(it);
            }
        }
        return items.toArray(new GXDLMSSeasonProfile[items.size()]);
    }

    static GXDLMSWeekProfile[] getWeekProfileTable(Object value) {
        ArrayList<GXDLMSWeekProfile> items = new ArrayList<GXDLMSWeekProfile>();
        if (value != null) {
            for (Object item : (List)value) {
                List arr = (List)item;
                GXDLMSWeekProfile it = new GXDLMSWeekProfile();
                it.setName((byte[])arr.get(0));
                it.setMonday(((Number)arr.get(1)).intValue());
                it.setTuesday(((Number)arr.get(2)).intValue());
                it.setWednesday(((Number)arr.get(3)).intValue());
                it.setThursday(((Number)arr.get(4)).intValue());
                it.setFriday(((Number)arr.get(5)).intValue());
                it.setSaturday(((Number)arr.get(6)).intValue());
                it.setSunday(((Number)arr.get(7)).intValue());
                items.add(it);
            }
        }
        return items.toArray(new GXDLMSWeekProfile[items.size()]);
    }

    static GXDLMSDayProfile[] getDayProfileTable(ValueEventArgs e, Object value) {
        ArrayList<GXDLMSDayProfile> items = new ArrayList<GXDLMSDayProfile>();
        if (value != null) {
            for (Object item : (List)value) {
                List arr = (List)item;
                GXDLMSDayProfile it = new GXDLMSDayProfile();
                it.setDayId(((Number)arr.get(0)).intValue());
                ArrayList<GXDLMSDayProfileAction> actions = new ArrayList<GXDLMSDayProfileAction>();
                for (Object it2 : (List)arr.get(1)) {
                    List arr1 = (List)it2;
                    GXDLMSDayProfileAction ac = new GXDLMSDayProfileAction();
                    ac.setStartTime((GXTime)GXDLMSClient.changeType((byte[])arr1.get(0), DataType.TIME, e.getSettings()));
                    ac.setScriptLogicalName(GXCommon.toLogicalName(arr1.get(1)));
                    ac.setScriptSelector(((Number)arr1.get(2)).intValue());
                    actions.add(ac);
                }
                it.setDaySchedules(actions.toArray(new GXDLMSDayProfileAction[actions.size()]));
                items.add(it);
            }
        }
        return items.toArray(new GXDLMSDayProfile[items.size()]);
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                if (e.getValue() == null) {
                    this.setCalendarNameActive(null);
                    break;
                }
                String tmp = new String((byte[])e.getValue()).trim();
                if (this.isSec || !GXCommon.isAscii(tmp)) {
                    this.setCalendarNameActive(GXCommon.toHex((byte[])e.getValue()));
                    break;
                }
                this.setCalendarNameActive(tmp);
                break;
            }
            case 3: {
                this.setSeasonProfileActive(GXDLMSActivityCalendar.getSeasonProfile(e, e.getValue()));
                break;
            }
            case 4: {
                this.setWeekProfileTableActive(GXDLMSActivityCalendar.getWeekProfileTable(e.getValue()));
                break;
            }
            case 5: {
                this.setDayProfileTableActive(GXDLMSActivityCalendar.getDayProfileTable(e, e.getValue()));
                break;
            }
            case 6: {
                if (e.getValue() == null) {
                    this.setCalendarNamePassive(null);
                    break;
                }
                String tmp = new String((byte[])e.getValue()).trim();
                if (this.isSec || !GXCommon.isAscii(tmp)) {
                    this.setCalendarNamePassive(GXCommon.toHex((byte[])e.getValue()));
                    break;
                }
                this.setCalendarNamePassive(new String((byte[])e.getValue()));
                break;
            }
            case 7: {
                this.setSeasonProfilePassive(GXDLMSActivityCalendar.getSeasonProfile(e, e.getValue()));
                break;
            }
            case 8: {
                this.setWeekProfileTablePassive(GXDLMSActivityCalendar.getWeekProfileTable(e.getValue()));
                break;
            }
            case 9: {
                this.setDayProfileTablePassive(GXDLMSActivityCalendar.getDayProfileTable(e, e.getValue()));
                break;
            }
            case 10: {
                if (e.getValue() instanceof GXDateTime) {
                    this.setTime((GXDateTime)e.getValue());
                    break;
                }
                this.setTime((GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()));
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    private static GXDLMSSeasonProfile[] loadSeasonProfile(GXXmlReader reader, String name) throws XMLStreamException {
        ArrayList<GXDLMSSeasonProfile> list = new ArrayList<GXDLMSSeasonProfile>();
        if (reader.isStartElement(name, true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSSeasonProfile it = new GXDLMSSeasonProfile();
                it.setName(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Name")));
                it.setStart(reader.readElementContentAsDateTime("Start"));
                it.setWeekName(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("WeekName")));
                list.add(it);
            }
            reader.readEndElement(name);
        }
        return list.toArray(new GXDLMSSeasonProfile[list.size()]);
    }

    private static GXDLMSWeekProfile[] loadWeekProfileTable(GXXmlReader reader, String name) throws XMLStreamException {
        ArrayList<GXDLMSWeekProfile> list = new ArrayList<GXDLMSWeekProfile>();
        if (reader.isStartElement(name, true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSWeekProfile it = new GXDLMSWeekProfile();
                it.setName(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Name")));
                it.setMonday(reader.readElementContentAsInt("Monday"));
                it.setTuesday(reader.readElementContentAsInt("Tuesday"));
                it.setWednesday(reader.readElementContentAsInt("Wednesday"));
                it.setThursday(reader.readElementContentAsInt("Thursday"));
                it.setFriday(reader.readElementContentAsInt("Friday"));
                it.setSaturday(reader.readElementContentAsInt("Saturday"));
                it.setSunday(reader.readElementContentAsInt("Sunday"));
                list.add(it);
            }
            reader.readEndElement(name);
        }
        return list.toArray(new GXDLMSWeekProfile[list.size()]);
    }

    private static GXDLMSDayProfile[] loadDayProfileTable(GXXmlReader reader, String name) throws XMLStreamException {
        ArrayList<GXDLMSDayProfile> list = new ArrayList<GXDLMSDayProfile>();
        if (reader.isStartElement(name, true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSDayProfile it = new GXDLMSDayProfile();
                it.setDayId(reader.readElementContentAsInt("DayId"));
                list.add(it);
                ArrayList<GXDLMSDayProfileAction> actions = new ArrayList<GXDLMSDayProfileAction>();
                if (reader.isStartElement("Actions", true)) {
                    while (reader.isStartElement("Action", true)) {
                        GXDLMSDayProfileAction d = new GXDLMSDayProfileAction();
                        actions.add(d);
                        d.setStartTime(reader.readElementContentAsTime("Start"));
                        d.setScriptLogicalName(reader.readElementContentAsString("LN"));
                        d.setScriptSelector(reader.readElementContentAsInt("Selector"));
                    }
                    reader.readEndElement("Actions");
                }
                it.setDaySchedules(actions.toArray(new GXDLMSDayProfileAction[actions.size()]));
            }
            reader.readEndElement(name);
        }
        return list.toArray(new GXDLMSDayProfile[list.size()]);
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.calendarNameActive = reader.readElementContentAsString("CalendarNameActive");
        this.seasonProfileActive = GXDLMSActivityCalendar.loadSeasonProfile(reader, "SeasonProfileActive");
        this.weekProfileTableActive = GXDLMSActivityCalendar.loadWeekProfileTable(reader, "WeekProfileTableActive");
        this.dayProfileTableActive = GXDLMSActivityCalendar.loadDayProfileTable(reader, "DayProfileTableActive");
        this.calendarNamePassive = reader.readElementContentAsString("CalendarNamePassive");
        this.seasonProfilePassive = GXDLMSActivityCalendar.loadSeasonProfile(reader, "SeasonProfilePassive");
        this.weekProfileTablePassive = GXDLMSActivityCalendar.loadWeekProfileTable(reader, "WeekProfileTablePassive");
        this.dayProfileTablePassive = GXDLMSActivityCalendar.loadDayProfileTable(reader, "DayProfileTablePassive");
        this.time = reader.readElementContentAsDateTime("Time");
    }

    private void saveSeasonProfile(GXXmlWriter writer, GXDLMSSeasonProfile[] list, String name) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement(name);
            for (GXDLMSSeasonProfile it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("Name", GXDLMSTranslator.toHex(it.getName()));
                writer.writeElementString("Start", it.getStart());
                writer.writeElementString("WeekName", GXDLMSTranslator.toHex(it.getWeekName()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveWeekProfileTable(GXXmlWriter writer, GXDLMSWeekProfile[] list, String name) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement(name);
            for (GXDLMSWeekProfile it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("Name", GXDLMSTranslator.toHex(it.getName()));
                writer.writeElementString("Monday", it.getMonday());
                writer.writeElementString("Tuesday", it.getTuesday());
                writer.writeElementString("Wednesday", it.getWednesday());
                writer.writeElementString("Thursday", it.getThursday());
                writer.writeElementString("Friday", it.getFriday());
                writer.writeElementString("Saturday", it.getSaturday());
                writer.writeElementString("Sunday", it.getSunday());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveDayProfileTable(GXXmlWriter writer, GXDLMSDayProfile[] list, String name) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement(name);
            for (GXDLMSDayProfile it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("DayId", String.valueOf(it.getDayId()));
                writer.writeStartElement("Actions");
                for (GXDLMSDayProfileAction d : it.getDaySchedules()) {
                    writer.writeStartElement("Action");
                    writer.writeElementString("Start", d.getStartTime());
                    writer.writeElementString("LN", d.getScriptLogicalName());
                    writer.writeElementString("Selector", d.getScriptSelector());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("CalendarNameActive", this.calendarNameActive);
        this.saveSeasonProfile(writer, this.seasonProfileActive, "SeasonProfileActive");
        this.saveWeekProfileTable(writer, this.weekProfileTableActive, "WeekProfileTableActive");
        this.saveDayProfileTable(writer, this.dayProfileTableActive, "DayProfileTableActive");
        writer.writeElementString("CalendarNamePassive", this.calendarNamePassive);
        this.saveSeasonProfile(writer, this.seasonProfilePassive, "SeasonProfilePassive");
        this.saveWeekProfileTable(writer, this.weekProfileTablePassive, "WeekProfileTablePassive");
        this.saveDayProfileTable(writer, this.dayProfileTablePassive, "DayProfileTablePassive");
        writer.writeElementString("Time", this.time);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Active Calendar Name ", "Active Season Profile", "Active Week Profile Table", "Active Day Profile Table", "Passive Calendar Name", "Passive Season Profile", "Passive Week Profile Table", "Passive Day Profile Table", "Time"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Activate passive calendar"};
    }
}

