/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXCryptoKeyParameter;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.IGXCryptoNotifier;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Integer;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.MethodAccessMode3;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.manufacturersettings.GXDLMSAttributeSettings;
import gurux.dlms.objects.GXApplicationContextName;
import gurux.dlms.objects.GXAuthenticationMechanismName;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSSecuritySetup;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.GXxDLMSContextType;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ApplicationContextName;
import gurux.dlms.objects.enums.AssociationStatus;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.secure.GXSecure;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSAssociationLogicalName
extends GXDLMSObject
implements IGXDLMSBase {
    private boolean multipleAssociationViews;
    private HashMap<GXDLMSObject, int[]> accessRights = new HashMap();
    private HashMap<GXDLMSObject, int[]> methodAccessRights = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(GXDLMSAssociationLogicalName.class.getName());
    private GXDLMSObjectCollection objectList;
    private int clientSAP;
    private short serverSAP = 1;
    private GXApplicationContextName applicationContextName;
    private GXxDLMSContextType xDLMSContextInfo;
    private GXAuthenticationMechanismName authenticationMechanismName;
    private byte[] secret;
    private AssociationStatus associationStatus = AssociationStatus.NON_ASSOCIATED;
    private String securitySetupReference;
    private List<Map.Entry<Byte, String>> userList;
    private Map.Entry<Byte, String> currentUser;

    public GXDLMSAssociationLogicalName() {
        this("0.0.40.0.0.255");
    }

    public GXDLMSAssociationLogicalName(String ln) {
        super(ObjectType.ASSOCIATION_LOGICAL_NAME, ln, 0);
        this.setLogicalName(ln);
        this.objectList = new GXDLMSObjectCollection(this);
        this.applicationContextName = new GXApplicationContextName();
        this.xDLMSContextInfo = new GXxDLMSContextType();
        this.authenticationMechanismName = new GXAuthenticationMechanismName();
        this.setUserList(new ArrayList<Map.Entry<Byte, String>>());
        this.setVersion(2);
    }

    public final GXDLMSObjectCollection getObjectList() {
        return this.objectList;
    }

    public final void setObjectList(GXDLMSObjectCollection value) {
        this.objectList = value;
    }

    public final int getClientSAP() {
        return this.clientSAP;
    }

    public final void setClientSAP(int value) {
        this.clientSAP = value;
    }

    public final short getServerSAP() {
        return this.serverSAP;
    }

    public final void setServerSAP(short value) {
        this.serverSAP = value;
    }

    public final GXApplicationContextName getApplicationContextName() {
        return this.applicationContextName;
    }

    public final GXxDLMSContextType getXDLMSContextInfo() {
        return this.xDLMSContextInfo;
    }

    public final GXAuthenticationMechanismName getAuthenticationMechanismName() {
        return this.authenticationMechanismName;
    }

    public final byte[] getSecret() {
        return this.secret;
    }

    public final void setSecret(byte[] value) {
        this.secret = value;
    }

    public final AssociationStatus getAssociationStatus() {
        return this.associationStatus;
    }

    public final void setAssociationStatus(AssociationStatus value) {
        this.associationStatus = value;
    }

    public final String getSecuritySetupReference() {
        return this.securitySetupReference;
    }

    public final void setSecuritySetupReference(String value) {
        this.securitySetupReference = value;
    }

    public byte[][] updateSecret(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (this.getAuthenticationMechanismName().getMechanismId() == Authentication.NONE) {
            throw new IllegalArgumentException("Invalid authentication level in MechanismId.");
        }
        if (this.getAuthenticationMechanismName().getMechanismId() == Authentication.HIGH_GMAC) {
            throw new IllegalArgumentException("HighGMAC secret is updated using Security setup.");
        }
        if (this.getAuthenticationMechanismName().getMechanismId() == Authentication.LOW) {
            return client.write(this, 7);
        }
        return client.method(this, 2, this.secret, DataType.OCTET_STRING);
    }

    public final byte[][] addUser(GXDLMSClient client, byte id, String name) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        GXCommon.setData(null, data, DataType.UINT8, id);
        GXCommon.setData(null, data, DataType.STRING, name);
        return client.method(this, 5, data.array(), DataType.STRUCTURE);
    }

    public final byte[][] removeUser(GXDLMSClient client, byte id, String name) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        GXCommon.setData(null, data, DataType.UINT8, id);
        GXCommon.setData(null, data, DataType.STRING, name);
        return client.method(this, 6, data.array(), DataType.STRUCTURE);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getObjectList(), this.clientSAP + "/" + this.serverSAP, this.getApplicationContextName(), this.getXDLMSContextInfo(), this.getAuthenticationMechanismName(), this.getSecret(), this.getAssociationStatus(), this.getSecuritySetupReference(), this.userList, this.currentUser};
    }

    static Object getKey(IGXCryptoNotifier cryptoNotifier, SecuritySuite securitySuite, CertificateType certificateType, byte[] systemTitle, boolean encrypt) {
        if (cryptoNotifier == null) {
            throw new RuntimeException("Failed to get the certificate.");
        }
        GXCryptoKeyParameter args = new GXCryptoKeyParameter();
        args.setEncrypt(encrypt);
        args.setSecuritySuite(securitySuite);
        args.setCertificateType(certificateType);
        args.setSystemTitle(systemTitle);
        PrivateKey key = null;
        PublicKey pub = null;
        cryptoNotifier.onKey(cryptoNotifier, args);
        if (encrypt) {
            key = args.getPrivateKey();
        } else {
            pub = args.getPublicKey();
        }
        if (encrypt) {
            return key;
        }
        return pub;
    }

    private byte[] replyToHlsAuthentication(GXDLMSSettings settings, ValueEventArgs e) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        Object tmp;
        byte[] readSecret;
        boolean accept;
        byte[] serverChallenge = null;
        byte[] clientChallenge = null;
        long ic = 0L;
        if (settings.getAuthentication() == Authentication.HIGH_ECDSA) {
            try {
                byte[] tmp2;
                Signature ver;
                if (settings.getSourceSystemTitle() == null || settings.getSourceSystemTitle().length != 8) {
                    throw new IllegalArgumentException("SourceSystemTitle is invalid.");
                }
                if (settings.getCipher().getSigningKeyPair() == null) {
                    PrivateKey key = (PrivateKey)GXDLMSAssociationLogicalName.getKey(settings.getCryptoNotifier(), settings.getCipher().getSecuritySuite(), CertificateType.DIGITAL_SIGNATURE, settings.getCipher().getSystemTitle(), true);
                    PublicKey pub = (PublicKey)GXDLMSAssociationLogicalName.getKey(settings.getCryptoNotifier(), settings.getCipher().getSecuritySuite(), CertificateType.DIGITAL_SIGNATURE, settings.getCipher().getSystemTitle(), false);
                    settings.getCipher().setKeyAgreementKeyPair(new KeyPair(pub, key));
                }
                GXByteBuffer signature = new GXByteBuffer((byte[])e.getParameters());
                if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                    ver = Signature.getInstance("SHA256withECDSA");
                    tmp2 = GXAsn1Converter.toByteArray(new Object[]{new GXAsn1Integer(signature.subArray(0, 32)), new GXAsn1Integer(signature.subArray(32, 32))});
                } else if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_2) {
                    ver = Signature.getInstance("SHA384withECDSA");
                    tmp2 = GXAsn1Converter.toByteArray(new Object[]{new GXAsn1Integer(signature.subArray(0, 48)), new GXAsn1Integer(signature.subArray(48, 48))});
                } else {
                    throw new IllegalArgumentException("Invalid security suite.");
                }
                signature.size(0);
                signature.set(tmp2);
                ver.initVerify(settings.getCipher().getSigningKeyPair().getPublic());
                GXByteBuffer bb = new GXByteBuffer();
                bb.set(settings.getSourceSystemTitle());
                bb.set(settings.getCipher().getSystemTitle());
                bb.set(settings.getStoCChallenge());
                bb.set(settings.getCtoSChallenge());
                ver.update(bb.array());
                LOGGER.log(Level.INFO, "StoC " + bb.toHex(true, 0));
                accept = ver.verify(signature.array());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        } else {
            if (settings.getAuthentication() == Authentication.HIGH_GMAC) {
                readSecret = settings.getSourceSystemTitle();
                GXByteBuffer bb = new GXByteBuffer((byte[])e.getParameters());
                bb.getUInt8();
                ic = bb.getUInt32();
            } else if (settings.getAuthentication() == Authentication.HIGH_SHA256) {
                tmp = new GXByteBuffer();
                ((GXByteBuffer)tmp).set(this.secret);
                ((GXByteBuffer)tmp).set(settings.getSourceSystemTitle());
                ((GXByteBuffer)tmp).set(settings.getCipher().getSystemTitle());
                ((GXByteBuffer)tmp).set(settings.getStoCChallenge());
                ((GXByteBuffer)tmp).set(settings.getCtoSChallenge());
                readSecret = ((GXByteBuffer)tmp).array();
            } else {
                readSecret = this.secret;
            }
            serverChallenge = GXSecure.secure(settings, settings.getCipher(), ic, settings.getStoCChallenge(), readSecret);
            clientChallenge = (byte[])e.getParameters();
            accept = GXCommon.compare(serverChallenge, clientChallenge);
        }
        if (accept) {
            if (settings.getAuthentication() == Authentication.HIGH_GMAC) {
                readSecret = settings.getCipher().getSystemTitle();
                ic = settings.getCipher().getInvocationCounter();
            } else {
                readSecret = this.secret;
            }
            if (settings.getAuthentication() == Authentication.HIGH_SHA256 || settings.getAuthentication() == Authentication.HIGH_ECDSA) {
                tmp = new GXByteBuffer();
                ((GXByteBuffer)tmp).set(this.secret);
                ((GXByteBuffer)tmp).set(settings.getCipher().getSystemTitle());
                ((GXByteBuffer)tmp).set(settings.getSourceSystemTitle());
                ((GXByteBuffer)tmp).set(settings.getCtoSChallenge());
                ((GXByteBuffer)tmp).set(settings.getStoCChallenge());
                readSecret = ((GXByteBuffer)tmp).array();
            }
            tmp = GXSecure.secure(settings, settings.getCipher(), ic, settings.getCtoSChallenge(), readSecret);
            this.associationStatus = AssociationStatus.ASSOCIATED;
            return tmp;
        }
        LOGGER.info("Invalid CtoS:" + GXCommon.toHex(serverChallenge, false) + "-" + GXCommon.toHex(clientChallenge, false));
        this.associationStatus = AssociationStatus.NON_ASSOCIATED;
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private void changeHlsSecret(GXDLMSSettings settings, ValueEventArgs e) {
        byte[] tmp = (byte[])e.getParameters();
        if (tmp == null || tmp.length == 0) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else {
            this.secret = tmp;
        }
    }

    private void removeObject(GXDLMSSettings settings, ValueEventArgs e) {
        GXDLMSObject obj = this.getObject(settings, (List)e.getParameters(), false);
        if (obj == this || obj instanceof GXDLMSAssociationLogicalName && obj.getLogicalName().compareTo("0.0.40.0.0.255") == 0) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        } else if (obj instanceof IGXDLMSBase) {
            GXDLMSObject t = this.objectList.findByLN(obj.getObjectType(), obj.getLogicalName());
            if (t != null) {
                this.objectList.remove(t);
            }
            boolean exists = false;
            for (GXDLMSObject it : settings.getObjects().getObjects(ObjectType.ASSOCIATION_LOGICAL_NAME)) {
                if (it == obj) continue;
                GXDLMSAssociationLogicalName a = (GXDLMSAssociationLogicalName)it;
                if (a.objectList.indexOf(obj) == -1) continue;
                exists = true;
                break;
            }
            if (!exists) {
                settings.getObjects().remove(obj);
            }
        }
    }

    private void addObject(GXDLMSSettings settings, ValueEventArgs e) {
        GXDLMSObject obj = this.getObject(settings, (List)e.getParameters(), true);
        if (obj instanceof IGXDLMSBase) {
            if (this.objectList.findByLN(obj.getObjectType(), obj.getLogicalName()) == null) {
                this.objectList.add(obj);
                if (settings.isServer()) {
                    int pos;
                    if (obj instanceof GXDLMSAssociationLogicalName) {
                        if (obj.getLogicalName().compareTo("0.0.40.0.0.255") == 0) {
                            e.setError(ErrorCode.UNDEFINED_OBJECT);
                            return;
                        }
                        obj.setVersion(this.version);
                        GXDLMSAssociationLogicalName ln = (GXDLMSAssociationLogicalName)obj;
                        ln.getXDLMSContextInfo().setConformance(this.xDLMSContextInfo.getConformance());
                        ln.getXDLMSContextInfo().setMaxReceivePduSize(this.xDLMSContextInfo.getMaxReceivePduSize());
                        ln.getXDLMSContextInfo().setMaxSendPduSize(this.xDLMSContextInfo.getMaxSendPduSize());
                    } else if (obj instanceof GXDLMSSecuritySetup) {
                        GXDLMSSecuritySetup ss = (GXDLMSSecuritySetup)obj;
                        ss.setServerSystemTitle(settings.getCipher().getSystemTitle());
                        ss.setGuek(settings.getCipher().getBlockCipherKey());
                        ss.setGbek(settings.getCipher().getBroadcastBlockCipherKey());
                        ss.setGak(settings.getCipher().getAuthenticationKey());
                        ss.setKek(settings.getKek());
                    }
                    int count = obj.getAttributeCount();
                    int[] list = new int[count];
                    for (pos = 0; pos != count; ++pos) {
                        list[pos] = this.getVersion() < 3 ? obj.getAccess(1 + pos).getValue() : AccessMode3.toInteger(obj.getAccess3(1 + pos));
                    }
                    this.accessRights.put(obj, list);
                    count = obj.getMethodCount();
                    list = new int[count];
                    for (pos = 0; pos != count; ++pos) {
                        list[pos] = this.getVersion() < 3 ? obj.getMethodAccess(1 + pos).getValue() : MethodAccessMode3.toInteger(obj.getMethodAccess3(1 + pos));
                    }
                    this.methodAccessRights.put(obj, list);
                }
            }
        } else {
            e.setError(ErrorCode.UNDEFINED_OBJECT);
        }
    }

    private void addUser(GXDLMSSettings settings, ValueEventArgs e) {
        List tmp = (List)e.getParameters();
        if (tmp == null || tmp.size() != 2) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else {
            this.userList.add(new GXSimpleEntry<Byte, String>(((Number)tmp.get(0)).byteValue(), (String)tmp.get(1)));
        }
    }

    private void removeUser(GXDLMSSettings settings, ValueEventArgs e) {
        List tmp = (List)e.getParameters();
        if (tmp == null || tmp.size() != 2) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else {
            byte id = ((Number)tmp.get(0)).byteValue();
            String name = (String)tmp.get(1);
            for (Map.Entry<Byte, String> it : this.userList) {
                if (it.getKey() != id || it.getValue().compareTo(name) != 0) continue;
                this.userList.remove(it);
                break;
            }
        }
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        switch (e.getIndex()) {
            case 1: {
                return this.replyToHlsAuthentication(settings, e);
            }
            case 2: {
                this.changeHlsSecret(settings, e);
                break;
            }
            case 3: {
                this.addObject(settings, e);
                break;
            }
            case 4: {
                this.removeObject(settings, e);
                break;
            }
            case 5: {
                this.addUser(settings, e);
                break;
            }
            case 6: {
                this.removeUser(settings, e);
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        if (all || !this.isRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        if (this.getVersion() > 0 && (all || !this.isRead(9))) {
            attributes.add(9);
        }
        if (this.getVersion() > 1) {
            if (all || !this.isRead(10)) {
                attributes.add(10);
            }
            if (all || !this.isRead(11)) {
                attributes.add(11);
            }
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() > 1) {
            return 11;
        }
        if (this.getVersion() > 0) {
            return 9;
        }
        return 8;
    }

    @Override
    public final int getMethodCount() {
        if (this.getVersion() > 1) {
            return 6;
        }
        return 4;
    }

    private byte[] getObjects(GXDLMSSettings settings, ValueEventArgs e) {
        try {
            boolean found = false;
            GXByteBuffer data = new GXByteBuffer();
            if (settings.getIndex() == 0L) {
                int count = this.objectList.size();
                if (this.associationStatus == AssociationStatus.ASSOCIATED) {
                    for (GXDLMSObject it : this.objectList) {
                        if (it == this || it.getObjectType() != ObjectType.ASSOCIATION_LOGICAL_NAME) continue;
                        if (it.getLogicalName().equals("0.0.40.0.0.255")) {
                            found = true;
                            continue;
                        }
                        if (this.multipleAssociationViews) continue;
                        --count;
                    }
                    if (!found) {
                        ++count;
                    }
                } else {
                    found = true;
                }
                settings.setCount(count);
                data.setUInt8(DataType.ARRAY.getValue());
                GXCommon.setObjectCount(count, data);
                if (!found) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(4);
                    GXCommon.setData(settings, data, DataType.UINT16, this.getObjectType().getValue());
                    GXCommon.setData(settings, data, DataType.UINT8, this.getVersion());
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes("0.0.40.0.0.255"));
                    this.getAccessRights(settings, this, e.getServer(), data);
                }
            }
            int pos = 0;
            boolean gbt = settings.getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER);
            for (GXDLMSObject it : this.objectList) {
                if ((long)(++pos) <= settings.getIndex()) continue;
                if (it.getObjectType() == ObjectType.ASSOCIATION_LOGICAL_NAME && !this.multipleAssociationViews && it != this && !it.getLogicalName().equals("0.0.40.0.0.255")) {
                    settings.setIndex(settings.getIndex() + 1L);
                    continue;
                }
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(4);
                GXCommon.setData(settings, data, DataType.UINT16, it.getObjectType().getValue());
                GXCommon.setData(settings, data, DataType.UINT8, it.getVersion());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getLogicalName()));
                this.getAccessRights(settings, it, e.getServer(), data);
                settings.setIndex(settings.getIndex() + 1L);
                if (!settings.isServer() || gbt || e.isSkipMaxPduSize() || data.size() < settings.getMaxPduSize()) continue;
                break;
            }
            if (pos == this.objectList.size()) {
                settings.setCount(0L);
                settings.setIndex(0L);
            }
            return data.array();
        }
        catch (Exception ex) {
            e.setError(ErrorCode.HARDWARE_FAULT);
            return null;
        }
    }

    private void getAccessRights(GXDLMSSettings settings, GXDLMSObject item, GXDLMSServerBase server, GXByteBuffer data) throws Exception {
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        if (server == null) {
            data.setUInt8(DataType.ARRAY.getValue());
            data.setUInt8(0);
            data.setUInt8(DataType.ARRAY.getValue());
            data.setUInt8(0);
        } else {
            int m;
            int pos;
            data.setUInt8(DataType.ARRAY.getValue());
            int cnt = item.getAttributeCount();
            data.setUInt8(cnt);
            ValueEventArgs e = new ValueEventArgs(server, item, 0, 0, null);
            for (pos = 0; pos != cnt; ++pos) {
                e.setIndex(pos + 1);
                m = server.notifyGetAttributeAccess(e);
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(3);
                GXCommon.setData(settings, data, DataType.INT8, pos + 1);
                GXCommon.setData(settings, data, DataType.ENUM, m);
                GXCommon.setData(settings, data, DataType.NONE, null);
            }
            data.setUInt8(DataType.ARRAY.getValue());
            cnt = item.getMethodCount();
            data.setUInt8(cnt);
            for (pos = 0; pos != cnt; ++pos) {
                e.setIndex(pos + 1);
                data.setUInt8(DataType.STRUCTURE.getValue());
                data.setUInt8(2);
                GXCommon.setData(settings, data, DataType.INT8, pos + 1);
                m = server.notifyGetMethodAccess(e);
                if (this.getVersion() == 0) {
                    GXCommon.setData(settings, data, DataType.BOOLEAN, m != 0);
                    continue;
                }
                GXCommon.setData(settings, data, DataType.ENUM, m);
            }
        }
    }

    final void updateAccessRights(GXDLMSObject obj, List<?> buff) {
        if (buff != null && !buff.isEmpty()) {
            int tmp;
            int id;
            int ver = obj instanceof GXDLMSAssociationLogicalName ? obj.getVersion() : this.getVersion();
            for (Object access : (List)buff.get(0)) {
                List attributeAccess = (List)access;
                id = ((Number)attributeAccess.get(0)).intValue();
                tmp = ((Number)attributeAccess.get(1)).intValue();
                if (ver < 3) {
                    obj.setAccess(id, AccessMode.forValue(tmp));
                    continue;
                }
                obj.setAccess3(id, AccessMode3.forValue(tmp));
            }
            for (Object access : (List)buff.get(1)) {
                List methodAccess = (List)access;
                id = ((Number)methodAccess.get(0)).intValue();
                tmp = methodAccess.get(1) instanceof Boolean ? (((Boolean)methodAccess.get(1)).booleanValue() ? 1 : 0) : ((Number)methodAccess.get(1)).intValue();
                if (ver < 3) {
                    obj.setMethodAccess(id, MethodAccessMode.forValue(tmp));
                    continue;
                }
                obj.setMethodAccess3(id, MethodAccessMode3.forValue(tmp));
            }
        }
    }

    private GXByteBuffer getUserList(GXDLMSSettings settings, ValueEventArgs e) {
        GXByteBuffer data = new GXByteBuffer();
        if (settings.getIndex() == 0L) {
            settings.setCount(this.userList.size());
            data.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(this.userList.size(), data);
        }
        int pos = 0;
        for (Map.Entry<Byte, String> it : this.userList) {
            if ((long)(++pos) <= settings.getIndex()) continue;
            settings.setIndex(settings.getIndex() + 1L);
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(settings, data, DataType.UINT8, it.getKey());
            GXCommon.setData(settings, data, DataType.STRING, it.getValue());
        }
        return data;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.STRUCTURE;
        }
        if (index == 4) {
            return DataType.STRUCTURE;
        }
        if (index == 5) {
            return DataType.STRUCTURE;
        }
        if (index == 6) {
            return DataType.STRUCTURE;
        }
        if (index == 7) {
            return DataType.OCTET_STRING;
        }
        if (index == 8) {
            return DataType.ENUM;
        }
        if (this.getVersion() > 0 && index == 9) {
            return DataType.OCTET_STRING;
        }
        if (this.getVersion() > 1) {
            if (index == 10) {
                return DataType.ARRAY;
            }
            if (index == 11) {
                return DataType.STRUCTURE;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getObjects(settings, e);
        }
        if (e.getIndex() == 3) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            data.setUInt8(DataType.INT8.getValue());
            data.setUInt8(this.clientSAP);
            data.setUInt8(DataType.UINT16.getValue());
            data.setUInt16(this.serverSAP);
            return data.array();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(7);
            GXCommon.setData(settings, data, DataType.UINT8, this.applicationContextName.getJointIsoCtt());
            GXCommon.setData(settings, data, DataType.UINT8, this.applicationContextName.getCountry());
            GXCommon.setData(settings, data, DataType.UINT16, this.applicationContextName.getCountryName());
            GXCommon.setData(settings, data, DataType.UINT8, this.applicationContextName.getIdentifiedOrganization());
            GXCommon.setData(settings, data, DataType.UINT8, this.applicationContextName.getDlmsUA());
            GXCommon.setData(settings, data, DataType.UINT8, this.applicationContextName.getApplicationContext());
            GXCommon.setData(settings, data, DataType.UINT8, this.applicationContextName.getContextId().getValue());
            return data.array();
        }
        if (e.getIndex() == 5) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(6);
            GXCommon.setData(settings, data, DataType.BITSTRING, GXBitString.toBitString(Conformance.toInteger(this.xDLMSContextInfo.getConformance()), 24));
            GXCommon.setData(settings, data, DataType.UINT16, this.xDLMSContextInfo.getMaxReceivePduSize());
            GXCommon.setData(settings, data, DataType.UINT16, this.xDLMSContextInfo.getMaxSendPduSize());
            GXCommon.setData(settings, data, DataType.UINT8, this.xDLMSContextInfo.getDlmsVersionNumber());
            GXCommon.setData(settings, data, DataType.INT8, this.xDLMSContextInfo.getQualityOfService());
            GXCommon.setData(settings, data, DataType.OCTET_STRING, this.xDLMSContextInfo.getCypheringInfo());
            return data.array();
        }
        if (e.getIndex() == 6) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(7);
            GXCommon.setData(settings, data, DataType.UINT8, this.authenticationMechanismName.getJointIsoCtt());
            GXCommon.setData(settings, data, DataType.UINT8, this.authenticationMechanismName.getCountry());
            GXCommon.setData(settings, data, DataType.UINT16, this.authenticationMechanismName.getCountryName());
            GXCommon.setData(settings, data, DataType.UINT8, this.authenticationMechanismName.getIdentifiedOrganization());
            GXCommon.setData(settings, data, DataType.UINT8, this.authenticationMechanismName.getDlmsUA());
            GXCommon.setData(settings, data, DataType.UINT8, this.authenticationMechanismName.getAuthenticationMechanismName());
            GXCommon.setData(settings, data, DataType.UINT8, this.authenticationMechanismName.getMechanismId().getValue());
            return data.array();
        }
        if (e.getIndex() == 7) {
            return this.secret;
        }
        if (e.getIndex() == 8) {
            return this.getAssociationStatus().ordinal();
        }
        if (e.getIndex() == 9) {
            return GXCommon.logicalNameToBytes(this.getSecuritySetupReference());
        }
        if (e.getIndex() == 10) {
            return this.getUserList(settings, e).array();
        }
        if (e.getIndex() == 11) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            if (this.currentUser == null) {
                GXCommon.setData(settings, data, DataType.UINT8, 0);
                GXCommon.setData(settings, data, DataType.STRING, null);
            } else {
                GXCommon.setData(settings, data, DataType.UINT8, this.currentUser.getKey());
                GXCommon.setData(settings, data, DataType.STRING, this.currentUser.getValue());
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private GXDLMSObject getObject(GXDLMSSettings settings, List<?> item, boolean add) {
        ObjectType type = ObjectType.forValue(((Number)item.get(0)).intValue());
        int version = ((Number)item.get(1)).intValue();
        String ln = GXCommon.toLogicalName((byte[])item.get(2));
        GXDLMSObject obj = settings.getObjects().findByLN(type, ln);
        if (obj == null) {
            obj = GXDLMSClient.createObject(type);
            obj.setLogicalName(ln);
            obj.setVersion(version);
            if (settings.isServer() && add) {
                settings.getObjects().add(obj);
            }
        }
        if (add && obj instanceof IGXDLMSBase && item.get(3) != null) {
            List arr = (List)item.get(3);
            this.updateAccessRights(obj, arr);
        }
        return obj;
    }

    private void updateObjectList(GXDLMSSettings settings, GXDLMSObjectCollection target, Object value) {
        target.clear();
        if (value != null) {
            for (Object tmp : (List)value) {
                List item = (List)tmp;
                GXDLMSObject obj = this.getObject(settings, item, true);
                if (!(obj instanceof IGXDLMSBase)) continue;
                target.add(obj);
            }
        }
    }

    private void updateApplicationContextName(Object value) {
        if (value instanceof byte[]) {
            GXByteBuffer buff = new GXByteBuffer((byte[])value);
            if (buff.getUInt8(0) == 96) {
                this.applicationContextName.setJointIsoCtt(0);
                this.applicationContextName.setCountry(0);
                this.applicationContextName.setCountryName(0);
                buff.position(buff.position() + 3);
                this.applicationContextName.setIdentifiedOrganization(buff.getUInt8());
                this.applicationContextName.setDlmsUA(buff.getUInt8());
                this.applicationContextName.setApplicationContext(buff.getUInt8());
                this.applicationContextName.setContextId(ApplicationContextName.forValue(buff.getUInt8()));
            } else {
                if (buff.getUInt8() != 2 && buff.getUInt8() != 7) {
                    throw new IllegalArgumentException();
                }
                if (buff.getUInt8() != 17) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setJointIsoCtt(buff.getUInt8());
                if (buff.getUInt8() != 17) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setCountry(buff.getUInt8());
                if (buff.getUInt8() != 18) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setCountryName(buff.getUInt16());
                if (buff.getUInt8() != 17) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setIdentifiedOrganization(buff.getUInt8());
                if (buff.getUInt8() != 17) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setDlmsUA(buff.getUInt8());
                if (buff.getUInt8() != 17) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setApplicationContext(buff.getUInt8());
                if (buff.getUInt8() != 17) {
                    throw new IllegalArgumentException();
                }
                this.applicationContextName.setContextId(ApplicationContextName.forValue(buff.getUInt8()));
            }
        } else if (value != null) {
            List arr = (List)value;
            this.applicationContextName.setJointIsoCtt(((Number)arr.get(0)).intValue());
            this.applicationContextName.setCountry(((Number)arr.get(1)).intValue());
            this.applicationContextName.setCountryName(((Number)arr.get(2)).intValue());
            this.applicationContextName.setIdentifiedOrganization(((Number)arr.get(3)).intValue());
            this.applicationContextName.setDlmsUA(((Number)arr.get(4)).intValue());
            this.applicationContextName.setApplicationContext(((Number)arr.get(5)).intValue());
            this.applicationContextName.setContextId(ApplicationContextName.forValue(((Number)arr.get(6)).intValue()));
        }
    }

    private void updateAuthenticationMechanismName(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                GXByteBuffer buff = new GXByteBuffer((byte[])value);
                if (buff.getUInt8(0) == 96) {
                    this.authenticationMechanismName.setJointIsoCtt(0);
                    this.authenticationMechanismName.setCountry(0);
                    this.authenticationMechanismName.setCountryName(0);
                    buff.position(buff.position() + 3);
                    this.authenticationMechanismName.setIdentifiedOrganization(buff.getUInt8());
                    this.authenticationMechanismName.setDlmsUA(buff.getUInt8());
                    this.authenticationMechanismName.setAuthenticationMechanismName(buff.getUInt8());
                    this.authenticationMechanismName.setMechanismId(Authentication.forValue(buff.getUInt8()));
                } else {
                    if (buff.getUInt8() != 2 && buff.getUInt8() != 7) {
                        throw new IllegalArgumentException();
                    }
                    if (buff.getUInt8() != 17) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setJointIsoCtt(buff.getUInt8());
                    if (buff.getUInt8() != 17) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setCountry(buff.getUInt8());
                    if (buff.getUInt8() != 18) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setCountryName(buff.getUInt16());
                    if (buff.getUInt8() != 17) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setIdentifiedOrganization(buff.getUInt8());
                    if (buff.getUInt8() != 17) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setDlmsUA(buff.getUInt8());
                    if (buff.getUInt8() != 17) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setAuthenticationMechanismName(buff.getUInt8());
                    if (buff.getUInt8() != 17) {
                        throw new IllegalArgumentException();
                    }
                    this.authenticationMechanismName.setMechanismId(Authentication.forValue(buff.getUInt8()));
                }
            } else {
                List arr = (List)value;
                this.authenticationMechanismName.setJointIsoCtt(((Number)arr.get(0)).intValue());
                this.authenticationMechanismName.setCountry(((Number)arr.get(1)).intValue());
                this.authenticationMechanismName.setCountryName(((Number)arr.get(2)).intValue());
                this.authenticationMechanismName.setIdentifiedOrganization(((Number)arr.get(3)).intValue());
                this.authenticationMechanismName.setDlmsUA(((Number)arr.get(4)).intValue());
                this.authenticationMechanismName.setAuthenticationMechanismName(((Number)arr.get(5)).intValue());
                this.authenticationMechanismName.setMechanismId(Authentication.forValue(((Number)arr.get(6)).intValue()));
            }
        }
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.updateObjectList(settings, this.objectList, e.getValue());
                break;
            }
            case 3: {
                if (e.getValue() == null) break;
                List tmp = (List)e.getValue();
                this.clientSAP = ((Number)tmp.get(0)).shortValue();
                this.serverSAP = ((Number)tmp.get(1)).shortValue();
                break;
            }
            case 4: {
                this.updateApplicationContextName(e.getValue());
                break;
            }
            case 5: {
                if (e.getValue() == null) break;
                List arr = (List)e.getValue();
                this.xDLMSContextInfo.setConformance(Conformance.forValue(((GXBitString)arr.get(0)).toInteger()));
                this.xDLMSContextInfo.setMaxReceivePduSize(((Number)arr.get(1)).intValue());
                this.xDLMSContextInfo.setMaxSendPduSize(((Number)arr.get(2)).intValue());
                this.xDLMSContextInfo.setDlmsVersionNumber(((Number)arr.get(3)).byteValue());
                this.xDLMSContextInfo.setQualityOfService(((Number)arr.get(4)).intValue());
                this.xDLMSContextInfo.setCypheringInfo((byte[])arr.get(5));
                break;
            }
            case 6: {
                this.updateAuthenticationMechanismName(e.getValue());
                break;
            }
            case 7: {
                this.secret = (byte[])e.getValue();
                break;
            }
            case 8: {
                if (e.getValue() == null) {
                    this.setAssociationStatus(AssociationStatus.NON_ASSOCIATED);
                    break;
                }
                this.setAssociationStatus(AssociationStatus.values()[((Number)e.getValue()).intValue()]);
                break;
            }
            case 9: {
                this.setSecuritySetupReference(GXCommon.toLogicalName((byte[])e.getValue()));
                break;
            }
            case 10: {
                this.userList.clear();
                if (e.getValue() == null) break;
                for (Object tmp : (List)e.getValue()) {
                    List item = (List)tmp;
                    this.userList.add(new GXSimpleEntry<Byte, String>((Byte)item.get(0), (String)item.get(1)));
                }
                break;
            }
            case 11: {
                if (e.getValue() != null) {
                    List tmp = (List)e.getValue();
                    this.currentUser = new GXSimpleEntry<Byte, String>(((Number)tmp.get(0)).byteValue(), (String)tmp.get(1));
                    break;
                }
                this.currentUser = null;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        String str;
        this.objectList.clear();
        if (reader.isStartElement("ObjectList", true)) {
            while (!reader.isEOF()) {
                if (reader.isStartElement()) {
                    int pos;
                    int[] buff;
                    byte[] tmp;
                    String target = reader.getName();
                    if (!target.startsWith("GXDLMS")) break;
                    str = target.substring(6);
                    reader.read();
                    ObjectType type = ObjectType.getEnum(target.substring(6));
                    if (type == null) {
                        throw new RuntimeException("Invalid object type: " + target + ".");
                    }
                    String ln = reader.readElementContentAsString("LN");
                    GXDLMSObject obj = reader.getObjects().findByLN(type, ln);
                    if (obj == null) {
                        obj = GXDLMSClient.createObject(type);
                        obj.setVersion(0);
                        obj.setLogicalName(ln);
                        reader.getObjects().add(obj);
                    }
                    this.objectList.add(obj);
                    String access = reader.readElementContentAsString("Access");
                    if (access != null && access != "") {
                        tmp = access.getBytes();
                        buff = new int[tmp.length];
                        for (pos = 0; pos != tmp.length; ++pos) {
                            buff[pos] = tmp[pos] - 48;
                        }
                        this.accessRights.put(obj, buff);
                    }
                    if ((access = reader.readElementContentAsString("Access3")) != null && access != "") {
                        buff = new int[access.length() / 4];
                        for (int pos2 = 0; pos2 != buff.length; ++pos2) {
                            buff[pos2] = Integer.parseInt(access.substring(4 * pos2, 4 * pos2 + 4), 16) & 0xFFFF7FFF;
                        }
                        this.accessRights.put(obj, buff);
                    }
                    if ((access = reader.readElementContentAsString("MethodAccess")) != null && access != "") {
                        tmp = access.getBytes();
                        buff = new int[tmp.length];
                        for (pos = 0; pos != tmp.length; ++pos) {
                            buff[pos] = tmp[pos] - 48;
                        }
                        this.methodAccessRights.put(obj, buff);
                    }
                    if ((access = reader.readElementContentAsString("MethodAccess3")) != null && access != "") {
                        buff = new int[access.length() / 4];
                        for (int pos3 = 0; pos3 != buff.length; ++pos3) {
                            buff[pos3] = Integer.parseInt(access.substring(4 * pos3, 4 * pos3 + 4), 16) & 0xFFFF7FFF;
                        }
                        this.methodAccessRights.put(obj, buff);
                    }
                    reader.readEndElement(target);
                    continue;
                }
                if (reader.getName().compareTo("ObjectList") == 0) break;
                reader.read();
            }
            reader.readEndElement("ObjectList");
            this.objectList.add(this);
        }
        this.clientSAP = (byte)reader.readElementContentAsInt("ClientSAP");
        this.serverSAP = (byte)reader.readElementContentAsInt("ServerSAP");
        if (reader.isStartElement("ApplicationContextName", true)) {
            this.applicationContextName.setJointIsoCtt(reader.readElementContentAsInt("JointIsoCtt"));
            this.applicationContextName.setCountry(reader.readElementContentAsInt("Country"));
            this.applicationContextName.setCountryName(reader.readElementContentAsInt("CountryName"));
            this.applicationContextName.setIdentifiedOrganization(reader.readElementContentAsInt("IdentifiedOrganization"));
            this.applicationContextName.setDlmsUA(reader.readElementContentAsInt("DlmsUA"));
            this.applicationContextName.setApplicationContext(reader.readElementContentAsInt("ApplicationContext"));
            this.applicationContextName.setContextId(ApplicationContextName.forValue(reader.readElementContentAsInt("ContextId")));
            reader.readEndElement("ApplicationContextName");
        }
        if (reader.isStartElement("XDLMSContextInfo", true)) {
            this.xDLMSContextInfo.setConformance(Conformance.forValue(reader.readElementContentAsInt("Conformance")));
            this.xDLMSContextInfo.setMaxReceivePduSize(reader.readElementContentAsInt("MaxReceivePduSize"));
            this.xDLMSContextInfo.setMaxSendPduSize(reader.readElementContentAsInt("MaxSendPduSize"));
            this.xDLMSContextInfo.setDlmsVersionNumber((byte)reader.readElementContentAsInt("DlmsVersionNumber"));
            this.xDLMSContextInfo.setQualityOfService(reader.readElementContentAsInt("QualityOfService"));
            this.xDLMSContextInfo.setCypheringInfo(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("CypheringInfo")));
            reader.readEndElement("XDLMSContextInfo");
        }
        if (reader.isStartElement("AuthenticationMechanismName", true) || reader.isStartElement("XDLMSContextInfo", true)) {
            this.authenticationMechanismName.setJointIsoCtt(reader.readElementContentAsInt("JointIsoCtt"));
            this.authenticationMechanismName.setCountry(reader.readElementContentAsInt("Country"));
            this.authenticationMechanismName.setCountryName(reader.readElementContentAsInt("CountryName"));
            this.authenticationMechanismName.setIdentifiedOrganization(reader.readElementContentAsInt("IdentifiedOrganization"));
            this.authenticationMechanismName.setDlmsUA(reader.readElementContentAsInt("DlmsUA"));
            this.authenticationMechanismName.setAuthenticationMechanismName(reader.readElementContentAsInt("AuthenticationMechanismName"));
            this.authenticationMechanismName.setMechanismId(Authentication.forValue(reader.readElementContentAsInt("MechanismId")));
            reader.readEndElement("AuthenticationMechanismName");
            reader.readEndElement("XDLMSContextInfo");
        }
        this.secret = (byte[])((str = reader.readElementContentAsString("Secret")) == null ? null : GXDLMSTranslator.hexToBytes(str));
        this.associationStatus = AssociationStatus.values()[reader.readElementContentAsInt("AssociationStatus")];
        this.securitySetupReference = reader.readElementContentAsString("SecuritySetupReference");
        this.userList.clear();
        if (reader.isStartElement("Users", true)) {
            while (reader.isStartElement("Item", true)) {
                byte id = (byte)reader.readElementContentAsInt("Id");
                String name = reader.readElementContentAsString("Name");
                this.userList.add(new GXSimpleEntry<Byte, String>(id, name));
            }
            reader.readEndElement("Users");
        }
        this.multipleAssociationViews = reader.readElementContentAsInt("MultipleAssociationViews") != 0;
    }

    private String getObjectName(ObjectType ot) {
        String name = String.valueOf((Object)ot).toLowerCase();
        CharSequence[] tmp = name.split("_");
        for (int pos = 0; pos != tmp.length; ++pos) {
            char[] array = tmp[pos].toCharArray();
            array[0] = Character.toUpperCase(array[0]);
            tmp[pos] = new String(array);
        }
        name = String.join((CharSequence)"", tmp);
        return name;
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.objectList != null) {
            writer.writeStartElement("ObjectList");
            StringBuilder sb = new StringBuilder();
            for (GXDLMSObject it : this.objectList) {
                int pos;
                if (it.getObjectType() == ObjectType.ASSOCIATION_LOGICAL_NAME && (it == this || it.getLogicalName().equals("0.0.40.0.0.255")) || !this.multipleAssociationViews && it.getObjectType() == ObjectType.ASSOCIATION_LOGICAL_NAME) continue;
                writer.writeStartElement("GXDLMS" + this.getObjectName(it.getObjectType()));
                writer.writeElementString("LN", it.getLogicalName());
                if (!this.accessRights.containsKey(it)) {
                    if (this.getVersion() < 3) {
                        for (int pos2 = 1; pos2 != ((IGXDLMSBase)((Object)it)).getAttributeCount() + 1; ++pos2) {
                            this.setAccess(it, pos2, it.getAccess(pos2));
                        }
                    } else {
                        for (int pos3 = 1; pos3 != ((IGXDLMSBase)((Object)it)).getAttributeCount() + 1; ++pos3) {
                            this.setAccess3(it, pos3, it.getAccess3(pos3));
                        }
                    }
                }
                if (this.accessRights.containsKey(it)) {
                    int[] buff = this.accessRights.get(it);
                    sb.setLength(0);
                    for (pos = 0; pos != buff.length; ++pos) {
                        if (this.getVersion() < 3) {
                            sb.append(String.valueOf(buff[pos]));
                            continue;
                        }
                        sb.append(Integer.toHexString(0x8000 | buff[pos]));
                    }
                    if (this.getVersion() < 3) {
                        writer.writeElementString("Access", sb.toString());
                    } else {
                        writer.writeElementString("Access3", sb.toString());
                    }
                }
                if (!this.methodAccessRights.containsKey(it)) {
                    if (this.getVersion() < 3) {
                        for (int pos4 = 1; pos4 != ((IGXDLMSBase)((Object)it)).getMethodCount() + 1; ++pos4) {
                            this.setMethodAccess(it, pos4, it.getMethodAccess(pos4));
                        }
                    } else {
                        for (int pos5 = 1; pos5 != ((IGXDLMSBase)((Object)it)).getMethodCount() + 1; ++pos5) {
                            this.setMethodAccess3(it, pos5, it.getMethodAccess3(pos5));
                        }
                    }
                }
                if (this.methodAccessRights.containsKey(it)) {
                    int[] buff = this.methodAccessRights.get(it);
                    sb.setLength(0);
                    for (pos = 0; pos != buff.length; ++pos) {
                        if (this.getVersion() < 3) {
                            sb.append(String.valueOf(buff[pos]));
                            continue;
                        }
                        sb.append(Integer.toHexString(0x8000 | buff[pos]));
                    }
                    if (this.getVersion() < 3) {
                        writer.writeElementString("MethodAccess", sb.toString());
                    } else {
                        writer.writeElementString("MethodAccess3", sb.toString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("ClientSAP", this.clientSAP);
        writer.writeElementString("ServerSAP", this.serverSAP);
        if (this.applicationContextName != null) {
            writer.writeStartElement("ApplicationContextName");
            writer.writeElementString("JointIsoCtt", this.applicationContextName.getJointIsoCtt());
            writer.writeElementString("Country", this.applicationContextName.getCountry());
            writer.writeElementString("CountryName", this.applicationContextName.getCountryName());
            writer.writeElementString("IdentifiedOrganization", this.applicationContextName.getIdentifiedOrganization());
            writer.writeElementString("DlmsUA", this.applicationContextName.getDlmsUA());
            writer.writeElementString("ApplicationContext", this.applicationContextName.getApplicationContext());
            writer.writeElementString("ContextId", this.applicationContextName.getContextId().getValue());
            writer.writeEndElement();
        }
        if (this.xDLMSContextInfo != null) {
            writer.writeStartElement("XDLMSContextInfo");
            writer.writeElementString("Conformance", Conformance.toInteger(this.xDLMSContextInfo.getConformance()));
            writer.writeElementString("MaxReceivePduSize", this.xDLMSContextInfo.getMaxReceivePduSize());
            writer.writeElementString("MaxSendPduSize", this.xDLMSContextInfo.getMaxSendPduSize());
            writer.writeElementString("DlmsVersionNumber", this.xDLMSContextInfo.getDlmsVersionNumber());
            writer.writeElementString("QualityOfService", this.xDLMSContextInfo.getQualityOfService());
            writer.writeElementString("CypheringInfo", GXDLMSTranslator.toHex(this.xDLMSContextInfo.getCypheringInfo()));
            writer.writeEndElement();
        }
        if (this.authenticationMechanismName != null) {
            writer.writeStartElement("AuthenticationMechanismName");
            writer.writeElementString("JointIsoCtt", this.authenticationMechanismName.getJointIsoCtt());
            writer.writeElementString("Country", this.authenticationMechanismName.getCountry());
            writer.writeElementString("CountryName", this.authenticationMechanismName.getCountryName());
            writer.writeElementString("IdentifiedOrganization", this.authenticationMechanismName.getIdentifiedOrganization());
            writer.writeElementString("DlmsUA", this.authenticationMechanismName.getDlmsUA());
            writer.writeElementString("AuthenticationMechanismName", this.authenticationMechanismName.getAuthenticationMechanismName());
            writer.writeElementString("MechanismId", this.authenticationMechanismName.getMechanismId().getValue());
            writer.writeEndElement();
        }
        writer.writeElementString("Secret", GXDLMSTranslator.toHex(this.secret));
        writer.writeElementString("AssociationStatus", this.associationStatus.ordinal());
        writer.writeElementString("SecuritySetupReference", this.securitySetupReference);
        if (this.userList != null) {
            writer.writeStartElement("Users");
            for (Map.Entry<Byte, String> it : this.userList) {
                writer.writeStartElement("User");
                writer.writeElementString("Id", it.getKey().byteValue());
                writer.writeElementString("Name", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("MultipleAssociationViews", this.multipleAssociationViews);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    public List<Map.Entry<Byte, String>> getUserList() {
        return this.userList;
    }

    public void setUserList(List<Map.Entry<Byte, String>> userList) {
        this.userList = userList;
    }

    public Map.Entry<Byte, String> getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(Map.Entry<Byte, String> currentUser) {
        this.currentUser = currentUser;
    }

    public boolean isMultipleAssociationViews() {
        return this.multipleAssociationViews;
    }

    public void setMultipleAssociationViews(boolean value) {
        this.multipleAssociationViews = value;
    }

    private static int getAttributeAccess(GXDLMSObject target, int attributeIndex) {
        if (attributeIndex == 1) {
            return AccessMode.READ.getValue();
        }
        GXDLMSAttributeSettings att = target.getAttributes().find(attributeIndex);
        if (att != null) {
            return att.getAccess().getValue();
        }
        switch (target.getObjectType()) {
            case ACCOUNT: {
                break;
            }
            case ACTION_SCHEDULE: {
                break;
            }
            case ACTIVITY_CALENDAR: {
                break;
            }
            case ARBITRATOR: {
                break;
            }
            case ASSOCIATION_LOGICAL_NAME: {
                if (attributeIndex == 8) {
                    return AccessMode.READ.getValue();
                }
            }
            case ASSOCIATION_SHORT_NAME: {
                break;
            }
            case AUTO_ANSWER: {
                break;
            }
            case AUTO_CONNECT: {
                break;
            }
            case CHARGE: {
                break;
            }
            case CLOCK: {
                break;
            }
            case COMPACT_DATA: {
                break;
            }
            case CREDIT: {
                break;
            }
            case DATA: {
                break;
            }
            case DATA_PROTECTION: {
                break;
            }
            case DEMAND_REGISTER: {
                break;
            }
            case DISCONNECT_CONTROL: {
                break;
            }
            case EXTENDED_REGISTER: {
                break;
            }
            case G3_PLC6_LO_WPAN: {
                break;
            }
            case G3_PLC_MAC_LAYER_COUNTERS: {
                break;
            }
            case G3_PLC_MAC_SETUP: {
                break;
            }
            case GPRS_SETUP: {
                break;
            }
            case GSM_DIAGNOSTIC: {
                break;
            }
            case IEC_61334_4_32_LLC_SETUP: {
                break;
            }
            case IEC_8802_LLC_TYPE1_SETUP: {
                break;
            }
            case IEC_8802_LLC_TYPE2_SETUP: {
                break;
            }
            case IEC_8802_LLC_TYPE3_SETUP: {
                break;
            }
            case IEC_HDLC_SETUP: {
                break;
            }
            case IEC_LOCAL_PORT_SETUP: {
                break;
            }
            case IEC_TWISTED_PAIR_SETUP: {
                break;
            }
            case IMAGE_TRANSFER: {
                break;
            }
            case IP4_SETUP: {
                break;
            }
            case IP6_SETUP: {
                break;
            }
            case LIMITER: {
                break;
            }
            case LLC_SSCS_SETUP: {
                break;
            }
            case MAC_ADDRESS_SETUP: {
                break;
            }
            case MBUS_CLIENT: {
                break;
            }
            case MBUS_MASTER_PORT_SETUP: {
                break;
            }
            case MBUS_SLAVE_PORT_SETUP: {
                break;
            }
            case MODEM_CONFIGURATION: {
                break;
            }
            case NONE: {
                break;
            }
            case PARAMETER_MONITOR: {
                break;
            }
            case PPP_SETUP: {
                break;
            }
            case PRIME_NB_OFDM_PLC_APPLICATIONS_IDENTIFICATION: {
                break;
            }
            case PRIME_NB_OFDM_PLC_MAC_COUNTERS: {
                break;
            }
            case PRIME_NB_OFDM_PLC_MAC_FUNCTIONAL_PARAMETERS: {
                break;
            }
            case PRIME_NB_OFDM_PLC_MAC_NETWORK_ADMINISTRATION_DATA: {
                break;
            }
            case PRIME_NB_OFDM_PLC_MAC_SETUP: {
                break;
            }
            case PRIME_NB_OFDM_PLC_PHYSICAL_LAYER_COUNTERS: {
                break;
            }
            case PROFILE_GENERIC: {
                break;
            }
            case PUSH_SETUP: {
                break;
            }
            case REGISTER: {
                break;
            }
            case REGISTER_ACTIVATION: {
                break;
            }
            case REGISTER_MONITOR: {
                break;
            }
            case REGISTER_TABLE: {
                break;
            }
            case SAP_ASSIGNMENT: {
                break;
            }
            case SCHEDULE: {
                break;
            }
            case SCRIPT_TABLE: {
                break;
            }
            case SECURITY_SETUP: {
                break;
            }
            case SFSK_ACTIVE_INITIATOR: {
                break;
            }
            case SFSK_MAC_COUNTERS: {
                break;
            }
            case SFSK_MAC_SYNCHRONIZATION_TIMEOUTS: {
                break;
            }
            case SFSK_PHY_MAC_SETUP: {
                break;
            }
            case SFSK_REPORTING_SYSTEM_LIST: {
                break;
            }
            case SMTP_SETUP: {
                break;
            }
            case SPECIAL_DAYS_TABLE: {
                break;
            }
            case STATUS_MAPPING: {
                break;
            }
            case TARIFF_PLAN: {
                break;
            }
            case TCP_UDP_SETUP: {
                break;
            }
            case TOKEN_GATEWAY: {
                break;
            }
            case UTILITY_TABLES: {
                break;
            }
            case WIRELESS_MODE_Q_CHANNEL: {
                break;
            }
            case ZIG_BEE_NETWORK_CONTROL: {
                break;
            }
            case ZIG_BEE_SAS_APS_FRAGMENTATION: {
                break;
            }
            case ZIG_BEE_SAS_JOIN: {
                break;
            }
            case ZIG_BEE_SAS_STARTUP: {
                break;
            }
        }
        return AccessMode.READ_WRITE.getValue();
    }

    public AccessMode getAccess(GXDLMSObject target, int index) {
        if (target == this || target instanceof GXDLMSAssociationLogicalName && target.getLogicalName().compareTo("0.0.40.0.0.255") == 0) {
            return this.getAccess(index);
        }
        int[] tmp = this.accessRights.get(target);
        if (tmp == null) {
            return AccessMode.forValue(GXDLMSAssociationLogicalName.getAttributeAccess(target, index));
        }
        return AccessMode.forValue(tmp[index - 1]);
    }

    public void setAccess(GXDLMSObject target, int index, AccessMode access) {
        if (this.accessRights.containsKey(target)) {
            this.accessRights.get((Object)target)[index - 1] = access.getValue();
        } else {
            int[] list = new int[target.getAttributeCount()];
            Arrays.fill(list, 3);
            list[index - 1] = access.getValue();
            this.accessRights.put(target, list);
        }
    }

    public void setAccess(GXDLMSObject target, AccessMode[] access) {
        int count = target.getAttributeCount();
        if (count < access.length) {
            throw new RuntimeException("Invalid access buffer.");
        }
        int[] buff = new int[count];
        Arrays.fill(buff, 3);
        for (int pos = 0; pos != access.length; ++pos) {
            buff[pos] = access[pos].getValue();
        }
        this.accessRights.put(target, buff);
    }

    public MethodAccessMode getMethodAccess(GXDLMSObject target, int index) {
        if (target == this || target instanceof GXDLMSAssociationLogicalName && target.getLogicalName().compareTo("0.0.40.0.0.255") == 0 || this.methodAccessRights.get(target) == null) {
            return this.getMethodAccess(index);
        }
        return MethodAccessMode.forValue(this.methodAccessRights.get(target)[index - 1]);
    }

    public void setMethodAccess(GXDLMSObject target, int index, MethodAccessMode access) {
        if (this.methodAccessRights.containsKey(target)) {
            this.methodAccessRights.get((Object)target)[index - 1] = access.getValue();
        } else {
            int[] list = new int[target.getMethodCount()];
            Arrays.fill(list, 1);
            list[index - 1] = access.getValue();
            this.methodAccessRights.put(target, list);
        }
    }

    public void setMethodAccess(GXDLMSObject target, MethodAccessMode[] access) {
        int count = target.getMethodCount();
        if (count < access.length) {
            throw new RuntimeException("Invalid access buffer.");
        }
        int[] buff = new int[count];
        Arrays.fill(buff, 1);
        for (int pos = 0; pos != access.length; ++pos) {
            buff[pos] = access[pos].getValue();
        }
        this.methodAccessRights.put(target, buff);
    }

    public Set<AccessMode3> getAccess3(GXDLMSObject target, int index) {
        if (target == this || target instanceof GXDLMSAssociationLogicalName && target.getLogicalName().compareTo("0.0.40.0.0.255") == 0) {
            return this.getAccess3(index);
        }
        int[] tmp = this.accessRights.get(target);
        if (tmp == null) {
            return AccessMode3.forValue(GXDLMSAssociationLogicalName.getAttributeAccess(target, index));
        }
        return AccessMode3.forValue(tmp[index - 1]);
    }

    public void setAccess3(GXDLMSObject target, int index, Set<AccessMode3> access) {
        if (this.accessRights.containsKey(target)) {
            this.accessRights.get((Object)target)[index - 1] = AccessMode3.toInteger(access);
        } else {
            int[] list = new int[target.getAttributeCount()];
            Arrays.fill(list, 3);
            list[index - 1] = AccessMode3.toInteger(access);
            this.accessRights.put(target, list);
        }
    }

    public void setAccess3(GXDLMSObject target, Set<AccessMode3>[] access) {
        int count = target.getAttributeCount();
        if (count < access.length) {
            throw new RuntimeException("Invalid access buffer.");
        }
        int[] buff = new int[count];
        Arrays.fill(buff, 3);
        for (int pos = 0; pos != access.length; ++pos) {
            buff[pos] = AccessMode3.toInteger(access[pos]);
        }
        this.accessRights.put(target, buff);
    }

    public Set<MethodAccessMode3> getMethodAccess3(GXDLMSObject target, int index) {
        if (target == this || target instanceof GXDLMSAssociationLogicalName && target.getLogicalName().compareTo("0.0.40.0.0.255") == 0 || this.accessRights.get(target) == null) {
            return this.getMethodAccess3(index);
        }
        return MethodAccessMode3.forValue(this.methodAccessRights.get(target)[index - 1]);
    }

    public void setMethodAccess3(GXDLMSObject target, int index, Set<MethodAccessMode3> access) {
        if (this.methodAccessRights.containsKey(target)) {
            this.methodAccessRights.get((Object)target)[index - 1] = MethodAccessMode3.toInteger(access);
        } else {
            int[] list = new int[target.getMethodCount()];
            Arrays.fill(list, 1);
            list[index - 1] = MethodAccessMode3.toInteger(access);
            this.methodAccessRights.put(target, list);
        }
    }

    public void setMethodAccess3(GXDLMSObject target, Set<MethodAccessMode3>[] access) {
        int count = target.getMethodCount();
        if (count < access.length) {
            throw new RuntimeException("Invalid access buffer.");
        }
        int[] buff = new int[count];
        Arrays.fill(buff, 1);
        for (int pos = 0; pos != access.length; ++pos) {
            buff[pos] = MethodAccessMode3.toInteger(access[pos]);
        }
        this.methodAccessRights.put(target, buff);
    }

    @Override
    public String[] getNames() {
        if (this.version == 0) {
            return new String[]{"Logical Name", "Object List", "Associated partners Id", "Application Context Name", "xDLMS Context Info", "Authentication Mechanism Name", "Secret", "Association Status"};
        }
        if (this.version == 1) {
            return new String[]{"Logical Name", "Object List", "Associated partners Id", "Application Context Name", "xDLMS Context Info", "Authentication Mechanism Name", "Secret", "Association Status", "Security Setup Reference"};
        }
        return new String[]{"Logical Name", "Object List", "Associated partners Id", "Application Context Name", "xDLMS Context Info", "Authentication Mechanism Name", "Secret", "Association Status", "Security Setup Reference", "UserList", "CurrentUser"};
    }

    @Override
    public String[] getMethodNames() {
        if (this.version > 1) {
            return new String[]{"Reply to HLS authentication", "Change HLS secret", "Add object", "Remove object", "Add user", "Remove user"};
        }
        return new String[]{"Reply to HLS authentication", "Change HLS secret", "Add object", "Remove object"};
    }
}

