/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.manufacturersettings.GXDLMSAttributeSettings;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.secure.GXSecure;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSAssociationShortName
extends GXDLMSObject
implements IGXDLMSBase {
    private static final Logger LOGGER = Logger.getLogger(GXDLMSAssociationShortName.class.getName());
    private GXDLMSObjectCollection objectList = new GXDLMSObjectCollection(this);
    private String securitySetupReference;
    private byte[] secret;

    public GXDLMSAssociationShortName() {
        this("0.0.40.0.0.255", 64000);
    }

    public GXDLMSAssociationShortName(String ln, int sn) {
        super(ObjectType.ASSOCIATION_SHORT_NAME, ln, sn);
        this.setVersion(2);
    }

    public final byte[] getSecret() {
        return this.secret;
    }

    public final void setSecret(byte[] value) {
        this.secret = value;
    }

    public final GXDLMSObjectCollection getObjectList() {
        return this.objectList;
    }

    public final String getSecuritySetupReference() {
        return this.securitySetupReference;
    }

    public final void setSecuritySetupReference(String value) {
        this.securitySetupReference = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getObjectList(), null, this.getSecuritySetupReference()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (e.getIndex() == 8) {
            GXByteBuffer tmp;
            byte[] readSecret;
            boolean accept;
            byte[] serverChallenge = null;
            byte[] clientChallenge = null;
            long ic = 0L;
            if (settings.getAuthentication() == Authentication.HIGH_ECDSA) {
                try {
                    Signature ver;
                    GXByteBuffer signature = new GXByteBuffer((byte[])e.getParameters());
                    if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                        ver = Signature.getInstance("SHA256withECDSA");
                    } else if (settings.getCipher().getSecuritySuite() == SecuritySuite.SUITE_2) {
                        ver = Signature.getInstance("SHA384withECDSA");
                    } else {
                        throw new IllegalArgumentException("Invalid security suite.");
                    }
                    ver.initVerify(((GXx509Certificate)settings.getCipher().getCertificates().get(0)).getPublicKey());
                    GXByteBuffer bb = new GXByteBuffer();
                    bb.set(settings.getSourceSystemTitle());
                    bb.set(settings.getCipher().getSystemTitle());
                    bb.set(settings.getStoCChallenge());
                    bb.set(settings.getCtoSChallenge());
                    ver.update(bb.array());
                    accept = ver.verify(signature.array());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
            } else {
                if (settings.getAuthentication() == Authentication.HIGH_GMAC) {
                    readSecret = settings.getSourceSystemTitle();
                    GXByteBuffer bb = new GXByteBuffer((byte[])e.getParameters());
                    bb.getUInt8();
                    ic = bb.getUInt32();
                } else if (settings.getAuthentication() == Authentication.HIGH_SHA256) {
                    tmp = new GXByteBuffer();
                    tmp.set(this.secret);
                    tmp.set(settings.getSourceSystemTitle());
                    tmp.set(settings.getCipher().getSystemTitle());
                    tmp.set(settings.getStoCChallenge());
                    tmp.set(settings.getCtoSChallenge());
                    readSecret = tmp.array();
                } else {
                    readSecret = this.secret;
                }
                serverChallenge = GXSecure.secure(settings, settings.getCipher(), ic, settings.getStoCChallenge(), readSecret);
                clientChallenge = (byte[])e.getParameters();
                accept = GXCommon.compare(serverChallenge, clientChallenge);
            }
            if (accept) {
                if (settings.getAuthentication() == Authentication.HIGH_GMAC) {
                    readSecret = settings.getCipher().getSystemTitle();
                    ic = settings.getCipher().getInvocationCounter();
                } else {
                    readSecret = this.secret;
                }
                settings.setConnected(settings.getConnected() | 2);
                if (settings.getAuthentication() == Authentication.HIGH_SHA256) {
                    tmp = new GXByteBuffer();
                    tmp.set(this.secret);
                    tmp.set(settings.getCipher().getSystemTitle());
                    tmp.set(settings.getSourceSystemTitle());
                    tmp.set(settings.getCtoSChallenge());
                    tmp.set(settings.getStoCChallenge());
                    readSecret = tmp.array();
                }
                return GXSecure.secure(settings, settings.getCipher(), ic, settings.getCtoSChallenge(), readSecret);
            }
            LOGGER.log(Level.INFO, "Invalid CtoS:" + GXCommon.toHex(serverChallenge, false) + "-" + GXCommon.toHex(clientChallenge, false));
            return null;
        }
        settings.setConnected(settings.getConnected() & 0xFFFFFFFD);
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (this.getVersion() > 1) {
            if (all || !this.isRead(3)) {
                attributes.add(3);
            }
            if (all || !this.isRead(4)) {
                attributes.add(4);
            }
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() < 2) {
            return 2;
        }
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 8;
    }

    private void getAccessRights(GXDLMSObject item, GXByteBuffer data) {
        data.setUInt8((byte)DataType.STRUCTURE.getValue());
        data.setUInt8(3);
        GXCommon.setData(null, data, DataType.UINT16, item.getShortName());
        data.setUInt8((byte)DataType.ARRAY.getValue());
        data.setUInt8((byte)item.getAttributes().size());
        for (GXDLMSAttributeSettings att : item.getAttributes()) {
            data.setUInt8((byte)DataType.STRUCTURE.getValue());
            data.setUInt8(3);
            GXCommon.setData(null, data, DataType.INT8, att.getIndex());
            GXCommon.setData(null, data, DataType.ENUM, att.getAccess().getValue());
            GXCommon.setData(null, data, DataType.NONE, null);
        }
        data.setUInt8((byte)DataType.ARRAY.getValue());
        data.setUInt8((byte)item.getMethodAttributes().size());
        for (GXDLMSAttributeSettings it : item.getMethodAttributes()) {
            data.setUInt8((byte)DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(null, data, DataType.INT8, it.getIndex());
            GXCommon.setData(null, data, DataType.ENUM, it.getMethodAccess().getValue());
        }
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.OCTET_STRING;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    private byte[] getObjects(GXDLMSSettings settings, ValueEventArgs e) {
        GXByteBuffer bb = new GXByteBuffer();
        int cnt = this.objectList.size();
        if (settings.getIndex() == 0L) {
            settings.setCount(cnt);
            bb.setUInt8((byte)DataType.ARRAY.getValue());
            GXCommon.setObjectCount(cnt, bb);
        }
        int pos = 0;
        if (cnt != 0) {
            for (GXDLMSObject it : this.objectList) {
                if ((long)(++pos) <= settings.getIndex()) continue;
                bb.setUInt8((byte)DataType.STRUCTURE.getValue());
                bb.setUInt8(4);
                GXCommon.setData(null, bb, DataType.INT16, it.getShortName());
                GXCommon.setData(null, bb, DataType.UINT16, it.getObjectType().getValue());
                GXCommon.setData(null, bb, DataType.UINT8, 0);
                GXCommon.setData(null, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getLogicalName()));
                settings.setIndex(settings.getIndex() + 1L);
                if (!settings.isServer() || e.isSkipMaxPduSize() || bb.size() < settings.getMaxPduSize()) continue;
                break;
            }
        }
        return bb.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        GXByteBuffer bb = new GXByteBuffer();
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getObjects(settings, e);
        }
        if (e.getIndex() == 3) {
            boolean lnExists = this.objectList.findBySN(this.getShortName()) != null;
            int cnt = this.objectList.size();
            if (!lnExists) {
                ++cnt;
            }
            bb.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(cnt, bb);
            for (GXDLMSObject it : this.objectList) {
                this.getAccessRights(it, bb);
            }
            if (!lnExists) {
                this.getAccessRights(this, bb);
            }
            return bb.array();
        }
        if (e.getIndex() == 4) {
            return GXCommon.getBytes(this.securitySetupReference);
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    final void updateAccessRights(List<?> buff) {
        for (Object access : buff) {
            Enum mode;
            int tmp;
            int id;
            List arr1;
            List arr = (List)access;
            int sn = ((Number)arr.get(0)).intValue();
            GXDLMSObject obj = this.objectList.findBySN(sn);
            if (obj == null) continue;
            for (Object attributeAccess : (List)arr.get(1)) {
                arr1 = (List)attributeAccess;
                id = ((Number)arr1.get(0)).intValue();
                tmp = ((Number)arr1.get(1)).intValue();
                mode = AccessMode.forValue(tmp);
                obj.setAccess(id, (AccessMode)mode);
            }
            for (Object methodAccess : (List)arr.get(2)) {
                arr1 = (List)methodAccess;
                id = ((Number)arr1.get(0)).intValue();
                tmp = ((Number)arr1.get(1)).intValue();
                mode = MethodAccessMode.forValue(tmp);
                obj.setMethodAccess(id, (MethodAccessMode)mode);
            }
        }
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.objectList.clear();
            if (e.getValue() != null) {
                for (Object item : (List)e.getValue()) {
                    List arr = (List)item;
                    int sn = ((Number)arr.get(0)).intValue() & 0xFFFF;
                    ObjectType type = ObjectType.forValue(((Number)arr.get(1)).intValue());
                    int version = ((Number)arr.get(2)).intValue();
                    String ln = GXCommon.toLogicalName((byte[])arr.get(3));
                    GXDLMSObject obj = GXDLMSClient.createObject(type);
                    obj.setLogicalName(ln);
                    obj.setShortName(sn);
                    obj.setVersion(version);
                    this.objectList.add(obj);
                }
            }
        } else if (e.getIndex() == 3) {
            if (e.getValue() == null) {
                for (GXDLMSObject it : this.objectList) {
                    for (int pos = 1; pos != it.getAttributeCount(); ++pos) {
                        it.setAccess(pos, AccessMode.NO_ACCESS);
                    }
                }
            } else {
                this.updateAccessRights((List)e.getValue());
            }
        } else if (e.getIndex() == 4) {
            if (e.getValue() instanceof String) {
                this.securitySetupReference = e.getValue().toString();
            } else if (e.getValue() != null) {
                this.securitySetupReference = new String((byte[])e.getValue());
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        String str = reader.readElementContentAsString("Secret");
        this.secret = (byte[])(str == null ? null : GXDLMSTranslator.hexToBytes(str));
        this.securitySetupReference = reader.readElementContentAsString("SecuritySetupReference");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Secret", GXDLMSTranslator.toHex(this.secret));
        writer.writeElementString("SecuritySetupReference", this.securitySetupReference);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        if (this.version < 2) {
            return new String[]{"Logical Name", "Object List"};
        }
        return new String[]{"Logical Name", "Object List", "Access Rights List", "Security Setup Reference"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Getlist by classid", "Getobj by logicalname", "Read by logicalname", "Get attributes&services", "Change LLS secret", "Change HLS secret", "Get HLS challenge", "Reply to HLS challenge", "Add user", "Remove user"};
    }
}

