/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.AutoConnectMode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSAutoConnect
extends GXDLMSObject
implements IGXDLMSBase {
    private AutoConnectMode mode;
    private List<Map.Entry<GXDateTime, GXDateTime>> callingWindow = new ArrayList<Map.Entry<GXDateTime, GXDateTime>>();
    private String[] destinations;
    private int repetitionDelay;
    private int repetitions;

    public GXDLMSAutoConnect() {
        this("0.0.2.1.0.255");
    }

    public GXDLMSAutoConnect(String ln) {
        this(ln, 0);
    }

    public GXDLMSAutoConnect(String ln, int sn) {
        super(ObjectType.AUTO_CONNECT, ln, sn);
        this.mode = AutoConnectMode.NO_AUTO_DIALLING;
        this.setVersion(2);
    }

    public final AutoConnectMode getMode() {
        return this.mode;
    }

    public final void setMode(AutoConnectMode value) {
        this.mode = value;
    }

    public final int getRepetitions() {
        return this.repetitions;
    }

    public final void setRepetitions(int value) {
        this.repetitions = value;
    }

    public final int getRepetitionDelay() {
        return this.repetitionDelay;
    }

    public final void setRepetitionDelay(int value) {
        this.repetitionDelay = value;
    }

    public final List<Map.Entry<GXDateTime, GXDateTime>> getCallingWindow() {
        return this.callingWindow;
    }

    public final void setCallingWindow(List<Map.Entry<GXDateTime, GXDateTime>> value) {
        this.callingWindow = value;
    }

    public final String[] getDestinations() {
        return this.destinations;
    }

    public final void setDestinations(String[] value) {
        this.destinations = value;
    }

    public final byte[][] connect(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getMode(), this.getRepetitions(), this.getRepetitionDelay(), this.getCallingWindow(), this.getDestinations()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() != 1) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.UINT8;
        }
        if (index == 4) {
            return DataType.UINT16;
        }
        if (index == 5) {
            return DataType.ARRAY;
        }
        if (index == 6) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return (byte)this.mode.getValue();
        }
        if (e.getIndex() == 3) {
            return this.getRepetitions();
        }
        if (e.getIndex() == 4) {
            return this.getRepetitionDelay();
        }
        if (e.getIndex() == 5) {
            int cnt = this.getCallingWindow().size();
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8((byte)DataType.ARRAY.getValue());
            GXCommon.setObjectCount(cnt, data);
            if (cnt != 0) {
                for (Map.Entry<GXDateTime, GXDateTime> it : this.callingWindow) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(2);
                    GXCommon.setData(null, data, DataType.OCTET_STRING, it.getKey());
                    GXCommon.setData(null, data, DataType.OCTET_STRING, it.getValue());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 6) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.getDestinations() == null) {
                GXCommon.setObjectCount(0, data);
            } else {
                int cnt = this.getDestinations().length;
                GXCommon.setObjectCount(cnt, data);
                for (String it : this.getDestinations()) {
                    GXCommon.setData(null, data, DataType.OCTET_STRING, GXCommon.getBytes(it));
                }
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setMode(AutoConnectMode.forValue(((Number)e.getValue()).intValue()));
        } else if (e.getIndex() == 3) {
            this.setRepetitions(((Number)e.getValue()).intValue());
        } else if (e.getIndex() == 4) {
            this.setRepetitionDelay(((Number)e.getValue()).intValue());
        } else if (e.getIndex() == 5) {
            this.getCallingWindow().clear();
            if (e.getValue() != null) {
                for (Object item : (List)e.getValue()) {
                    GXDateTime start = (GXDateTime)GXDLMSClient.changeType((byte[])((List)item).get(0), DataType.DATETIME, e.getSettings());
                    GXDateTime end = (GXDateTime)GXDLMSClient.changeType((byte[])((List)item).get(1), DataType.DATETIME, e.getSettings());
                    this.getCallingWindow().add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
                }
            }
        } else if (e.getIndex() == 6) {
            this.setDestinations(null);
            if (e.getValue() != null) {
                ArrayList<String> items = new ArrayList<String>();
                for (Object item : (List)e.getValue()) {
                    String it = GXDLMSClient.changeType((byte[])item, DataType.STRING, false).toString();
                    items.add(it);
                }
                this.setDestinations(items.toArray(new String[items.size()]));
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.mode = AutoConnectMode.forValue(reader.readElementContentAsInt("Mode"));
        this.repetitions = reader.readElementContentAsInt("Repetitions");
        this.repetitionDelay = reader.readElementContentAsInt("RepetitionDelay");
        this.callingWindow.clear();
        if (reader.isStartElement("CallingWindow", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDateTime start = reader.readElementContentAsDateTime("Start");
                GXDateTime end = reader.readElementContentAsDateTime("End");
                this.callingWindow.add(new AbstractMap.SimpleEntry<GXDateTime, GXDateTime>(start, end));
            }
            reader.readEndElement("CallingWindow");
        }
        this.destinations = GXCommon.split(reader.readElementContentAsString("Destinations", ""), ';').toArray(new String[0]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Mode", this.mode.getValue());
        writer.writeElementString("Repetitions", this.repetitions);
        writer.writeElementString("RepetitionDelay", this.repetitionDelay);
        if (this.callingWindow != null) {
            writer.writeStartElement("CallingWindow");
            for (Map.Entry<GXDateTime, GXDateTime> it : this.callingWindow) {
                writer.writeStartElement("Item");
                writer.writeElementString("Start", it.getKey());
                writer.writeElementString("End", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.destinations != null) {
            writer.writeElementString("Destinations", String.join((CharSequence)";", this.destinations));
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Mode", "Repetitions", "Repetition Delay", "Calling Window", "Destinations"};
    }

    @Override
    public String[] getMethodNames() {
        if (this.version == 0) {
            return new String[0];
        }
        return new String[]{"Connect"};
    }
}

