/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt64;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSData
extends GXDLMSObject
implements IGXDLMSBase {
    private Object value;

    public GXDLMSData() {
        this(null, 0);
    }

    public GXDLMSData(String ln) {
        this(ln, 0);
    }

    public GXDLMSData(String ln, int sn) {
        super(ObjectType.DATA, ln, sn);
    }

    public final Object getValue() {
        return this.value;
    }

    public final void setValue(Object forValue) {
        this.value = forValue;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getValue()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return super.getDataType(index);
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getValue();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            DataType dt2;
            DataType dt = this.getDataType(2);
            if (e.getValue() != null && (dt == DataType.NONE || dt == DataType.DATETIME || dt == DataType.STRING) && dt != (dt2 = GXDLMSConverter.getDLMSDataType(e.getValue()))) {
                this.setDataType(2, dt2);
            }
            if ((dt = this.getUIDataType(2)) == DataType.DATETIME && (e.getValue() instanceof GXUInt32 || e.getValue() instanceof GXUInt64 || e.getValue() instanceof Integer || e.getValue() instanceof Long)) {
                this.setValue(GXDateTime.fromUnixTime(((Number)e.getValue()).longValue()));
            } else {
                this.setValue(e.getValue());
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.value = reader.readElementContentAsObject("Value", null, this, 2);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        DataType dt = this.getDataType(2);
        if (this.value != null && dt == DataType.NONE) {
            dt = GXDLMSConverter.getDLMSDataType(this.value);
        }
        writer.writeElementObject("Value", this.value, dt, this.getUIDataType(2));
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Value"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

