/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt16;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSFunctionControl
extends GXDLMSObject
implements IGXDLMSBase {
    private ArrayList<Map.Entry<String, Boolean>> activationStatus = new ArrayList();
    private ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functionList = new ArrayList();

    public GXDLMSFunctionControl() {
        this("0.0.44.1.0.255", 0);
    }

    public GXDLMSFunctionControl(String ln) {
        this(ln, 0);
    }

    public GXDLMSFunctionControl(String ln, int sn) {
        super(ObjectType.FUNCTION_CONTROL, ln, sn);
    }

    public final ArrayList<Map.Entry<String, Boolean>> getActivationStatus() {
        return this.activationStatus;
    }

    public final void setActivationStatus(ArrayList<Map.Entry<String, Boolean>> value) {
        this.activationStatus = value;
    }

    public final ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> getFunctionList() {
        return this.functionList;
    }

    public final void setFunctionList(ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> value) {
        this.functionList = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getActivationStatus(), this.getFunctionList()};
    }

    public final byte[][] setFunctionStatus(GXDLMSClient client, ArrayList<Map.Entry<String, Boolean>> functions) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, GXDLMSFunctionControl.functionStatusToByteArray(functions), DataType.ARRAY);
    }

    public final byte[][] addFunction(GXDLMSClient client, ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functions) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, GXDLMSFunctionControl.functionListToByteArray(functions), DataType.ARRAY);
    }

    public final byte[][] RemoveFunction(GXDLMSClient client, ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functions) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, GXDLMSFunctionControl.functionListToByteArray(functions), DataType.ARRAY);
    }

    private static byte[] functionStatusToByteArray(ArrayList<Map.Entry<String, Boolean>> functions) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY);
        GXCommon.setObjectCount(functions.size(), bb);
        for (Map.Entry<String, Boolean> it : functions) {
            bb.setUInt8(DataType.STRUCTURE);
            bb.setUInt8(2);
            bb.setUInt8(DataType.OCTET_STRING);
            GXCommon.setObjectCount(it.getKey().length(), bb);
            bb.set(it.getKey().getBytes());
            bb.setUInt8(DataType.BOOLEAN);
            bb.setUInt8((byte)(it.getValue() != false ? 1 : 0));
        }
        return bb.array();
    }

    private static ArrayList<Map.Entry<String, Boolean>> functionStatusFromByteArray(ArrayList<?> values) {
        ArrayList<Map.Entry<String, Boolean>> functions = new ArrayList<Map.Entry<String, Boolean>>();
        for (Object tmp : values) {
            GXStructure it = (GXStructure)tmp;
            functions.add(new GXSimpleEntry<String, Boolean>(new String((byte[])it.get(0)), (Boolean)it.get(1)));
        }
        return functions;
    }

    private static byte[] functionListToByteArray(ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functions) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY);
        GXCommon.setObjectCount(functions.size(), bb);
        for (Map.Entry<String, ArrayList<GXDLMSObject>> it : functions) {
            bb.setUInt8(DataType.STRUCTURE);
            bb.setUInt8(2);
            bb.setUInt8(DataType.OCTET_STRING);
            GXCommon.setObjectCount(it.getKey().length(), bb);
            bb.set(it.getKey().getBytes());
            bb.setUInt8(DataType.ARRAY);
            GXCommon.setObjectCount(it.getValue().size(), bb);
            for (GXDLMSObject obj : it.getValue()) {
                bb.setUInt8(DataType.STRUCTURE);
                bb.setUInt8(2);
                bb.setUInt8(DataType.UINT16);
                bb.setUInt16(obj.getObjectType().getValue());
                GXCommon.setData(null, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(obj.getLogicalName()));
            }
        }
        return bb.array();
    }

    private static ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functionListFromByteArray(ArrayList<?> values) {
        ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functions = new ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>>();
        for (Object tmp : values) {
            GXStructure it = (GXStructure)tmp;
            String fn = new String((byte[])it.get(0));
            ArrayList<GXDLMSObject> objects = new ArrayList<GXDLMSObject>();
            for (Object tmp2 : (GXArray)it.get(1)) {
                GXStructure it2 = (GXStructure)tmp2;
                ObjectType ot = ObjectType.forValue(((GXUInt16)it2.get(0)).intValue());
                byte[] ln = (byte[])it2.get(1);
                GXDLMSObject obj = GXDLMSClient.createObject(ot);
                obj.setLogicalName(GXCommon.toLogicalName(ln));
                objects.add(obj);
            }
            functions.add(new GXSimpleEntry(fn, objects));
        }
        return functions;
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            ArrayList<Map.Entry<String, Boolean>> functions = GXDLMSFunctionControl.functionStatusFromByteArray((ArrayList)e.getParameters());
            block0: for (Map.Entry<String, Boolean> f : functions) {
                for (Map.Entry<String, Boolean> w : this.activationStatus) {
                    if (!f.getKey().equals(w.getKey())) continue;
                    w.setValue(f.getValue());
                    continue block0;
                }
            }
        } else if (e.getIndex() == 2) {
            ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functions = GXDLMSFunctionControl.functionListFromByteArray((ArrayList)e.getParameters());
            this.functionList.addAll(functions);
        } else if (e.getIndex() == 3) {
            ArrayList<Map.Entry<String, ArrayList<GXDLMSObject>>> functions = GXDLMSFunctionControl.functionListFromByteArray((ArrayList)e.getParameters());
            block2: for (Map.Entry<String, ArrayList<GXDLMSObject>> f : functions) {
                for (Map.Entry<String, ArrayList<GXDLMSObject>> w : this.functionList) {
                    if (!f.getKey().equals(w.getKey())) continue;
                    this.functionList.remove(f);
                    continue block2;
                }
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "ActivationStatus", "FunctionList"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[]{"SetFunctionStatus", "AddFunction", "RemoveFunction"};
    }

    @Override
    public final int getAttributeCount() {
        return 3;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.ARRAY;
            }
            case 3: {
                return DataType.ARRAY;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return GXDLMSFunctionControl.functionStatusToByteArray(this.getActivationStatus());
            }
            case 3: {
                return GXDLMSFunctionControl.functionListToByteArray(this.getFunctionList());
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.setActivationStatus(GXDLMSFunctionControl.functionStatusFromByteArray((ArrayList)e.getValue()));
                break;
            }
            case 3: {
                this.setFunctionList(GXDLMSFunctionControl.functionListFromByteArray((ArrayList)e.getValue()));
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        String name;
        if (reader.isStartElement("Activations", true)) {
            this.getActivationStatus().clear();
            while (reader.isStartElement("Item", true)) {
                name = reader.readElementContentAsString("Name");
                boolean status = reader.readElementContentAsInt("Status") != 0;
                this.getActivationStatus().add(new GXSimpleEntry<String, Boolean>(name, status));
            }
            reader.readEndElement("Activations");
        }
        if (reader.isStartElement("Functions", true)) {
            this.getFunctionList().clear();
            while (reader.isStartElement("Item", true)) {
                name = reader.readElementContentAsString("Name");
                ArrayList<GXDLMSObject> objects = new ArrayList<GXDLMSObject>();
                this.getFunctionList().add(new GXSimpleEntry(name, objects));
                if (!reader.isStartElement("Objects", true)) continue;
                while (reader.isStartElement("Object", true)) {
                    ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
                    String ln = reader.readElementContentAsString("LN");
                    GXDLMSObject obj = GXDLMSClient.createObject(ot);
                    obj.setLogicalName(ln);
                    objects.add(obj);
                }
                reader.readEndElement("Objects");
            }
            reader.readEndElement("Functions");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("Activations");
        for (Map.Entry<String, Boolean> entry : this.getActivationStatus()) {
            writer.writeStartElement("Item");
            writer.writeElementString("Name", entry.getKey());
            writer.writeElementString("Status", entry.getValue());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("Functions");
        for (Map.Entry<String, Serializable> entry : this.getFunctionList()) {
            writer.writeStartElement("Item");
            writer.writeElementString("Name", entry.getKey());
            writer.writeStartElement("Objects");
            for (GXDLMSObject obj : (ArrayList)entry.getValue()) {
                writer.writeStartElement("Object");
                writer.writeElementString("ObjectType", obj.getObjectType().getValue());
                writer.writeElementString("LN", obj.getLogicalName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

