/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXEnum;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt8;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSBroadcastLogTable;
import gurux.dlms.objects.GXDLMSContextInformationTable;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSRoutingConfiguration;
import gurux.dlms.objects.GXDLMSRoutingTable;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.DeviceType;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class GXDLMSG3Plc6LoWPan
extends GXDLMSObject
implements IGXDLMSBase {
    private short maxHops;
    private short weakLqiValue;
    private short securityLevel;
    private short[] prefixTable;
    private ArrayList<GXDLMSRoutingConfiguration> routingConfiguration;
    private int broadcastLogTableEntryTtl;
    private ArrayList<GXDLMSRoutingTable> routingTable;
    private ArrayList<GXDLMSContextInformationTable> contextInformationTable;
    private ArrayList<Map.Entry<Integer, Integer>> blacklistTable;
    private ArrayList<GXDLMSBroadcastLogTable> broadcastLogTable;
    private int[] groupTable;
    private int maxJoinWaitTime;
    private short pathDiscoveryTime;
    private short activeKeyIndex;
    private short metricType;
    private int coordShortAddress;
    private boolean disableDefaultRouting;
    private DeviceType deviceType = DeviceType.PAN_DEVICE;
    private boolean defaultCoordRouteEnabled;
    private int[] destinationAddress;
    private short lowLQI;
    private short highLQI;

    public final ArrayList<GXDLMSRoutingTable> getRoutingTable() {
        return this.routingTable;
    }

    public final void setRoutingTable(ArrayList<GXDLMSRoutingTable> value) {
        this.routingTable = value;
    }

    public GXDLMSG3Plc6LoWPan() {
        this("0.0.29.2.0.255", 0);
    }

    public GXDLMSG3Plc6LoWPan(String ln) {
        this(ln, 0);
    }

    public GXDLMSG3Plc6LoWPan(String ln, int sn) {
        super(ObjectType.G3_PLC6_LO_WPAN, ln, sn);
        this.setVersion(3);
        this.blacklistTable = new ArrayList();
        this.contextInformationTable = new ArrayList();
        this.routingConfiguration = new ArrayList();
        this.routingTable = new ArrayList();
        this.broadcastLogTable = new ArrayList();
        this.maxHops = (short)8;
        this.weakLqiValue = (short)52;
        this.securityLevel = (short)5;
        this.broadcastLogTableEntryTtl = 2;
        this.maxJoinWaitTime = 20;
        this.pathDiscoveryTime = (short)40;
        this.activeKeyIndex = 0;
        this.metricType = (short)15;
        this.coordShortAddress = 0;
        this.disableDefaultRouting = false;
        this.deviceType = DeviceType.NOT_DEFINED;
    }

    public final short getMaxHops() {
        return this.maxHops;
    }

    public final void setMaxHops(short value) {
        this.maxHops = value;
    }

    public final short getWeakLqiValue() {
        return this.weakLqiValue;
    }

    public final void setWeakLqiValue(short value) {
        this.weakLqiValue = value;
    }

    public final short getSecurityLevel() {
        return this.securityLevel;
    }

    public final void setSecurityLevel(short value) {
        this.securityLevel = value;
    }

    public final short[] getPrefixTable() {
        return this.prefixTable;
    }

    public final void setPrefixTable(short[] value) {
        this.prefixTable = value;
    }

    public final ArrayList<GXDLMSRoutingConfiguration> getRoutingConfiguration() {
        return this.routingConfiguration;
    }

    public final void setRoutingConfiguration(ArrayList<GXDLMSRoutingConfiguration> value) {
        this.routingConfiguration = value;
    }

    public final int getBroadcastLogTableEntryTtl() {
        return this.broadcastLogTableEntryTtl;
    }

    public final void setBroadcastLogTableEntryTtl(int value) {
        this.broadcastLogTableEntryTtl = value;
    }

    public final ArrayList<GXDLMSContextInformationTable> getContextInformationTable() {
        return this.contextInformationTable;
    }

    public final void setContextInformationTable(ArrayList<GXDLMSContextInformationTable> value) {
        this.contextInformationTable = value;
    }

    public final ArrayList<Map.Entry<Integer, Integer>> getBlacklistTable() {
        return this.blacklistTable;
    }

    public final void setBlacklistTable(ArrayList<Map.Entry<Integer, Integer>> value) {
        this.blacklistTable = value;
    }

    public final ArrayList<GXDLMSBroadcastLogTable> getBroadcastLogTable() {
        return this.broadcastLogTable;
    }

    public final void setBroadcastLogTable(ArrayList<GXDLMSBroadcastLogTable> value) {
        this.broadcastLogTable = value;
    }

    public final int[] getGroupTable() {
        return this.groupTable;
    }

    public final void setGroupTable(int[] value) {
        this.groupTable = value;
    }

    public final int getMaxJoinWaitTime() {
        return this.maxJoinWaitTime;
    }

    public final void setMaxJoinWaitTime(int value) {
        this.maxJoinWaitTime = value;
    }

    public final short getPathDiscoveryTime() {
        return this.pathDiscoveryTime;
    }

    public final void setPathDiscoveryTime(short value) {
        this.pathDiscoveryTime = value;
    }

    public final short getActiveKeyIndex() {
        return this.activeKeyIndex;
    }

    public final void setActiveKeyIndex(short value) {
        this.activeKeyIndex = value;
    }

    public final short getMetricType() {
        return this.metricType;
    }

    public final void setMetricType(short value) {
        this.metricType = value;
    }

    public final int getCoordShortAddress() {
        return this.coordShortAddress;
    }

    public final void setCoordShortAddress(int value) {
        this.coordShortAddress = value;
    }

    public final boolean getDisableDefaultRouting() {
        return this.disableDefaultRouting;
    }

    public final void setDisableDefaultRouting(boolean value) {
        this.disableDefaultRouting = value;
    }

    public final DeviceType getDeviceType() {
        return this.deviceType;
    }

    public final void setDeviceType(DeviceType value) {
        this.deviceType = value;
    }

    public final boolean getDefaultCoordRouteEnabled() {
        return this.defaultCoordRouteEnabled;
    }

    public final void setDefaultCoordRouteEnabled(boolean value) {
        this.defaultCoordRouteEnabled = value;
    }

    public final int[] getDestinationAddress() {
        return this.destinationAddress;
    }

    public final void setDestinationAddress(int[] value) {
        this.destinationAddress = value;
    }

    public final short getLowLQI() {
        return this.lowLQI;
    }

    public final void setLowLQI(short value) {
        this.lowLQI = value;
    }

    public final short getHighLQI() {
        return this.highLQI;
    }

    public final void setHighLQI(short value) {
        this.highLQI = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getMaxHops(), this.getWeakLqiValue(), this.getSecurityLevel(), this.getPrefixTable(), this.getRoutingConfiguration(), this.getBroadcastLogTableEntryTtl(), this.getRoutingTable(), this.getContextInformationTable(), this.getBlacklistTable(), this.getBroadcastLogTable(), this.getGroupTable(), this.getMaxJoinWaitTime(), this.getPathDiscoveryTime(), this.getActiveKeyIndex(), this.getMetricType(), this.getCoordShortAddress(), this.getDisableDefaultRouting(), this.getDeviceType(), this.getDefaultCoordRouteEnabled(), this.getDestinationAddress(), this.getLowLQI(), this.getHighLQI()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (all || this.canRead(13)) {
            attributes.add(13);
        }
        if (all || this.canRead(14)) {
            attributes.add(14);
        }
        if (all || this.canRead(15)) {
            attributes.add(15);
        }
        if (all || this.canRead(16)) {
            attributes.add(16);
        }
        if (this.getVersion() > 0) {
            if (all || this.canRead(17)) {
                attributes.add(17);
            }
            if (all || this.canRead(18)) {
                attributes.add(18);
            }
            if (all || this.canRead(19)) {
                attributes.add(19);
            }
            if (this.getVersion() > 1) {
                if (all || this.canRead(20)) {
                    attributes.add(20);
                }
                if (all || this.canRead(21)) {
                    attributes.add(21);
                }
                if (this.getVersion() > 2) {
                    if (all || this.canRead(22)) {
                        attributes.add(22);
                    }
                    if (all || this.canRead(23)) {
                        attributes.add(23);
                    }
                }
            }
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "MaxHops", "WeakLqiValue", "SecurityLevel", "PrefixTable", "RoutingConfiguration", "BroadcastLogTableEntryTtl", "RoutingTable", "ContextInformationTable", "BlacklistTable", "BroadcastLogTable", "GroupTable", "MaxJoinWaitTime", " PathDiscoveryTime", "ActiveKeyIndex", "MetricType", "CoordShortAddress", "DisableDefaultRouting", "DeviceType", "Default coord route enabled", "Destination address", "Low LQI", "High LQI"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() == 0) {
            return 16;
        }
        if (this.getVersion() == 1) {
            return 19;
        }
        if (this.getVersion() == 2) {
            return 21;
        }
        return 23;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.UINT8;
        }
        if (index == 3) {
            return DataType.UINT8;
        }
        if (index == 4) {
            return DataType.UINT8;
        }
        if (index == 5) {
            return DataType.ARRAY;
        }
        if (index == 6) {
            return DataType.ARRAY;
        }
        if (index == 7) {
            return DataType.UINT16;
        }
        if (index == 8) {
            return DataType.ARRAY;
        }
        if (index == 9) {
            return DataType.ARRAY;
        }
        if (index == 10) {
            return DataType.ARRAY;
        }
        if (index == 11) {
            return DataType.ARRAY;
        }
        if (index == 12) {
            return DataType.ARRAY;
        }
        if (index == 13) {
            return DataType.UINT16;
        }
        if (index == 14) {
            return DataType.UINT8;
        }
        if (index == 15) {
            return DataType.UINT8;
        }
        if (index == 16) {
            return DataType.UINT8;
        }
        if (this.getVersion() > 0) {
            if (index == 17) {
                return DataType.UINT16;
            }
            if (index == 18) {
                return DataType.BOOLEAN;
            }
            if (index == 19) {
                return DataType.ENUM;
            }
            if (this.getVersion() > 1) {
                if (index == 20) {
                    return DataType.BOOLEAN;
                }
                if (index == 21) {
                    return DataType.ARRAY;
                }
                if (index == 22) {
                    return DataType.UINT8;
                }
                if (index == 23) {
                    return DataType.UINT8;
                }
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getMaxHops();
        }
        if (e.getIndex() == 3) {
            return this.getWeakLqiValue();
        }
        if (e.getIndex() == 4) {
            return this.getSecurityLevel();
        }
        if (e.getIndex() == 5) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getPrefixTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getPrefixTable().length, bb);
                short[] sArray = this.prefixTable;
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    Short it = sArray[i];
                    GXCommon.setData(settings, bb, DataType.UINT8, it);
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 6) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getRoutingConfiguration() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getRoutingConfiguration().size(), bb);
                for (GXDLMSRoutingConfiguration it : this.getRoutingConfiguration()) {
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(14);
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getNetTraversalTime());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getRoutingTableEntryTtl());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKr());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKm());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKc());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKq());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKh());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getKrt());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getRreqRetries());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getRreqReqWait());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getBlacklistTableEntryTtl());
                    GXCommon.setData(settings, bb, DataType.BOOLEAN, it.getUnicastRreqGenEnable());
                    GXCommon.setData(settings, bb, DataType.BOOLEAN, it.getRlcEnabled());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getAddRevLinkCost());
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 7) {
            return this.getBroadcastLogTableEntryTtl();
        }
        if (e.getIndex() == 8) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getRoutingTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getRoutingTable().size(), bb);
                for (GXDLMSRoutingTable it : this.getRoutingTable()) {
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(6);
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getDestinationAddress());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getNextHopAddress());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getRouteCost());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getHopCount());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getWeakLinkCount());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getValidTime());
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 9) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getContextInformationTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getContextInformationTable().size(), bb);
                for (GXDLMSContextInformationTable it : this.getContextInformationTable()) {
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(5);
                    GXCommon.setData(settings, bb, DataType.BITSTRING, it.getCID());
                    if (it.getContext() == null) {
                        GXCommon.setData(settings, bb, DataType.UINT8, 0);
                    } else {
                        GXCommon.setData(settings, bb, DataType.UINT8, it.getContext().length);
                    }
                    GXCommon.setData(settings, bb, DataType.OCTET_STRING, it.getContext());
                    GXCommon.setData(settings, bb, DataType.BOOLEAN, it.getCompression());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getValidLifetime());
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 10) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getBlacklistTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getBlacklistTable().size(), bb);
                for (Map.Entry<Integer, Integer> it : this.getBlacklistTable()) {
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(2);
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getKey());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getValue());
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 11) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getBroadcastLogTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getBroadcastLogTable().size(), bb);
                for (GXDLMSBroadcastLogTable it : this.getBroadcastLogTable()) {
                    bb.setUInt8(DataType.STRUCTURE);
                    bb.setUInt8(3);
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getSourceAddress());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getSequenceNumber());
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getValidTime());
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 12) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getGroupTable() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getGroupTable().length, bb);
                for (int it : this.getGroupTable()) {
                    GXCommon.setData(settings, bb, DataType.UINT16, it);
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 13) {
            return this.getMaxJoinWaitTime();
        }
        if (e.getIndex() == 14) {
            return this.getPathDiscoveryTime();
        }
        if (e.getIndex() == 15) {
            return this.getActiveKeyIndex();
        }
        if (e.getIndex() == 16) {
            return this.getMetricType();
        }
        if (e.getIndex() == 17) {
            return this.getCoordShortAddress();
        }
        if (e.getIndex() == 18) {
            return this.getDisableDefaultRouting();
        }
        if (e.getIndex() == 19) {
            return this.deviceType.getValue();
        }
        if (e.getIndex() == 20) {
            return this.getDefaultCoordRouteEnabled();
        }
        if (e.getIndex() == 21) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY);
            if (this.getDestinationAddress() == null) {
                bb.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.getDestinationAddress().length, bb);
                for (int it : this.getDestinationAddress()) {
                    GXCommon.setData(settings, bb, DataType.UINT16, it);
                }
            }
            return bb.array();
        }
        if (e.getIndex() == 22) {
            return this.getLowLQI();
        }
        if (e.getIndex() == 23) {
            return this.getHighLQI();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setMaxHops(((Number)e.getValue()).shortValue());
        } else if (e.getIndex() == 3) {
            this.setWeakLqiValue(((Number)e.getValue()).shortValue());
        } else if (e.getIndex() == 4) {
            this.setSecurityLevel(((Number)e.getValue()).shortValue());
        } else if (e.getIndex() == 5) {
            ArrayList<Short> list = new ArrayList<Short>();
            if (e.getValue() != null) {
                for (Object it : (Iterable)e.getValue()) {
                    list.add(((GXUInt8)it).shortValue());
                }
            }
            this.prefixTable = GXDLMSObjectHelpers.toShortArray(list);
        } else if (e.getIndex() == 6) {
            this.getRoutingConfiguration().clear();
            if (e.getValue() != null) {
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure arr = (GXStructure)tmp;
                    GXDLMSRoutingConfiguration it = new GXDLMSRoutingConfiguration();
                    it.setNetTraversalTime(((Number)arr.get(0)).shortValue());
                    it.setRoutingTableEntryTtl(((Number)arr.get(1)).intValue());
                    it.setKr(((Number)arr.get(2)).shortValue());
                    it.setKm(((Number)arr.get(3)).shortValue());
                    it.setKc(((Number)arr.get(4)).shortValue());
                    it.setKq(((Number)arr.get(5)).shortValue());
                    it.setKh(((Number)arr.get(6)).shortValue());
                    it.setKrt(((Number)arr.get(7)).shortValue());
                    it.setRreqRetries(((Number)arr.get(8)).shortValue());
                    it.setRreqReqWait(((Number)arr.get(9)).shortValue());
                    it.setBlacklistTableEntryTtl(((Number)arr.get(10)).shortValue());
                    it.setUnicastRreqGenEnable((Boolean)arr.get(11));
                    it.setRlcEnabled((Boolean)arr.get(12));
                    it.setAddRevLinkCost(((Number)arr.get(13)).shortValue());
                    this.getRoutingConfiguration().add(it);
                }
            }
        } else if (e.getIndex() == 7) {
            this.broadcastLogTableEntryTtl = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 8) {
            this.routingTable.clear();
            if (e.getValue() != null) {
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure arr = (GXStructure)tmp;
                    GXDLMSRoutingTable it = new GXDLMSRoutingTable();
                    it.setDestinationAddress(((Number)arr.get(0)).intValue());
                    it.setNextHopAddress(((Number)arr.get(1)).intValue());
                    it.setRouteCost(((Number)arr.get(2)).intValue());
                    it.setHopCount(((Number)arr.get(3)).shortValue());
                    it.setWeakLinkCount(((Number)arr.get(4)).shortValue());
                    it.setValidTime(((Number)arr.get(5)).intValue());
                    this.routingTable.add(it);
                }
            }
        } else if (e.getIndex() == 9) {
            this.contextInformationTable.clear();
            if (e.getValue() != null) {
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure arr = (GXStructure)tmp;
                    GXDLMSContextInformationTable it = new GXDLMSContextInformationTable();
                    it.setCID(((GXBitString)arr.get(0)).toString());
                    it.setContext((byte[])arr.get(2));
                    it.setCompression((Boolean)arr.get(3));
                    it.setValidLifetime(((Number)arr.get(4)).intValue());
                    this.contextInformationTable.add(it);
                }
            }
        } else if (e.getIndex() == 10) {
            this.blacklistTable.clear();
            if (e.getValue() != null) {
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure arr = (GXStructure)tmp;
                    this.blacklistTable.add(new GXSimpleEntry<Integer, Integer>(((GXUInt16)arr.get(0)).intValue(), ((GXUInt16)arr.get(1)).intValue()));
                }
            }
        } else if (e.getIndex() == 11) {
            this.broadcastLogTable.clear();
            if (e.getValue() != null) {
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure arr = (GXStructure)tmp;
                    GXDLMSBroadcastLogTable it = new GXDLMSBroadcastLogTable();
                    it.setSourceAddress(((GXUInt16)arr.get(0)).intValue());
                    it.setSequenceNumber(((GXUInt8)arr.get(1)).shortValue());
                    it.setValidTime(((GXUInt16)arr.get(2)).intValue());
                    this.broadcastLogTable.add(it);
                }
            }
        } else if (e.getIndex() == 12) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (e.getValue() != null) {
                for (Object it : (Iterable)e.getValue()) {
                    list.add(((GXUInt16)it).intValue());
                }
            }
            this.groupTable = GXDLMSObjectHelpers.toIntArray(list);
        } else if (e.getIndex() == 13) {
            this.setMaxJoinWaitTime(((GXUInt16)e.getValue()).intValue());
        } else if (e.getIndex() == 14) {
            this.setPathDiscoveryTime(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 15) {
            this.setActiveKeyIndex(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 16) {
            this.setMetricType(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 17) {
            this.setCoordShortAddress(((GXUInt16)e.getValue()).intValue());
        } else if (e.getIndex() == 18) {
            this.setDisableDefaultRouting((Boolean)e.getValue());
        } else if (e.getIndex() == 19) {
            this.setDeviceType(DeviceType.forValue(((GXEnum)e.getValue()).shortValue()));
        } else if (e.getIndex() == 20) {
            this.setDefaultCoordRouteEnabled((Boolean)e.getValue());
        } else if (e.getIndex() == 21) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (e.getValue() != null) {
                for (Object it : (Iterable)e.getValue()) {
                    list.add(((GXUInt16)it).intValue());
                }
            }
            this.destinationAddress = GXDLMSObjectHelpers.toIntArray(list);
        } else if (e.getIndex() == 22) {
            this.setLowLQI(((GXUInt8)e.getValue()).shortValue());
        } else if (e.getIndex() == 23) {
            this.setHighLQI(((GXUInt8)e.getValue()).shortValue());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void loadPrefixTable(GXXmlReader reader) throws XMLStreamException {
        ArrayList<Short> list = new ArrayList<Short>();
        if (reader.isStartElement("PrefixTable", true)) {
            while (reader.isStartElement("Value", false)) {
                list.add((short)reader.readElementContentAsInt("Value", 0));
            }
            reader.readEndElement("PrefixTable");
        }
        this.prefixTable = GXDLMSObjectHelpers.toShortArray(list);
    }

    private void loadRoutingConfiguration(GXXmlReader reader) throws XMLStreamException {
        this.getRoutingConfiguration().clear();
        if (reader.isStartElement("RoutingConfiguration", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSRoutingConfiguration it = new GXDLMSRoutingConfiguration();
                this.getRoutingConfiguration().add(it);
                it.setNetTraversalTime((short)reader.readElementContentAsInt("NetTraversalTime"));
                it.setRoutingTableEntryTtl(reader.readElementContentAsInt("RoutingTableEntryTtl"));
                it.setKr((short)reader.readElementContentAsInt("Kr"));
                it.setKm((short)reader.readElementContentAsInt("Km"));
                it.setKc((short)reader.readElementContentAsInt("Kc"));
                it.setKq((short)reader.readElementContentAsInt("Kq"));
                it.setKh((short)reader.readElementContentAsInt("Kh"));
                it.setKrt((short)reader.readElementContentAsInt("Krt"));
                it.setRreqRetries((short)reader.readElementContentAsInt("RreqRetries"));
                it.setRreqReqWait((short)reader.readElementContentAsInt("RreqReqWait"));
                it.setBlacklistTableEntryTtl(reader.readElementContentAsInt("BlacklistTableEntryTtl"));
                it.setUnicastRreqGenEnable(reader.readElementContentAsInt("UnicastRreqGenEnable") != 0);
                it.setRlcEnabled(reader.readElementContentAsInt("RlcEnabled") != 0);
                it.setAddRevLinkCost((short)reader.readElementContentAsInt("AddRevLinkCost"));
            }
            reader.readEndElement("RoutingConfiguration");
        }
    }

    private void loadRoutingTable(GXXmlReader reader) throws XMLStreamException {
        this.getRoutingTable().clear();
        if (reader.isStartElement("RoutingTable", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSRoutingTable it = new GXDLMSRoutingTable();
                this.getRoutingTable().add(it);
                it.setDestinationAddress(reader.readElementContentAsInt("DestinationAddress"));
                it.setNextHopAddress(reader.readElementContentAsInt("NextHopAddress"));
                it.setRouteCost(reader.readElementContentAsInt("RouteCost"));
                it.setHopCount((short)reader.readElementContentAsInt("HopCount"));
                it.setWeakLinkCount((short)reader.readElementContentAsInt("WeakLinkCount"));
                it.setValidTime(reader.readElementContentAsInt("ValidTime"));
            }
            reader.readEndElement("RoutingTable");
        }
    }

    private void loadContextInformationTable(GXXmlReader reader) throws XMLStreamException {
        this.getContextInformationTable().clear();
        if (reader.isStartElement("ContextInformationTable", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSContextInformationTable it = new GXDLMSContextInformationTable();
                this.getContextInformationTable().add(it);
                it.setCID(reader.readElementContentAsString("CID"));
                it.setContext(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Context")));
                it.setCompression(reader.readElementContentAsInt("Compression") != 0);
                it.setValidLifetime(reader.readElementContentAsInt("ValidLifetime"));
            }
            reader.readEndElement("ContextInformationTable");
        }
    }

    private void loadBlacklistTable(GXXmlReader reader) throws XMLStreamException {
        this.blacklistTable.clear();
        if (reader.isStartElement("BlacklistTable", true)) {
            while (reader.isStartElement("Item", true)) {
                int k = reader.readElementContentAsInt("Key");
                int v = reader.readElementContentAsInt("Value");
                this.blacklistTable.add(new GXSimpleEntry<Integer, Integer>(k, v));
            }
            reader.readEndElement("BlacklistTable");
        }
    }

    private void loadBroadcastLogTable(GXXmlReader reader) throws XMLStreamException {
        this.broadcastLogTable.clear();
        if (reader.isStartElement("BroadcastLogTable", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSBroadcastLogTable it = new GXDLMSBroadcastLogTable();
                this.getBroadcastLogTable().add(it);
                it.setSourceAddress(reader.readElementContentAsInt("SourceAddress"));
                it.setSequenceNumber((short)reader.readElementContentAsInt("SequenceNumber"));
                it.setValidTime(reader.readElementContentAsInt("ValidTime"));
            }
            reader.readEndElement("BroadcastLogTable");
        }
    }

    private void loadGroupTable(GXXmlReader reader) throws XMLStreamException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (reader.isStartElement("GroupTable", true)) {
            while (reader.isStartElement("Value", false)) {
                list.add(reader.readElementContentAsInt("Value"));
            }
            reader.readEndElement("GroupTable");
        }
        this.groupTable = GXDLMSObjectHelpers.toIntArray(list);
    }

    private void loadDestinationAddress(GXXmlReader reader) throws XMLStreamException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (reader.isStartElement("DestinationAddress", true)) {
            while (reader.isStartElement("Value", false)) {
                list.add(reader.readElementContentAsInt("Value"));
            }
            reader.readEndElement("DestinationAddress");
        }
        this.destinationAddress = GXDLMSObjectHelpers.toIntArray(list);
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.maxHops = (short)reader.readElementContentAsInt("MaxHops");
        this.weakLqiValue = (short)reader.readElementContentAsInt("WeakLqiValue");
        this.securityLevel = (short)reader.readElementContentAsInt("SecurityLevel");
        this.loadPrefixTable(reader);
        this.loadRoutingConfiguration(reader);
        this.broadcastLogTableEntryTtl = reader.readElementContentAsInt("BroadcastLogTableEntryTtl");
        this.loadRoutingTable(reader);
        this.loadContextInformationTable(reader);
        this.loadBlacklistTable(reader);
        this.loadBroadcastLogTable(reader);
        this.loadGroupTable(reader);
        this.maxJoinWaitTime = reader.readElementContentAsInt("MaxJoinWaitTime");
        this.pathDiscoveryTime = (short)reader.readElementContentAsInt("PathDiscoveryTime");
        this.activeKeyIndex = (short)reader.readElementContentAsInt("ActiveKeyIndex");
        this.metricType = (short)reader.readElementContentAsInt("MetricType");
        this.coordShortAddress = reader.readElementContentAsInt("CoordShortAddress");
        this.disableDefaultRouting = reader.readElementContentAsInt("DisableDefaultRouting") != 0;
        this.deviceType = DeviceType.forValue(reader.readElementContentAsInt("DeviceType"));
        this.defaultCoordRouteEnabled = reader.readElementContentAsInt("DefaultCoordRouteEnabled") != 0;
        this.loadDestinationAddress(reader);
        this.lowLQI = (short)reader.readElementContentAsInt("LowLQI");
        this.highLQI = (short)reader.readElementContentAsInt("HighLQI");
    }

    private void savePrefixTable(GXXmlWriter writer) throws XMLStreamException {
        if (this.getPrefixTable() != null) {
            writer.writeStartElement("PrefixTable");
            short[] sArray = this.getPrefixTable();
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short it = sArray[i];
                writer.writeElementObject("Value", it);
            }
            writer.writeEndElement();
        }
    }

    private void saveRoutingConfiguration(GXXmlWriter writer) throws XMLStreamException {
        if (this.getRoutingConfiguration() != null) {
            writer.writeStartElement("RoutingConfiguration");
            for (GXDLMSRoutingConfiguration it : this.getRoutingConfiguration()) {
                writer.writeStartElement("Item");
                writer.writeElementString("NetTraversalTime", it.getNetTraversalTime());
                writer.writeElementString("RoutingTableEntryTtl", it.getRoutingTableEntryTtl());
                writer.writeElementString("Kr", it.getKr());
                writer.writeElementString("Km", it.getKm());
                writer.writeElementString("Kc", it.getKc());
                writer.writeElementString("Kq", it.getKq());
                writer.writeElementString("Kh", it.getKh());
                writer.writeElementString("Krt", it.getKrt());
                writer.writeElementString("RreqRetries", it.getRreqRetries());
                writer.writeElementString("RreqReqWait", it.getRreqReqWait());
                writer.writeElementString("BlacklistTableEntryTtl", it.getBlacklistTableEntryTtl());
                writer.writeElementString("UnicastRreqGenEnable", it.getUnicastRreqGenEnable());
                writer.writeElementString("RlcEnabled", it.getRlcEnabled());
                writer.writeElementString("AddRevLinkCost", it.getAddRevLinkCost());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveRoutingTable(GXXmlWriter writer) throws XMLStreamException {
        if (this.getRoutingTable() != null) {
            writer.writeStartElement("RoutingTable");
            for (GXDLMSRoutingTable it : this.getRoutingTable()) {
                writer.writeStartElement("Item");
                writer.writeElementString("DestinationAddress", it.getDestinationAddress());
                writer.writeElementString("NextHopAddress", it.getNextHopAddress());
                writer.writeElementString("RouteCost", it.getRouteCost());
                writer.writeElementString("HopCount", it.getHopCount());
                writer.writeElementString("WeakLinkCount", it.getWeakLinkCount());
                writer.writeElementString("ValidTime", it.getValidTime());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveContextInformationTable(GXXmlWriter writer) throws XMLStreamException {
        if (this.getContextInformationTable() != null) {
            writer.writeStartElement("ContextInformationTable");
            for (GXDLMSContextInformationTable it : this.getContextInformationTable()) {
                writer.writeStartElement("Item");
                writer.writeElementString("CID", it.getCID());
                writer.writeElementString("Context", GXDLMSTranslator.toHex(it.getContext()));
                writer.writeElementString("Compression", it.getCompression());
                writer.writeElementString("ValidLifetime", it.getValidLifetime());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveBlacklistTable(GXXmlWriter writer) throws XMLStreamException {
        if (this.getBlacklistTable() != null) {
            writer.writeStartElement("BlacklistTable");
            for (Map.Entry<Integer, Integer> it : this.blacklistTable) {
                writer.writeStartElement("Item");
                writer.writeElementObject("Key", it.getKey());
                writer.writeElementObject("Value", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveBroadcastLogTable(GXXmlWriter writer) throws XMLStreamException {
        if (this.getBroadcastLogTable() != null) {
            writer.writeStartElement("BroadcastLogTable");
            for (GXDLMSBroadcastLogTable it : this.getBroadcastLogTable()) {
                writer.writeStartElement("Item");
                writer.writeElementObject("SourceAddress", it.getSourceAddress());
                writer.writeElementObject("SequenceNumber", it.getSequenceNumber());
                writer.writeElementObject("ValidTime", it.getValidTime());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void saveGroupTable(GXXmlWriter writer) throws XMLStreamException {
        if (this.getGroupTable() != null) {
            writer.writeStartElement("GroupTable");
            for (int it : this.getGroupTable()) {
                writer.writeElementObject("Value", it);
            }
            writer.writeEndElement();
        }
    }

    private void saveDestinationAddress(GXXmlWriter writer) throws XMLStreamException {
        if (this.getDestinationAddress() != null) {
            writer.writeStartElement("DestinationAddress");
            for (int it : this.getDestinationAddress()) {
                writer.writeElementObject("Value", it);
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("MaxHops", this.getMaxHops());
        writer.writeElementString("WeakLqiValue", this.getWeakLqiValue());
        writer.writeElementString("SecurityLevel", this.getSecurityLevel());
        this.savePrefixTable(writer);
        this.saveRoutingConfiguration(writer);
        writer.writeElementString("BroadcastLogTableEntryTtl", this.getBroadcastLogTableEntryTtl());
        this.saveRoutingTable(writer);
        this.saveContextInformationTable(writer);
        this.saveBlacklistTable(writer);
        this.saveBroadcastLogTable(writer);
        this.saveGroupTable(writer);
        writer.writeElementString("MaxJoinWaitTime", this.getMaxJoinWaitTime());
        writer.writeElementString("PathDiscoveryTime", this.getPathDiscoveryTime());
        writer.writeElementString("ActiveKeyIndex", this.getActiveKeyIndex());
        writer.writeElementString("MetricType", this.getMetricType());
        writer.writeElementString("CoordShortAddress", this.getCoordShortAddress());
        writer.writeElementString("DisableDefaultRouting", this.getDisableDefaultRouting());
        writer.writeElementString("DeviceType", this.getDeviceType().getValue());
        writer.writeElementString("DefaultCoordRouteEnabled", this.getDefaultCoordRouteEnabled());
        this.saveDestinationAddress(writer);
        writer.writeElementString("LowLQI", this.getLowLQI());
        writer.writeElementString("HighLQI", this.getHighLQI());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

