/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.BaudRate;
import gurux.dlms.objects.enums.IecTwistedPairSetupMode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIecTwistedPairSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private IecTwistedPairSetupMode mode = IecTwistedPairSetupMode.INACTIVE;
    private BaudRate speed = BaudRate.BAUDRATE_9600;
    private byte[] primaryAddresses;
    private byte[] tabis;

    public GXDLMSIecTwistedPairSetup() {
        this("0.0.23.0.0.255", 0);
    }

    public GXDLMSIecTwistedPairSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSIecTwistedPairSetup(String ln, int sn) {
        super(ObjectType.IEC_TWISTED_PAIR_SETUP, ln, sn);
    }

    public final IecTwistedPairSetupMode getMode() {
        return this.mode;
    }

    public final void setMode(IecTwistedPairSetupMode value) {
        this.mode = value;
    }

    public final BaudRate getSpeed() {
        return this.speed;
    }

    public final void setSpeed(BaudRate value) {
        this.speed = value;
    }

    public final byte[] getPrimaryAddresses() {
        return this.primaryAddresses;
    }

    public final void setPrimaryAddresses(byte[] value) {
        this.primaryAddresses = value;
    }

    public final byte[] getTabis() {
        return this.tabis;
    }

    public final void setTabis(byte[] value) {
        this.tabis = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getMode(), this.getSpeed(), this.getPrimaryAddresses(), this.getTabis()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        DataType ret;
        switch (index) {
            case 1: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 2: 
            case 3: {
                ret = DataType.ENUM;
                break;
            }
            case 4: 
            case 5: {
                ret = DataType.ARRAY;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return ret;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.mode.ordinal();
                break;
            }
            case 3: {
                ret = this.speed.ordinal();
                break;
            }
            case 4: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.primaryAddresses == null) {
                    data.setUInt8(0);
                } else {
                    data.setUInt8((byte)this.primaryAddresses.length);
                    for (byte it : this.primaryAddresses) {
                        data.setUInt8(DataType.UINT8);
                        data.setUInt8(it);
                    }
                }
                ret = data.array();
                break;
            }
            case 5: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.tabis == null) {
                    data.setUInt8(0);
                } else {
                    data.setUInt8(this.tabis.length);
                    for (byte it : this.tabis) {
                        data.setUInt8(DataType.INT8);
                        data.setUInt8(it);
                    }
                }
                ret = data.array();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setMode(IecTwistedPairSetupMode.values()[((Number)e.getValue()).intValue()]);
        } else if (e.getIndex() == 3) {
            this.setSpeed(BaudRate.values()[((Number)e.getValue()).intValue()]);
        } else if (e.getIndex() == 4) {
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (Object it : (List)e.getValue()) {
                list.add(((Number)it).byteValue());
            }
            this.setPrimaryAddresses(GXDLMSIecTwistedPairSetup.toByteArray(list));
        } else if (e.getIndex() == 5) {
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (Object it : (List)e.getValue()) {
                list.add(((Number)it).byteValue());
            }
            this.setTabis(GXDLMSIecTwistedPairSetup.toByteArray(list));
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.mode = IecTwistedPairSetupMode.values()[reader.readElementContentAsInt("Mode")];
        this.speed = BaudRate.values()[reader.readElementContentAsInt("Speed")];
        this.primaryAddresses = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("PrimaryAddresses"));
        this.tabis = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Tabis"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Mode", this.mode.ordinal());
        writer.writeElementString("Speed", this.speed.ordinal());
        writer.writeElementString("PrimaryAddresses", GXDLMSTranslator.toHex(this.primaryAddresses));
        if (this.tabis != null) {
            writer.writeElementString("Tabis", GXDLMSTranslator.toHex(this.tabis));
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Mode", "Speed", "PrimaryAddresses", "Tabis"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

