/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXEnum;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt8;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXBroadcastFrameCounter;
import gurux.dlms.objects.GXCaptureTime;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.MBusLinkStatus;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSMBusDiagnostic
extends GXDLMSObject
implements IGXDLMSBase {
    private short receivedSignalStrength;
    private short channelId;
    private MBusLinkStatus linkStatus = MBusLinkStatus.NONE;
    private ArrayList<GXBroadcastFrameCounter> broadcastFrames;
    private long transmissions;
    private long receivedFrames;
    private long failedReceivedFrames;
    private GXCaptureTime captureTime;

    public GXDLMSMBusDiagnostic() {
        this("0.0.24.9.0.255", 0);
    }

    public GXDLMSMBusDiagnostic(String ln) {
        this(ln, 0);
    }

    public GXDLMSMBusDiagnostic(String ln, int sn) {
        super(ObjectType.MBUS_DIAGNOSTIC, ln, sn);
        this.setBroadcastFrames(new ArrayList<GXBroadcastFrameCounter>());
        this.setCaptureTime(new GXCaptureTime());
    }

    public final short getReceivedSignalStrength() {
        return this.receivedSignalStrength;
    }

    public final void setReceivedSignalStrength(short value) {
        this.receivedSignalStrength = value;
    }

    public final short getChannelId() {
        return this.channelId;
    }

    public final void setChannelId(short value) {
        this.channelId = value;
    }

    public final MBusLinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    public final void setLinkStatus(MBusLinkStatus value) {
        this.linkStatus = value;
    }

    public final ArrayList<GXBroadcastFrameCounter> getBroadcastFrames() {
        return this.broadcastFrames;
    }

    public final void setBroadcastFrames(ArrayList<GXBroadcastFrameCounter> value) {
        this.broadcastFrames = value;
    }

    public final long getTransmissions() {
        return this.transmissions;
    }

    public final void setTransmissions(long value) {
        this.transmissions = value;
    }

    public final long getReceivedFrames() {
        return this.receivedFrames;
    }

    public final void setReceivedFrames(long value) {
        this.receivedFrames = value;
    }

    public final long getFailedReceivedFrames() {
        return this.failedReceivedFrames;
    }

    public final void setFailedReceivedFrames(long value) {
        this.failedReceivedFrames = value;
    }

    public final GXCaptureTime getCaptureTime() {
        return this.captureTime;
    }

    public final void setCaptureTime(GXCaptureTime value) {
        this.captureTime = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getReceivedSignalStrength(), this.getChannelId(), this.getLinkStatus(), this.getBroadcastFrames(), this.getTransmissions(), this.getReceivedFrames(), this.getFailedReceivedFrames(), this.getCaptureTime()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.receivedSignalStrength = 0;
            this.setTransmissions(0L);
            this.setReceivedFrames(0L);
            this.setFailedReceivedFrames(0L);
            this.setCaptureTime(null);
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || !super.isRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || !super.isRead(5)) {
            attributes.add(5);
        }
        if (all || !super.isRead(6)) {
            attributes.add(6);
        }
        if (all || !super.isRead(7)) {
            attributes.add(7);
        }
        if (all || !super.isRead(8)) {
            attributes.add(8);
        }
        if (all || !super.isRead(9)) {
            attributes.add(9);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "Received signal strength ", "Channel Id", "Link status", "Broadcast frames", "Transmissions", "Received frames", "Failed received frames", "Capture time"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[]{"Reset"};
    }

    @Override
    public final int getAttributeCount() {
        return 9;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.UINT8;
            }
            case 3: {
                return DataType.UINT8;
            }
            case 4: {
                return DataType.ENUM;
            }
            case 5: {
                return DataType.ARRAY;
            }
            case 6: {
                return DataType.UINT32;
            }
            case 7: {
                return DataType.UINT32;
            }
            case 8: {
                return DataType.UINT32;
            }
            case 9: {
                return DataType.STRUCTURE;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.getReceivedSignalStrength();
            }
            case 3: {
                return this.getChannelId();
            }
            case 4: {
                return this.linkStatus.getValue();
            }
            case 5: {
                int cnt = this.getBroadcastFrames().size();
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                GXCommon.setObjectCount(cnt, data);
                if (cnt != 0) {
                    for (GXBroadcastFrameCounter it : this.getBroadcastFrames()) {
                        data.setUInt8(DataType.STRUCTURE);
                        data.setUInt8(3);
                        GXCommon.setData(settings, data, DataType.UINT8, it.getClientId());
                        GXCommon.setData(settings, data, DataType.UINT32, it.getCounter());
                        GXCommon.setData(settings, data, DataType.DATETIME, it.getTimeStamp());
                    }
                }
                return data.array();
            }
            case 6: {
                return this.getTransmissions();
            }
            case 7: {
                return this.getReceivedFrames();
            }
            case 8: {
                return this.getFailedReceivedFrames();
            }
            case 9: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(2, data);
                GXCommon.setData(settings, data, DataType.UINT8, this.getCaptureTime().getAttributeId());
                GXCommon.setData(settings, data, DataType.DATETIME, this.getCaptureTime().getTimeStamp());
                return data.array();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.setReceivedSignalStrength(((GXUInt8)e.getValue()).shortValue());
                break;
            }
            case 3: {
                this.setChannelId(((GXUInt8)e.getValue()).shortValue());
                break;
            }
            case 4: {
                this.setLinkStatus(MBusLinkStatus.forValue(((GXEnum)e.getValue()).shortValue()));
                break;
            }
            case 5: {
                this.getBroadcastFrames().clear();
                if (e.getValue() == null) break;
                for (Object tmp : (Iterable)e.getValue()) {
                    GXDateTime timeStamp;
                    GXStructure item = (GXStructure)tmp;
                    if (item.get(2) instanceof GXDateTime) {
                        timeStamp = (GXDateTime)item.get(2);
                    } else if (item.get(2) instanceof byte[]) {
                        byte[] ba = (byte[])item.get(2);
                        timeStamp = (GXDateTime)GXDLMSClient.changeType(ba, DataType.DATETIME, settings.getUseUtc2NormalTime());
                    } else {
                        timeStamp = null;
                    }
                    GXBroadcastFrameCounter tempVar = new GXBroadcastFrameCounter();
                    tempVar.setClientId(((GXUInt8)item.get(0)).shortValue());
                    tempVar.setCounter(((GXUInt32)item.get(1)).longValue());
                    tempVar.setTimeStamp(timeStamp);
                    this.getBroadcastFrames().add(tempVar);
                }
                break;
            }
            case 6: {
                this.setTransmissions(((GXUInt32)e.getValue()).longValue());
                break;
            }
            case 7: {
                this.setReceivedFrames(((GXUInt32)e.getValue()).longValue());
                break;
            }
            case 8: {
                this.setFailedReceivedFrames(((GXUInt32)e.getValue()).longValue());
                break;
            }
            case 9: {
                if (e.getValue() == null) break;
                GXStructure item = (GXStructure)e.getValue();
                this.getCaptureTime().setAttributeId(((GXUInt8)item.get(0)).shortValue());
                if (item.get(1) instanceof GXDateTime) {
                    this.getCaptureTime().setTimeStamp((GXDateTime)item.get(1));
                    break;
                }
                if (!(item.get(1) instanceof byte[])) break;
                byte[] ba = (byte[])item.get(2);
                this.getCaptureTime().setTimeStamp((GXDateTime)GXDLMSClient.changeType(ba, DataType.DATETIME, settings.getUseUtc2NormalTime()));
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        String str;
        this.setReceivedSignalStrength((short)reader.readElementContentAsInt("ReceivedSignalStrength"));
        this.setChannelId((short)reader.readElementContentAsInt("ChannelId"));
        this.setLinkStatus(MBusLinkStatus.forValue(reader.readElementContentAsInt("LinkStatus")));
        this.getBroadcastFrames().clear();
        if (reader.isStartElement("BroadcastFrames", true)) {
            while (reader.isStartElement("Item", true)) {
                GXBroadcastFrameCounter tempVar = new GXBroadcastFrameCounter();
                tempVar.setClientId((short)reader.readElementContentAsInt("ClientId"));
                tempVar.setCounter((short)reader.readElementContentAsInt("Counter"));
                GXBroadcastFrameCounter item = tempVar;
                str = reader.readElementContentAsString("TimeStamp");
                if (str == null) {
                    item.setTimeStamp(null);
                } else {
                    item.setTimeStamp(new GXDateTime(str));
                }
                this.getBroadcastFrames().add(item);
            }
            reader.readEndElement("BroadcastFrames");
        }
        this.setTransmissions(reader.readElementContentAsInt("Transmissions"));
        this.setReceivedFrames(reader.readElementContentAsInt("ReceivedFrames"));
        this.setFailedReceivedFrames(reader.readElementContentAsInt("FailedReceivedFrames"));
        if (reader.isStartElement("CaptureTime", true)) {
            this.getCaptureTime().setAttributeId((short)reader.readElementContentAsInt("AttributeId"));
            str = reader.readElementContentAsString("TimeStamp");
            if (str == null) {
                this.getCaptureTime().setTimeStamp(null);
            } else {
                this.getCaptureTime().setTimeStamp(new GXDateTime(str));
            }
            reader.readEndElement("CaptureTime");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("ReceivedSignalStrength", this.getReceivedSignalStrength());
        writer.writeElementString("ChannelId", this.getChannelId());
        writer.writeElementString("LinkStatus", this.getLinkStatus().getValue());
        writer.writeStartElement("BroadcastFrames");
        if (this.getBroadcastFrames() != null) {
            for (GXBroadcastFrameCounter it : this.getBroadcastFrames()) {
                writer.writeStartElement("Item");
                writer.writeElementString("ClientId", it.getClientId());
                writer.writeElementString("Counter", it.getCounter());
                writer.writeElementString("TimeStamp", it.getTimeStamp());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        writer.writeElementString("Transmissions", this.getTransmissions());
        writer.writeElementString("ReceivedFrames", this.getReceivedFrames());
        writer.writeElementString("FailedReceivedFrames", this.getFailedReceivedFrames());
        writer.writeStartElement("CaptureTime");
        writer.writeElementString("AttributeId", this.getCaptureTime().getAttributeId());
        writer.writeElementString("TimeStamp", this.getCaptureTime().getTimeStamp());
        writer.writeEndElement();
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

