/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.BaudRate;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSMBusMasterPortSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private BaudRate commSpeed = BaudRate.BAUDRATE_2400;

    public GXDLMSMBusMasterPortSetup() {
        super(ObjectType.MBUS_MASTER_PORT_SETUP);
    }

    public GXDLMSMBusMasterPortSetup(String ln) {
        super(ObjectType.MBUS_MASTER_PORT_SETUP, ln, 0);
    }

    public GXDLMSMBusMasterPortSetup(String ln, int sn) {
        super(ObjectType.MBUS_MASTER_PORT_SETUP, ln, sn);
    }

    public final BaudRate getCommSpeed() {
        return this.commSpeed;
    }

    public final void setCommSpeed(BaudRate value) {
        this.commSpeed = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.commSpeed};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return this.getLogicalName();
        }
        if (e.getIndex() == 2) {
            return this.commSpeed.ordinal();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.commSpeed = BaudRate.values()[((Number)e.getValue()).intValue()];
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.commSpeed = BaudRate.values()[reader.readElementContentAsInt("CommSpeed")];
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.commSpeed != BaudRate.BAUDRATE_2400) {
            writer.writeElementString("CommSpeed", this.commSpeed.ordinal());
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Comm Speed"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

