/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSMacAddressSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private String macAddress;

    public GXDLMSMacAddressSetup() {
        super(ObjectType.MAC_ADDRESS_SETUP, "0.0.25.2.0.255", 0);
    }

    public GXDLMSMacAddressSetup(String ln) {
        super(ObjectType.MAC_ADDRESS_SETUP, ln, 0);
    }

    public GXDLMSMacAddressSetup(String ln, int sn) {
        super(ObjectType.MAC_ADDRESS_SETUP, ln, sn);
    }

    public final String getMacAddress() {
        return this.macAddress;
    }

    public final void setMacAddress(String value) {
        this.macAddress = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getMacAddress()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.OCTET_STRING;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            if (this.macAddress == null) {
                return this.macAddress;
            }
            return GXCommon.hexToBytes(this.getMacAddress().replaceAll(":", " "));
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            String add = GXCommon.toHex((byte[])e.getValue());
            add = add.replaceAll(" ", ":");
            this.setMacAddress(add);
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.macAddress = reader.readElementContentAsString("MacAddress");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("MacAddress", this.macAddress);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "MAC Address"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

