/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.MethodAccessMode3;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.manufacturersettings.GXAttributeCollection;
import gurux.dlms.manufacturersettings.GXDLMSAttributeSettings;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.GXXmlWriterSettings;
import gurux.dlms.objects.IGXDLMSBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSObject {
    private HashMap<Integer, Date> readTimes = new HashMap();
    protected int version;
    private ObjectType objectType = ObjectType.NONE;
    private int customObjectType = 0;
    private GXAttributeCollection attributes = new GXAttributeCollection();
    private GXAttributeCollection methodAttributes = new GXAttributeCollection();
    private int shortName;
    private String logicalName;
    private String description;

    public GXDLMSObject() {
        this(ObjectType.NONE, null, 0);
    }

    protected GXDLMSObject(ObjectType type) {
        this(type, null, 0);
    }

    protected GXDLMSObject(ObjectType type, String ln, int sn) {
        List<String> items;
        this.setObjectType(type);
        this.setShortName(sn);
        if (ln != null && (items = GXCommon.split(ln, '.')).size() != 6) {
            throw new GXDLMSException("Invalid Logical Name.");
        }
        this.logicalName = ln;
    }

    protected GXDLMSObject(int type, String ln, int sn) {
        List<String> items;
        this.customObjectType = type;
        this.setShortName(sn);
        if (ln != null && (items = GXCommon.split(ln, '.')).size() != 6) {
            throw new GXDLMSException("Invalid Logical Name.");
        }
        this.logicalName = ln;
    }

    public static void validateLogicalName(String value) {
        GXCommon.logicalNameToBytes(value);
    }

    protected static byte[] toByteArray(List<Byte> list) {
        byte[] ret = new byte[list.size()];
        int i = -1;
        for (Byte e : list) {
            ret[++i] = e;
        }
        return ret;
    }

    protected boolean isRead(int index) {
        if (!this.canRead(index)) {
            return true;
        }
        return !this.getLastReadTime(index).equals(new Date(0L));
    }

    protected final boolean canRead(int index) {
        return this.getAccess(index) != AccessMode.NO_ACCESS;
    }

    protected final Date getLastReadTime(int attributeIndex) {
        for (Map.Entry<Integer, Date> it : this.readTimes.entrySet()) {
            if (it.getKey() != attributeIndex) continue;
            return it.getValue();
        }
        return new Date(0L);
    }

    protected final void setLastReadTime(int attributeIndex, Date tm) {
        this.readTimes.put(attributeIndex, tm);
    }

    public final String toString() {
        String str = this.getShortName() != 0 ? String.valueOf(this.getShortName()) : this.getLogicalName();
        if (this.description != null) {
            str = str + " " + this.description;
        }
        return str;
    }

    public final ObjectType getObjectType() {
        return this.objectType;
    }

    public final void setObjectType(ObjectType value) {
        this.objectType = value;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int value) {
        this.version = value;
    }

    public final int getShortName() {
        return this.shortName;
    }

    public final void setShortName(int value) {
        this.shortName = value;
    }

    public final Object getName() {
        if (this.getShortName() != 0) {
            return this.getShortName();
        }
        return this.getLogicalName();
    }

    public final String getLogicalName() {
        return this.logicalName;
    }

    public final void setLogicalName(String value) {
        this.logicalName = value;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String value) {
        this.description = value;
    }

    public final GXAttributeCollection getAttributes() {
        return this.attributes;
    }

    public final GXAttributeCollection getMethodAttributes() {
        return this.methodAttributes;
    }

    public final AccessMode getAccess(int index) {
        if (index == 1) {
            return AccessMode.READ;
        }
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            return AccessMode.READ_WRITE;
        }
        return att.getAccess();
    }

    public final void setAccess(int index, AccessMode access) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.attributes.add(att);
        }
        att.setAccess(access);
        att.getAccess3().clear();
    }

    public final Set<AccessMode3> getAccess3(int index) {
        if (index == 1) {
            HashSet<AccessMode3> tmp = new HashSet<AccessMode3>();
            tmp.add(AccessMode3.READ);
            return tmp;
        }
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            HashSet<AccessMode3> tmp = new HashSet<AccessMode3>();
            tmp.add(AccessMode3.READ);
            tmp.add(AccessMode3.WRITE);
            return tmp;
        }
        return att.getAccess3();
    }

    public final void setAccess3(int index, Set<AccessMode3> access) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.attributes.add(att);
        }
        att.setAccess3(access);
        att.setAccess(AccessMode.NO_ACCESS);
    }

    public int getMethodCount() {
        throw new UnsupportedOperationException("getMethodCount");
    }

    public final MethodAccessMode getMethodAccess(int index) {
        GXDLMSAttributeSettings att = this.getMethodAttributes().find(index);
        if (att != null) {
            return att.getMethodAccess();
        }
        return MethodAccessMode.ACCESS;
    }

    public final void setMethodAccess(int index, MethodAccessMode access) {
        GXDLMSAttributeSettings att = this.getMethodAttributes().find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.getMethodAttributes().add(att);
        }
        att.setMethodAccess(access);
    }

    public final Set<MethodAccessMode3> getMethodAccess3(int index) {
        GXDLMSAttributeSettings att = this.getMethodAttributes().find(index);
        if (att != null) {
            return att.getMethodAccess3();
        }
        HashSet<MethodAccessMode3> tmp = new HashSet<MethodAccessMode3>();
        tmp.add(MethodAccessMode3.ACCESS);
        return tmp;
    }

    public final void setMethodAccess3(int index, Set<MethodAccessMode3> access) {
        GXDLMSAttributeSettings att = this.getMethodAttributes().find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.getMethodAttributes().add(att);
        }
        att.setMethodAccess3(access);
    }

    public DataType getDataType(int index) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            return DataType.NONE;
        }
        return att.getType();
    }

    public DataType getUIDataType(int index) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            return DataType.NONE;
        }
        return att.getUIType();
    }

    public int getAttributeCount() {
        throw new UnsupportedOperationException("getAttributeCount");
    }

    public Object[] getValues() {
        throw new UnsupportedOperationException("getValues");
    }

    public Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        throw new UnsupportedOperationException("getValue");
    }

    public void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        throw new UnsupportedOperationException("setValue");
    }

    public byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    public final void setDataType(int index, DataType type) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.attributes.add(att);
        }
        att.setType(type);
    }

    public final void setUIDataType(int index, DataType type) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.attributes.add(att);
        }
        att.setUIType(type);
    }

    public final void setStatic(int index, boolean isStatic) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.attributes.add(att);
        }
        att.setStatic(isStatic);
    }

    public final boolean getStatic(int index) {
        GXDLMSAttributeSettings att = this.attributes.find(index);
        if (att == null) {
            att = new GXDLMSAttributeSettings(index);
            this.attributes.add(att);
        }
        return att.getStatic();
    }

    public void start(GXDLMSServerBase server) {
    }

    public void stop(GXDLMSServerBase server) throws Exception {
    }

    public final GXDLMSObject clone() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2000);
        GXXmlWriterSettings settings = null;
        try {
            GXDLMSObject target = GXDLMSClient.createObject(this.getObjectType());
            GXXmlWriter writer = new GXXmlWriter(out, settings);
            writer.writeStartDocument();
            writer.writeStartElement("Objects");
            ((IGXDLMSBase)((Object)this)).save(writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            GXXmlReader reader = new GXXmlReader(in);
            reader.read();
            reader.read();
            ((IGXDLMSBase)((Object)target)).load(reader);
            return target;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static final boolean equals(GXDLMSObject obj1, GXDLMSObject obj2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2000);
        GXXmlWriterSettings settings = null;
        try {
            GXXmlWriter writer = new GXXmlWriter(out, settings);
            writer.writeStartDocument();
            ((IGXDLMSBase)((Object)obj1)).save(writer);
            String expected = writer.toString();
            out.reset();
            writer.writeStartDocument();
            ((IGXDLMSBase)((Object)obj2)).save(writer);
            String actual = writer.toString();
            return expected.equals(actual);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getCustomObjectType() {
        return this.customObjectType;
    }
}

