/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSPppSetupIPCPOption;
import gurux.dlms.objects.GXDLMSPppSetupLcpOption;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.PppAuthenticationType;
import gurux.dlms.objects.enums.PppSetupIPCPOptionType;
import gurux.dlms.objects.enums.PppSetupLcpOptionType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPppSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSPppSetupIPCPOption[] ipcpOptions;
    private String phyReference;
    private GXDLMSPppSetupLcpOption[] lcpOptions;
    private byte[] userName;
    private byte[] password;
    private PppAuthenticationType authentication;

    public final PppAuthenticationType getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(PppAuthenticationType value) {
        this.authentication = value;
    }

    public final byte[] getUserName() {
        return this.userName;
    }

    public final void setUserName(byte[] value) {
        this.userName = value;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    public final void setPassword(byte[] value) {
        this.password = value;
    }

    public GXDLMSPppSetup() {
        super(ObjectType.PPP_SETUP);
    }

    public GXDLMSPppSetup(String ln) {
        super(ObjectType.PPP_SETUP, ln, 0);
    }

    public GXDLMSPppSetup(String ln, int sn) {
        super(ObjectType.PPP_SETUP, ln, sn);
    }

    public final String getPHYReference() {
        return this.phyReference;
    }

    public final void setPHYReference(String value) {
        this.phyReference = value;
    }

    public final GXDLMSPppSetupLcpOption[] getLCPOptions() {
        return this.lcpOptions;
    }

    public final void setLCPOptions(GXDLMSPppSetupLcpOption[] value) {
        this.lcpOptions = value;
    }

    public final GXDLMSPppSetupIPCPOption[] getIPCPOptions() {
        return this.ipcpOptions;
    }

    public final void setIPCPOptions(GXDLMSPppSetupIPCPOption[] value) {
        this.ipcpOptions = value;
    }

    @Override
    public final Object[] getValues() {
        String str = "";
        if (this.userName != null) {
            str = new String(this.userName);
        }
        if (this.password != null) {
            str = str + " " + new String(this.password);
        }
        return new Object[]{this.getLogicalName(), this.getPHYReference(), this.getLCPOptions(), this.getIPCPOptions(), str};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.OCTET_STRING;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        if (index == 5) {
            if (this.userName == null || this.userName.length == 0) {
                return DataType.NONE;
            }
            return DataType.STRUCTURE;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return GXCommon.logicalNameToBytes(this.phyReference);
        }
        if (e.getIndex() == 3) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8((byte)DataType.ARRAY.getValue());
            if (this.lcpOptions == null) {
                data.setUInt8(0);
            } else {
                data.setUInt8((byte)this.lcpOptions.length);
                for (GXDLMSPppSetupLcpOption it : this.lcpOptions) {
                    data.setUInt8((byte)DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(settings, data, DataType.UINT8, it.getType().getValue());
                    GXCommon.setData(settings, data, DataType.UINT8, it.getLength());
                    GXCommon.setData(settings, data, GXDLMSConverter.getDLMSDataType(it.getData()), it.getData());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8((byte)DataType.ARRAY.getValue());
            if (this.ipcpOptions == null) {
                data.setUInt8(0);
            } else {
                data.setUInt8((byte)this.ipcpOptions.length);
                for (GXDLMSPppSetupIPCPOption it : this.ipcpOptions) {
                    data.setUInt8((byte)DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(settings, data, DataType.UINT8, it.getType().getValue());
                    GXCommon.setData(settings, data, DataType.UINT8, it.getLength());
                    GXCommon.setData(settings, data, GXDLMSConverter.getDLMSDataType(it.getData()), it.getData());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 5) {
            if (this.userName == null || this.userName.length == 0) {
                return null;
            }
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8((byte)DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(settings, data, DataType.OCTET_STRING, this.userName);
            GXCommon.setData(settings, data, DataType.OCTET_STRING, this.password);
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.phyReference = GXCommon.toLogicalName(e.getValue());
        } else if (e.getIndex() == 3) {
            ArrayList<GXDLMSPppSetupLcpOption> items = new ArrayList<GXDLMSPppSetupLcpOption>();
            if (e.getValue() instanceof List) {
                for (Object item : (List)e.getValue()) {
                    GXDLMSPppSetupLcpOption it = new GXDLMSPppSetupLcpOption();
                    it.setType(PppSetupLcpOptionType.forValue(((Number)((List)item).get(0)).intValue()));
                    it.setLength(((Number)((List)item).get(1)).intValue());
                    it.setData(((List)item).get(2));
                    items.add(it);
                }
            }
            this.lcpOptions = items.toArray(new GXDLMSPppSetupLcpOption[items.size()]);
        } else if (e.getIndex() == 4) {
            ArrayList<GXDLMSPppSetupIPCPOption> items = new ArrayList<GXDLMSPppSetupIPCPOption>();
            if (e.getValue() instanceof List) {
                for (Object item : (List)e.getValue()) {
                    GXDLMSPppSetupIPCPOption it = new GXDLMSPppSetupIPCPOption();
                    it.setType(PppSetupIPCPOptionType.forValue(((Number)((List)item).get(0)).intValue()));
                    it.setLength(((Number)((List)item).get(1)).intValue());
                    it.setData(((List)item).get(2));
                    items.add(it);
                }
            }
            this.ipcpOptions = items.toArray(new GXDLMSPppSetupIPCPOption[items.size()]);
        } else if (e.getIndex() == 5) {
            if (e.getValue() != null) {
                this.userName = (byte[])((List)e.getValue()).get(0);
                this.password = (byte[])((List)e.getValue()).get(1);
            } else {
                this.password = null;
                this.userName = null;
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.phyReference = reader.readElementContentAsString("PHYReference");
        ArrayList options = new ArrayList();
        if (reader.isStartElement("LCPOptions", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSPppSetupLcpOption it = new GXDLMSPppSetupLcpOption();
                it.setType(PppSetupLcpOptionType.forValue(reader.readElementContentAsInt("Type")));
                it.setLength(reader.readElementContentAsInt("Length"));
                it.setData(reader.readElementContentAsObject("Data", null, null, 0));
            }
            reader.readEndElement("LCPOptions");
        }
        this.lcpOptions = options.toArray(new GXDLMSPppSetupLcpOption[options.size()]);
        ArrayList list = new ArrayList();
        if (reader.isStartElement("IPCPOptions", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSPppSetupIPCPOption it = new GXDLMSPppSetupIPCPOption();
                it.setType(PppSetupIPCPOptionType.forValue(reader.readElementContentAsInt("Type")));
                it.setLength(reader.readElementContentAsInt("Length"));
                it.setData(reader.readElementContentAsObject("Data", null, null, 0));
            }
            reader.readEndElement("IPCPOptions");
        }
        this.ipcpOptions = list.toArray(new GXDLMSPppSetupIPCPOption[list.size()]);
        this.userName = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("UserName"));
        this.password = GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Password"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("PHYReference", this.phyReference);
        if (this.lcpOptions != null) {
            writer.writeStartElement("LCPOptions");
            for (GXDLMSPppSetupLcpOption gXDLMSPppSetupLcpOption : this.lcpOptions) {
                writer.writeStartElement("Item");
                writer.writeElementString("Type", gXDLMSPppSetupLcpOption.getType().getValue());
                writer.writeElementString("Length", gXDLMSPppSetupLcpOption.getLength());
                writer.writeElementObject("Data", gXDLMSPppSetupLcpOption.getData());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.ipcpOptions != null) {
            writer.writeStartElement("IPCPOptions");
            for (GXDLMSPppSetupIPCPOption gXDLMSPppSetupIPCPOption : this.ipcpOptions) {
                writer.writeStartElement("Item");
                writer.writeElementString("Type", gXDLMSPppSetupIPCPOption.getType().getValue());
                writer.writeElementString("Length", gXDLMSPppSetupIPCPOption.getLength());
                writer.writeElementObject("Data", gXDLMSPppSetupIPCPOption.getData());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("UserName", GXDLMSTranslator.toHex(this.userName));
        writer.writeElementString("Password", GXDLMSTranslator.toHex(this.password));
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "PHY Reference", "LCP Options", "IPCP Options", "PPP Authentication"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

