/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.MacCapabilities;
import gurux.dlms.objects.enums.MacState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPrimeNbOfdmPlcMacFunctionalParameters
extends GXDLMSObject
implements IGXDLMSBase {
    private short lnId;
    private short lsId;
    private short sId;
    private byte[] sna;
    private MacState state;
    private int scpLength;
    private short nodeHierarchyLevel;
    private short beaconSlotCount;
    private short beaconRxSlot;
    private short beaconTxSlot;
    private short beaconRxFrequency;
    private short beaconTxFrequency;
    private Set<MacCapabilities> capabilities = new HashSet<MacCapabilities>();

    public GXDLMSPrimeNbOfdmPlcMacFunctionalParameters() {
        this("0.0.28.3.0.255", 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacFunctionalParameters(String ln) {
        this(ln, 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacFunctionalParameters(String ln, int sn) {
        super(ObjectType.PRIME_NB_OFDM_PLC_MAC_FUNCTIONAL_PARAMETERS, ln, sn);
        this.state = MacState.DISCONNECTED;
    }

    public final short getLnId() {
        return this.lnId;
    }

    public final void setLnId(short value) {
        this.lnId = value;
    }

    public final short getLsId() {
        return this.lsId;
    }

    public final void setLsId(short value) {
        this.lsId = value;
    }

    public final short getSId() {
        return this.sId;
    }

    public final void setSId(short value) {
        this.sId = value;
    }

    public final byte[] getSna() {
        return this.sna;
    }

    public final void setSna(byte[] value) {
        this.sna = value;
    }

    public final MacState getState() {
        return this.state;
    }

    public final void setState(MacState value) {
        this.state = value;
    }

    public final int getScpLength() {
        return this.scpLength;
    }

    public final void setScpLength(int value) {
        this.scpLength = value;
    }

    public final short getNodeHierarchyLevel() {
        return this.nodeHierarchyLevel;
    }

    public final void setNodeHierarchyLevel(short value) {
        this.nodeHierarchyLevel = value;
    }

    public final short getBeaconSlotCount() {
        return this.beaconSlotCount;
    }

    public final void setBeaconSlotCount(short value) {
        this.beaconSlotCount = value;
    }

    public final short getBeaconRxSlot() {
        return this.beaconRxSlot;
    }

    public final void setBeaconRxSlot(short value) {
        this.beaconRxSlot = value;
    }

    public final short getBeaconTxSlot() {
        return this.beaconTxSlot;
    }

    public final void setBeaconTxSlot(short value) {
        this.beaconTxSlot = value;
    }

    public final short getBeaconRxFrequency() {
        return this.beaconRxFrequency;
    }

    public final void setBeaconRxFrequency(short value) {
        this.beaconRxFrequency = value;
    }

    public final short getBeaconTxFrequency() {
        return this.beaconTxFrequency;
    }

    public final void setBeaconTxFrequency(short value) {
        this.beaconTxFrequency = value;
    }

    public final Set<MacCapabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.lnId, this.lsId, this.sId, this.sna, this.state, this.scpLength, this.nodeHierarchyLevel, this.beaconSlotCount, this.beaconRxSlot, this.beaconTxSlot, this.beaconRxFrequency, this.beaconTxFrequency, this.capabilities};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (all || this.canRead(13)) {
            attributes.add(13);
        }
        if (all || this.canRead(14)) {
            attributes.add(14);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 14;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.INT16;
            }
            case 3: 
            case 4: {
                return DataType.UINT8;
            }
            case 5: {
                return DataType.OCTET_STRING;
            }
            case 6: {
                return DataType.ENUM;
            }
            case 7: {
                return DataType.INT16;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return DataType.UINT8;
            }
            case 14: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.lnId;
            }
            case 3: {
                return this.lsId;
            }
            case 4: {
                return this.sId;
            }
            case 5: {
                return this.sna;
            }
            case 6: {
                return this.state.ordinal();
            }
            case 7: {
                return this.scpLength;
            }
            case 8: {
                return this.nodeHierarchyLevel;
            }
            case 9: {
                return this.beaconSlotCount;
            }
            case 10: {
                return this.beaconRxSlot;
            }
            case 11: {
                return this.beaconTxSlot;
            }
            case 12: {
                return this.beaconRxFrequency;
            }
            case 13: {
                return this.beaconTxFrequency;
            }
            case 14: {
                return MacCapabilities.toInteger(this.capabilities);
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.lnId = ((Number)e.getValue()).shortValue();
                break;
            }
            case 3: {
                this.lsId = ((Number)e.getValue()).shortValue();
                break;
            }
            case 4: {
                this.sId = ((Number)e.getValue()).shortValue();
                break;
            }
            case 5: {
                this.sna = (byte[])e.getValue();
                break;
            }
            case 6: {
                this.state = MacState.values()[((Number)e.getValue()).shortValue()];
                break;
            }
            case 7: {
                this.scpLength = ((Number)e.getValue()).shortValue();
                break;
            }
            case 8: {
                this.nodeHierarchyLevel = ((Number)e.getValue()).shortValue();
                break;
            }
            case 9: {
                this.beaconSlotCount = ((Number)e.getValue()).shortValue();
                break;
            }
            case 10: {
                this.beaconRxSlot = ((Number)e.getValue()).shortValue();
                break;
            }
            case 11: {
                this.beaconTxSlot = ((Number)e.getValue()).shortValue();
                break;
            }
            case 12: {
                this.beaconRxFrequency = ((Number)e.getValue()).shortValue();
                break;
            }
            case 13: {
                this.beaconTxFrequency = ((Number)e.getValue()).shortValue();
                break;
            }
            case 14: {
                this.capabilities = MacCapabilities.forValue(((Number)e.getValue()).shortValue());
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.lnId = (short)reader.readElementContentAsInt("LnId");
        this.lsId = (byte)reader.readElementContentAsInt("LsId");
        this.sId = (byte)reader.readElementContentAsInt("SId");
        this.sna = GXCommon.hexToBytes(reader.readElementContentAsString("SNa"));
        this.state = MacState.values()[reader.readElementContentAsInt("State")];
        this.scpLength = (byte)reader.readElementContentAsInt("ScpLength");
        this.nodeHierarchyLevel = (byte)reader.readElementContentAsInt("NodeHierarchyLevel");
        this.beaconSlotCount = (byte)reader.readElementContentAsInt("BeaconSlotCount");
        this.beaconRxSlot = (byte)reader.readElementContentAsInt("BeaconRxSlot");
        this.beaconTxSlot = (byte)reader.readElementContentAsInt("BeaconTxSlot");
        this.beaconRxFrequency = (byte)reader.readElementContentAsInt("BeaconRxFrequency");
        this.beaconTxFrequency = (byte)reader.readElementContentAsInt("BeaconTxFrequency");
        this.capabilities = MacCapabilities.forValue(reader.readElementContentAsInt("Capabilities"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("LnId", this.lnId);
        writer.writeElementString("LsId", this.lsId);
        writer.writeElementString("SId", this.sId);
        writer.writeElementString("SNa", GXCommon.toHex(this.sna, false));
        writer.writeElementString("State", this.state.ordinal());
        writer.writeElementString("ScpLength", this.scpLength);
        writer.writeElementString("NodeHierarchyLevel", this.nodeHierarchyLevel);
        writer.writeElementString("BeaconSlotCount", this.beaconSlotCount);
        writer.writeElementString("BeaconRxSlot", this.beaconRxSlot);
        writer.writeElementString("BeaconTxSlot", this.beaconTxSlot);
        writer.writeElementString("BeaconRxFrequency", this.beaconRxFrequency);
        writer.writeElementString("BeaconTxFrequency", this.beaconTxFrequency);
        writer.writeElementString("Capabilities", MacCapabilities.toInteger(this.capabilities));
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "LnId", "LsId", "SId", "SNa", "State", "ScpLength", "NodeHierarchyLevel", "BeaconSlotCount", "BeaconRxSlot", "BeaconTxSlot", "BeaconRxFrequency", "BeaconTxFrequency", "Capabilities"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

