/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXMacAvailableSwitch;
import gurux.dlms.objects.GXMacDirectTable;
import gurux.dlms.objects.GXMacMulticastEntry;
import gurux.dlms.objects.GXMacPhyCommunication;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPrimeNbOfdmPlcMacNetworkAdministrationData
extends GXDLMSObject
implements IGXDLMSBase {
    private GXMacMulticastEntry[] multicastEntries;
    private short[] switchTable;
    private GXMacDirectTable[] directTable;
    private GXMacAvailableSwitch[] availableSwitches;
    private GXMacPhyCommunication[] communications;

    public GXDLMSPrimeNbOfdmPlcMacNetworkAdministrationData() {
        this("0.0.28.5.0.255", 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacNetworkAdministrationData(String ln) {
        this(ln, 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacNetworkAdministrationData(String ln, int sn) {
        super(ObjectType.PRIME_NB_OFDM_PLC_MAC_NETWORK_ADMINISTRATION_DATA, ln, sn);
    }

    public final GXMacMulticastEntry[] getMulticastEntries() {
        return this.multicastEntries;
    }

    public final void setMulticastEntries(GXMacMulticastEntry[] value) {
        this.multicastEntries = value;
    }

    public final short[] getSwitchTable() {
        return this.switchTable;
    }

    public final void setSwitchTable(short[] value) {
        this.switchTable = value;
    }

    public final GXMacDirectTable[] getDirectTable() {
        return this.directTable;
    }

    public final void setDirectTable(GXMacDirectTable[] value) {
        this.directTable = value;
    }

    public final GXMacAvailableSwitch[] getAvailableSwitches() {
        return this.availableSwitches;
    }

    public final void setAvailableSwitches(GXMacAvailableSwitch[] value) {
        this.availableSwitches = value;
    }

    public final GXMacPhyCommunication[] getCommunications() {
        return this.communications;
    }

    public final void setCommunications(GXMacPhyCommunication[] value) {
        this.communications = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.multicastEntries, this.switchTable, this.directTable, this.availableSwitches, this.communications};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.multicastEntries = null;
            this.switchTable = null;
            this.directTable = null;
            this.availableSwitches = null;
            this.communications = null;
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return DataType.ARRAY;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    private byte[] getMulticastEntries(GXDLMSSettings settings) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        if (this.multicastEntries == null) {
            GXCommon.setObjectCount(0, bb);
        } else {
            GXCommon.setObjectCount(this.multicastEntries.length, bb);
            for (GXMacMulticastEntry it : this.multicastEntries) {
                bb.setUInt8((byte)DataType.STRUCTURE.getValue());
                bb.setUInt8(2);
                GXCommon.setData(settings, bb, DataType.INT8, it.getId());
                GXCommon.setData(settings, bb, DataType.INT16, it.getMembers());
            }
        }
        return bb.array();
    }

    private byte[] getSwitchTable(GXDLMSSettings settings) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        if (this.switchTable == null) {
            GXCommon.setObjectCount(0, bb);
        } else {
            GXCommon.setObjectCount(this.switchTable.length, bb);
            for (short it : this.switchTable) {
                GXCommon.setData(settings, bb, DataType.INT16, it);
            }
        }
        return bb.array();
    }

    private byte[] getDirectTable(GXDLMSSettings settings) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        if (this.directTable == null) {
            GXCommon.setObjectCount(0, bb);
        } else {
            GXCommon.setObjectCount(this.directTable.length, bb);
            for (GXMacDirectTable it : this.directTable) {
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(7);
                GXCommon.setData(settings, bb, DataType.INT16, it.getSourceSId());
                GXCommon.setData(settings, bb, DataType.INT16, it.getSourceLnId());
                GXCommon.setData(settings, bb, DataType.INT16, it.getSourceLcId());
                GXCommon.setData(settings, bb, DataType.INT16, it.getDestinationSId());
                GXCommon.setData(settings, bb, DataType.INT16, it.getDestinationLnId());
                GXCommon.setData(settings, bb, DataType.INT16, it.getDestinationLcId());
                GXCommon.setData(settings, bb, DataType.OCTET_STRING, it.getDid());
            }
        }
        return bb.array();
    }

    private byte[] getAvailableSwitches(GXDLMSSettings settings) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        if (this.availableSwitches == null) {
            GXCommon.setObjectCount(0, bb);
        } else {
            GXCommon.setObjectCount(this.availableSwitches.length, bb);
            for (GXMacAvailableSwitch it : this.availableSwitches) {
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(5);
                GXCommon.setData(settings, bb, DataType.OCTET_STRING, it.getSna());
                GXCommon.setData(settings, bb, DataType.INT16, it.getLsId());
                GXCommon.setData(settings, bb, DataType.INT8, it.getLevel());
                GXCommon.setData(settings, bb, DataType.INT8, it.getRxLevel());
                GXCommon.setData(settings, bb, DataType.INT8, it.getRxSnr());
            }
        }
        return bb.array();
    }

    private byte[] getCommunications(GXDLMSSettings settings) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        if (this.communications == null) {
            GXCommon.setObjectCount(0, bb);
        } else {
            GXCommon.setObjectCount(this.communications.length, bb);
            for (GXMacPhyCommunication it : this.communications) {
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(9);
                GXCommon.setData(settings, bb, DataType.OCTET_STRING, it.getEui());
                GXCommon.setData(settings, bb, DataType.INT8, it.getTxPower());
                GXCommon.setData(settings, bb, DataType.INT8, it.getTxCoding());
                GXCommon.setData(settings, bb, DataType.INT8, it.getRxCoding());
                GXCommon.setData(settings, bb, DataType.INT8, it.getRxLvl());
                GXCommon.setData(settings, bb, DataType.INT8, it.getSnr());
                GXCommon.setData(settings, bb, DataType.INT8, it.getTxPowerModified());
                GXCommon.setData(settings, bb, DataType.INT8, it.getTxCodingModified());
                GXCommon.setData(settings, bb, DataType.INT8, it.getRxCodingModified());
            }
        }
        return bb.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.getMulticastEntries(settings);
            }
            case 3: {
                return this.getSwitchTable(settings);
            }
            case 4: {
                return this.getDirectTable(settings);
            }
            case 5: {
                return this.getAvailableSwitches(settings);
            }
            case 6: {
                return this.getCommunications(settings);
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private GXMacMulticastEntry[] setMulticastEntry(List<?> value) {
        ArrayList<GXMacMulticastEntry> data = new ArrayList<GXMacMulticastEntry>();
        if (value != null) {
            for (Object tmp : value) {
                List it = (List)tmp;
                GXMacMulticastEntry v = new GXMacMulticastEntry();
                v.setId(((Number)it.get(0)).byteValue());
                v.setMembers(((Number)it.get(1)).shortValue());
                data.add(v);
            }
        }
        return data.toArray(new GXMacMulticastEntry[data.size()]);
    }

    private short[] setSwitchTable(List<?> value) {
        ArrayList<Short> data = new ArrayList<Short>();
        if (value != null) {
            for (Object it : value) {
                data.add(((Number)it).shortValue());
            }
        }
        return GXCommon.toShortArray(data);
    }

    private GXMacDirectTable[] setDirectTable(List<?> value) {
        ArrayList<GXMacDirectTable> data = new ArrayList<GXMacDirectTable>();
        if (value != null) {
            for (Object tmp : value) {
                List it = (List)tmp;
                GXMacDirectTable v = new GXMacDirectTable();
                v.setSourceSId(((Number)it.get(0)).shortValue());
                v.setSourceLnId(((Number)it.get(1)).shortValue());
                v.setSourceLcId(((Number)it.get(2)).shortValue());
                v.setDestinationSId(((Number)it.get(3)).shortValue());
                v.setDestinationLnId(((Number)it.get(4)).shortValue());
                v.setDestinationLcId(((Number)it.get(5)).shortValue());
                v.setDid((byte[])it.get(6));
                data.add(v);
            }
        }
        return data.toArray(new GXMacDirectTable[data.size()]);
    }

    private GXMacAvailableSwitch[] setAvailableSwitches(List<?> value) {
        ArrayList<GXMacAvailableSwitch> data = new ArrayList<GXMacAvailableSwitch>();
        if (value != null) {
            for (Object tmp : value) {
                List it = (List)tmp;
                GXMacAvailableSwitch v = new GXMacAvailableSwitch();
                v.setSna((byte[])it.get(0));
                v.setLsId(((Number)it.get(1)).shortValue());
                v.setLevel(((Number)it.get(2)).byteValue());
                v.setRxLevel(((Number)it.get(3)).byteValue());
                v.setRxSnr(((Number)it.get(4)).byteValue());
                data.add(v);
            }
        }
        return data.toArray(new GXMacAvailableSwitch[data.size()]);
    }

    private GXMacPhyCommunication[] setCommunications(List<?> value) {
        ArrayList<GXMacPhyCommunication> data = new ArrayList<GXMacPhyCommunication>();
        if (value != null) {
            for (Object tmp : value) {
                List it = (List)tmp;
                GXMacPhyCommunication v = new GXMacPhyCommunication();
                v.setEui((byte[])it.get(0));
                v.setTxPower(((Number)it.get(1)).byteValue());
                v.setTxCoding(((Number)it.get(2)).byteValue());
                v.setRxCoding(((Number)it.get(3)).byteValue());
                v.setRxLvl(((Number)it.get(4)).byteValue());
                v.setSnr(((Number)it.get(5)).byteValue());
                v.setTxPowerModified(((Number)it.get(6)).byteValue());
                v.setTxCodingModified(((Number)it.get(7)).byteValue());
                v.setRxCodingModified(((Number)it.get(8)).byteValue());
                data.add(v);
            }
        }
        return data.toArray(new GXMacPhyCommunication[data.size()]);
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.multicastEntries = this.setMulticastEntry((List)e.getValue());
                break;
            }
            case 3: {
                this.switchTable = this.setSwitchTable((List)e.getValue());
                break;
            }
            case 4: {
                this.directTable = this.setDirectTable((List)e.getValue());
                break;
            }
            case 5: {
                this.availableSwitches = this.setAvailableSwitches((List)e.getValue());
                break;
            }
            case 6: {
                this.communications = this.setCommunications((List)e.getValue());
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    private GXMacMulticastEntry[] loadMulticastEntries(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXMacMulticastEntry> list = new ArrayList<GXMacMulticastEntry>();
        if (reader.isStartElement("MulticastEntries", true)) {
            while (reader.isStartElement("Item", true)) {
                GXMacMulticastEntry it = new GXMacMulticastEntry();
                list.add(it);
                it.setId((byte)reader.readElementContentAsInt("Id"));
                it.setMembers((short)reader.readElementContentAsInt("Members"));
            }
            reader.readEndElement("MulticastEntries");
        }
        return list.toArray(new GXMacMulticastEntry[list.size()]);
    }

    private short[] loadSwitchTable(GXXmlReader reader) throws XMLStreamException {
        ArrayList<Short> list = new ArrayList<Short>();
        if (reader.isStartElement("SwitchTable", true)) {
            while (reader.isStartElement("Item", false)) {
                list.add((short)reader.readElementContentAsInt("Item"));
            }
            reader.readEndElement("SwitchTable");
        }
        return GXCommon.toShortArray(list);
    }

    private GXMacDirectTable[] loadDirectTable(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXMacDirectTable> list = new ArrayList<GXMacDirectTable>();
        if (reader.isStartElement("DirectTable", true)) {
            while (reader.isStartElement("Item", true)) {
                GXMacDirectTable it = new GXMacDirectTable();
                list.add(it);
                it.setSourceSId((short)reader.readElementContentAsInt("SourceSId"));
                it.setSourceLnId((short)reader.readElementContentAsInt("SourceLnId"));
                it.setSourceLcId((short)reader.readElementContentAsInt("SourceLcId"));
                it.setDestinationSId((short)reader.readElementContentAsInt("DestinationSId"));
                it.setDestinationLnId((short)reader.readElementContentAsInt("DestinationLnId"));
                it.setDestinationLcId((short)reader.readElementContentAsInt("DestinationLcId"));
                it.setDid(GXCommon.hexToBytes(reader.readElementContentAsString("Did")));
            }
            reader.readEndElement("DirectTable");
        }
        return list.toArray(new GXMacDirectTable[list.size()]);
    }

    private GXMacAvailableSwitch[] loadAvailableSwitches(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXMacAvailableSwitch> list = new ArrayList<GXMacAvailableSwitch>();
        if (reader.isStartElement("AvailableSwitches", true)) {
            while (reader.isStartElement("Item", true)) {
                GXMacAvailableSwitch it = new GXMacAvailableSwitch();
                list.add(it);
                it.setSna(GXCommon.hexToBytes(reader.readElementContentAsString("Sna")));
                it.setLsId((short)reader.readElementContentAsInt("LsId"));
                it.setLevel((byte)reader.readElementContentAsInt("Level"));
                it.setRxLevel((byte)reader.readElementContentAsInt("RxLevel"));
                it.setRxSnr((byte)reader.readElementContentAsInt("RxSnr"));
            }
            reader.readEndElement("AvailableSwitches");
        }
        return list.toArray(new GXMacAvailableSwitch[list.size()]);
    }

    private GXMacPhyCommunication[] loadCommunications(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXMacPhyCommunication> list = new ArrayList<GXMacPhyCommunication>();
        if (reader.isStartElement("Communications", true)) {
            while (reader.isStartElement("Item", true)) {
                GXMacPhyCommunication it = new GXMacPhyCommunication();
                list.add(it);
                it.setEui(GXCommon.hexToBytes(reader.readElementContentAsString("Eui")));
                it.setTxPower((byte)reader.readElementContentAsInt("TxPower"));
                it.setTxCoding((byte)reader.readElementContentAsInt("TxCoding"));
                it.setRxCoding((byte)reader.readElementContentAsInt("RxCoding"));
                it.setRxLvl((byte)reader.readElementContentAsInt("RxLvl"));
                it.setSnr((byte)reader.readElementContentAsInt("Snr"));
                it.setTxPowerModified((byte)reader.readElementContentAsInt("TxPowerModified"));
                it.setTxCodingModified((byte)reader.readElementContentAsInt("TxCodingModified"));
                it.setRxCodingModified((byte)reader.readElementContentAsInt("RxCodingModified"));
            }
            reader.readEndElement("Communications");
        }
        return list.toArray(new GXMacPhyCommunication[list.size()]);
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.multicastEntries = this.loadMulticastEntries(reader);
        this.switchTable = this.loadSwitchTable(reader);
        this.directTable = this.loadDirectTable(reader);
        this.availableSwitches = this.loadAvailableSwitches(reader);
        this.communications = this.loadCommunications(reader);
    }

    private void saveMulticastEntries(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("MulticastEntries");
        if (this.multicastEntries != null) {
            for (GXMacMulticastEntry it : this.multicastEntries) {
                writer.writeStartElement("Item");
                writer.writeElementString("Id", it.getId());
                writer.writeElementString("Members", it.getMembers());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void saveSwitchTable(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("SwitchTable");
        if (this.switchTable != null) {
            for (short it : this.switchTable) {
                writer.writeElementString("Item", it);
            }
        }
        writer.writeEndElement();
    }

    private void saveDirectTable(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("DirectTable");
        if (this.directTable != null) {
            for (GXMacDirectTable it : this.directTable) {
                writer.writeStartElement("Item");
                writer.writeElementString("SourceSId", it.getSourceSId());
                writer.writeElementString("SourceLnId", it.getSourceLnId());
                writer.writeElementString("SourceLcId", it.getSourceLcId());
                writer.writeElementString("DestinationSId", it.getDestinationSId());
                writer.writeElementString("DestinationLnId", it.getDestinationLnId());
                writer.writeElementString("DestinationLcId", it.getDestinationLcId());
                writer.writeElementString("Did", GXCommon.toHex(it.getDid(), false));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void saveAvailableSwitches(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("AvailableSwitches");
        if (this.availableSwitches != null) {
            for (GXMacAvailableSwitch it : this.availableSwitches) {
                writer.writeStartElement("Item");
                writer.writeElementString("Sna", GXCommon.toHex(it.getSna(), false));
                writer.writeElementString("LsId", it.getLsId());
                writer.writeElementString("Level", it.getLevel());
                writer.writeElementString("RxLevel", it.getRxLevel());
                writer.writeElementString("RxSnr", it.getRxSnr());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void saveCommunications(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("Communications");
        if (this.communications != null) {
            for (GXMacPhyCommunication it : this.communications) {
                writer.writeStartElement("Item");
                writer.writeElementString("Eui", GXCommon.toHex(it.getEui(), false));
                writer.writeElementString("TxPower", it.getTxPower());
                writer.writeElementString("TxCoding", it.getTxCoding());
                writer.writeElementString("RxCoding", it.getRxCoding());
                writer.writeElementString("RxLvl", it.getRxLvl());
                writer.writeElementString("Snr", it.getSnr());
                writer.writeElementString("TxPowerModified", it.getTxPowerModified());
                writer.writeElementString("TxCodingModified", it.getTxCodingModified());
                writer.writeElementString("RxCodingModified", it.getRxCodingModified());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        this.saveMulticastEntries(writer);
        this.saveSwitchTable(writer);
        this.saveDirectTable(writer);
        this.saveAvailableSwitches(writer);
        this.saveCommunications(writer);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "MulticastEntries", "SwitchTable", "DirectTable", "AvailableSwitches", "Communications"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

