/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXUInt64;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSDemandRegister;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSRegister;
import gurux.dlms.objects.GXProfileGenericUpdater;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.SortMethod;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSProfileGeneric
extends GXDLMSObject
implements IGXDLMSBase {
    private GXProfileGenericUpdater updater = null;
    private ArrayList<Object[]> buffer = new ArrayList();
    private List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> captureObjects;
    private long capturePeriod;
    private SortMethod sortMethod;
    private GXDLMSObject sortObject;
    private int sortObjectAttributeIndex;
    private int sortObjectDataIndex;
    private int entriesInUse;
    private int profileEntries;

    public GXDLMSProfileGeneric() {
        this((String)null);
    }

    public GXDLMSProfileGeneric(String ln) {
        this(ln, 0);
    }

    public GXDLMSProfileGeneric(String ln, int sn) {
        super(ObjectType.PROFILE_GENERIC, ln, sn);
        this.setVersion(1);
        this.sortMethod = SortMethod.FIFO;
        this.captureObjects = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
    }

    public final Object[] getBuffer() {
        return this.buffer.toArray();
    }

    public final void setBuffer(Object[][] value) {
        this.buffer.clear();
        this.buffer.addAll(Arrays.asList(value));
        this.entriesInUse = this.buffer.size();
    }

    public final void addRow(Object[] value) {
        this.buffer.add(value);
    }

    public final void addBuffer(Object[][] value) {
        this.buffer.addAll(Arrays.asList(value));
    }

    public final void addBuffer(List<Object[]> value) {
        this.buffer.addAll(value);
    }

    public final void clearBuffer() {
        this.buffer.clear();
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    public final byte[][] capture(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, 0, DataType.INT8);
    }

    public final void addCaptureObject(GXDLMSObject item, int attributeIndex, int dataIndex) {
        if (item == null) {
            throw new RuntimeException("Invalid Object");
        }
        if (attributeIndex < 1) {
            throw new RuntimeException("Invalid attribute index");
        }
        if (dataIndex < 0) {
            throw new RuntimeException("Invalid data index");
        }
        GXDLMSCaptureObject co = new GXDLMSCaptureObject(attributeIndex, dataIndex);
        this.captureObjects.add(new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(item, co));
    }

    public final List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> getCaptureObjects() {
        return this.captureObjects;
    }

    public final long getCapturePeriod() {
        return this.capturePeriod;
    }

    public final void setCapturePeriod(long value) {
        this.capturePeriod = value;
    }

    public final SortMethod getSortMethod() {
        return this.sortMethod;
    }

    public final void setSortMethod(SortMethod value) {
        this.sortMethod = value;
    }

    public final GXDLMSObject getSortObject() {
        return this.sortObject;
    }

    public final void setSortObject(GXDLMSObject value) {
        this.sortObject = value;
    }

    public final int getSortObjectAttributeIndex() {
        return this.sortObjectAttributeIndex;
    }

    public final void setSortObjectAttributeIndex(int value) {
        this.sortObjectAttributeIndex = value;
    }

    public final int getSortObjectDataIndex() {
        return this.sortObjectDataIndex;
    }

    public final void setSortObject(int value) {
        this.sortObjectDataIndex = value;
    }

    public final int getEntriesInUse() {
        return this.entriesInUse;
    }

    public final void setEntriesInUse(int value) {
        this.entriesInUse = value;
    }

    public final int getProfileEntries() {
        return this.profileEntries;
    }

    public final void setProfileEntries(int value) {
        this.profileEntries = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getBuffer(), this.getCaptureObjects(), this.getCapturePeriod(), this.getSortMethod(), this.getSortObject(), this.getEntriesInUse(), this.getProfileEntries()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.reset();
        } else if (e.getIndex() == 2) {
            try {
                this.capture(e.getServer());
            }
            catch (Exception e1) {
                e.setError(ErrorCode.HARDWARE_FAULT);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 8;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    private byte[] getColumns() {
        int cnt = this.captureObjects.size();
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.ARRAY.getValue());
        GXCommon.setObjectCount(cnt, data);
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.captureObjects) {
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(4);
            GXCommon.setData(null, data, DataType.UINT16, it.getKey().getObjectType().getValue());
            GXCommon.setData(null, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getKey().getLogicalName()));
            GXCommon.setData(null, data, DataType.INT8, it.getValue().getAttributeIndex());
            GXCommon.setData(null, data, DataType.UINT16, it.getValue().getDataIndex());
        }
        return data.array();
    }

    private byte[] getData(GXDLMSSettings settings, ValueEventArgs e, Object[] table, List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns) {
        GXByteBuffer data = new GXByteBuffer();
        if (settings.getIndex() == 0L) {
            data.setUInt8((byte)DataType.ARRAY.getValue());
            if (e.getRowEndIndex() != 0L) {
                GXCommon.setObjectCount((int)(e.getRowEndIndex() - e.getRowBeginIndex()), data);
            } else {
                GXCommon.setObjectCount(table.length, data);
            }
        }
        DataType[] types = new DataType[this.captureObjects.size()];
        int pos = 0;
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.captureObjects) {
            types[pos] = it.getKey().getDataType(it.getValue().getAttributeIndex());
            ++pos;
        }
        for (Object row : table) {
            Object[] items = (Object[])row;
            data.setUInt8(DataType.STRUCTURE.getValue());
            if (columns == null || columns.isEmpty()) {
                GXCommon.setObjectCount(items.length, data);
            } else {
                GXCommon.setObjectCount(columns.size(), data);
            }
            pos = 0;
            for (Object value : items) {
                if (columns == null || columns.contains(this.captureObjects.get(pos))) {
                    DataType tp = types[pos];
                    if (tp == DataType.NONE) {
                        types[pos] = tp = GXDLMSConverter.getDLMSDataType(value);
                    }
                    GXCommon.setData(settings, data, tp, value);
                }
                ++pos;
            }
            settings.setIndex(settings.getIndex() + 1L);
        }
        if (e.getRowEndIndex() != 0L) {
            e.setRowBeginIndex(e.getRowBeginIndex() + (long)table.length);
        } else {
            settings.setIndex(0L);
        }
        return data.array();
    }

    private List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> getColumns(List<?> cols) {
        ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns = null;
        if (cols != null && cols.size() != 0) {
            columns = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
            block0: for (Object it : cols) {
                List tmp = (List)it;
                ObjectType ot = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
                byte attributeIndex = ((Number)tmp.get(2)).byteValue();
                int dataIndex = ((Number)tmp.get(3)).intValue();
                for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> c : this.captureObjects) {
                    if (c.getKey().getObjectType() != ot || c.getValue().getAttributeIndex() != attributeIndex || c.getValue().getDataIndex() != dataIndex || c.getKey().getLogicalName().compareTo(ln) != 0) continue;
                    columns.add(c);
                    continue block0;
                }
            }
        } else {
            ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> colums = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
            colums.addAll(this.captureObjects);
            return colums;
        }
        return columns;
    }

    public final List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> getSelectedColumns(int selector, Object parameters) {
        if (selector == 0) {
            ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> colums = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
            colums.addAll(this.captureObjects);
            return colums;
        }
        if (selector == 1) {
            return this.getColumns((List)((List)parameters).get(3));
        }
        if (selector == 2) {
            List arr = (List)parameters;
            int colStart = 1;
            int colCount = 0;
            if (arr.size() > 2) {
                colStart = ((Number)arr.get(2)).intValue();
            }
            if (arr.size() > 3) {
                colCount = ((Number)arr.get(3)).intValue();
            } else if (colStart != 1) {
                colCount = this.captureObjects.size();
            }
            if (colStart != 1 || colCount != 0) {
                return this.captureObjects.subList(colStart - 1, colStart + colCount - 1);
            }
            ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> colums = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
            colums.addAll(this.captureObjects);
            return colums;
        }
        throw new IllegalArgumentException("Invalid selector.");
    }

    final byte[] getProfileGenericData(GXDLMSSettings settings, ValueEventArgs e) {
        List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> columns = null;
        if (e.getSelector() == 0 || e.getParameters() == null || e.getRowEndIndex() != 0L) {
            return this.getData(settings, e, this.getBuffer(), columns);
        }
        List arr = (List)e.getParameters();
        columns = this.getSelectedColumns(e.getSelector(), arr);
        ArrayList<Object[]> table = new ArrayList<Object[]>();
        if (e.getSelector() == 1) {
            GXDataInfo info = new GXDataInfo();
            info.setType(DataType.DATETIME);
            Date start = ((GXDateTime)GXCommon.getData(settings, new GXByteBuffer((byte[])arr.get(1)), info)).getMeterCalendar().getTime();
            info.clear();
            info.setType(DataType.DATETIME);
            Date end = ((GXDateTime)GXCommon.getData(settings, new GXByteBuffer((byte[])arr.get(2)), info)).getMeterCalendar().getTime();
            for (Object row : this.getBuffer()) {
                Object tmp = ((Object[])row)[this.getSortObjectDataIndex()];
                Date tm = tmp instanceof GXDateTime ? ((GXDateTime)tmp).getMeterCalendar().getTime() : (Date)tmp;
                if (tm.compareTo(start) < 0 || tm.compareTo(end) > 0) continue;
                table.add((Object[])row);
            }
        } else if (e.getSelector() == 2) {
            int count;
            int start = ((Number)arr.get(0)).intValue();
            if (start == 0) {
                start = 1;
            }
            if ((count = ((Number)arr.get(1)).intValue()) == 0) {
                count = this.getBuffer().length;
            }
            if (start + count > this.getBuffer().length + 1) {
                count = this.getBuffer().length;
            }
            for (int pos = 0; pos < count && pos + start - 1 != this.getBuffer().length; ++pos) {
                table.add((Object[])this.getBuffer()[start + pos - 1]);
            }
        } else {
            throw new IllegalArgumentException("Invalid selector.");
        }
        return this.getData(settings, e, table.toArray(), columns);
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.UINT32;
        }
        if (index == 5) {
            return DataType.ENUM;
        }
        if (index == 6) {
            return DataType.ARRAY;
        }
        if (index == 7) {
            return DataType.UINT32;
        }
        if (index == 8) {
            return DataType.UINT32;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getProfileGenericData(settings, e);
        }
        if (e.getIndex() == 3) {
            return this.getColumns();
        }
        if (e.getIndex() == 4) {
            return this.getCapturePeriod();
        }
        if (e.getIndex() == 5) {
            return this.getSortMethod().getValue();
        }
        if (e.getIndex() == 6) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8((byte)DataType.STRUCTURE.getValue());
            data.setUInt8(4);
            if (this.sortObject == null) {
                GXCommon.setData(settings, data, DataType.UINT16, 0);
                GXCommon.setData(settings, data, DataType.OCTET_STRING, new byte[6]);
                GXCommon.setData(settings, data, DataType.INT8, 0);
                GXCommon.setData(settings, data, DataType.UINT16, 0);
            } else {
                GXCommon.setData(settings, data, DataType.UINT16, this.sortObject.getObjectType().getValue());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(this.sortObject.getLogicalName()));
                GXCommon.setData(settings, data, DataType.INT8, this.sortObjectAttributeIndex);
                GXCommon.setData(settings, data, DataType.UINT16, this.sortObjectDataIndex);
            }
            return data.array();
        }
        if (e.getIndex() == 7) {
            return this.getEntriesInUse();
        }
        if (e.getIndex() == 8) {
            return this.getProfileEntries();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setBuffer(e);
        } else if (e.getIndex() == 3) {
            this.captureObjects.clear();
            this.buffer.clear();
            this.entriesInUse = 0;
            if (e.getValue() != null) {
                for (Object it : (List)e.getValue()) {
                    int index;
                    List tmp = (List)it;
                    if (tmp.size() != 4) {
                        throw new GXDLMSException("Invalid structure format.");
                    }
                    ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                    String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
                    GXDLMSObject obj = null;
                    if (settings != null && settings.getObjects() != null) {
                        obj = settings.getObjects().findByLN(type, ln);
                    }
                    if (obj == null) {
                        obj = GXDLMSClient.createObject(type);
                        obj.setLogicalName(ln);
                    }
                    try {
                        index = (Byte)tmp.get(2) & 0xFF;
                    }
                    catch (Exception ex) {
                        index = ((Number)tmp.get(2)).intValue();
                    }
                    this.addCaptureObject(obj, index, ((Number)tmp.get(3)).intValue());
                }
            }
        } else if (e.getIndex() == 4) {
            if (settings != null && settings.isServer()) {
                this.reset();
            }
            this.capturePeriod = e.getValue() == null ? 0L : ((Number)e.getValue()).longValue();
        } else if (e.getIndex() == 5) {
            if (settings != null && settings.isServer()) {
                this.reset();
            }
            if (e.getValue() == null) {
                this.sortMethod = SortMethod.FIFO;
            } else {
                this.sortMethod = SortMethod.forValue(((Number)e.getValue()).intValue());
                if (this.sortMethod == null) {
                    this.sortMethod = SortMethod.LIFO;
                    throw new IllegalArgumentException("Invalid sort method.");
                }
            }
        } else if (e.getIndex() == 6) {
            if (settings != null && settings.isServer()) {
                this.reset();
            }
            if (e.getValue() == null) {
                this.sortObject = null;
            } else {
                List tmp = (List)e.getValue();
                if (tmp.size() != 4) {
                    throw new IllegalArgumentException("Invalid structure format.");
                }
                ObjectType type = ObjectType.forValue(((Number)tmp.get(0)).intValue());
                if (type == ObjectType.NONE) {
                    this.sortObject = null;
                    this.sortObjectAttributeIndex = 0;
                    this.sortObjectDataIndex = 0;
                } else {
                    String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
                    int attributeIndex = ((Number)tmp.get(2)).intValue();
                    int dataIndex = ((Number)tmp.get(3)).intValue();
                    this.sortObject = settings.getObjects().findByLN(type, ln);
                    if (this.sortObject == null) {
                        this.sortObject = GXDLMSClient.createObject(type);
                        this.sortObject.setLogicalName(ln);
                    }
                    this.sortObjectAttributeIndex = attributeIndex;
                    this.sortObjectDataIndex = dataIndex;
                }
            }
        } else if (e.getIndex() == 7) {
            this.entriesInUse = e.getValue() == null ? 0 : ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 8) {
            if (settings != null && settings.isServer()) {
                this.reset();
            }
            this.profileEntries = e.getValue() == null ? 0 : ((Number)e.getValue()).intValue();
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void setBuffer(ValueEventArgs e) {
        List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> cols = (List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>)e.getParameters();
        if (cols == null) {
            cols = this.captureObjects;
        }
        if (cols == null || cols.size() == 0) {
            throw new RuntimeException("Read capture objects first.");
        }
        if (e.getValue() != null) {
            Calendar lastDate = Calendar.getInstance();
            DataType[] types = new DataType[cols.size()];
            int colIndex = -1;
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : cols) {
                types[++colIndex] = it.getKey().getUIDataType(it.getValue().getAttributeIndex());
            }
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : (List)e.getValue()) {
                List row = (List)((Object)it);
                if (row.size() != cols.size()) {
                    throw new RuntimeException("Number of columns do not match.");
                }
                for (colIndex = 0; colIndex < row.size(); ++colIndex) {
                    double scaler;
                    Object data = row.get(colIndex);
                    DataType type = types[colIndex];
                    if (type != DataType.NONE && type != null && data instanceof byte[]) {
                        if ((data = GXDLMSClient.changeType((byte[])data, type, e.getSettings())) instanceof GXDateTime) {
                            GXDateTime dt = (GXDateTime)data;
                            lastDate.setTime(dt.getMeterCalendar().getTime());
                        }
                        row.set(colIndex, data);
                    } else if (type == DataType.DATETIME && data == null && this.capturePeriod != 0L) {
                        if (lastDate.getTimeInMillis() == 0L && !this.buffer.isEmpty()) {
                            lastDate.setTime(((GXDateTime)this.buffer.get(this.buffer.size() - 1)[colIndex]).getMeterCalendar().getTime());
                        }
                        if (lastDate.getTimeInMillis() != 0L) {
                            lastDate.add(13, (int)this.capturePeriod);
                            row.set(colIndex, new GXDateTime(lastDate.getTime()));
                        }
                    } else if (type == DataType.DATETIME && row.get(colIndex) instanceof Number) {
                        if (row.get(colIndex) instanceof GXUInt64) {
                            row.set(colIndex, GXDateTime.fromHighResolutionTime(((Number)row.get(colIndex)).longValue()));
                        } else {
                            row.set(colIndex, GXDateTime.fromUnixTime(((Number)row.get(colIndex)).longValue()));
                        }
                    }
                    Map.Entry<GXDLMSObject, GXDLMSCaptureObject> item = cols.get(colIndex);
                    if (item.getKey() instanceof GXDLMSRegister && item.getValue().getAttributeIndex() == 2) {
                        scaler = ((GXDLMSRegister)item.getKey()).getScaler();
                        if (scaler == 1.0 || data == null) continue;
                        try {
                            data = ((Number)data).doubleValue() * scaler;
                            row.set(colIndex, data);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(GXDLMSProfileGeneric.class.getName()).log(Level.SEVERE, "Scalar failed for: {0}", item.getKey().getLogicalName());
                        }
                        continue;
                    }
                    if (!(item.getKey() instanceof GXDLMSDemandRegister) || item.getValue().getAttributeIndex() != 2 && item.getValue().getAttributeIndex() != 3 || (scaler = ((GXDLMSDemandRegister)item.getKey()).getScaler()) == 1.0 || data == null) continue;
                    try {
                        data = ((Number)data).doubleValue() * scaler;
                        row.set(colIndex, data);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(GXDLMSProfileGeneric.class.getName()).log(Level.SEVERE, "Scalar failed for: {0}", item.getKey().getLogicalName());
                    }
                }
                this.buffer.add(row.toArray(new Object[0]));
            }
            if (e.getSettings().isServer()) {
                this.entriesInUse = this.buffer.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        GXDLMSProfileGeneric gXDLMSProfileGeneric = this;
        synchronized (gXDLMSProfileGeneric) {
            this.buffer.clear();
            this.entriesInUse = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void capture(Object server) throws Exception {
        GXDLMSProfileGeneric gXDLMSProfileGeneric = this;
        synchronized (gXDLMSProfileGeneric) {
            GXDLMSServerBase srv = (GXDLMSServerBase)server;
            Object[] values = new Object[this.captureObjects.size()];
            int pos = 0;
            ValueEventArgs[] args = new ValueEventArgs[]{new ValueEventArgs(srv, (GXDLMSObject)this, 2, 0, null)};
            srv.notifyPreGet(args);
            if (!args[0].getHandled()) {
                for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.captureObjects) {
                    values[pos] = it.getKey().getValues()[it.getValue().getAttributeIndex() - 1];
                    ++pos;
                }
                GXDLMSProfileGeneric gXDLMSProfileGeneric2 = this;
                synchronized (gXDLMSProfileGeneric2) {
                    if (this.getProfileEntries() != 0 && this.getProfileEntries() == this.getBuffer().length) {
                        --this.entriesInUse;
                        this.buffer.remove(0);
                    }
                    this.buffer.add(values);
                    ++this.entriesInUse;
                }
            }
            srv.notifyPostGet(args);
            srv.notifyAction(args);
            srv.notifyPostAction(args);
        }
    }

    @Override
    public final void start(GXDLMSServerBase server) {
        if (this.getCapturePeriod() > 0L) {
            this.updater = new GXProfileGenericUpdater(server, this);
            this.updater.start();
        }
    }

    @Override
    public final void stop(GXDLMSServerBase server) throws InterruptedException {
        if (this.updater != null) {
            this.updater.getReceivedEvent().set();
            this.updater.join(10000L);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        String ln;
        ObjectType ot;
        this.buffer.clear();
        if (reader.isStartElement("Buffer", true)) {
            while (reader.isStartElement("Row", true)) {
                ArrayList<Object> row = new ArrayList<Object>();
                while (reader.isStartElement("Cell", false)) {
                    row.add(reader.readElementContentAsObject("Cell", null, null, 0));
                }
                this.addRow(row.toArray(new Object[row.size()]));
            }
            reader.readEndElement("Buffer");
        }
        this.captureObjects.clear();
        if (reader.isStartElement("CaptureObjects", true)) {
            while (reader.isStartElement("Item", true)) {
                ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
                ln = reader.readElementContentAsString("LN");
                int ai = reader.readElementContentAsInt("Attribute");
                int di = reader.readElementContentAsInt("Data");
                GXDLMSCaptureObject co = new GXDLMSCaptureObject(ai, di);
                GXDLMSObject obj = reader.getObjects().findByLN(ot, ln);
                if (obj == null) {
                    obj = GXDLMSClient.createObject(ot);
                    obj.setLogicalName(ln);
                }
                GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject> o = new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, co);
                this.captureObjects.add(o);
            }
            reader.readEndElement("CaptureObjects");
        }
        this.capturePeriod = reader.readElementContentAsInt("CapturePeriod");
        this.sortMethod = SortMethod.forValue(reader.readElementContentAsInt("SortMethod"));
        if (reader.isStartElement("SortObject", true)) {
            this.capturePeriod = reader.readElementContentAsInt("CapturePeriod");
            ot = ObjectType.forValue(reader.readElementContentAsInt("ObjectType"));
            ln = reader.readElementContentAsString("LN");
            this.sortObject = reader.getObjects().findByLN(ot, ln);
            reader.readEndElement("SortObject");
        }
        this.entriesInUse = reader.readElementContentAsInt("EntriesInUse");
        this.profileEntries = reader.readElementContentAsInt("ProfileEntries");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.buffer != null && writer.isSerialized(ObjectType.PROFILE_GENERIC, 2)) {
            writer.writeStartElement("Buffer");
            for (Object[] objectArray : this.buffer) {
                writer.writeStartElement("Row");
                for (Object it : objectArray) {
                    writer.writeElementObject("Cell", it);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.captureObjects != null && writer.isSerialized(ObjectType.PROFILE_GENERIC, 3)) {
            writer.writeStartElement("CaptureObjects");
            for (Map.Entry entry : this.captureObjects) {
                writer.writeStartElement("Item");
                writer.writeElementString("ObjectType", ((GXDLMSObject)entry.getKey()).getObjectType().getValue());
                writer.writeElementString("LN", ((GXDLMSObject)entry.getKey()).getLogicalName());
                writer.writeElementString("Attribute", ((GXDLMSCaptureObject)entry.getValue()).getAttributeIndex());
                writer.writeElementString("Data", ((GXDLMSCaptureObject)entry.getValue()).getDataIndex());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("CapturePeriod", this.capturePeriod);
        writer.writeElementString("SortMethod", this.sortMethod.getValue());
        if (this.sortObject != null) {
            writer.writeStartElement("SortObject");
            writer.writeElementString("ObjectType", this.sortObject.getObjectType().getValue());
            writer.writeElementString("LN", this.sortObject.getLogicalName());
            writer.writeEndElement();
        }
        writer.writeElementString("EntriesInUse", this.entriesInUse);
        writer.writeElementString("ProfileEntries", this.profileEntries);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Buffer", "CaptureObjects", "Capture Period", "Sort Method", "Sort Object", "Entries In Use", "Profile Entries"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset", "Capture"};
    }
}

