/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSFSKMacSynchronizationTimeouts
extends GXDLMSObject
implements IGXDLMSBase {
    private int searchInitiatorTimeout;
    private int synchronizationConfirmationTimeout;
    private int timeOutNotAddressed;
    private int timeOutFrameNotOK;

    public GXDLMSSFSKMacSynchronizationTimeouts() {
        this("0.0.26.2.0.255", 0);
    }

    public GXDLMSSFSKMacSynchronizationTimeouts(String ln) {
        this(ln, 0);
    }

    public GXDLMSSFSKMacSynchronizationTimeouts(String ln, int sn) {
        super(ObjectType.SFSK_MAC_SYNCHRONIZATION_TIMEOUTS, ln, sn);
    }

    public final int getSearchInitiatorTimeout() {
        return this.searchInitiatorTimeout;
    }

    public final void setSearchInitiatorTimeout(int value) {
        this.searchInitiatorTimeout = value;
    }

    public final int getSynchronizationConfirmationTimeout() {
        return this.synchronizationConfirmationTimeout;
    }

    public final void setSynchronizationConfirmationTimeout(int value) {
        this.synchronizationConfirmationTimeout = value;
    }

    public final int getTimeOutNotAddressed() {
        return this.timeOutNotAddressed;
    }

    public final void setTimeOutNotAddressed(int value) {
        this.timeOutNotAddressed = value;
    }

    public final int getTimeOutFrameNotOK() {
        return this.timeOutFrameNotOK;
    }

    public final void setTimeOutFrameNotOK(int value) {
        this.timeOutFrameNotOK = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.searchInitiatorTimeout, this.synchronizationConfirmationTimeout, this.timeOutNotAddressed, this.timeOutFrameNotOK};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        DataType ret;
        switch (index) {
            case 1: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ret = DataType.UINT16;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return ret;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.searchInitiatorTimeout;
                break;
            }
            case 3: {
                ret = this.synchronizationConfirmationTimeout;
                break;
            }
            case 4: {
                ret = this.timeOutNotAddressed;
                break;
            }
            case 5: {
                ret = this.timeOutFrameNotOK;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.searchInitiatorTimeout = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                this.synchronizationConfirmationTimeout = ((Number)e.getValue()).intValue();
                break;
            }
            case 4: {
                this.timeOutNotAddressed = ((Number)e.getValue()).intValue();
                break;
            }
            case 5: {
                this.timeOutFrameNotOK = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.searchInitiatorTimeout = reader.readElementContentAsInt("SearchInitiatorTimeout");
        this.synchronizationConfirmationTimeout = reader.readElementContentAsInt("SynchronizationConfirmationTimeout");
        this.timeOutNotAddressed = reader.readElementContentAsInt("TimeOutNotAddressed");
        this.timeOutFrameNotOK = reader.readElementContentAsInt("TimeOutFrameNotOK");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("SearchInitiatorTimeout", this.searchInitiatorTimeout);
        writer.writeElementString("SynchronizationConfirmationTimeout", this.synchronizationConfirmationTimeout);
        writer.writeElementString("TimeOutNotAddressed", this.timeOutNotAddressed);
        writer.writeElementString("TimeOutFrameNotOK", this.timeOutFrameNotOK);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "SearchInitiatorTimeout", "SynchronizationConfirmationTimeout", "TimeOutNotAddressed", "TimeOutFrameNotOK"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

