/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.BaudRate;
import gurux.dlms.objects.enums.DeltaElectricalPhase;
import gurux.dlms.objects.enums.InitiatorElectricalPhase;
import gurux.dlms.objects.enums.Repeater;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSFSKPhyMacSetUp
extends GXDLMSObject
implements IGXDLMSBase {
    private InitiatorElectricalPhase initiatorElectricalPhase = InitiatorElectricalPhase.NOT_DEFINED;
    private DeltaElectricalPhase deltaElectricalPhase = DeltaElectricalPhase.NOT_DEFINED;
    private byte maxReceivingGain;
    private byte maxTransmittingGain;
    private byte searchInitiatorThreshold;
    private long markFrequency;
    private long spaceFrequency;
    private int macAddress;
    private int[] macGroupAddresses;
    private Repeater repeater = Repeater.NEVER;
    private boolean repeaterStatus;
    private byte minDeltaCredit;
    private int initiatorMacAddress;
    private boolean synchronizationLocked;
    private BaudRate transmissionSpeed = BaudRate.BAUDRATE_2400;

    public GXDLMSSFSKPhyMacSetUp() {
        this("0.0.26.0.0.255", 0);
    }

    public GXDLMSSFSKPhyMacSetUp(String ln) {
        this(ln, 0);
    }

    public GXDLMSSFSKPhyMacSetUp(String ln, int sn) {
        super(ObjectType.SFSK_PHY_MAC_SETUP, ln, sn);
    }

    public final InitiatorElectricalPhase getInitiatorElectricalPhase() {
        return this.initiatorElectricalPhase;
    }

    public final void setInitiatorElectricalPhase(InitiatorElectricalPhase value) {
        this.initiatorElectricalPhase = value;
    }

    public final DeltaElectricalPhase getDeltaElectricalPhase() {
        return this.deltaElectricalPhase;
    }

    public final void setDeltaElectricalPhase(DeltaElectricalPhase value) {
        this.deltaElectricalPhase = value;
    }

    public final byte getMaxReceivingGain() {
        return this.maxReceivingGain;
    }

    public final void setMaxReceivingGain(byte value) {
        this.maxReceivingGain = value;
    }

    public final byte getMaxTransmittingGain() {
        return this.maxTransmittingGain;
    }

    public final void setMaxTransmittingGain(byte value) {
        this.maxTransmittingGain = value;
    }

    public final byte getSearchInitiatorThreshold() {
        return this.searchInitiatorThreshold;
    }

    public final void setSearchInitiatorThreshold(byte value) {
        this.searchInitiatorThreshold = value;
    }

    public final long getMarkFrequency() {
        return this.markFrequency;
    }

    public final void setMarkFrequency(long value) {
        this.markFrequency = value;
    }

    public final long getSpaceFrequency() {
        return this.spaceFrequency;
    }

    public final void setSpaceFrequency(long value) {
        this.spaceFrequency = value;
    }

    public final int getMacAddress() {
        return this.macAddress;
    }

    public final void setMacAddress(int value) {
        this.macAddress = value;
    }

    public final int[] getMacGroupAddresses() {
        return this.macGroupAddresses;
    }

    public final void setMacGroupAddresses(int[] value) {
        this.macGroupAddresses = value;
    }

    public final Repeater getRepeater() {
        return this.repeater;
    }

    public final void setRepeater(Repeater value) {
        this.repeater = value;
    }

    public final boolean getRepeaterStatus() {
        return this.repeaterStatus;
    }

    public final void setRepeaterStatus(boolean value) {
        this.repeaterStatus = value;
    }

    public final byte getMinDeltaCredit() {
        return this.minDeltaCredit;
    }

    public final void setMinDeltaCredit(byte value) {
        this.minDeltaCredit = value;
    }

    public final int getInitiatorMacAddress() {
        return this.initiatorMacAddress;
    }

    public final void setInitiatorMacAddress(int value) {
        this.initiatorMacAddress = value;
    }

    public final boolean getSynchronizationLocked() {
        return this.synchronizationLocked;
    }

    public final void setSynchronizationLocked(boolean value) {
        this.synchronizationLocked = value;
    }

    public final BaudRate getTransmissionSpeed() {
        return this.transmissionSpeed;
    }

    public final void setTransmissionSpeed(BaudRate value) {
        this.transmissionSpeed = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.initiatorElectricalPhase, this.deltaElectricalPhase, this.maxReceivingGain, this.maxTransmittingGain, this.searchInitiatorThreshold, new Object[]{this.markFrequency, this.spaceFrequency}, this.macAddress, this.macGroupAddresses, this.repeater, this.repeaterStatus, this.minDeltaCredit, this.initiatorMacAddress, this.synchronizationLocked, this.transmissionSpeed};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        attributes.add(11);
        attributes.add(12);
        attributes.add(13);
        attributes.add(14);
        if (all || this.canRead(15)) {
            attributes.add(15);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 15;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        DataType ret;
        switch (index) {
            case 1: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                ret = DataType.UINT8;
                break;
            }
            case 7: {
                ret = DataType.STRUCTURE;
                break;
            }
            case 8: 
            case 13: {
                ret = DataType.UINT16;
                break;
            }
            case 9: {
                ret = DataType.ARRAY;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 15: {
                ret = DataType.ENUM;
                break;
            }
            case 11: 
            case 14: {
                ret = DataType.BOOLEAN;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return ret;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.initiatorElectricalPhase.ordinal();
                break;
            }
            case 3: {
                ret = this.deltaElectricalPhase.ordinal();
                break;
            }
            case 4: {
                ret = this.maxReceivingGain;
                break;
            }
            case 5: {
                ret = this.maxTransmittingGain;
                break;
            }
            case 6: {
                ret = this.searchInitiatorThreshold;
                break;
            }
            case 7: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(2);
                GXCommon.setData(settings, bb, DataType.UINT32, this.markFrequency);
                GXCommon.setData(settings, bb, DataType.UINT32, this.spaceFrequency);
                ret = bb.array();
                break;
            }
            case 8: {
                ret = this.macAddress;
                break;
            }
            case 9: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.macGroupAddresses == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.macGroupAddresses.length, bb);
                    for (int it : this.macGroupAddresses) {
                        GXCommon.setData(settings, bb, DataType.UINT16, it);
                    }
                }
                ret = bb.array();
                break;
            }
            case 10: {
                ret = this.repeater.ordinal();
                break;
            }
            case 11: {
                ret = this.repeaterStatus;
                break;
            }
            case 12: {
                ret = this.minDeltaCredit;
                break;
            }
            case 13: {
                ret = this.initiatorMacAddress;
                break;
            }
            case 14: {
                ret = this.synchronizationLocked;
                break;
            }
            case 15: {
                ret = this.transmissionSpeed.ordinal();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.initiatorElectricalPhase = InitiatorElectricalPhase.values()[((Number)e.getValue()).byteValue()];
                break;
            }
            case 3: {
                this.deltaElectricalPhase = DeltaElectricalPhase.values()[((Number)e.getValue()).byteValue()];
                break;
            }
            case 4: {
                this.maxReceivingGain = ((Number)e.getValue()).byteValue();
                break;
            }
            case 5: {
                this.maxTransmittingGain = ((Number)e.getValue()).byteValue();
                break;
            }
            case 6: {
                this.searchInitiatorThreshold = ((Number)e.getValue()).byteValue();
                break;
            }
            case 7: {
                if (e.getValue() != null) {
                    List arr = (List)e.getValue();
                    this.markFrequency = ((Number)arr.get(0)).intValue();
                    this.spaceFrequency = ((Number)arr.get(1)).intValue();
                    break;
                }
                this.markFrequency = 0L;
                this.spaceFrequency = 0L;
                break;
            }
            case 8: {
                this.macAddress = ((Number)e.getValue()).intValue();
                break;
            }
            case 9: {
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        list.add(((Number)it).intValue());
                    }
                }
                this.macGroupAddresses = GXCommon.toIntArray(list);
                break;
            }
            case 10: {
                this.repeater = Repeater.values()[((Number)e.getValue()).byteValue()];
                break;
            }
            case 11: {
                this.repeaterStatus = (Boolean)e.getValue();
                break;
            }
            case 12: {
                this.minDeltaCredit = ((Number)e.getValue()).byteValue();
                break;
            }
            case 13: {
                this.initiatorMacAddress = ((Number)e.getValue()).intValue();
                break;
            }
            case 14: {
                this.synchronizationLocked = (Boolean)e.getValue();
                break;
            }
            case 15: {
                this.transmissionSpeed = BaudRate.values()[((Number)e.getValue()).byteValue()];
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.initiatorElectricalPhase = InitiatorElectricalPhase.values()[reader.readElementContentAsInt("InitiatorElectricalPhase")];
        this.deltaElectricalPhase = DeltaElectricalPhase.values()[reader.readElementContentAsInt("DeltaElectricalPhase")];
        this.maxReceivingGain = (byte)reader.readElementContentAsInt("MaxReceivingGain");
        this.maxTransmittingGain = (byte)reader.readElementContentAsInt("MaxTransmittingGain");
        this.searchInitiatorThreshold = (byte)reader.readElementContentAsInt("SearchInitiatorThreshold");
        this.markFrequency = reader.readElementContentAsInt("MarkFrequency");
        this.spaceFrequency = reader.readElementContentAsInt("SpaceFrequency");
        this.macAddress = reader.readElementContentAsInt("MacAddress");
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (reader.isStartElement("MacGroupAddresses", true)) {
            while (reader.isStartElement("Value", false)) {
                list.add(reader.readElementContentAsInt("Value"));
            }
            reader.readEndElement("MacGroupAddresses");
        }
        this.macGroupAddresses = GXCommon.toIntArray(list);
        this.repeater = Repeater.values()[reader.readElementContentAsInt("Repeater")];
        this.repeaterStatus = reader.readElementContentAsInt("RepeaterStatus") != 0;
        this.minDeltaCredit = (byte)reader.readElementContentAsInt("MinDeltaCredit");
        this.initiatorMacAddress = reader.readElementContentAsInt("InitiatorMacAddress");
        this.synchronizationLocked = reader.readElementContentAsInt("SynchronizationLocked") != 0;
        this.transmissionSpeed = BaudRate.values()[reader.readElementContentAsInt("TransmissionSpeed")];
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("InitiatorElectricalPhase", this.initiatorElectricalPhase.ordinal());
        writer.writeElementString("DeltaElectricalPhase", this.deltaElectricalPhase.ordinal());
        writer.writeElementString("MaxReceivingGain", this.maxReceivingGain);
        writer.writeElementString("MaxTransmittingGain", this.maxTransmittingGain);
        writer.writeElementString("SearchInitiatorThreshold", this.searchInitiatorThreshold);
        writer.writeElementString("MarkFrequency", this.markFrequency);
        writer.writeElementString("SpaceFrequency", this.spaceFrequency);
        writer.writeElementString("MacAddress", this.macAddress);
        writer.writeStartElement("MacGroupAddresses");
        if (this.macGroupAddresses != null) {
            for (int it : this.macGroupAddresses) {
                writer.writeElementString("Value", it);
            }
        }
        writer.writeEndElement();
        writer.writeElementString("Repeater", this.repeater.ordinal());
        writer.writeElementString("RepeaterStatus", this.repeaterStatus);
        writer.writeElementString("MinDeltaCredit", this.minDeltaCredit);
        writer.writeElementString("InitiatorMacAddress", this.initiatorMacAddress);
        writer.writeElementString("SynchronizationLocked", this.synchronizationLocked);
        writer.writeElementString("TransmissionSpeed", this.transmissionSpeed.ordinal());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "InitiatorElectricalPhase", "DeltaElectricalPhase", "MaxReceivingGain", "MaxTransmittingGain", "SearchInitiatorThreshold", "Frequency", "MacAddress", "MacGroupAddresses", "Repeater", "RepeaterStatus", "MinDeltaCredit", "InitiatorMacAddress", "SynchronizationLocked", "TransmissionSpeed"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

