/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.asn.GXPkcs10;
import gurux.dlms.asn.GXPkcs8;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.asn.GXx509CertificateCollection;
import gurux.dlms.asn.enums.Ecc;
import gurux.dlms.asn.enums.KeyUsage;
import gurux.dlms.ecdsa.GXEcdsa;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.Signing;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSCertificateCollection;
import gurux.dlms.objects.GXDLMSCertificateInfo;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.CertificateEntity;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.GlobalKeyType;
import gurux.dlms.objects.enums.SecurityPolicy;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.secure.GXDLMSSecureClient;
import gurux.dlms.secure.GXSecure;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSecuritySetup
extends GXDLMSObject
implements IGXDLMSBase {
    private byte[] guek;
    private byte[] gbek;
    private byte[] gak;
    private byte[] kek;
    public KeyPair signingKey;
    public KeyPair keyAgreement;
    public KeyPair tls;
    public GXx509CertificateCollection serverCertificates = new GXx509CertificateCollection();
    private Set<SecurityPolicy> securityPolicy = new HashSet<SecurityPolicy>();
    private SecuritySuite securitySuite = SecuritySuite.SUITE_0;
    private byte[] serverSystemTitle;
    private byte[] clientSystemTitle;
    private GXDLMSCertificateCollection certificates = new GXDLMSCertificateCollection();

    public GXDLMSSecuritySetup() {
        this("0.0.43.0.0.255");
    }

    public GXDLMSSecuritySetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSSecuritySetup(String ln, int sn) {
        super(ObjectType.SECURITY_SETUP, ln, sn);
        this.setVersion(1);
        this.gbek = null;
        this.guek = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this.gak = new byte[]{-48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33};
        this.setKek("1111111111111111".getBytes());
    }

    public byte[] getGuek() {
        return this.guek;
    }

    public void setGuek(byte[] value) {
        if (value != null && value.length != 0 && this.getSecuritySuite() != SecuritySuite.SUITE_2 && value.length != 16 || this.getSecuritySuite() == SecuritySuite.SUITE_2 && value.length != 32) {
            throw new IllegalArgumentException("Invalid Guek");
        }
        this.guek = value;
    }

    public byte[] getGbek() {
        return this.gbek;
    }

    public void setGbek(byte[] value) {
        if (value != null && value.length != 0 && this.getSecuritySuite() != SecuritySuite.SUITE_2 && value.length != 16 || this.getSecuritySuite() == SecuritySuite.SUITE_2 && value.length != 32) {
            throw new IllegalArgumentException("Invalid Gbek");
        }
        this.gbek = value;
    }

    public byte[] getGak() {
        return this.gak;
    }

    public void setGak(byte[] value) {
        if (value != null && value.length != 0 && this.getSecuritySuite() != SecuritySuite.SUITE_2 && value.length != 16 || this.getSecuritySuite() == SecuritySuite.SUITE_2 && value.length != 32) {
            throw new IllegalArgumentException("Invalid Gak");
        }
        this.gak = value;
    }

    public byte[] getKek() {
        return this.kek;
    }

    public void setKek(byte[] value) {
        this.kek = value;
    }

    public final Set<SecurityPolicy> getSecurityPolicy() {
        return this.securityPolicy;
    }

    public final void setSecurityPolicy(Set<SecurityPolicy> value) {
        this.securityPolicy = value;
    }

    public final SecuritySuite getSecuritySuite() {
        return this.securitySuite;
    }

    public final void setSecuritySuite(SecuritySuite value) {
        this.securitySuite = value;
    }

    public final byte[] getClientSystemTitle() {
        return this.clientSystemTitle;
    }

    public final void setClientSystemTitle(byte[] value) {
        if (value != null && value.length != 0 && value.length != 8) {
            throw new IllegalArgumentException("Invalid client system title.");
        }
        this.clientSystemTitle = value;
    }

    public final byte[] getServerSystemTitle() {
        return this.serverSystemTitle;
    }

    public final void setServerSystemTitle(byte[] value) {
        if (value != null && value.length != 0 && value.length != 8) {
            throw new IllegalArgumentException("Invalid server system title.");
        }
        this.serverSystemTitle = value;
    }

    public final GXDLMSCertificateCollection getCertificates() {
        return this.certificates;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.securityPolicy, this.securitySuite, this.clientSystemTitle, this.serverSystemTitle, this.certificates};
    }

    public final byte[][] activate(GXDLMSClient client, SecurityPolicy security) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, security.getValue(), DataType.ENUM);
    }

    public final byte[][] activate(GXDLMSClient client, Set<SecurityPolicy> security) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, SecurityPolicy.toInteger(security), DataType.ENUM);
    }

    public static GXPkcs10 parseCertificate(GXByteBuffer data) {
        GXDataInfo info = new GXDataInfo();
        byte[] value = (byte[])GXCommon.getData(null, data, info);
        return new GXPkcs10(value);
    }

    public final byte[][] globalKeyTransfer(GXDLMSClient client, byte[] kek, List<GXSimpleEntry<GlobalKeyType, byte[]>> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid list. It is empty.");
        }
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        bb.setUInt8((byte)list.size());
        for (GXSimpleEntry<GlobalKeyType, byte[]> it : list) {
            bb.setUInt8(DataType.STRUCTURE.getValue());
            bb.setUInt8(2);
            GXCommon.setData(null, bb, DataType.ENUM, it.getKey().ordinal());
            byte[] tmp = GXDLMSSecureClient.encrypt(kek, it.getValue());
            GXCommon.setData(null, bb, DataType.OCTET_STRING, tmp);
        }
        return client.method(this, 2, bb.array(), DataType.ARRAY);
    }

    public final byte[][] keyAgreement(GXDLMSClient client, List<GXSimpleEntry<GlobalKeyType, byte[]>> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid list. It is empty.");
        }
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY.getValue());
        bb.setUInt8((byte)list.size());
        for (GXSimpleEntry<GlobalKeyType, byte[]> it : list) {
            bb.setUInt8(DataType.STRUCTURE.getValue());
            bb.setUInt8(2);
            GXCommon.setData(null, bb, DataType.ENUM, it.getKey().ordinal());
            GXCommon.setData(null, bb, DataType.OCTET_STRING, it.getValue());
        }
        return client.method(this, 3, bb.array(), DataType.ARRAY);
    }

    public final byte[][] keyAgreement(GXDLMSSecureClient client, GlobalKeyType type) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer bb = new GXByteBuffer();
        byte[] data = GXSecure.getEphemeralPublicKeyData(type.ordinal(), client.getCiphering().getEphemeralKeyPair().getPublic());
        bb.set(data, 1, 64);
        Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.INFO, "Signin public key: {0}", client.getCiphering().getSigningKeyPair().getPublic());
        byte[] sign = GXSecure.getEphemeralPublicKeySignature(type.ordinal(), client.getCiphering().getEphemeralKeyPair().getPublic(), client.getCiphering().getSigningKeyPair().getPrivate());
        bb.set(sign);
        Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.FINEST, "Data: {0}", GXCommon.toHex(data));
        Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.FINEST, "Sign: {0}", GXCommon.toHex(sign));
        ArrayList<GXSimpleEntry<GlobalKeyType, byte[]>> list = new ArrayList<GXSimpleEntry<GlobalKeyType, byte[]>>();
        list.add(new GXSimpleEntry<GlobalKeyType, byte[]>(type, bb.array()));
        return this.keyAgreement((GXDLMSClient)client, list);
    }

    public final byte[][] generateKeyPair(GXDLMSClient client, CertificateType type) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 4, type.getValue(), DataType.ENUM);
    }

    public final byte[][] generateCertificate(GXDLMSClient client, CertificateType type) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 5, type.getValue(), DataType.ENUM);
    }

    public final byte[][] importCertificate(GXDLMSClient client, GXx509Certificate certificate) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.importCertificate(client, certificate.getEncoded());
    }

    public final byte[][] importCertificate(GXDLMSClient client, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 6, key, DataType.OCTET_STRING);
    }

    public final byte[][] exportCertificateByEntity(GXDLMSSecureClient client, CertificateEntity entity, CertificateType type, byte[] systemTitle) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (systemTitle == null || systemTitle.length == 0) {
            throw new IllegalArgumentException("Invalid system title.");
        }
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(0);
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(entity.getValue());
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(type.getValue());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, systemTitle);
        return client.method(this, 7, bb.array(), DataType.STRUCTURE);
    }

    private static void verifyIssuer(byte[] issuer) {
        try {
            if (issuer == null || issuer.length == 0) {
                throw new IllegalArgumentException();
            }
            GXAsn1Converter.fromByteArray(issuer);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid issuer. Issuer must be in ASN1 format.");
        }
    }

    public final byte[][] exportCertificateBySerial(GXDLMSSecureClient client, BigInteger serialNumber, byte[] issuer) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXDLMSSecuritySetup.verifyIssuer(issuer);
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(1);
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        GXCommon.setData(null, bb, DataType.OCTET_STRING, serialNumber.toByteArray());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, issuer);
        return client.method(this, 7, bb.array(), DataType.STRUCTURE);
    }

    public final byte[][] removeCertificateByEntity(GXDLMSSecureClient client, CertificateEntity entity, CertificateType type, byte[] systemTitle) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(0);
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(entity.getValue());
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(type.getValue());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, systemTitle);
        return client.method(this, 8, bb.array(), DataType.STRUCTURE);
    }

    public final byte[][] removeCertificateBySerial(GXDLMSSecureClient client, String serialNumber, byte[] issuer) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXDLMSSecuritySetup.verifyIssuer(issuer);
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        bb.setUInt8(DataType.ENUM.getValue());
        bb.setUInt8(1);
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        GXCommon.setData(null, bb, DataType.OCTET_STRING, serialNumber.getBytes());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, issuer);
        return client.method(this, 8, bb.array(), DataType.STRUCTURE);
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (this.securitySuite == SecuritySuite.SUITE_0 && e.getIndex() > 3) {
            throw new IllegalArgumentException("Invalid Security Suite Version.");
        }
        switch (e.getIndex()) {
            case 1: {
                this.securityActivate(settings, e);
                break;
            }
            case 2: {
                this.keyTransfer(settings, e);
                break;
            }
            case 3: {
                return this.invokeKeyAgreement(settings, e);
            }
            case 4: {
                this.generateKeyPair(settings, e);
                break;
            }
            case 5: {
                return this.generateCertificateRequest(settings, e);
            }
            case 6: {
                this.importCertificate(settings, e);
                break;
            }
            case 7: {
                return this.exportCertificate(e);
            }
            case 8: {
                this.removeCertificate(e);
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return null;
    }

    private void removeCertificate(ValueEventArgs e) {
        List tmp = (List)e.getParameters();
        short type = ((Number)tmp.get(0)).shortValue();
        tmp = (List)tmp.get(1);
        GXx509Certificate cert = null;
        if (type == 0) {
            cert = GXDLMSSecuritySetup.findCertificateByEntity(this.serverCertificates, CertificateEntity.forValue(((Number)tmp.get(0)).intValue()), CertificateType.forValue(((Number)tmp.get(1)).intValue()), (byte[])tmp.get(2));
        } else if (type == 1) {
            cert = this.serverCertificates.findBySerial(new BigInteger((byte[])tmp.get(0)), new String((byte[])tmp.get(1)));
        }
        if (cert == null) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        } else {
            this.serverCertificates.remove(cert);
        }
    }

    private static String getStringFromAsn1(byte[] value) {
        Object issuer = GXAsn1Converter.fromByteArray(value);
        if (issuer instanceof GXAsn1Sequence) {
            return GXAsn1Converter.getSubject((GXAsn1Sequence)issuer);
        }
        return issuer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] exportCertificate(ValueEventArgs e) {
        List tmp = (List)e.getParameters();
        short type = ((Number)tmp.get(0)).shortValue();
        GXx509Certificate cert = null;
        tmp = (List)tmp.get(1);
        GXx509CertificateCollection gXx509CertificateCollection = this.serverCertificates;
        synchronized (gXx509CertificateCollection) {
            if (type == 0) {
                cert = GXDLMSSecuritySetup.findCertificateByEntity(this.serverCertificates, CertificateEntity.forValue(((Number)tmp.get(0)).shortValue()), CertificateType.forValue(((Number)tmp.get(1)).shortValue()), (byte[])tmp.get(2));
            } else if (type == 1) {
                String issuer;
                try {
                    issuer = GXDLMSSecuritySetup.getStringFromAsn1((byte[])tmp.get(1));
                }
                catch (Exception ex) {
                    issuer = new String((byte[])tmp.get(1));
                }
                cert = this.serverCertificates.findBySerial(new BigInteger((byte[])tmp.get(0)), issuer);
            }
            if (cert != null) {
                Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.INFO, "Export certificate: {0}", cert.getSerialNumber());
                return cert.getEncoded();
            }
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        }
        return null;
    }

    private void importCertificate(GXDLMSSettings settings, ValueEventArgs e) {
        GXx509Certificate cert = new GXx509Certificate((byte[])e.getParameters());
        byte[] st = this.getServerSystemTitle();
        if (st == null) {
            st = settings.getCipher().getSystemTitle();
        }
        String serverSubject = GXAsn1Converter.systemTitleToSubject(st);
        boolean isServerCert = cert.getSubject().contains(serverSubject);
        int usage = KeyUsage.toInteger(cert.getKeyUsage());
        if (usage != KeyUsage.KEY_AGREEMENT.getValue() && usage != KeyUsage.DIGITAL_SIGNATURE.getValue() && usage != (KeyUsage.KEY_AGREEMENT.getValue() | KeyUsage.DIGITAL_SIGNATURE.getValue())) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        } else {
            List<GXx509Certificate> list = this.serverCertificates.getCertificates(cert.getKeyUsage());
            for (GXx509Certificate it : list) {
                boolean isServer = it.getSubject().contains(serverSubject);
                if (isServer != isServerCert) continue;
                this.serverCertificates.remove(it);
            }
        }
        this.serverCertificates.add(cert);
        Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.INFO, "New certificate imported: {0}", cert.getSerialNumber());
    }

    private byte[] generateCertificateRequest(GXDLMSSettings settings, ValueEventArgs e) {
        CertificateType key = CertificateType.forValue(((Number)e.getParameters()).intValue());
        byte[] st = this.getServerSystemTitle();
        if (st == null) {
            st = settings.getCipher().getSystemTitle();
        }
        try {
            KeyPair kp = null;
            switch (key) {
                case DIGITAL_SIGNATURE: {
                    kp = this.signingKey;
                    break;
                }
                case KEY_AGREEMENT: {
                    kp = this.keyAgreement;
                    break;
                }
                case TLS: {
                    kp = this.tls;
                    break;
                }
            }
            if (kp != null) {
                GXPkcs10 pkc10 = GXPkcs10.createCertificateSigningRequest(kp, GXAsn1Converter.systemTitleToSubject(st));
                return GXCommon.fromBase64(pkc10.toDer());
            }
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        }
        catch (Exception e1) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        }
        return null;
    }

    private void generateKeyPair(GXDLMSSettings settings, ValueEventArgs e) {
        CertificateType key = CertificateType.forValue(((Number)e.getParameters()).intValue());
        try {
            KeyPair value = GXEcdsa.generateKeyPair(Ecc.P256);
            switch (key) {
                case DIGITAL_SIGNATURE: {
                    this.signingKey = value;
                    break;
                }
                case KEY_AGREEMENT: {
                    this.keyAgreement = value;
                }
                case TLS: {
                    this.tls = value;
                    break;
                }
                default: {
                    e.setError(ErrorCode.INCONSISTENT_CLASS);
                    break;
                }
            }
        }
        catch (Exception e1) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        }
    }

    private byte[] invokeKeyAgreement(GXDLMSSettings settings, ValueEventArgs e) {
        block10: {
            try {
                List tmp = (List)((List)e.getParameters()).get(0);
                short keyId = ((Number)tmp.get(0)).shortValue();
                if (keyId != 0) {
                    e.setError(ErrorCode.READ_WRITE_DENIED);
                    break block10;
                }
                byte[] data = (byte[])tmp.get(1);
                GXByteBuffer data2 = new GXByteBuffer(65);
                data2.setUInt8(keyId);
                data2.set(data, 0, 64);
                GXByteBuffer sign = new GXByteBuffer();
                sign.set(data, 64, 64);
                PublicKey pk = settings.getCipher().getKeyAgreementKeyPair().getPublic();
                if (pk == null || !GXSecure.validateEphemeralPublicKeySignature(data2.array(), sign.array(), pk)) {
                    e.setError(ErrorCode.READ_WRITE_DENIED);
                    settings.setTargetEphemeralKey(null);
                    break block10;
                }
                e.setByteArray(true);
                settings.setTargetEphemeralKey(GXAsn1Converter.getPublicKey(data2.subArray(1, 64)));
                KeyPair eKpS = settings.getCipher().getEphemeralKeyPair();
                eKpS = GXEcdsa.generateKeyPair(Ecc.P256);
                settings.getCipher().setEphemeralKeyPair(eKpS);
                KeyAgreement ka = KeyAgreement.getInstance("ECDH");
                ka.init(eKpS.getPrivate());
                ka.doPhase(settings.getTargetEphemeralKey(), true);
                byte[] sharedSecret = ka.generateSecret();
                Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.FINEST, "Server shared secret: {0}", GXCommon.toHex(sharedSecret));
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY);
                bb.setUInt8(1);
                bb.setUInt8(DataType.STRUCTURE);
                bb.setUInt8(2);
                bb.setUInt8(22);
                bb.setUInt8(0);
                bb.setUInt8(DataType.OCTET_STRING);
                GXCommon.setObjectCount(128, bb);
                data = GXSecure.getEphemeralPublicKeyData(keyId, eKpS.getPublic());
                bb.set(data, 1, 64);
                byte[] tmp2 = GXSecure.getEphemeralPublicKeySignature(keyId, eKpS.getPublic(), settings.getCipher().getSigningKeyPair().getPrivate());
                bb.set(tmp2);
                Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.FINEST, "Data: {0}", GXCommon.toHex(data));
                Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.FINEST, "Sign: {0}", GXCommon.toHex(tmp2));
                byte[] algID = GXCommon.hexToBytes("60857405080300");
                GXByteBuffer kdf = new GXByteBuffer();
                kdf.set(GXSecure.generateKDF("SHA-256", sharedSecret, 256, algID, settings.getSourceSystemTitle(), settings.getCipher().getSystemTitle(), null, null), 0, 16);
                Logger.getLogger(GXDLMSSecuritySetup.class.getName()).log(Level.INFO, "GUEK: {0}", kdf);
                settings.getCipher().setSigning(Signing.EPHEMERAL_UNIFIED_MODEL);
                switch (GlobalKeyType.values()[keyId]) {
                    case BROADCAST_ENCRYPTION: {
                        this.gbek = kdf.array();
                        break;
                    }
                    case UNICAST_ENCRYPTION: {
                        this.guek = kdf.array();
                        break;
                    }
                    case AUTHENTICATION: {
                        this.gak = kdf.array();
                        break;
                    }
                    case KEK: {
                        this.kek = kdf.array();
                        break;
                    }
                    default: {
                        e.setError(ErrorCode.INCONSISTENT_CLASS);
                    }
                }
                return bb.array();
            }
            catch (Exception ex) {
                e.setError(ErrorCode.INCONSISTENT_CLASS);
            }
        }
        return null;
    }

    private void keyTransfer(GXDLMSSettings settings, ValueEventArgs e) {
        try {
            block8: for (Object tmp : (List)e.getParameters()) {
                List item = (List)tmp;
                GlobalKeyType type = GlobalKeyType.values()[((Number)item.get(0)).intValue()];
                byte[] data = (byte[])item.get(1);
                switch (type) {
                    case BROADCAST_ENCRYPTION: {
                        this.gbek = GXDLMSSecureClient.decrypt(settings.getKek(), data);
                        continue block8;
                    }
                    case UNICAST_ENCRYPTION: {
                        this.guek = GXDLMSSecureClient.decrypt(settings.getKek(), data);
                        continue block8;
                    }
                    case AUTHENTICATION: {
                        this.gak = GXDLMSSecureClient.decrypt(settings.getKek(), data);
                        continue block8;
                    }
                    case KEK: {
                        this.kek = GXDLMSSecureClient.decrypt(settings.getKek(), data);
                        continue block8;
                    }
                }
                e.setError(ErrorCode.INCONSISTENT_CLASS);
            }
        }
        catch (Exception ex) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        }
    }

    private boolean isAssigned(GXDLMSSettings settings) {
        return settings.getAssignedAssociation() == null || this.getLogicalName().compareTo(settings.getAssignedAssociation().getSecuritySetupReference()) == 0;
    }

    private void securityActivate(GXDLMSSettings settings, ValueEventArgs e) {
        Security security = settings.getCipher().getSecurity();
        if (this.getVersion() == 0) {
            Set<SecurityPolicy> policy = SecurityPolicy.forValue(((Number)e.getParameters()).byteValue());
            this.setSecurityPolicy(policy);
            if (this.isAssigned(settings)) {
                int val = SecurityPolicy.toInteger(policy);
                if (val == SecurityPolicy.AUTHENTICATED.getValue()) {
                    settings.getCipher().setSecurity(Security.AUTHENTICATION);
                } else if (val == SecurityPolicy.ENCRYPTED.getValue()) {
                    settings.getCipher().setSecurity(Security.ENCRYPTION);
                } else if (val == (SecurityPolicy.AUTHENTICATED.getValue() | SecurityPolicy.ENCRYPTED.getValue())) {
                    settings.getCipher().setSecurity(Security.AUTHENTICATION_ENCRYPTION);
                }
            }
        } else if (this.getVersion() == 1) {
            Set<SecurityPolicy> policy = SecurityPolicy.forValue(((Number)e.getParameters()).byteValue());
            this.setSecurityPolicy(policy);
            if (this.isAssigned(settings)) {
                if (policy.contains((Object)SecurityPolicy.AUTHENTICATED_RESPONSE)) {
                    security = Security.forValue(security.getValue() | Security.AUTHENTICATION.getValue());
                    settings.getCipher().setSecurity(security);
                }
                if (policy.contains((Object)SecurityPolicy.ENCRYPTED_RESPONSE)) {
                    security = Security.forValue(security.getValue() | Security.ENCRYPTION.getValue());
                    settings.getCipher().setSecurity(security);
                }
            }
        }
    }

    public final void applyKeys(GXDLMSSettings settings, ValueEventArgs e) {
        try {
            if (this.isAssigned(settings)) {
                block8: for (Object tmp : (List)e.getParameters()) {
                    List item = (List)tmp;
                    GlobalKeyType type = GlobalKeyType.values()[((Number)item.get(0)).intValue()];
                    switch (type) {
                        case UNICAST_ENCRYPTION: {
                            if (e.getIndex() == 2) {
                                settings.getCipher().setBlockCipherKey(this.guek);
                                continue block8;
                            }
                            settings.setEphemeralBlockCipherKey(this.guek);
                            continue block8;
                        }
                        case BROADCAST_ENCRYPTION: {
                            if (e.getIndex() == 2) {
                                settings.getCipher().setBroadcastBlockCipherKey(this.gbek);
                                continue block8;
                            }
                            settings.setEphemeralBroadcastBlockCipherKey(this.gbek);
                            continue block8;
                        }
                        case AUTHENTICATION: {
                            if (e.getIndex() == 2) {
                                settings.getCipher().setAuthenticationKey(this.gak);
                                continue block8;
                            }
                            settings.setEphemeralAuthenticationKey(this.gak);
                            continue block8;
                        }
                        case KEK: {
                            settings.setKek(this.kek);
                            continue block8;
                        }
                    }
                    e.setError(ErrorCode.INCONSISTENT_CLASS);
                }
            }
        }
        catch (Exception ex) {
            e.setError(ErrorCode.INCONSISTENT_CLASS);
        }
    }

    private static GXx509Certificate findCertificateByEntity(GXx509CertificateCollection certificates, CertificateEntity entity, CertificateType type, byte[] systemtitle) {
        String subject = GXAsn1Converter.systemTitleToSubject(systemtitle);
        int k = KeyUsage.toInteger(GXAsn1Converter.certificateTypeToKeyUsage(type));
        for (GXx509Certificate it : certificates) {
            if ((KeyUsage.toInteger(it.getKeyUsage()) & k) == 0 || !it.getSubject().contains(subject)) continue;
            return it;
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (this.getVersion() != 0 && (all || this.canRead(6))) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() == 0) {
            return 5;
        }
        return 6;
    }

    @Override
    public final int getMethodCount() {
        if (this.getVersion() == 0) {
            return 2;
        }
        return 8;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ENUM;
        }
        if (index == 3) {
            return DataType.ENUM;
        }
        if (index == 4) {
            return DataType.OCTET_STRING;
        }
        if (index == 5) {
            return DataType.OCTET_STRING;
        }
        if (this.getVersion() > 0) {
            if (index == 6) {
                return DataType.ARRAY;
            }
            throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    private byte[] getCertificatesByteArray(GXDLMSSettings settings) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8((byte)DataType.ARRAY.getValue());
        GXCommon.setObjectCount(this.serverCertificates.size(), bb);
        for (GXx509Certificate it : this.serverCertificates) {
            bb.setUInt8((byte)DataType.STRUCTURE.getValue());
            GXCommon.setObjectCount(6, bb);
            bb.setUInt8((byte)DataType.ENUM.getValue());
            if (it.isBasicConstraints()) {
                bb.setUInt8((byte)CertificateEntity.CERTIFICATION_AUTHORITY.getValue());
            } else if (it.getSubject().contains(GXAsn1Converter.systemTitleToSubject(this.serverSystemTitle))) {
                bb.setUInt8((byte)CertificateEntity.SERVER.getValue());
            } else {
                bb.setUInt8((byte)CertificateEntity.CLIENT.getValue());
            }
            bb.setUInt8((byte)DataType.ENUM.getValue());
            if (it.getKeyUsage().contains((Object)KeyUsage.DIGITAL_SIGNATURE) && it.getKeyUsage().contains((Object)KeyUsage.KEY_AGREEMENT)) {
                bb.setUInt8((byte)CertificateType.TLS.getValue());
            } else if (it.getKeyUsage().contains((Object)KeyUsage.DIGITAL_SIGNATURE)) {
                bb.setUInt8((byte)CertificateType.DIGITAL_SIGNATURE.getValue());
            } else if (it.getKeyUsage().contains((Object)KeyUsage.KEY_AGREEMENT)) {
                bb.setUInt8((byte)CertificateType.KEY_AGREEMENT.getValue());
            } else {
                bb.setUInt8((byte)CertificateType.OTHER.getValue());
            }
            bb.setUInt8(DataType.OCTET_STRING.getValue());
            byte[] tmp = it.getSerialNumber().toByteArray();
            bb.setUInt8(tmp.length);
            bb.set(tmp);
            GXCommon.addString(it.getIssuer(), bb);
            GXCommon.addString(it.getSubject(), bb);
            GXCommon.addString("", bb);
        }
        return bb.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return SecurityPolicy.toInteger(this.securityPolicy);
        }
        if (e.getIndex() == 3) {
            return this.getSecuritySuite().getValue();
        }
        if (e.getIndex() == 4) {
            return this.getClientSystemTitle();
        }
        if (e.getIndex() == 5) {
            return this.getServerSystemTitle();
        }
        if (e.getIndex() == 6) {
            return this.getCertificatesByteArray(settings);
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private void updateSertificates(List<?> list) {
        this.certificates.clear();
        if (list != null) {
            for (Object tmp : list) {
                List it = (List)tmp;
                GXDLMSCertificateInfo info = new GXDLMSCertificateInfo();
                info.setEntity(CertificateEntity.forValue(((Number)it.get(0)).intValue()));
                info.setType(CertificateType.forValue(((Number)it.get(1)).intValue()));
                info.setSerialNumber(new BigInteger((byte[])it.get(2)));
                try {
                    info.setIssuerRaw((byte[])it.get(3));
                    info.setIssuer(GXDLMSSecuritySetup.getStringFromAsn1(info.getIssuerRaw()));
                }
                catch (Exception ex) {
                    info.setIssuer(new String((byte[])it.get(3)));
                }
                try {
                    info.setSubjectRaw((byte[])it.get(4));
                    info.setSubject(GXDLMSSecuritySetup.getStringFromAsn1(info.getIssuerRaw()));
                }
                catch (Exception ex) {
                    info.setSubject(new String((byte[])it.get(4)));
                }
                try {
                    info.setSubjectAltNameRaw((byte[])it.get(5));
                    info.setSubjectAltName(GXDLMSSecuritySetup.getStringFromAsn1(info.getSubjectAltNameRaw()));
                }
                catch (Exception ex) {
                    info.setSubjectAltName(new String((byte[])it.get(5)));
                }
                this.certificates.add(info);
            }
        }
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (settings.isServer()) {
                e.setError(ErrorCode.INCONSISTENT_CLASS);
            } else {
                this.securityPolicy = SecurityPolicy.forValue(((Number)e.getValue()).intValue());
            }
        } else if (e.getIndex() == 3) {
            this.setSecuritySuite(SecuritySuite.forValue(((Number)e.getValue()).byteValue()));
        } else if (e.getIndex() == 4) {
            if (e.getValue() != null && ((byte[])e.getValue()).length != 8 && ((byte[])e.getValue()).length != 0) {
                e.setError(ErrorCode.INCONSISTENT_CLASS);
            } else {
                this.setClientSystemTitle((byte[])e.getValue());
            }
        } else if (e.getIndex() == 5) {
            if (((byte[])e.getValue()).length != 8) {
                e.setError(ErrorCode.INCONSISTENT_CLASS);
            } else {
                this.setServerSystemTitle((byte[])e.getValue());
            }
        } else if (e.getIndex() == 6) {
            this.updateSertificates((List)e.getValue());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        GXPkcs8 pk;
        this.securityPolicy = SecurityPolicy.forValue(reader.readElementContentAsInt("SecurityPolicy"));
        int value = reader.readElementContentAsInt("SecurityPolicy0");
        if (value != 0) {
            this.securityPolicy = SecurityPolicy.forValue(value);
        }
        this.securitySuite = SecuritySuite.values()[reader.readElementContentAsInt("SecuritySuite")];
        String str = reader.readElementContentAsString("ClientSystemTitle");
        this.clientSystemTitle = (byte[])(str == null ? null : GXDLMSTranslator.hexToBytes(str));
        str = reader.readElementContentAsString("ServerSystemTitle");
        this.serverSystemTitle = (byte[])(str == null ? null : GXDLMSTranslator.hexToBytes(str));
        this.certificates.clear();
        if (reader.isStartElement("Certificates", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSCertificateInfo it = new GXDLMSCertificateInfo();
                this.certificates.add(it);
                it.setEntity(CertificateEntity.forValue(reader.readElementContentAsInt("Entity")));
                it.setType(CertificateType.forValue(reader.readElementContentAsInt("Type")));
                it.setSerialNumber(new BigInteger(reader.readElementContentAsString("SerialNumber")));
                it.setIssuer(reader.readElementContentAsString("Issuer"));
                it.setSubject(reader.readElementContentAsString("Subject"));
                it.setSubjectAltName(reader.readElementContentAsString("SubjectAltName"));
            }
            reader.readEndElement("Certificates");
        }
        if ((str = reader.readElementContentAsString("SigningKey")) == null) {
            this.signingKey = null;
        } else {
            pk = GXPkcs8.fromDer(str);
            this.signingKey = new KeyPair(pk.getPublicKey(), pk.getPrivateKey());
        }
        str = reader.readElementContentAsString("KeyAgreement");
        if (str == null) {
            this.keyAgreement = null;
        } else {
            pk = GXPkcs8.fromDer(str);
            this.keyAgreement = new KeyPair(pk.getPublicKey(), pk.getPrivateKey());
        }
        str = reader.readElementContentAsString("TLS");
        if (str == null) {
            this.tls = null;
        } else {
            pk = GXPkcs8.fromDer(str);
            this.tls = new KeyPair(pk.getPublicKey(), pk.getPrivateKey());
        }
        this.serverCertificates.clear();
        if (reader.isStartElement("ServerCertificates", true)) {
            while (reader.isStartElement("Cert", false)) {
                GXx509Certificate cert = GXx509Certificate.fromDer(reader.readElementContentAsString("Cert"));
                if (this.serverCertificates.find(cert) != null) continue;
                this.serverCertificates.add(cert);
            }
            reader.readEndElement("ServerCertificates");
        }
        if ((str = reader.readElementContentAsString("Guek")) != null) {
            this.guek = GXCommon.hexToBytes(str);
        }
        if ((str = reader.readElementContentAsString("Gbek")) != null) {
            this.gbek = GXCommon.hexToBytes(str);
        }
        if ((str = reader.readElementContentAsString("Gak")) != null) {
            this.gak = GXCommon.hexToBytes(str);
        }
        if ((str = reader.readElementContentAsString("Kek")) != null) {
            this.kek = GXCommon.hexToBytes(str);
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        GXPkcs8 kp;
        writer.writeElementString("SecurityPolicy", SecurityPolicy.toInteger(this.securityPolicy));
        writer.writeElementString("SecuritySuite", this.securitySuite.ordinal());
        writer.writeElementString("ClientSystemTitle", GXDLMSTranslator.toHex(this.clientSystemTitle));
        writer.writeElementString("ServerSystemTitle", GXDLMSTranslator.toHex(this.serverSystemTitle));
        if (this.certificates != null && this.certificates.size() != 0) {
            writer.writeStartElement("Certificates");
            for (Object it : this.certificates) {
                writer.writeStartElement("Item");
                writer.writeElementString("Entity", ((GXDLMSCertificateInfo)it).getEntity().getValue());
                writer.writeElementString("Type", ((GXDLMSCertificateInfo)it).getType().getValue());
                writer.writeElementString("SerialNumber", ((GXDLMSCertificateInfo)it).getSerialNumber().toString());
                writer.writeElementString("Issuer", ((GXDLMSCertificateInfo)it).getIssuer());
                writer.writeElementString("Subject", ((GXDLMSCertificateInfo)it).getSubject());
                writer.writeElementString("SubjectAltName", ((GXDLMSCertificateInfo)it).getSubjectAltName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.signingKey != null) {
            kp = new GXPkcs8(this.signingKey);
            writer.writeElementString("SigningKey", kp.toDer());
        }
        if (this.keyAgreement != null) {
            kp = new GXPkcs8(this.keyAgreement);
            writer.writeElementString("KeyAgreement", kp.toDer());
        }
        if (this.tls != null) {
            kp = new GXPkcs8(this.tls);
            writer.writeElementString("TLS", kp.toDer());
        }
        if (this.serverCertificates.size() != 0) {
            writer.writeStartElement("ServerCertificates");
            for (Object it : this.serverCertificates) {
                writer.writeElementString("Cert", ((GXx509Certificate)it).toDer());
            }
            writer.writeEndElement();
        }
        if (this.guek != null) {
            writer.writeElementString("Guek", GXCommon.toHex(this.guek));
        }
        if (this.gbek != null) {
            writer.writeElementString("Gbek", GXCommon.toHex(this.gbek));
        }
        if (this.gak != null) {
            writer.writeElementString("Gak", GXCommon.toHex(this.gak));
        }
        if (this.kek != null) {
            writer.writeElementString("Kek", GXCommon.toHex(this.kek));
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Security Policy", "Security Suite", "Client System Title", "Server System Title"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Security activate", "Key transfer"};
    }
}

