/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDate;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSSpecialDay;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSpecialDaysTable
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSSpecialDay[] entries;

    public GXDLMSSpecialDaysTable() {
        this("0.0.11.0.0.255", 0);
    }

    public GXDLMSSpecialDaysTable(String ln) {
        this(ln, 0);
    }

    public GXDLMSSpecialDaysTable(String ln, int sn) {
        super(ObjectType.SPECIAL_DAYS_TABLE, ln, sn);
    }

    public final GXDLMSSpecialDay[] getEntries() {
        return this.entries;
    }

    public final void setEntries(GXDLMSSpecialDay[] value) {
        this.entries = value;
    }

    public final byte[][] insert(GXDLMSClient client, GXDLMSSpecialDay entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        GXCommon.setData(null, bb, DataType.UINT16, entry.getIndex());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, entry.getDate());
        GXCommon.setData(null, bb, DataType.UINT8, entry.getDayId());
        return client.method(this, 1, bb.array(), DataType.ARRAY);
    }

    public final byte[][] delete(GXDLMSClient client, GXDLMSSpecialDay entry) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, entry.getIndex(), DataType.UINT16);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getEntries()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.entries == null) {
                GXCommon.setObjectCount(0, data);
            } else {
                int cnt = this.entries.length;
                GXCommon.setObjectCount(cnt, data);
                for (GXDLMSSpecialDay it : this.entries) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(null, data, DataType.UINT16, it.getIndex());
                    GXCommon.setData(null, data, DataType.OCTET_STRING, it.getDate());
                    GXCommon.setData(null, data, DataType.UINT8, it.getDayId());
                }
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.entries = null;
            if (e.getValue() != null) {
                ArrayList<GXDLMSSpecialDay> items = new ArrayList<GXDLMSSpecialDay>();
                for (Object i : (List)e.getValue()) {
                    List item = (List)i;
                    GXDLMSSpecialDay it = new GXDLMSSpecialDay();
                    it.setIndex(((Number)item.get(0)).intValue());
                    it.setDate((GXDate)GXDLMSClient.changeType((byte[])item.get(1), DataType.DATE, e.getSettings()));
                    it.setDayId(((Number)item.get(2)).intValue());
                    items.add(it);
                }
                this.entries = items.toArray(new GXDLMSSpecialDay[0]);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() != 1 && e.getIndex() != 2) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else {
            ArrayList<GXDLMSSpecialDay> items = new ArrayList<GXDLMSSpecialDay>();
            if (this.entries != null) {
                items.addAll(Arrays.asList(this.entries));
            }
            if (e.getIndex() == 1) {
                List tmp = (List)e.getParameters();
                GXDLMSSpecialDay it = new GXDLMSSpecialDay();
                it.setIndex(((Number)tmp.get(0)).intValue());
                it.setDate((GXDate)GXDLMSClient.changeType((byte[])tmp.get(1), DataType.DATE, e.getSettings()));
                it.setDayId(((Number)tmp.get(2)).intValue());
                for (GXDLMSSpecialDay item2 : items) {
                    if (item2.getIndex() != it.getIndex()) continue;
                    items.remove(item2);
                    break;
                }
                items.add(it);
            } else if (e.getIndex() == 2) {
                int index = ((Number)e.getParameters()).intValue();
                for (GXDLMSSpecialDay item : items) {
                    if (item.getIndex() != index) continue;
                    items.remove(item);
                    break;
                }
            }
            this.entries = items.toArray(new GXDLMSSpecialDay[0]);
        }
        return null;
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXDLMSSpecialDay> list = new ArrayList<GXDLMSSpecialDay>();
        if (reader.isStartElement("Entries", true)) {
            while (reader.isStartElement("Entry", true)) {
                GXDLMSSpecialDay it = new GXDLMSSpecialDay();
                it.setIndex(reader.readElementContentAsInt("Index"));
                it.setDate(reader.readElementContentAsDate("Date"));
                it.setDayId(reader.readElementContentAsInt("DayId"));
                list.add(it);
            }
            reader.readEndElement("Entries");
        }
        this.entries = list.toArray(new GXDLMSSpecialDay[list.size()]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.entries != null) {
            writer.writeStartElement("Entries");
            for (GXDLMSSpecialDay it : this.entries) {
                writer.writeStartElement("Entry");
                writer.writeElementString("Index", it.getIndex());
                writer.writeElementString("Date", it.getDate());
                writer.writeElementString("DayId", it.getDayId());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Entries"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Insert", "Delete"};
    }
}

