/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSUtilityTables
extends GXDLMSObject
implements IGXDLMSBase {
    private int tableId;
    private byte[] buffer;

    public GXDLMSUtilityTables() {
        this("0.0.65.0.0.255", 0);
    }

    public GXDLMSUtilityTables(String ln) {
        this(ln, 0);
    }

    public GXDLMSUtilityTables(String ln, int sn) {
        super(ObjectType.UTILITY_TABLES, ln, sn);
    }

    public final int getTableId() {
        return this.tableId;
    }

    public final void setTableId(int value) {
        this.tableId = value;
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(byte[] value) {
        this.buffer = value;
    }

    @Override
    public final Object[] getValues() {
        int len = 0;
        if (this.buffer != null) {
            len = this.buffer.length;
        }
        return new Object[]{this.getLogicalName(), this.tableId, len, this.buffer};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.UINT16;
            }
            case 3: {
                return DataType.UINT32;
            }
            case 4: {
                return DataType.OCTET_STRING;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.tableId;
            }
            case 3: {
                return this.buffer == null ? 0 : this.buffer.length;
            }
            case 4: {
                return this.buffer;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.tableId = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (e.getValue() instanceof String) {
                    this.buffer = GXCommon.hexToBytes((String)e.getValue());
                    break;
                }
                this.buffer = (byte[])e.getValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.tableId = reader.readElementContentAsInt("Value", 0);
        this.buffer = GXCommon.hexToBytes(reader.readElementContentAsString("Value", null));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Id", this.tableId);
        writer.writeElementString("Buffer", GXCommon.toHex(this.buffer, true));
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Table Id", "Length", "Buffer"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

