/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum AutoConnectMode {
    NO_AUTO_DIALLING(0),
    AUTO_DIALLING_ALLOWED_ANYTIME(1),
    AUTO_DIALLING_ALLOWED_CALLING_WINDOW(2),
    REGULAR_AUTO_DIALLING_ALLOWED_CALLING_WINDOW(3),
    SMS_SENDING_PLMN(4),
    SMS_SENDING_PSTN(5),
    EMAIL_SENDING(6),
    PERMANENTLY_CONNECT(101),
    CONNECT_WITH_CALLING_WINDOW(102),
    CONNECT_INVOKED(103),
    DISCONNECT_CONNECT_INVOKED(104),
    MANUFACTURE_SPESIFIC(200);

    private int value;
    private static HashMap<Integer, AutoConnectMode> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, AutoConnectMode> getMappings() {
        Class<AutoConnectMode> clazz = AutoConnectMode.class;
        synchronized (AutoConnectMode.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private AutoConnectMode(int forValue) {
        this.value = forValue > 200 && forValue < 255 ? 200 : forValue;
        AutoConnectMode.getMappings().put(this.value, this);
    }

    public int getValue() {
        return this.value;
    }

    public static AutoConnectMode forValue(int value) {
        if (value > 200 && value < 255) {
            return MANUFACTURE_SPESIFIC;
        }
        return AutoConnectMode.getMappings().get(value);
    }
}

