/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum PaymentMode {
    CREDIT(1),
    PREPAYMENT(2);

    private int intValue;
    private static HashMap<Integer, PaymentMode> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, PaymentMode> getMappings() {
        Class<PaymentMode> clazz = PaymentMode.class;
        synchronized (PaymentMode.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private PaymentMode(int value) {
        this.intValue = value;
        PaymentMode.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static PaymentMode forValue(int value) {
        PaymentMode ret = PaymentMode.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid payment mode enum value.");
        }
        return ret;
    }
}

