/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.internal.GXCommon;

public class GXBitString {
    private int padBits;
    private byte[] _value;

    public final int getPadBits() {
        return this.padBits;
    }

    public final byte[] getValue() {
        return this._value;
    }

    public final int length() {
        if (this._value == null) {
            return 0;
        }
        return 8 * this._value.length - this.padBits;
    }

    public GXBitString() {
    }

    public GXBitString(String bitString) {
        this.padBits = 8 - bitString.length() % 8;
        if (this.padBits == 8) {
            this.padBits = 0;
        }
        StringBuilder sb = new StringBuilder(bitString);
        GXBitString.appendZeros(sb, this.padBits);
        this._value = new byte[sb.length() / 8];
        for (int pos = 0; pos != this._value.length; ++pos) {
            this._value[pos] = (byte)Integer.parseInt(sb.substring(8 * pos, 8 * (pos + 1)), 2);
        }
    }

    public GXBitString(byte[] str, int padCount) {
        if (str == null) {
            throw new IllegalArgumentException("data");
        }
        if (this.padBits < 0 || this.padBits > 7) {
            throw new IllegalArgumentException("PadCount must be in the range 0 to 7");
        }
        this._value = str;
        this.padBits = padCount;
    }

    public GXBitString(byte[] str) {
        if (str == null) {
            throw new IllegalArgumentException("data");
        }
        this.padBits = str[0];
        if (this.padBits < 0 || this.padBits > 7) {
            throw new IllegalArgumentException("PadCount must be in the range 0 to 7");
        }
        this._value = new byte[str.length - 1];
        System.arraycopy(str, 1, this._value, 0, str.length - 1);
    }

    public GXBitString(long value, int count) {
        long tmp = value;
        this.padBits = count % 8;
        this._value = new byte[count / 8 + this.padBits];
        for (int pos = 0; pos != this._value.length; pos = (int)((byte)(pos + 1))) {
            this._value[pos] = (byte)GXCommon.swapBits((byte)tmp);
            tmp >>= 8;
        }
    }

    private static void appendZeros(StringBuilder sb, int count) {
        for (int pos = 0; pos != count; ++pos) {
            sb.append('0');
        }
    }

    public final String toString() {
        return this.toString(false);
    }

    public final String toString(boolean showBits) {
        if (this._value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(8 * this._value.length);
        for (byte it : this._value) {
            GXCommon.toBitString(sb, it, 8);
        }
        sb.setLength(sb.length() - this.padBits);
        if (showBits) {
            sb.insert(0, String.valueOf(8 * this._value.length - this.padBits) + " bit ");
        }
        return sb.toString();
    }

    public int toInteger() {
        int ret = 0;
        if (this._value != null) {
            int bytePos = 0;
            for (byte it : this._value) {
                ret |= GXCommon.swapBits(it) << bytePos;
                bytePos += 8;
            }
        }
        return ret;
    }
}

