/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXDLMS;
import gurux.dlms.enums.AcseServiceProvider;
import gurux.dlms.enums.AssociationResult;
import gurux.dlms.enums.SourceDiagnostic;

public class GXDLMSException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private AssociationResult result = AssociationResult.ACCEPTED;
    private int diagnostic = 0;
    private int errorCode;

    public GXDLMSException(int errCode) {
        super(GXDLMS.getDescription(errCode));
        this.setErrorCode(errCode);
    }

    public GXDLMSException(String message) {
        super(message);
    }

    GXDLMSException(AssociationResult forResult, SourceDiagnostic forDiagnostic) {
        this(forResult, forDiagnostic, "");
    }

    GXDLMSException(AssociationResult forResult, SourceDiagnostic forDiagnostic, String extra) {
        super("Connection is " + GXDLMSException.getResult(forResult) + "\r\n" + GXDLMSException.getDiagnostic(forDiagnostic) + extra);
        this.result = forResult;
        this.diagnostic = forDiagnostic.getValue();
    }

    GXDLMSException(AssociationResult forResult, AcseServiceProvider forDiagnostic) {
        super("Connection is " + GXDLMSException.getResult(forResult) + "\r\n" + GXDLMSException.getDiagnostic(forDiagnostic));
        this.result = forResult;
        this.diagnostic = forDiagnostic.getValue();
    }

    private static String getResult(AssociationResult result) {
        if (result == AssociationResult.PERMANENT_REJECTED) {
            return "permanently rejected";
        }
        if (result == AssociationResult.TRANSIENT_REJECTED) {
            return "transient rejected";
        }
        throw new UnsupportedOperationException();
    }

    private static String getDiagnostic(AcseServiceProvider diagnostic) {
        String str;
        switch (diagnostic) {
            case NONE: {
                str = "None.";
                break;
            }
            case NO_REASON_GIVEN: {
                str = "No reason given.";
                break;
            }
            case NO_COMMON_ACSE_VERSION: {
                str = "No Common Acse version.";
                break;
            }
            default: {
                str = "Unknown diagnostic error.";
            }
        }
        return str;
    }

    private static String getDiagnostic(SourceDiagnostic value) {
        if (value == SourceDiagnostic.NO_REASON_GIVEN) {
            return "No reason is given.";
        }
        if (value == SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED) {
            return "The application context name is not supported.";
        }
        if (value == SourceDiagnostic.AUTHENTICATION_MECHANISM_NAME_NOT_RECOGNIZED) {
            return "The authentication mechanism name is not recognized.";
        }
        if (value == SourceDiagnostic.AUTHENTICATION_MECHANISM_NAME_REGUIRED) {
            return "Authentication mechanism name is required.";
        }
        if (value == SourceDiagnostic.AUTHENTICATION_FAILURE) {
            return "Authentication failure.";
        }
        if (value == SourceDiagnostic.AUTHENTICATION_REQUIRED) {
            return "Authentication is required.";
        }
        throw new UnsupportedOperationException();
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final void setErrorCode(int value) {
        this.errorCode = value;
    }

    public final AssociationResult getResult() {
        return this.result;
    }

    public final int getDiagnostic() {
        return this.diagnostic;
    }
}

