/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;

class GXDLMSLNParameters {
    private GXDLMSSettings settings;
    int command;
    int cipheredCommand;
    private int requestType;
    private GXByteBuffer attributeDescriptor;
    private GXByteBuffer data;
    private GXDateTime time;
    private int status;
    private boolean multipleBlocks;
    private boolean lastBlock;
    int blockIndex;
    int blockNumber;
    public int blockNumberAck;
    private long invokeId;
    public byte windowSize;
    public boolean streaming;
    public int accessMode;

    GXDLMSLNParameters(GXDLMSSettings forSettings, long forInvokeId, int forCommand, int forCommandType, GXByteBuffer forAttributeDescriptor, GXByteBuffer forData, int forStatus, int forCipheredCommand) {
        this.settings = forSettings;
        this.invokeId = forInvokeId;
        this.setBlockIndex(this.settings.getBlockIndex());
        this.blockNumberAck = this.settings.getBlockNumberAck();
        this.command = forCommand;
        this.cipheredCommand = forCipheredCommand;
        this.setRequestType(forCommandType);
        this.attributeDescriptor = forAttributeDescriptor;
        this.data = forData;
        this.setTime(null);
        this.setStatus(forStatus);
        this.setMultipleBlocks(forSettings.getCount() != forSettings.getIndex());
        this.setLastBlock(forSettings.getCount() == forSettings.getIndex());
        this.windowSize = 1;
        if (this.settings != null) {
            this.settings.setCommand(forCommand);
            if (forCommand == 192 && forCommandType != 2) {
                this.settings.setCommandType((byte)forCommandType);
            }
        }
    }

    public GXDLMSSettings getSettings() {
        return this.settings;
    }

    public int getCommand() {
        return this.command;
    }

    public int getCipheredCommand() {
        return this.cipheredCommand;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public final void setRequestType(int value) {
        this.requestType = value;
    }

    public GXByteBuffer getAttributeDescriptor() {
        return this.attributeDescriptor;
    }

    public GXByteBuffer getData() {
        return this.data;
    }

    public GXDateTime getTime() {
        return this.time;
    }

    public final void setTime(GXDateTime value) {
        this.time = value;
    }

    public int getStatus() {
        return this.status;
    }

    public final void setStatus(int value) {
        this.status = value;
    }

    public boolean isMultipleBlocks() {
        return this.multipleBlocks;
    }

    void setMultipleBlocks(boolean value) {
        this.multipleBlocks = value;
    }

    boolean isLastBlock() {
        return this.lastBlock;
    }

    void setLastBlock(boolean value) {
        this.lastBlock = value;
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    void setBlockIndex(int value) {
        this.blockIndex = value;
    }

    public final long getInvokeId() {
        return this.invokeId;
    }

    public final void setInvokeId(long value) {
        this.invokeId = value;
    }

    public final int getBlockNumber() {
        return this.blockNumber;
    }

    final void setBlockNumber(int value) {
        this.blockNumber = value;
    }

    public final int getBlockNumberAck() {
        return this.blockNumberAck;
    }

    final void setBlockNumberAck(int value) {
        this.blockNumberAck = value;
    }

    public final boolean getStreaming() {
        return this.streaming;
    }

    final void setStreaming(boolean value) {
        this.streaming = value;
    }

    public final byte getWindowSize() {
        return this.windowSize;
    }

    public final void setWindowSize(byte value) {
        this.windowSize = value;
    }

    @Deprecated
    public final boolean IsStreaming() {
        return this.isStreaming();
    }

    public final boolean isStreaming() {
        return this.getStreaming() && this.getBlockNumberAck() * this.getWindowSize() + 1 > this.getBlockNumber();
    }
}

