/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.enums.AssociationResult;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.secure.GXCiphering;
import java.util.HashMap;

class GXDLMSXmlSettings {
    private AssociationResult result = AssociationResult.ACCEPTED;
    private SourceDiagnostic diagnostic = SourceDiagnostic.NONE;
    private byte reason = 0;
    private int command;
    private int gwCommand;
    private int networkId;
    private byte[] physicalDeviceAddress;
    private int count = 0;
    private int requestType = 255;
    private GXByteBuffer attributeDescriptor = new GXByteBuffer();
    private GXByteBuffer data = new GXByteBuffer();
    private final GXDLMSSettings settings;
    private HashMap<String, Integer> tags = new HashMap();
    private GXDateTime time = null;
    private boolean template;
    private boolean showNumericsAsHex;
    private boolean showStringAsHex = false;
    private TranslatorOutputType outputType;

    GXDLMSXmlSettings(TranslatorOutputType type, boolean numericsAsHex, boolean hex, HashMap<String, Integer> list) {
        this.settings = new GXDLMSSettings(true, null, null);
        this.outputType = type;
        this.showNumericsAsHex = this.outputType != TranslatorOutputType.STANDARD_XML && numericsAsHex;
        this.showStringAsHex = hex;
        this.settings.setInterfaceType(InterfaceType.PDU);
        this.settings.setCipher(new GXCiphering("ABCDEFGH".getBytes()));
        this.tags = list;
    }

    public final GXDLMSSettings getSettings() {
        return this.settings;
    }

    public final AssociationResult getResult() {
        return this.result;
    }

    public final void setResult(AssociationResult value) {
        this.result = value;
    }

    public final SourceDiagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public final void setDiagnostic(SourceDiagnostic value) {
        this.diagnostic = value;
    }

    public final byte getReason() {
        return this.reason;
    }

    public final void setReason(byte value) {
        this.reason = value;
    }

    public final int getCommand() {
        return this.command;
    }

    public final void setCommand(int value) {
        this.command = value;
    }

    public final int getCount() {
        return this.count;
    }

    public void setCount(int value) {
        this.count = value;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public final void setRequestType(int value) {
        this.requestType = value;
    }

    public final GXByteBuffer getAttributeDescriptor() {
        return this.attributeDescriptor;
    }

    public final GXByteBuffer getData() {
        return this.data;
    }

    public final HashMap<String, Integer> getTags() {
        return this.tags;
    }

    public final GXDateTime getTime() {
        return this.time;
    }

    public final void setTime(GXDateTime value) {
        this.time = value;
    }

    public final boolean isShowStringAsHex() {
        return this.showStringAsHex;
    }

    public final int parseInt(String value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        if (this.showNumericsAsHex) {
            return Integer.parseInt(value, 16);
        }
        return Integer.parseInt(value);
    }

    public final short parseShort(String value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        if (this.showNumericsAsHex) {
            return Short.parseShort(value, 16);
        }
        return Short.parseShort(value);
    }

    public final long parseLong(String value) {
        if (value == null || "".equals(value)) {
            return 0L;
        }
        if (this.showNumericsAsHex) {
            return Long.parseLong(value, 16);
        }
        return Long.parseLong(value);
    }

    public TranslatorOutputType getOutputType() {
        return this.outputType;
    }

    public int getGwCommand() {
        return this.gwCommand;
    }

    public void setGwCommand(int value) {
        this.gwCommand = value;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int value) {
        this.networkId = value;
    }

    public byte[] getPhysicalDeviceAddress() {
        return this.physicalDeviceAddress;
    }

    public void setPhysicalDeviceAddress(byte[] value) {
        this.physicalDeviceAddress = value;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }
}

