/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import java.util.HashMap;

public enum MBusCommand {
    SND_NR(4),
    SND_UD(3),
    RSP_UD(8);

    private int intValue;
    private static HashMap<Integer, MBusCommand> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, MBusCommand> getMappings() {
        if (mappings != null) return mappings;
        Class<MBusCommand> clazz = MBusCommand.class;
        synchronized (MBusCommand.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private MBusCommand(int value) {
        this.intValue = value;
        MBusCommand.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static MBusCommand forValue(int value) {
        MBusCommand ret = MBusCommand.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid MBus command enum value.");
        }
        return ret;
    }
}

