/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import java.util.HashMap;

public enum MBusControlInfo {
    LONG_HEADER_MASTER(96),
    SHORT_HEADER_MASTER(97),
    LONG_HEADER_SLAVE(124),
    SHORT_HEADER_SLAVE(125),
    SHORT_HEADER(122),
    LONG_HEADER(114);

    private int intValue;
    private static HashMap<Integer, MBusControlInfo> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, MBusControlInfo> getMappings() {
        if (mappings != null) return mappings;
        Class<MBusControlInfo> clazz = MBusControlInfo.class;
        synchronized (MBusControlInfo.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private MBusControlInfo(int value) {
        this.intValue = value;
        MBusControlInfo.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static MBusControlInfo forValue(int value) {
        MBusControlInfo ret = MBusControlInfo.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid MBus control info enum value.");
        }
        return ret;
    }
}

