/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

import java.util.HashMap;

public enum Security {
    NONE(0),
    AUTHENTICATION(16),
    ENCRYPTION(32),
    AUTHENTICATION_ENCRYPTION(48);

    private int intValue;
    private static HashMap<Integer, Security> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, Security> getMappings() {
        if (mappings != null) return mappings;
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private Security(int value) {
        this.intValue = value;
        Security.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static Security forValue(int value) {
        Security tmp = Security.getMappings().get(value);
        if (tmp == null) {
            throw new IllegalArgumentException("Invalid security integer value.");
        }
        return tmp;
    }

    public String toString() {
        String str;
        Security value = Security.forValue(this.getValue());
        switch (value.ordinal()) {
            case 0: {
                str = "NONE";
                break;
            }
            case 1: {
                str = "AUTHENTICATION";
                break;
            }
            case 2: {
                str = "ENCRYPTION";
                break;
            }
            case 3: {
                str = "AUTHENTICATION_ENCRYPTION";
                break;
            }
            default: {
                throw new IllegalArgumentException("Security");
            }
        }
        return str;
    }

    public static Security valueOfString(String value) {
        Security v;
        if ("NONE".equalsIgnoreCase(value)) {
            v = NONE;
        } else if ("AUTHENTICATION".equalsIgnoreCase(value)) {
            v = AUTHENTICATION;
        } else if ("ENCRYPTION".equalsIgnoreCase(value)) {
            v = ENCRYPTION;
        } else if ("AUTHENTICATION_ENCRYPTION".equalsIgnoreCase(value)) {
            v = AUTHENTICATION_ENCRYPTION;
        } else {
            throw new IllegalArgumentException(value);
        }
        return v;
    }
}

