/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

import java.util.HashMap;

public enum Standard {
    DLMS(0),
    INDIA(1),
    ITALY(2),
    SAUDI_ARABIA(3),
    IDIS(4),
    SPAIN(5);

    private int value;
    private static HashMap<Integer, Standard> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, Standard> getMappings() {
        Class<Standard> clazz = Standard.class;
        synchronized (Standard.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private Standard(int mode) {
        this.value = mode;
        Standard.getMappings().put(mode, this);
    }

    public final int getValue() {
        return this.value;
    }

    public static Standard forValue(int value) {
        return Standard.getMappings().get(value);
    }

    public String toString() {
        String str;
        Standard value = Standard.forValue(this.getValue());
        switch (value.ordinal()) {
            case 0: {
                str = "DLMS";
                break;
            }
            case 1: {
                str = "INDIA";
                break;
            }
            case 2: {
                str = "ITALY";
                break;
            }
            case 3: {
                str = "SAUDI_ARABIA";
                break;
            }
            case 4: {
                str = "IDIS";
                break;
            }
            default: {
                throw new IllegalArgumentException("Standard");
            }
        }
        return str;
    }

    public static Standard valueOfString(String value) {
        Standard v;
        if ("DLMS".equalsIgnoreCase(value)) {
            v = DLMS;
        } else if ("INDIA".equalsIgnoreCase(value)) {
            v = INDIA;
        } else if ("ITALY".equalsIgnoreCase(value)) {
            v = ITALY;
        } else if ("SAUDI_ARABIA".equalsIgnoreCase(value)) {
            v = SAUDI_ARABIA;
        } else if ("IDIS".equalsIgnoreCase(value)) {
            v = IDIS;
        } else {
            throw new IllegalArgumentException(value);
        }
        return v;
    }
}

