/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXStructure;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSArrayManagerItem;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSProfileGeneric;
import gurux.dlms.objects.GXDLMSTargetObject;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSArrayManager
extends GXDLMSObject
implements IGXDLMSBase {
    private ArrayList<GXDLMSArrayManagerItem> elements = new ArrayList();

    public GXDLMSArrayManager() {
        this("0.0.18.0.0.255", 0);
    }

    public GXDLMSArrayManager(String ln) {
        this(ln, 0);
        this.elements = new ArrayList();
    }

    public GXDLMSArrayManager(String ln, int sn) {
        super(ObjectType.ARRAY_MANAGER, ln, sn);
    }

    public final ArrayList<GXDLMSArrayManagerItem> getElements() {
        return this.elements;
    }

    public final void setElements(ArrayList<GXDLMSArrayManagerItem> value) {
        this.elements = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.elements};
    }

    public final byte[][] numberOfEntries(GXDLMSClient client, byte id) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, id, DataType.INT8);
    }

    public final int parseNumberOfEntries(byte[] reply) {
        return this.parseNumberOfEntries(new GXByteBuffer(reply));
    }

    public final int parseNumberOfEntries(GXByteBuffer reply) {
        GXDataInfo info = new GXDataInfo();
        return (Integer)GXCommon.getData(null, reply, info);
    }

    public final byte[][] retrieveEntries(GXDLMSClient client, short id, int from, int to) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer reply = new GXByteBuffer();
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT8, id);
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT16, from);
        GXCommon.setData(null, reply, DataType.UINT16, to);
        return client.method(this, 2, reply.array(), DataType.STRUCTURE);
    }

    public final ArrayList<?> parseEntries(GXByteBuffer reply) {
        GXDataInfo info = new GXDataInfo();
        return (ArrayList)GXCommon.getData(null, reply, info);
    }

    public final byte[][] insertEntry(GXDLMSClient client, short id, int index, Object entry, DataType dataType) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer reply = new GXByteBuffer();
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT8, id);
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT16, index);
        GXCommon.setData(null, reply, dataType, entry);
        return client.method(this, 3, reply.array(), DataType.STRUCTURE);
    }

    public final byte[][] updateEntry(GXDLMSClient client, short id, int index, Object entry, DataType dataType) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer reply = new GXByteBuffer();
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT8, id);
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT16, index);
        GXCommon.setData(null, reply, dataType, entry);
        return client.method(this, 4, reply.array(), DataType.STRUCTURE);
    }

    public final byte[][] RemoveEntries(GXDLMSClient client, short id, int from, int to) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer reply = new GXByteBuffer();
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT8, id);
        reply.setUInt8(DataType.STRUCTURE);
        reply.setUInt8(2);
        GXCommon.setData(null, reply, DataType.UINT16, from);
        GXCommon.setData(null, reply, DataType.UINT16, to);
        return client.method(this, 5, reply.array(), DataType.STRUCTURE);
    }

    private GXByteBuffer getData(GXDLMSSettings settings, GXDLMSObject target, int attributeIndex) {
        return this.getData(settings, target, attributeIndex, 0, null);
    }

    private GXByteBuffer getData(GXDLMSSettings settings, GXDLMSObject target, int attributeIndex, int selector, Object parameters) {
        GXByteBuffer bb;
        ValueEventArgs arg;
        Object tmp;
        if (target.getDataType(attributeIndex) == DataType.ARRAY && (tmp = ((IGXDLMSBase)((Object)target)).getValue(settings, arg = new ValueEventArgs(target, attributeIndex, selector, parameters))) instanceof byte[] && (bb = new GXByteBuffer((byte[])tmp)).getUInt8() == DataType.ARRAY.getValue()) {
            return bb;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        e.setByteArray(true);
        byte[] ret = null;
        GXByteBuffer reply = new GXByteBuffer();
        switch (e.getIndex()) {
            case 1: {
                this.numberOfEntries(settings, e, ((Byte)e.getParameters()).byteValue(), reply);
                break;
            }
            case 2: {
                GXStructure args = (GXStructure)e.getParameters();
                this.retrieveEntries(settings, e, args, reply);
                break;
            }
            case 3: {
                GXStructure args = (GXStructure)e.getParameters();
                this.insertEntry(settings, e, args, reply);
                break;
            }
            case 4: {
                GXStructure args = (GXStructure)e.getParameters();
                this.updateEntry(settings, e, args, reply);
                break;
            }
            case 5: {
                GXStructure args = (GXStructure)e.getParameters();
                this.removeEntries(settings, e, args, reply);
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        if (reply.size() != 0) {
            ret = reply.array();
        }
        return ret;
    }

    private void numberOfEntries(GXDLMSSettings settings, ValueEventArgs e, short id, GXByteBuffer reply) {
        boolean found = false;
        for (GXDLMSArrayManagerItem it : this.elements) {
            if (it.getId() != id) continue;
            if (it.getElement().getTarget() instanceof GXDLMSProfileGeneric && it.getElement().getAttributeIndex() == 2) {
                GXDLMSProfileGeneric pg = (GXDLMSProfileGeneric)it.getElement().getTarget();
                GXCommon.setData(settings, reply, DataType.UINT32, pg.getEntriesInUse());
                found = true;
            }
            if (found) break;
            GXByteBuffer value = this.getData(settings, it.getElement().getTarget(), it.getElement().getAttributeIndex());
            int count = GXCommon.getObjectCount(value);
            DataType dt = count <= 127 ? DataType.UINT8 : (count <= Short.MAX_VALUE ? DataType.UINT16 : DataType.UINT32);
            GXCommon.setData(settings, reply, dt, count);
            found = true;
            break;
        }
        if (!found) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void retrieveEntries(GXDLMSSettings settings, ValueEventArgs e, GXStructure args, GXByteBuffer reply) {
        boolean found = false;
        short id = (Short)args.get(0);
        int from = (Integer)((GXStructure)args.get(1)).get(0);
        int to = (Integer)((GXStructure)args.get(1)).get(1);
        for (GXDLMSArrayManagerItem it : this.elements) {
            if (it.getId() != id || from > to || from <= 0) continue;
            Object[] parameters = null;
            if (it.getElement().getTarget() instanceof GXDLMSProfileGeneric) {
                parameters = new Object[]{null, null, from, to};
            }
            ValueEventArgs arg = new ValueEventArgs(it.getElement().getTarget(), it.getElement().getAttributeIndex(), 2, parameters);
            GXByteBuffer bb = new GXByteBuffer((byte[])((IGXDLMSBase)((Object)it.getElement().getTarget())).getValue(settings, arg));
            GXDataInfo info = new GXDataInfo();
            GXArray arr = (GXArray)GXCommon.getData(settings, bb, info);
            --from;
            if (to < arr.size()) {
                arr.removeRange(to, arr.size());
            }
            if (from != 0) {
                arr.removeRange(0, from);
            }
            GXCommon.setData(settings, reply, DataType.ARRAY, arr);
            found = true;
            break;
        }
        if (!found) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void insertEntry(GXDLMSSettings settings, ValueEventArgs e, GXStructure args, GXByteBuffer reply) {
        boolean found = false;
        short id = (Short)args.get(0);
        for (GXDLMSArrayManagerItem it : this.elements) {
            if (it.getId() != id) continue;
            int index = (Integer)((GXStructure)args.get(1)).get(0);
            Object data = ((GXStructure)args.get(1)).get(1);
            ValueEventArgs arg = new ValueEventArgs(it.getElement().getTarget(), it.getElement().getAttributeIndex(), 0, null);
            GXByteBuffer bb = new GXByteBuffer((byte[])((IGXDLMSBase)((Object)it.getElement().getTarget())).getValue(settings, arg));
            GXDataInfo info = new GXDataInfo();
            GXArray arr = (GXArray)GXCommon.getData(settings, bb, info);
            if (index == 0) {
                arr.add(0, data);
            } else if (index > arr.size()) {
                arr.add(data);
            } else {
                arr.add(index, data);
            }
            arg.setValue(arr);
            ((IGXDLMSBase)((Object)it.getElement().getTarget())).setValue(settings, arg);
            found = true;
            break;
        }
        if (!found) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void updateEntry(GXDLMSSettings settings, ValueEventArgs e, GXStructure args, GXByteBuffer reply) {
        boolean found = false;
        short id = (Short)args.get(0);
        for (GXDLMSArrayManagerItem it : this.elements) {
            GXDataInfo info;
            if (it.getId() != id) continue;
            int index = (Integer)((GXStructure)args.get(1)).get(0);
            Object data = ((GXStructure)args.get(1)).get(1);
            if (index <= 0) break;
            ValueEventArgs arg = new ValueEventArgs(it.getElement().getTarget(), it.getElement().getAttributeIndex(), 0, null);
            GXByteBuffer bb = new GXByteBuffer((byte[])((IGXDLMSBase)((Object)it.getElement().getTarget())).getValue(settings, arg));
            GXArray arr = (GXArray)GXCommon.getData(settings, bb, info = new GXDataInfo());
            if (--index >= arr.size()) break;
            arr.set(index, data);
            arg.setValue(arr);
            ((IGXDLMSBase)((Object)it.getElement().getTarget())).setValue(settings, arg);
            found = true;
            break;
        }
        if (!found) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    private void removeEntries(GXDLMSSettings settings, ValueEventArgs e, GXStructure args, GXByteBuffer reply) {
        boolean found = false;
        short id = (Short)args.get(0);
        int from = (Integer)((GXStructure)args.get(1)).get(0);
        int to = (Integer)((GXStructure)args.get(1)).get(1);
        if (from != 0 && from <= to) {
            for (GXDLMSArrayManagerItem it : this.elements) {
                if (it.getId() != id) continue;
                int index = (Integer)((GXStructure)args.get(1)).get(0);
                Object data = ((GXStructure)args.get(1)).get(1);
                ValueEventArgs arg = new ValueEventArgs(it.getElement().getTarget(), it.getElement().getAttributeIndex(), 0, null);
                GXByteBuffer bb = new GXByteBuffer((byte[])((IGXDLMSBase)((Object)it.getElement().getTarget())).getValue(settings, arg));
                GXDataInfo info = new GXDataInfo();
                GXArray arr = (GXArray)GXCommon.getData(settings, bb, info);
                arr.removeRange(--from, to);
                arg.setValue(arr);
                ((IGXDLMSBase)((Object)it.getElement().getTarget())).setValue(settings, arg);
                found = true;
                break;
            }
        }
        if (!found) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "Objects"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[]{"Amount", "Retrieve", "Insert", "Update", "Remove"};
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 5;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.ARRAY;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                int cnt = this.getElements() == null ? 0 : this.getElements().size();
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                GXCommon.setObjectCount(cnt, data);
                if (cnt != 0) {
                    for (GXDLMSArrayManagerItem it : this.elements) {
                        data.setUInt8(DataType.STRUCTURE);
                        data.setUInt8(2);
                        GXCommon.setData(settings, data, DataType.UINT8, it.getId());
                        data.setUInt8(DataType.STRUCTURE);
                        data.setUInt8(3);
                        GXCommon.setData(settings, data, DataType.UINT16, it.getElement().getTarget().getObjectType().getValue());
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getElement().getTarget().getLogicalName()));
                        GXCommon.setData(settings, data, DataType.INT8, it.getElement().getAttributeIndex());
                    }
                }
                return data.array();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.getElements().clear();
                if (e.getValue() == null) break;
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure item = (GXStructure)tmp;
                    GXDLMSArrayManagerItem tempVar = new GXDLMSArrayManagerItem();
                    tempVar.setId(((Number)item.get(0)).shortValue());
                    GXDLMSArrayManagerItem tmp2 = tempVar;
                    GXStructure a = (GXStructure)item.get(1);
                    ObjectType ot = ObjectType.forValue(((Number)a.get(0)).byteValue());
                    GXDLMSObject obj = GXDLMSClient.createObject(ot);
                    obj.setLogicalName(GXCommon.toLogicalName(a.get(1)));
                    byte attributeIndex = (Byte)a.get(2);
                    tmp2.setElement(new GXDLMSTargetObject(obj, attributeIndex));
                    this.elements.add(tmp2);
                }
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.getElements().clear();
        if (reader.isStartElement("Elements", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSArrayManagerItem tempVar = new GXDLMSArrayManagerItem();
                tempVar.setId((short)reader.readElementContentAsInt("Id"));
                GXDLMSArrayManagerItem item = tempVar;
                if (reader.isStartElement("Target", true)) {
                    ObjectType ot = ObjectType.forValue(reader.readElementContentAsInt("Type"));
                    GXDLMSObject obj = GXDLMSClient.createObject(ot);
                    obj.setLogicalName(reader.readElementContentAsString("LN"));
                    int index = reader.readElementContentAsInt("Index");
                    item.setElement(new GXDLMSTargetObject(obj, index));
                    reader.readEndElement("Target");
                }
                reader.readEndElement("Item");
                this.getElements().add(item);
            }
            reader.readEndElement("Elements");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("Elements");
        if (this.getElements() != null) {
            for (GXDLMSArrayManagerItem it : this.elements) {
                writer.writeStartElement("Item");
                writer.writeElementString("Id", it.getId());
                writer.writeStartElement("Target");
                writer.writeElementString("Type", it.getElement().getTarget().getObjectType().getValue());
                writer.writeElementString("LN", it.getElement().getTarget().getLogicalName());
                writer.writeElementString("Index", it.getElement().getAttributeIndex());
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
        for (GXDLMSArrayManagerItem it : this.elements) {
            GXDLMSObject obj;
            if (it.getElement() == null || it.getElement().getTarget() == null || (obj = reader.getObjects().findByLN(it.getElement().getTarget().getObjectType(), it.getElement().getTarget().getLogicalName())) == null) continue;
            it.getElement().setTarget(obj);
        }
    }
}

