/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXChargeTable;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXUnitCharge;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ChargeConfiguration;
import gurux.dlms.objects.enums.ChargeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class GXDLMSCharge
extends GXDLMSObject
implements IGXDLMSBase {
    private int totalAmountPaid;
    private ChargeType chargeType;
    private byte priority;
    private GXUnitCharge unitChargeActive = new GXUnitCharge();
    private GXUnitCharge unitChargePassive = new GXUnitCharge();
    private GXDateTime unitChargeActivationTime;
    private int period;
    private Set<ChargeConfiguration> chargeConfiguration;
    private GXDateTime lastCollectionTime;
    private int lastCollectionAmount;
    private int totalAmountRemaining;
    private int proportion;

    public GXDLMSCharge() {
        this("0.0.19.20.0.255", 0);
    }

    public GXDLMSCharge(String ln) {
        this(ln, 0);
    }

    public GXDLMSCharge(String ln, int sn) {
        super(ObjectType.CHARGE, ln, sn);
        this.chargeType = ChargeType.CONSUMPTION_BASED_COLLECTION;
        this.chargeConfiguration = new HashSet<ChargeConfiguration>();
    }

    public final int getTotalAmountPaid() {
        return this.totalAmountPaid;
    }

    public final void setTotalAmountPaid(int value) {
        this.totalAmountPaid = value;
    }

    public final ChargeType getChargeType() {
        return this.chargeType;
    }

    public final void setChargeType(ChargeType value) {
        this.chargeType = value;
    }

    public final byte getPriority() {
        return this.priority;
    }

    public final void setPriority(byte value) {
        this.priority = value;
    }

    public final GXUnitCharge getUnitChargeActive() {
        return this.unitChargeActive;
    }

    public final void setUnitChargeActive(GXUnitCharge value) {
        this.unitChargeActive = value;
    }

    public final GXUnitCharge getUnitChargePassive() {
        return this.unitChargePassive;
    }

    public final void setUnitChargePassive(GXUnitCharge value) {
        this.unitChargePassive = value;
    }

    public final GXDateTime getUnitChargeActivationTime() {
        return this.unitChargeActivationTime;
    }

    public final void setUnitChargeActivationTime(GXDateTime value) {
        this.unitChargeActivationTime = value;
    }

    public final int getPeriod() {
        return this.period;
    }

    public final void setPeriod(int value) {
        this.period = value;
    }

    public final Set<ChargeConfiguration> getChargeConfiguration() {
        return this.chargeConfiguration;
    }

    public final void setChargeConfiguration(Set<ChargeConfiguration> value) {
        this.chargeConfiguration = value;
    }

    public final GXDateTime getLastCollectionTime() {
        return this.lastCollectionTime;
    }

    public final void setLastCollectionTime(GXDateTime value) {
        this.lastCollectionTime = value;
    }

    public final int getLastCollectionAmount() {
        return this.lastCollectionAmount;
    }

    public final void setLastCollectionAmount(int value) {
        this.lastCollectionAmount = value;
    }

    public final int getTotalAmountRemaining() {
        return this.totalAmountRemaining;
    }

    public final void setTotalAmountRemaining(int value) {
        this.totalAmountRemaining = value;
    }

    public final int getProportion() {
        return this.proportion;
    }

    public final void setProportion(int value) {
        this.proportion = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.totalAmountPaid, this.chargeType, this.priority, this.unitChargeActive, this.unitChargePassive, this.unitChargeActivationTime, this.period, this.chargeConfiguration, this.lastCollectionTime, this.lastCollectionAmount, this.totalAmountRemaining, this.proportion};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (all || this.canRead(13)) {
            attributes.add(13);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 13;
    }

    @Override
    public final int getMethodCount() {
        return 5;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.INT32;
            }
            case 3: {
                return DataType.ENUM;
            }
            case 4: {
                return DataType.UINT8;
            }
            case 5: {
                return DataType.STRUCTURE;
            }
            case 6: {
                return DataType.STRUCTURE;
            }
            case 7: {
                return DataType.OCTET_STRING;
            }
            case 8: {
                return DataType.UINT32;
            }
            case 9: {
                return DataType.BITSTRING;
            }
            case 10: {
                return DataType.DATETIME;
            }
            case 11: {
                return DataType.INT32;
            }
            case 12: {
                return DataType.INT32;
            }
            case 13: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final DataType getUIDataType(int index) {
        if (index == 7 || index == 10) {
            return DataType.DATETIME;
        }
        return super.getUIDataType(index);
    }

    private static byte[] getUnitCharge(GXUnitCharge charge) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(2);
        GXCommon.setData(null, bb, DataType.INT8, charge.getChargePerUnitScaling().getCommodityScale());
        GXCommon.setData(null, bb, DataType.INT8, charge.getChargePerUnitScaling().getPriceScale());
        bb.setUInt8(DataType.STRUCTURE.getValue());
        bb.setUInt8(3);
        if (charge.getCommodity().getTarget() == null) {
            GXCommon.setData(null, bb, DataType.UINT16, 0);
            bb.setUInt8(DataType.OCTET_STRING.getValue());
            bb.setUInt8(6);
            bb.setUInt8(0);
            bb.setUInt8(0);
            bb.setUInt8(0);
            bb.setUInt8(0);
            bb.setUInt8(0);
            bb.setUInt8(0);
            GXCommon.setData(null, bb, DataType.INT8, 0);
        } else {
            GXCommon.setData(null, bb, DataType.UINT16, charge.getCommodity().getTarget().getObjectType().getValue());
            GXCommon.setData(null, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(charge.getCommodity().getTarget().getLogicalName()));
            GXCommon.setData(null, bb, DataType.INT8, charge.getCommodity().getIndex());
        }
        bb.setUInt8(DataType.ARRAY.getValue());
        if (charge.getChargeTables() == null) {
            bb.setUInt8(0);
        } else {
            GXCommon.setObjectCount(charge.getChargeTables().length, bb);
            for (GXChargeTable it : charge.getChargeTables()) {
                bb.setUInt8(DataType.STRUCTURE.getValue());
                bb.setUInt8(2);
                GXCommon.setData(null, bb, DataType.OCTET_STRING, it.getIndex());
                GXCommon.setData(null, bb, DataType.INT16, it.getChargePerUnit());
            }
        }
        return bb.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.totalAmountPaid;
            }
            case 3: {
                return this.chargeType.getValue();
            }
            case 4: {
                return this.priority;
            }
            case 5: {
                return GXDLMSCharge.getUnitCharge(this.unitChargeActive);
            }
            case 6: {
                return GXDLMSCharge.getUnitCharge(this.unitChargePassive);
            }
            case 7: {
                return this.unitChargeActivationTime;
            }
            case 8: {
                return this.period;
            }
            case 9: {
                return new GXBitString(ChargeConfiguration.toInteger(this.chargeConfiguration), 2);
            }
            case 10: {
                return this.lastCollectionTime;
            }
            case 11: {
                return this.lastCollectionAmount;
            }
            case 12: {
                return this.totalAmountRemaining;
            }
            case 13: {
                return this.proportion;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private void setUnitCharge(GXDLMSSettings settings, GXUnitCharge charge, Object value) {
        List tmp = (List)value;
        List tmp2 = (List)tmp.get(0);
        charge.getChargePerUnitScaling().setCommodityScale(((Number)tmp2.get(0)).shortValue());
        charge.getChargePerUnitScaling().setPriceScale(((Number)tmp2.get(1)).shortValue());
        tmp2 = (List)tmp.get(1);
        ObjectType ot = ObjectType.forValue(((Number)tmp2.get(0)).intValue());
        String ln = GXCommon.toLogicalName(tmp2.get(1));
        charge.getCommodity().setTarget(settings.getObjects().findByLN(ot, ln));
        charge.getCommodity().setIndex(((Number)tmp2.get(2)).intValue());
        ArrayList<GXChargeTable> list = new ArrayList<GXChargeTable>();
        tmp2 = (List)tmp.get(2);
        for (Object tmp3 : tmp2) {
            List it = (List)tmp3;
            GXChargeTable item = new GXChargeTable();
            item.setIndex(new String((byte[])it.get(0)));
            item.setChargePerUnit(((Number)it.get(1)).shortValue());
            list.add(item);
        }
        charge.setChargeTables(list.toArray(new GXChargeTable[0]));
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.totalAmountPaid = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                this.chargeType = ChargeType.forValue(((Number)e.getValue()).intValue());
                break;
            }
            case 4: {
                this.priority = ((Number)e.getValue()).byteValue();
                break;
            }
            case 5: {
                this.setUnitCharge(settings, this.unitChargeActive, e.getValue());
                break;
            }
            case 6: {
                this.setUnitCharge(settings, this.unitChargePassive, e.getValue());
                break;
            }
            case 7: {
                if (e.getValue() instanceof GXDateTime) {
                    this.unitChargeActivationTime = (GXDateTime)e.getValue();
                    break;
                }
                this.unitChargeActivationTime = (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings());
                break;
            }
            case 8: {
                this.period = ((Number)e.getValue()).intValue();
                break;
            }
            case 9: {
                this.chargeConfiguration = ChargeConfiguration.forValue(((GXBitString)e.getValue()).toInteger());
                break;
            }
            case 10: {
                if (e.getValue() instanceof GXDateTime) {
                    this.lastCollectionTime = (GXDateTime)e.getValue();
                    break;
                }
                this.lastCollectionTime = (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings());
                break;
            }
            case 11: {
                this.lastCollectionAmount = ((Number)e.getValue()).intValue();
                break;
            }
            case 12: {
                this.totalAmountRemaining = ((Number)e.getValue()).intValue();
                break;
            }
            case 13: {
                this.proportion = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    private static void loadUnitChargeActive(GXXmlReader reader, String name, GXUnitCharge charge) {
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.totalAmountPaid = reader.readElementContentAsInt("TotalAmountPaid");
        this.chargeType = ChargeType.forValue(reader.readElementContentAsInt("ChargeType"));
        this.priority = (byte)reader.readElementContentAsInt("Priority");
        GXDLMSCharge.loadUnitChargeActive(reader, "UnitChargeActive", this.unitChargeActive);
        GXDLMSCharge.loadUnitChargeActive(reader, "UnitChargePassive", this.unitChargePassive);
        this.unitChargeActivationTime = reader.readElementContentAsDateTime("UnitChargeActivationTime");
        this.period = reader.readElementContentAsInt("Period");
        this.chargeConfiguration = ChargeConfiguration.forValue(reader.readElementContentAsInt("ChargeConfiguration"));
        this.lastCollectionTime = reader.readElementContentAsDateTime("LastCollectionTime");
        this.lastCollectionAmount = reader.readElementContentAsInt("LastCollectionAmount");
        this.totalAmountRemaining = reader.readElementContentAsInt("TotalAmountRemaining");
        this.proportion = reader.readElementContentAsInt("Proportion");
    }

    private static void saveUnitChargeActive(GXXmlWriter writer, String name, GXUnitCharge charge) {
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("TotalAmountPaid", this.totalAmountPaid);
        if (this.chargeType != null) {
            writer.writeElementString("ChargeType", this.chargeType.getValue());
        }
        writer.writeElementString("Priority", this.priority);
        GXDLMSCharge.saveUnitChargeActive(writer, "UnitChargeActive", this.unitChargeActive);
        GXDLMSCharge.saveUnitChargeActive(writer, "UnitChargePassive", this.unitChargePassive);
        writer.writeElementString("UnitChargeActivationTime", this.unitChargeActivationTime);
        writer.writeElementString("Period", this.period);
        writer.writeElementString("ChargeConfiguration", ChargeConfiguration.toInteger(this.chargeConfiguration));
        writer.writeElementString("LastCollectionTime", this.lastCollectionTime);
        writer.writeElementString("LastCollectionAmount", this.lastCollectionAmount);
        writer.writeElementString("TotalAmountRemaining", this.totalAmountRemaining);
        writer.writeElementString("Proportion", this.proportion);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "TotalAmountPaid", "ChargeType", "Priority", "UnitChargeActive", "UnitChargePassive", "UnitChargeActivationTime", "Period", "ChargeConfiguration", "LastCollectionTime", "LastCollectionAmount", "TotalAmountRemaining", "Proportion"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Update unit charge", "Activate passive unit charge", "Collect", "Update total amount remaining", "Set total amount remaining"};
    }
}

