/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.ClockStatus;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ClockBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSClock
extends GXDLMSObject
implements IGXDLMSBase {
    private ClockBase clockBase;
    private int deviation;
    private boolean enabled;
    private GXDateTime end = new GXDateTime();
    private Set<ClockStatus> status;
    private GXDateTime begin = new GXDateTime();
    private int timeZone;
    private GXDateTime time = new GXDateTime();

    public GXDLMSClock() {
        this("0.0.1.0.0.255", 0);
    }

    public GXDLMSClock(String ln) {
        this(ln, 0);
    }

    public GXDLMSClock(String ln, int sn) {
        super(ObjectType.CLOCK, ln, sn);
        this.status = new HashSet<ClockStatus>();
        this.status.add(ClockStatus.OK);
        this.deviation = 0;
        HashSet<DateTimeSkips> value = new HashSet<DateTimeSkips>();
        value.add(DateTimeSkips.MONTH);
        value.add(DateTimeSkips.DAY);
        this.begin.setSkip(value);
        this.end.setSkip(this.begin.getSkip());
        this.clockBase = ClockBase.NONE;
    }

    @Override
    public final DataType getUIDataType(int index) {
        if (index == 2 || index == 5 || index == 6) {
            return DataType.DATETIME;
        }
        return super.getUIDataType(index);
    }

    public final GXDateTime getTime() {
        return this.time;
    }

    public final void setTime(GXDateTime value) {
        this.time = value;
    }

    public final void setTime(Date value) {
        this.time = new GXDateTime(value);
    }

    public final void setTime(Calendar value) {
        this.time = new GXDateTime(value.getTime());
    }

    public final int getTimeZone() {
        return this.timeZone;
    }

    public final void setTimeZone(int value) {
        this.timeZone = value;
    }

    public final Set<ClockStatus> getStatus() {
        return this.status;
    }

    public final void setStatus(Set<ClockStatus> value) {
        this.status = value;
    }

    public final GXDateTime getBegin() {
        return this.begin;
    }

    public final void setBegin(GXDateTime value) {
        this.begin = value;
    }

    public final GXDateTime getEnd() {
        return this.end;
    }

    public final void setEnd(GXDateTime value) {
        this.end = value;
    }

    public final int getDeviation() {
        return this.deviation;
    }

    public final void setDeviation(int value) {
        this.deviation = value;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value) {
        this.enabled = value;
    }

    public final ClockBase getClockBase() {
        return this.clockBase;
    }

    public final void setClockBase(ClockBase value) {
        this.clockBase = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getTime(), this.getTimeZone(), this.getStatus(), this.getBegin(), this.getEnd(), this.getDeviation(), this.getEnabled(), this.getClockBase()};
    }

    public GXDateTime now() {
        Calendar now = Calendar.getInstance();
        GXDateTime tm = new GXDateTime(now);
        if (this.timeZone == -1 || this.timeZone == Short.MIN_VALUE || this.timeZone == 32768) {
            tm.getSkip().add(DateTimeSkips.DEVIATION);
        } else {
            int offset = this.timeZone + now.getTimeZone().getRawOffset() / 60000;
            if (offset != 0) {
                TimeZone tz = GXDateTime.getTimeZone(this.timeZone, this.enabled);
                now = tz != null ? Calendar.getInstance(tz) : Calendar.getInstance();
                tm.setMeterCalendar(now);
            }
        }
        if (!this.enabled && now.getTimeZone().observesDaylightTime()) {
            tm.getStatus().remove((Object)ClockStatus.DAYLIGHT_SAVE_ACTIVE);
            tm.getMeterCalendar().add(12, -this.deviation);
        }
        return tm;
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            GXDateTime dt = this.getTime();
            Calendar tm = Calendar.getInstance();
            tm.setTime(dt.getMeterCalendar().getTime());
            int minutes = tm.get(12);
            if (minutes < 8) {
                minutes = 0;
            } else if (minutes < 23) {
                minutes = 15;
            } else if (minutes < 38) {
                minutes = 30;
            } else if (minutes < 53) {
                minutes = 45;
            } else {
                minutes = 0;
                tm.add(11, 1);
            }
            tm.set(12, minutes);
            tm.set(13, 0);
            tm.set(14, 0);
            dt.setMeterCalendar(tm);
            this.setTime(dt);
        } else if (e.getIndex() == 3) {
            GXDateTime dt = this.getTime();
            Calendar tm = Calendar.getInstance();
            tm.setTime(dt.getMeterCalendar().getTime());
            int s = tm.get(13);
            if (s > 30) {
                tm.add(12, 1);
            }
            tm.set(13, 0);
            tm.set(14, 0);
            dt.setMeterCalendar(tm);
            this.setTime(dt);
        } else if (e.getIndex() == 5) {
            List arr = (List)e.getParameters();
            GXDateTime presetTime = (GXDateTime)GXDLMSClient.changeType((byte[])arr.get(0), DataType.DATETIME, e.getSettings());
            GXDLMSClient.changeType((byte[])arr.get(1), DataType.DATETIME, e.getSettings());
            GXDLMSClient.changeType((byte[])arr.get(2), DataType.DATETIME, e.getSettings());
            this.setTime(presetTime);
        } else if (e.getIndex() == 6) {
            int shift = ((Number)e.getParameters()).intValue();
            GXDateTime dt = this.getTime();
            Calendar tm = Calendar.getInstance();
            tm.setTime(dt.getMeterCalendar().getTime());
            tm.add(13, shift);
            dt.setMeterCalendar(tm);
            this.setTime(dt);
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    public final byte[][] adjustToQuarter(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    public final byte[][] adjustToMeasuringPeriod(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, 0, DataType.INT8);
    }

    public final byte[][] adjustToMinute(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, 0, DataType.INT8);
    }

    public final byte[][] adjustToPresetTime(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 4, 0, DataType.INT8);
    }

    public final byte[][] presetAdjustingTime(GXDLMSClient client, Date presetTime, Date validityIntervalStart, Date validityIntervalEnd) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer buff = new GXByteBuffer(44);
        buff.setUInt8(DataType.STRUCTURE.getValue());
        buff.setUInt8(3);
        GXCommon.setData(null, buff, DataType.OCTET_STRING, presetTime);
        GXCommon.setData(null, buff, DataType.OCTET_STRING, validityIntervalStart);
        GXCommon.setData(null, buff, DataType.OCTET_STRING, validityIntervalEnd);
        return client.method(this, 5, buff.array(), DataType.ARRAY);
    }

    public final byte[][] shiftTime(GXDLMSClient client, int forTime) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (forTime < -900 || forTime > 900) {
            throw new IllegalArgumentException("Invalid shift time.");
        }
        return client.method(this, 6, forTime, DataType.INT16);
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        if (all || !this.isRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        if (all || !this.isRead(9)) {
            attributes.add(9);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 9;
    }

    @Override
    public final int getMethodCount() {
        return 6;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.OCTET_STRING;
            }
            case 3: {
                return DataType.INT16;
            }
            case 4: {
                return DataType.UINT8;
            }
            case 5: {
                return DataType.OCTET_STRING;
            }
            case 6: {
                return DataType.OCTET_STRING;
            }
            case 7: {
                return DataType.INT8;
            }
            case 8: {
                return DataType.BOOLEAN;
            }
            case 9: {
                return DataType.ENUM;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.getTime();
            }
            case 3: {
                return this.getTimeZone();
            }
            case 4: {
                return ClockStatus.toInteger(this.status);
            }
            case 5: {
                return this.getBegin();
            }
            case 6: {
                return this.getEnd();
            }
            case 7: {
                return this.getDeviation();
            }
            case 8: {
                return this.getEnabled();
            }
            case 9: {
                return this.getClockBase().ordinal();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                if (e.getValue() == null) {
                    this.setTime(new GXDateTime());
                    break;
                }
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.setTime(tmp);
                break;
            }
            case 3: {
                if (e.getValue() == null) {
                    this.setTimeZone(0);
                    break;
                }
                this.setTimeZone(((Number)e.getValue()).intValue());
                break;
            }
            case 4: {
                if (e.getValue() == null) {
                    HashSet<ClockStatus> val = new HashSet<ClockStatus>();
                    val.add(ClockStatus.OK);
                    this.setStatus(val);
                    break;
                }
                this.setStatus(ClockStatus.forValue(((Number)e.getValue()).intValue()));
                break;
            }
            case 5: {
                if (e.getValue() == null) {
                    this.setBegin(new GXDateTime());
                    break;
                }
                if (e.getValue() instanceof byte[]) {
                    GXDateTime tmp = (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings());
                    this.setBegin(tmp);
                    break;
                }
                this.setBegin((GXDateTime)e.getValue());
                break;
            }
            case 6: {
                if (e.getValue() == null) {
                    this.setEnd(new GXDateTime());
                    break;
                }
                if (e.getValue() instanceof byte[]) {
                    GXDateTime tmp = (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings());
                    this.setEnd(tmp);
                    break;
                }
                this.setEnd((GXDateTime)e.getValue());
                break;
            }
            case 7: {
                if (e.getValue() == null) {
                    this.setDeviation(0);
                    break;
                }
                this.setDeviation(((Number)e.getValue()).intValue());
                break;
            }
            case 8: {
                if (e.getValue() == null) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled((Boolean)e.getValue());
                break;
            }
            case 9: {
                if (e.getValue() == null) {
                    this.setClockBase(ClockBase.NONE);
                    break;
                }
                this.setClockBase(ClockBase.values()[((Number)e.getValue()).intValue()]);
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.time = reader.readElementContentAsDateTime("Time");
        this.timeZone = reader.readElementContentAsInt("TimeZone");
        this.status = ClockStatus.forValue(reader.readElementContentAsInt("Status"));
        this.begin = reader.readElementContentAsDateTime("Begin");
        this.end = reader.readElementContentAsDateTime("End");
        this.deviation = reader.readElementContentAsInt("Deviation");
        this.enabled = reader.readElementContentAsInt("Enabled") != 0;
        this.clockBase = ClockBase.values()[reader.readElementContentAsInt("ClockBase")];
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Time", this.time);
        writer.writeElementString("TimeZone", this.timeZone);
        writer.writeElementString("Status", ClockStatus.toInteger(this.status));
        writer.writeElementString("Begin", this.begin);
        writer.writeElementString("End", this.end);
        writer.writeElementString("Deviation", this.deviation);
        writer.writeElementString("Enabled", this.enabled);
        writer.writeElementString("ClockBase", this.clockBase.ordinal());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Time", "Time Zone", "Status", "Begin", "End", "Deviation", "Enabled", "Clock Base"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Adjust to quarter", "Adjust to measuring period", "Adjust to minute", "Adjust to preset time", "Preset adjusting time", "Shift time"};
    }
}

