/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXEnum;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt8;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSTcpUdpSetup;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.TransportMode;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSCoAPSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSTcpUdpSetup udpReference;
    private int ackTimeout;
    private int ackRandomFactor;
    private int maxRetransmit;
    private int nStart;
    private int delayAckTimeout;
    private int exponentialBackOff;
    private int probingRate;
    private String coAPUriPath;
    private TransportMode transportMode;
    private Object wrapperVersion;
    private short tokenLength;

    public GXDLMSCoAPSetup() {
        this("0.0.25.16.0.255", 0);
    }

    public GXDLMSCoAPSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSCoAPSetup(String ln, int sn) {
        super(ObjectType.COAP_SETUP, ln, sn);
    }

    public final GXDLMSTcpUdpSetup getUdpReference() {
        return this.udpReference;
    }

    public final void setUdpReference(GXDLMSTcpUdpSetup value) {
        this.udpReference = value;
    }

    public final int getAckTimeout() {
        return this.ackTimeout;
    }

    public final void setAckTimeout(int value) {
        this.ackTimeout = value;
    }

    public final int getAckRandomFactor() {
        return this.ackRandomFactor;
    }

    public final void setAckRandomFactor(int value) {
        this.ackRandomFactor = value;
    }

    public final int getMaxRetransmit() {
        return this.maxRetransmit;
    }

    public final void setMaxRetransmit(int value) {
        this.maxRetransmit = value;
    }

    public final int getNStart() {
        return this.nStart;
    }

    public final void setNStart(int value) {
        this.nStart = value;
    }

    public final int getDelayAckTimeout() {
        return this.delayAckTimeout;
    }

    public final void setDelayAckTimeout(int value) {
        this.delayAckTimeout = value;
    }

    public final int getExponentialBackOff() {
        return this.exponentialBackOff;
    }

    public final void setExponentialBackOff(int value) {
        this.exponentialBackOff = value;
    }

    public final int getProbingRate() {
        return this.probingRate;
    }

    public final void setProbingRate(int value) {
        this.probingRate = value;
    }

    public final String getCoAPUriPath() {
        return this.coAPUriPath;
    }

    public final void setCoAPUriPath(String value) {
        this.coAPUriPath = value;
    }

    public final TransportMode getTransportMode() {
        return this.transportMode;
    }

    public final void setTransportMode(TransportMode value) {
        this.transportMode = value;
    }

    public final Object getWrapperVersion() {
        return this.wrapperVersion;
    }

    public final void setWrapperVersion(Object value) {
        this.wrapperVersion = value;
    }

    public final short getTokenLength() {
        return this.tokenLength;
    }

    public final void setTokenLength(short value) {
        this.tokenLength = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getUdpReference(), this.getAckTimeout(), this.getAckRandomFactor(), this.getMaxRetransmit(), this.getNStart(), this.getDelayAckTimeout(), this.getExponentialBackOff(), this.getProbingRate(), this.getCoAPUriPath(), this.getTransportMode(), this.getWrapperVersion(), this.getTokenLength()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (all || this.canRead(13)) {
            attributes.add(13);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "Value", "UdpReference", "AckTimeout", "AckRandomFactor", "MaxRetransmit", "NStart", "DelayAckTimeout", "ExponentialBackOff", "ProbingRate", "CoAPUriPath", "TransportMode", "WrapperVersion", "TokenLength"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public final int getAttributeCount() {
        return 13;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: 
            case 2: 
            case 10: {
                return DataType.OCTET_STRING;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return DataType.UINT16;
            }
            case 11: {
                return DataType.ENUM;
            }
            case 12: {
                return super.getDataType(index);
            }
            case 13: {
                return DataType.UINT8;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                if (this.getUdpReference() != null) {
                    ret = GXCommon.logicalNameToBytes(this.getUdpReference().getLogicalName());
                    break;
                }
                ret = null;
                break;
            }
            case 3: {
                ret = this.getAckTimeout();
                break;
            }
            case 4: {
                ret = this.getAckRandomFactor();
                break;
            }
            case 5: {
                ret = this.getMaxRetransmit();
                break;
            }
            case 6: {
                ret = this.getNStart();
                break;
            }
            case 7: {
                ret = this.getDelayAckTimeout();
                break;
            }
            case 8: {
                ret = this.getExponentialBackOff();
                break;
            }
            case 9: {
                ret = this.getProbingRate();
                break;
            }
            case 10: {
                ret = this.getCoAPUriPath().getBytes();
                break;
            }
            case 11: {
                ret = this.transportMode.getValue();
                break;
            }
            case 12: {
                ret = this.getWrapperVersion();
                break;
            }
            case 13: {
                ret = this.getTokenLength();
                break;
            }
            default: {
                ret = null;
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.setUdpReference(null);
                String ln = GXCommon.toLogicalName(e.getValue());
                this.setUdpReference((GXDLMSTcpUdpSetup)settings.getObjects().findByLN(ObjectType.TCP_UDP_SETUP, ln));
                if (this.getUdpReference() != null) break;
                this.setUdpReference(new GXDLMSTcpUdpSetup(ln));
                break;
            }
            case 3: {
                this.setAckTimeout(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 4: {
                this.setAckRandomFactor(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 5: {
                this.setMaxRetransmit(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 6: {
                this.setNStart(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 7: {
                this.setDelayAckTimeout(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 8: {
                this.setExponentialBackOff(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 9: {
                this.setProbingRate(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 10: {
                byte[] tmp = (byte[])e.getValue();
                if (tmp != null) {
                    this.setCoAPUriPath(new String(tmp));
                    break;
                }
                this.setCoAPUriPath(null);
                break;
            }
            case 11: {
                this.setTransportMode(TransportMode.forValue(((GXEnum)e.getValue()).shortValue()));
                break;
            }
            case 12: {
                this.setWrapperVersion(e.getValue());
                break;
            }
            case 13: {
                this.setTokenLength(((GXUInt8)e.getValue()).shortValue());
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.setUdpReference(null);
        String ln = reader.readElementContentAsString("UdpReference");
        if (ln != null && ln != "") {
            this.setUdpReference((GXDLMSTcpUdpSetup)reader.getObjects().findByLN(ObjectType.TCP_UDP_SETUP, ln));
            if (this.getUdpReference() == null) {
                this.setUdpReference(new GXDLMSTcpUdpSetup(ln));
            }
        }
        this.setAckTimeout((short)reader.readElementContentAsInt("AckTimeout"));
        this.setAckRandomFactor((short)reader.readElementContentAsInt("AckRandomFactor"));
        this.setMaxRetransmit((short)reader.readElementContentAsInt("MaxRetransmit"));
        this.setNStart((short)reader.readElementContentAsInt("NStart"));
        this.setDelayAckTimeout((short)reader.readElementContentAsInt("DelayAckTimeout"));
        this.setExponentialBackOff((short)reader.readElementContentAsInt("ExponentialBackOff"));
        this.setProbingRate((short)reader.readElementContentAsInt("ProbingRate"));
        this.setCoAPUriPath(reader.readElementContentAsString("CoAPUriPath"));
        this.setTransportMode(TransportMode.forValue(reader.readElementContentAsInt("TransportMode")));
        this.setWrapperVersion(reader.readElementContentAsObject("WrapperVersion", null, this, 12));
        this.setTokenLength((byte)reader.readElementContentAsInt("TokenLength"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.getUdpReference() != null) {
            writer.writeElementString("UdpReference", this.getUdpReference().getLogicalName());
        }
        writer.writeElementString("AckTimeout", this.getAckTimeout());
        writer.writeElementString("AckRandomFactor", this.getAckRandomFactor());
        writer.writeElementString("MaxRetransmit", this.getMaxRetransmit());
        writer.writeElementString("NStart", this.getNStart());
        writer.writeElementString("DelayAckTimeout", this.getDelayAckTimeout());
        writer.writeElementString("ExponentialBackOff", this.getExponentialBackOff());
        writer.writeElementString("ProbingRate", this.getProbingRate());
        writer.writeElementString("CoAPUriPath", this.getCoAPUriPath());
        writer.writeElementString("TransportMode", this.getTransportMode().getValue());
        DataType dt = this.getDataType(2);
        if (this.getWrapperVersion() != null && dt == DataType.NONE) {
            dt = GXDLMSConverter.getDLMSDataType(this.getWrapperVersion());
        }
        writer.writeElementObject("WrapperVersion", this.getWrapperVersion(), dt, this.getUIDataType(2));
        writer.writeElementString("TokenLength", this.getTokenLength());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
        GXDLMSTcpUdpSetup target;
        if (this.getUdpReference() != null && (target = (GXDLMSTcpUdpSetup)reader.getObjects().findByLN(ObjectType.TCP_UDP_SETUP, this.getUdpReference().getLogicalName())) != null && target != this.getUdpReference()) {
            this.setUdpReference(target);
        }
    }
}

