/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ProtectionMode;
import gurux.dlms.objects.enums.ProtectionStatus;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSCommunicationPortProtection
extends GXDLMSObject
implements IGXDLMSBase {
    private ProtectionMode protectionMode = ProtectionMode.LOCKED_ON_FAILED_ATTEMPTS;
    private int allowedFailedAttempts;
    private long initialLockoutTime;
    private byte steepnessFactor = 1;
    private long maxLockoutTime;
    private GXDLMSObject port;
    private ProtectionStatus protectionStatus = ProtectionStatus.UNLOCKED;
    private long failedAttempts;
    private long cumulativeFailedAttempts;

    public GXDLMSCommunicationPortProtection() {
        this("0.0.44.2.0.255", 0);
    }

    public GXDLMSCommunicationPortProtection(String ln) {
        this(ln, 0);
    }

    public GXDLMSCommunicationPortProtection(String ln, int sn) {
        super(ObjectType.COMMUNICATION_PORT_PROTECTION, ln, sn);
    }

    public final ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public final void setProtectionMode(ProtectionMode value) {
        this.protectionMode = value;
    }

    public final int getAllowedFailedAttempts() {
        return this.allowedFailedAttempts;
    }

    public final void setAllowedFailedAttempts(int value) {
        this.allowedFailedAttempts = value;
    }

    public final long getInitialLockoutTime() {
        return this.initialLockoutTime;
    }

    public final void setInitialLockoutTime(long value) {
        this.initialLockoutTime = value;
    }

    public final byte getSteepnessFactor() {
        return this.steepnessFactor;
    }

    public final void setSteepnessFactor(byte value) {
        this.steepnessFactor = value;
    }

    public final long getMaxLockoutTime() {
        return this.maxLockoutTime;
    }

    public final void setMaxLockoutTime(long value) {
        this.maxLockoutTime = value;
    }

    public final GXDLMSObject getPort() {
        return this.port;
    }

    public final void setPort(GXDLMSObject value) {
        this.port = value;
    }

    public final ProtectionStatus getProtectionStatus() {
        return this.protectionStatus;
    }

    public final void setProtectionStatus(ProtectionStatus value) {
        this.protectionStatus = value;
    }

    public final long getFailedAttempts() {
        return this.failedAttempts;
    }

    public final void setFailedAttempts(long value) {
        this.failedAttempts = value;
    }

    public final long getCumulativeFailedAttempts() {
        return this.cumulativeFailedAttempts;
    }

    public final void setCumulativeFailedAttempts(long value) {
        this.cumulativeFailedAttempts = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.protectionMode, this.allowedFailedAttempts, this.initialLockoutTime, this.steepnessFactor, this.maxLockoutTime, this.port, this.protectionStatus, this.failedAttempts, this.cumulativeFailedAttempts};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 10;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        DataType ret;
        switch (index) {
            case 1: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 2: {
                ret = DataType.ENUM;
                break;
            }
            case 3: {
                ret = DataType.UINT16;
                break;
            }
            case 4: {
                ret = DataType.UINT32;
                break;
            }
            case 5: {
                ret = DataType.UINT8;
                break;
            }
            case 6: {
                ret = DataType.UINT32;
                break;
            }
            case 7: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 8: {
                ret = DataType.ENUM;
                break;
            }
            case 9: {
                ret = DataType.UINT32;
                break;
            }
            case 10: {
                ret = DataType.UINT32;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return ret;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.getProtectionMode().ordinal();
                break;
            }
            case 3: {
                ret = this.getAllowedFailedAttempts();
                break;
            }
            case 4: {
                ret = this.getInitialLockoutTime();
                break;
            }
            case 5: {
                ret = this.getSteepnessFactor();
                break;
            }
            case 6: {
                ret = this.getMaxLockoutTime();
                break;
            }
            case 7: {
                if (this.getPort() == null) {
                    ret = GXCommon.logicalNameToBytes("");
                    break;
                }
                ret = GXCommon.logicalNameToBytes(this.port.getLogicalName());
                break;
            }
            case 8: {
                ret = this.getProtectionStatus().ordinal();
                break;
            }
            case 9: {
                ret = this.getFailedAttempts();
                break;
            }
            case 10: {
                ret = this.getCumulativeFailedAttempts();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.protectionMode = ProtectionMode.values()[((Number)e.getValue()).byteValue()];
                break;
            }
            case 3: {
                this.allowedFailedAttempts = ((Number)e.getValue()).intValue();
                break;
            }
            case 4: {
                this.initialLockoutTime = ((Number)e.getValue()).longValue();
                break;
            }
            case 5: {
                this.steepnessFactor = ((Number)e.getValue()).byteValue();
                break;
            }
            case 6: {
                this.maxLockoutTime = ((Number)e.getValue()).longValue();
                break;
            }
            case 7: {
                this.port = settings.getObjects().findByLN(ObjectType.NONE, GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 8: {
                this.protectionStatus = ProtectionStatus.values()[((Number)e.getValue()).intValue()];
                break;
            }
            case 9: {
                this.failedAttempts = ((Number)e.getValue()).longValue();
                break;
            }
            case 10: {
                this.cumulativeFailedAttempts = ((Number)e.getValue()).longValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.protectionMode = ProtectionMode.values()[reader.readElementContentAsInt("ProtectionMode")];
        this.allowedFailedAttempts = reader.readElementContentAsInt("AllowedFailedAttempts");
        this.initialLockoutTime = reader.readElementContentAsLong("InitialLockoutTime");
        this.steepnessFactor = (byte)reader.readElementContentAsInt("SteepnessFactor");
        this.maxLockoutTime = reader.readElementContentAsLong("MaxLockoutTime");
        String str = reader.readElementContentAsString("Port");
        if (str == null || str == "") {
            this.port = null;
        } else {
            this.port = reader.getObjects().findByLN(ObjectType.NONE, str);
            if (this.port == null) {
                this.port = GXDLMSClient.createObject(ObjectType.DATA);
                this.port.setLogicalName(str);
            }
        }
        this.protectionStatus = ProtectionStatus.values()[reader.readElementContentAsInt("ProtectionStatus")];
        this.failedAttempts = reader.readElementContentAsLong("FailedAttempts");
        this.cumulativeFailedAttempts = reader.readElementContentAsLong("CumulativeFailedAttempts");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("ProtectionMode", this.protectionMode.ordinal());
        writer.writeElementString("AllowedFailedAttempts", this.allowedFailedAttempts);
        writer.writeElementString("InitialLockoutTime", this.initialLockoutTime);
        writer.writeElementString("SteepnessFactor", this.steepnessFactor);
        writer.writeElementString("MaxLockoutTime", this.maxLockoutTime);
        if (this.port == null) {
            writer.writeElementString("Port", "");
        } else {
            writer.writeElementString("Port", this.port.getLogicalName());
        }
        writer.writeElementString("ProtectionStatus", this.protectionStatus.ordinal());
        writer.writeElementString("FailedAttempts", this.failedAttempts);
        writer.writeElementString("CumulativeFailedAttempts", this.cumulativeFailedAttempts);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Protection mode", "Allowed failed attempts", "Initial lockout time", "Steepness factor", "Max lockout time", "Port", "Protection status", "Failed attempts", "Cumulative failed attempts"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

