/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXAdjacentCell;
import gurux.dlms.objects.GXDLMSGSMCellInfo;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.GsmCircuitSwitchStatus;
import gurux.dlms.objects.enums.GsmPacketSwitchStatus;
import gurux.dlms.objects.enums.GsmStatus;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSGSMDiagnostic
extends GXDLMSObject
implements IGXDLMSBase {
    private String operator;
    private GsmStatus status;
    private GsmCircuitSwitchStatus circuitSwitchStatus;
    private GsmPacketSwitchStatus packetSwitchStatus;
    private GXDLMSGSMCellInfo cellInfo;
    private List<GXAdjacentCell> adjacentCells;
    private GXDateTime captureTime;

    public GXDLMSGSMDiagnostic() {
        this("0.0.25.6.0.255", 0);
    }

    public GXDLMSGSMDiagnostic(String ln) {
        this(ln, 0);
    }

    public GXDLMSGSMDiagnostic(String ln, int sn) {
        super(ObjectType.GSM_DIAGNOSTIC, ln, sn);
        this.setVersion(1);
        this.cellInfo = new GXDLMSGSMCellInfo();
        this.adjacentCells = new ArrayList<GXAdjacentCell>();
        this.status = GsmStatus.NONE;
        this.circuitSwitchStatus = GsmCircuitSwitchStatus.INACTIVE;
        this.packetSwitchStatus = GsmPacketSwitchStatus.INACTIVE;
    }

    public final String getOperator() {
        return this.operator;
    }

    public final void setOperator(String value) {
        this.operator = value;
    }

    public final GsmStatus getStatus() {
        return this.status;
    }

    public final void setStatus(GsmStatus value) {
        this.status = value;
    }

    public final GsmCircuitSwitchStatus getCircuitSwitchStatus() {
        return this.circuitSwitchStatus;
    }

    public final void setCircuitSwitchStatus(GsmCircuitSwitchStatus value) {
        this.circuitSwitchStatus = value;
    }

    public final GsmPacketSwitchStatus getPacketSwitchStatus() {
        return this.packetSwitchStatus;
    }

    public final void setPacketSwitchStatus(GsmPacketSwitchStatus value) {
        this.packetSwitchStatus = value;
    }

    public final GXDLMSGSMCellInfo getCellInfo() {
        return this.cellInfo;
    }

    public final void setCellInfo(GXDLMSGSMCellInfo value) {
        this.cellInfo = value;
    }

    public final List<GXAdjacentCell> getAdjacentCells() {
        return this.adjacentCells;
    }

    public final GXDateTime getCaptureTime() {
        return this.captureTime;
    }

    public final void setCaptureTime(GXDateTime value) {
        this.captureTime = value;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.operator, this.status, this.circuitSwitchStatus, this.packetSwitchStatus, this.cellInfo, this.adjacentCells, this.captureTime};
    }

    @Override
    public final int getAttributeCount() {
        return 8;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.STRING;
            }
            case 3: {
                return DataType.ENUM;
            }
            case 4: {
                return DataType.ENUM;
            }
            case 5: {
                return DataType.ENUM;
            }
            case 6: {
                return DataType.STRUCTURE;
            }
            case 7: {
                return DataType.ARRAY;
            }
            case 8: {
                return DataType.DATETIME;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                if (this.operator == null) {
                    return null;
                }
                return this.operator.getBytes();
            }
            case 3: {
                if (this.status == null) {
                    return 0;
                }
                return this.status.ordinal();
            }
            case 4: {
                return this.circuitSwitchStatus.ordinal();
            }
            case 5: {
                return this.packetSwitchStatus.ordinal();
            }
            case 6: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.STRUCTURE.getValue());
                if (this.getVersion() == 0) {
                    bb.setUInt8(4);
                    GXCommon.setData(settings, bb, DataType.UINT16, this.cellInfo.getCellId());
                } else {
                    bb.setUInt8(7);
                    GXCommon.setData(settings, bb, DataType.UINT32, this.cellInfo.getCellId());
                }
                GXCommon.setData(settings, bb, DataType.UINT16, this.cellInfo.getLocationId());
                GXCommon.setData(settings, bb, DataType.UINT8, this.cellInfo.getSignalQuality());
                GXCommon.setData(settings, bb, DataType.UINT8, this.cellInfo.getBer());
                if (this.getVersion() > 0) {
                    GXCommon.setData(settings, bb, DataType.UINT16, this.cellInfo.getMobileCountryCode());
                    GXCommon.setData(settings, bb, DataType.UINT16, this.cellInfo.getMobileNetworkCode());
                    GXCommon.setData(settings, bb, DataType.UINT32, this.cellInfo.getChannelNumber());
                }
                return bb.array();
            }
            case 7: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY.getValue());
                if (this.adjacentCells == null) {
                    bb.setUInt8(0);
                } else {
                    bb.setUInt8((byte)this.adjacentCells.size());
                }
                for (GXAdjacentCell it : this.adjacentCells) {
                    bb.setUInt8(DataType.STRUCTURE.getValue());
                    bb.setUInt8(2);
                    GXCommon.setData(settings, bb, this.getVersion() == 0 ? DataType.UINT16 : DataType.UINT32, it.getCellId());
                    GXCommon.setData(settings, bb, DataType.UINT8, it.getSignalQuality());
                }
                return bb.array();
            }
            case 8: {
                return this.captureTime;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                if (e.getValue() instanceof byte[]) {
                    this.operator = new String((byte[])e.getValue());
                    break;
                }
                if (this.operator instanceof String) {
                    this.operator = (String)e.getValue();
                    break;
                }
                if (this.operator == null) {
                    this.operator = null;
                    break;
                }
                e.setError(ErrorCode.READ_WRITE_DENIED);
                break;
            }
            case 3: {
                this.status = GsmStatus.values()[((Number)e.getValue()).intValue()];
                break;
            }
            case 4: {
                this.circuitSwitchStatus = GsmCircuitSwitchStatus.values()[((Number)e.getValue()).intValue()];
                break;
            }
            case 5: {
                this.packetSwitchStatus = GsmPacketSwitchStatus.values()[((Number)e.getValue()).intValue()];
                break;
            }
            case 6: {
                if (e.getValue() == null) break;
                List tmp = (List)e.getValue();
                this.cellInfo.setCellId(((Number)tmp.get(0)).longValue());
                this.cellInfo.setLocationId(((Number)tmp.get(1)).intValue());
                this.cellInfo.setSignalQuality(((Number)tmp.get(2)).intValue());
                this.cellInfo.setBer(((Number)tmp.get(3)).intValue());
                if (this.getVersion() <= 0) break;
                this.cellInfo.setMobileCountryCode(((Number)tmp.get(4)).intValue());
                this.cellInfo.setMobileNetworkCode(((Number)tmp.get(5)).intValue());
                this.cellInfo.setChannelNumber(((Number)tmp.get(6)).intValue());
                break;
            }
            case 7: {
                this.adjacentCells.clear();
                if (e.getValue() == null) break;
                for (Object it : (List)e.getValue()) {
                    List tmp = (List)it;
                    GXAdjacentCell ac = new GXAdjacentCell();
                    ac.setCellId(((Number)tmp.get(0)).longValue());
                    ac.setSignalQuality(((Number)tmp.get(1)).shortValue());
                    this.adjacentCells.add(ac);
                }
                break;
            }
            case 8: {
                if (e.getValue() instanceof byte[]) {
                    this.captureTime = (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings());
                    break;
                }
                this.captureTime = (GXDateTime)e.getValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.operator = reader.readElementContentAsString("Operator");
        this.status = GsmStatus.values()[reader.readElementContentAsInt("Status")];
        this.circuitSwitchStatus = GsmCircuitSwitchStatus.values()[reader.readElementContentAsInt("CircuitSwitchStatus")];
        this.packetSwitchStatus = GsmPacketSwitchStatus.values()[reader.readElementContentAsInt("PacketSwitchStatus")];
        if (reader.isStartElement("CellInfo", true)) {
            this.cellInfo.setCellId(reader.readElementContentAsLong("CellId"));
            this.cellInfo.setLocationId(reader.readElementContentAsInt("LocationId"));
            this.cellInfo.setSignalQuality(reader.readElementContentAsInt("SignalQuality"));
            this.cellInfo.setBer(reader.readElementContentAsInt("Ber"));
            reader.readEndElement("CellInfo");
        }
        this.adjacentCells.clear();
        if (reader.isStartElement("AdjacentCells", true)) {
            while (reader.isStartElement("Item", true)) {
                GXAdjacentCell it = new GXAdjacentCell();
                it.setCellId(reader.readElementContentAsLong("CellId"));
                it.setSignalQuality((short)reader.readElementContentAsInt("SignalQuality"));
                this.adjacentCells.add(it);
            }
            reader.readEndElement("AdjacentCells");
        }
        this.captureTime = reader.readElementContentAsDateTime("CaptureTime");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementObject("Operator", this.operator);
        writer.writeElementString("Status", this.status.ordinal());
        writer.writeElementString("CircuitSwitchStatus", this.circuitSwitchStatus.ordinal());
        writer.writeElementString("PacketSwitchStatus", this.packetSwitchStatus.ordinal());
        if (this.cellInfo != null) {
            writer.writeStartElement("CellInfo");
            writer.writeElementString("CellId", this.cellInfo.getCellId());
            writer.writeElementString("LocationId", this.cellInfo.getLocationId());
            writer.writeElementString("SignalQuality", this.cellInfo.getSignalQuality());
            writer.writeElementString("Ber", this.cellInfo.getBer());
            writer.writeEndElement();
        }
        if (this.adjacentCells != null) {
            writer.writeStartElement("AdjacentCells");
            for (GXAdjacentCell it : this.adjacentCells) {
                writer.writeStartElement("Item");
                writer.writeElementString("CellId", it.getCellId());
                writer.writeElementString("SignalQuality", it.getSignalQuality());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementObject("CaptureTime", this.captureTime);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Operator", "Status", "CircuitSwitchStatus", "PacketSwitchStatus", "CellInfo", "AdjacentCells", "CaptureTime"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

