/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXEnum;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt8;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.MBusDataHeaderType;
import gurux.dlms.objects.enums.MBusDeviceType;
import gurux.dlms.objects.enums.MBusPortCommunicationState;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class GXDLMSMBusPortSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private String profileSelection;
    private MBusPortCommunicationState portCommunicationStatus = MBusPortCommunicationState.NO_ACCESS;
    private MBusDataHeaderType dataHeaderType = MBusDataHeaderType.NONE;
    private short primaryAddress;
    private long identificationNumber;
    private int manufacturerId;
    private short mBusVersion;
    private MBusDeviceType deviceType = MBusDeviceType.OTHER;
    private int maxPduSize;
    private ArrayList<Map.Entry<GXDateTime, GXDateTime>> listeningWindow;

    public GXDLMSMBusPortSetup() {
        this("0.0.24.8.0.255", 0);
    }

    public GXDLMSMBusPortSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSMBusPortSetup(String ln, int sn) {
        super(ObjectType.MBUS_PORT_SETUP, ln, sn);
        this.setListeningWindow(new ArrayList<Map.Entry<GXDateTime, GXDateTime>>());
    }

    public final String getProfileSelection() {
        return this.profileSelection;
    }

    public final void setProfileSelection(String value) {
        this.profileSelection = value;
    }

    public final MBusPortCommunicationState getPortCommunicationStatus() {
        return this.portCommunicationStatus;
    }

    public final void setPortCommunicationStatus(MBusPortCommunicationState value) {
        this.portCommunicationStatus = value;
    }

    public final MBusDataHeaderType getDataHeaderType() {
        return this.dataHeaderType;
    }

    public final void setDataHeaderType(MBusDataHeaderType value) {
        this.dataHeaderType = value;
    }

    public final short getPrimaryAddress() {
        return this.primaryAddress;
    }

    public final void setPrimaryAddress(short value) {
        this.primaryAddress = value;
    }

    public final long getIdentificationNumber() {
        return this.identificationNumber;
    }

    public final void setIdentificationNumber(long value) {
        this.identificationNumber = value;
    }

    public final int getManufacturerId() {
        return this.manufacturerId;
    }

    public final void setManufacturerId(int value) {
        this.manufacturerId = value;
    }

    public final short getMBusVersion() {
        return this.mBusVersion;
    }

    public final void setMBusVersion(short value) {
        this.mBusVersion = value;
    }

    public final MBusDeviceType getDeviceType() {
        return this.deviceType;
    }

    public final void setDeviceType(MBusDeviceType value) {
        this.deviceType = value;
    }

    public final int getMaxPduSize() {
        return this.maxPduSize;
    }

    public final void setMaxPduSize(int value) {
        this.maxPduSize = value;
    }

    public final ArrayList<Map.Entry<GXDateTime, GXDateTime>> getListeningWindow() {
        return this.listeningWindow;
    }

    public final void setListeningWindow(ArrayList<Map.Entry<GXDateTime, GXDateTime>> value) {
        this.listeningWindow = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getProfileSelection(), this.getPortCommunicationStatus(), this.getDataHeaderType(), this.getPrimaryAddress(), this.getIdentificationNumber(), this.getManufacturerId(), this.mBusVersion, this.getDeviceType(), this.getMaxPduSize(), this.getListeningWindow()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || !super.isRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || !super.isRead(5)) {
            attributes.add(5);
        }
        if (all || !super.isRead(6)) {
            attributes.add(6);
        }
        if (all || !super.isRead(7)) {
            attributes.add(7);
        }
        if (all || !super.isRead(8)) {
            attributes.add(8);
        }
        if (all || !super.isRead(9)) {
            attributes.add(9);
        }
        if (all || !super.isRead(10)) {
            attributes.add(10);
        }
        if (all || !super.isRead(11)) {
            attributes.add(11);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "Profile selection", "Port communication status", "Data header type", "Primary address", "Identification number", "Manufacturer Id", "MBus version.", "Device type", "Max PDU size", "Listening window"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public final int getAttributeCount() {
        return 11;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.OCTET_STRING;
            }
            case 3: {
                return DataType.ENUM;
            }
            case 4: {
                return DataType.ENUM;
            }
            case 5: {
                return DataType.UINT8;
            }
            case 6: {
                return DataType.UINT32;
            }
            case 7: {
                return DataType.UINT16;
            }
            case 8: {
                return DataType.UINT8;
            }
            case 9: {
                return DataType.UINT8;
            }
            case 10: {
                return DataType.UINT16;
            }
            case 11: {
                return DataType.ARRAY;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return GXCommon.logicalNameToBytes(this.getProfileSelection());
            }
            case 3: {
                return this.portCommunicationStatus.getValue();
            }
            case 4: {
                return this.dataHeaderType.getValue();
            }
            case 5: {
                return this.getPrimaryAddress();
            }
            case 6: {
                return this.getIdentificationNumber();
            }
            case 7: {
                return this.getManufacturerId();
            }
            case 8: {
                return this.mBusVersion;
            }
            case 9: {
                return this.deviceType.getValue();
            }
            case 10: {
                return this.getMaxPduSize();
            }
            case 11: {
                int cnt = this.getListeningWindow().size();
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                GXCommon.setObjectCount(cnt, data);
                if (cnt != 0) {
                    for (Map.Entry<GXDateTime, GXDateTime> it : this.listeningWindow) {
                        data.setUInt8(DataType.STRUCTURE);
                        data.setUInt8(2);
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getKey());
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getValue());
                    }
                }
                return data.array();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.setProfileSelection(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 3: {
                this.setPortCommunicationStatus(MBusPortCommunicationState.forValue(((GXEnum)e.getValue()).shortValue()));
                break;
            }
            case 4: {
                this.setDataHeaderType(MBusDataHeaderType.forValue(((GXEnum)e.getValue()).shortValue()));
                break;
            }
            case 5: {
                this.setPrimaryAddress(((GXUInt8)e.getValue()).shortValue());
                break;
            }
            case 6: {
                this.setIdentificationNumber(((GXUInt32)e.getValue()).longValue());
                break;
            }
            case 7: {
                this.setManufacturerId(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 8: {
                this.mBusVersion = ((GXUInt8)e.getValue()).shortValue();
                break;
            }
            case 9: {
                this.setDeviceType(MBusDeviceType.forValue(((GXUInt8)e.getValue()).shortValue()));
                break;
            }
            case 10: {
                this.setMaxPduSize(((GXUInt16)e.getValue()).intValue());
                break;
            }
            case 11: {
                this.getListeningWindow().clear();
                if (e.getValue() == null) break;
                for (Object tmp : (Iterable)e.getValue()) {
                    GXStructure item = (GXStructure)tmp;
                    GXDateTime start = (GXDateTime)GXDLMSClient.changeType((byte[])item.get(0), DataType.DATETIME, settings.getUseUtc2NormalTime());
                    GXDateTime end = (GXDateTime)GXDLMSClient.changeType((byte[])item.get(1), DataType.DATETIME, settings.getUseUtc2NormalTime());
                    this.getListeningWindow().add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
                }
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.setProfileSelection(reader.readElementContentAsString("ProfileSelection"));
        this.setPortCommunicationStatus(MBusPortCommunicationState.forValue(reader.readElementContentAsInt("Status")));
        this.setDataHeaderType(MBusDataHeaderType.forValue(reader.readElementContentAsInt("DataHeaderType")));
        this.setPrimaryAddress((short)reader.readElementContentAsInt("PrimaryAddress"));
        this.setIdentificationNumber(reader.readElementContentAsLong("IdentificationNumber"));
        this.setManufacturerId(reader.readElementContentAsInt("ManufacturerId"));
        this.mBusVersion = (short)reader.readElementContentAsInt("Version");
        this.deviceType = MBusDeviceType.forValue(reader.readElementContentAsInt("DeviceType"));
        this.setMaxPduSize(reader.readElementContentAsInt("MaxPduSize"));
        this.listeningWindow.clear();
        if (reader.isStartElement("ListeningWindow", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDateTime start = new GXDateTime(reader.readElementContentAsString("Start"));
                GXDateTime end = new GXDateTime(reader.readElementContentAsString("End"));
                this.listeningWindow.add(new GXSimpleEntry<GXDateTime, GXDateTime>(start, end));
            }
            reader.readEndElement("ListeningWindow");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("ProfileSelection", this.getProfileSelection());
        writer.writeElementString("Status", this.getPortCommunicationStatus().getValue());
        writer.writeElementString("DataHeaderType", this.getDataHeaderType().getValue());
        writer.writeElementString("PrimaryAddress", this.getPrimaryAddress());
        writer.writeElementString("IdentificationNumber", this.getIdentificationNumber());
        writer.writeElementString("ManufacturerId", this.getManufacturerId());
        writer.writeElementString("Version", this.mBusVersion);
        writer.writeElementString("DeviceType", this.deviceType.getValue());
        writer.writeElementString("MaxPduSize", this.maxPduSize);
        writer.writeStartElement("ListeningWindow");
        if (this.listeningWindow != null) {
            for (Map.Entry<GXDateTime, GXDateTime> it : this.listeningWindow) {
                writer.writeStartElement("Item");
                writer.writeElementString("Start", new GXDateTime(it.getKey()));
                writer.writeElementString("End", new GXDateTime(it.getValue()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

