/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSActionSet;
import gurux.dlms.objects.GXDLMSMonitoredValue;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSRegisterMonitor
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSActionSet[] actions;
    private GXDLMSMonitoredValue monitoredValue;
    private Object[] thresholds;

    public GXDLMSRegisterMonitor() {
        this(null, 0);
    }

    public GXDLMSRegisterMonitor(String ln) {
        this(ln, 0);
    }

    public GXDLMSRegisterMonitor(String ln, int sn) {
        super(ObjectType.REGISTER_MONITOR, ln, sn);
        this.setThresholds(new Object[0]);
        this.setMonitoredValue(new GXDLMSMonitoredValue());
        this.setActions(new GXDLMSActionSet[0]);
    }

    public final Object[] getThresholds() {
        return this.thresholds;
    }

    public final void setThresholds(Object[] value) {
        this.thresholds = value;
    }

    public final GXDLMSMonitoredValue getMonitoredValue() {
        return this.monitoredValue;
    }

    final void setMonitoredValue(GXDLMSMonitoredValue value) {
        this.monitoredValue = value;
    }

    public final GXDLMSActionSet[] getActions() {
        return this.actions;
    }

    public final void setActions(GXDLMSActionSet[] value) {
        this.actions = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getThresholds(), this.getMonitoredValue(), this.getActions()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return super.getDataType(index);
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getThresholds();
        }
        if (e.getIndex() == 3) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.STRUCTURE.getValue());
            bb.setUInt8(3);
            GXCommon.setData(settings, bb, DataType.UINT16, this.monitoredValue.getObjectType().getValue());
            GXCommon.setData(settings, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(this.monitoredValue.getLogicalName()));
            GXCommon.setData(settings, bb, DataType.INT8, this.monitoredValue.getAttributeIndex());
            return bb.array();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(DataType.ARRAY.getValue());
            if (this.actions == null) {
                bb.setUInt8(0);
            } else {
                bb.setUInt8(this.actions.length);
                for (GXDLMSActionSet it : this.actions) {
                    bb.setUInt8((byte)DataType.STRUCTURE.getValue());
                    bb.setUInt8(2);
                    bb.setUInt8((byte)DataType.STRUCTURE.getValue());
                    bb.setUInt8(2);
                    GXCommon.setData(settings, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getActionUp().getLogicalName()));
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getActionUp().getScriptSelector());
                    bb.setUInt8((byte)DataType.STRUCTURE.getValue());
                    bb.setUInt8(2);
                    GXCommon.setData(settings, bb, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getActionDown().getLogicalName()));
                    GXCommon.setData(settings, bb, DataType.UINT16, it.getActionDown().getScriptSelector());
                }
            }
            return bb.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() == null) {
                this.setThresholds(null);
            } else {
                this.setThresholds(((List)e.getValue()).toArray());
            }
        } else if (e.getIndex() == 3) {
            if (this.getMonitoredValue() == null) {
                this.setMonitoredValue(new GXDLMSMonitoredValue());
            }
            this.getMonitoredValue().setObjectType(ObjectType.forValue(((Number)((List)e.getValue()).get(0)).intValue()));
            this.getMonitoredValue().setLogicalName(GXCommon.toLogicalName(((List)e.getValue()).get(1)));
            this.getMonitoredValue().setAttributeIndex(((Number)((List)e.getValue()).get(2)).intValue());
        } else if (e.getIndex() == 4) {
            this.setActions(new GXDLMSActionSet[0]);
            if (e.getValue() != null) {
                ArrayList<GXDLMSActionSet> items = new ArrayList<GXDLMSActionSet>();
                for (Object as : (List)e.getValue()) {
                    GXDLMSActionSet set = new GXDLMSActionSet();
                    List target = (List)((List)as).get(0);
                    set.getActionUp().setLogicalName(GXCommon.toLogicalName(target.get(0)));
                    set.getActionUp().setScriptSelector(((Number)target.get(1)).intValue());
                    target = (List)((List)as).get(1);
                    set.getActionDown().setLogicalName(GXCommon.toLogicalName(target.get(0)));
                    set.getActionDown().setScriptSelector(((Number)target.get(1)).intValue());
                    items.add(set);
                }
                this.setActions(items.toArray(new GXDLMSActionSet[items.size()]));
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (reader.isStartElement("Thresholds", true)) {
            while (reader.isStartElement("Value", false)) {
                Object it = reader.readElementContentAsObject("Value", null, null, 0);
                tmp.add(it);
            }
            reader.readEndElement("Thresholds");
        }
        this.thresholds = tmp.toArray(new Object[tmp.size()]);
        if (reader.isStartElement("MonitoredValue", true)) {
            this.monitoredValue.setObjectType(ObjectType.forValue(reader.readElementContentAsInt("ObjectType")));
            this.monitoredValue.setLogicalName(reader.readElementContentAsString("LN"));
            this.monitoredValue.setAttributeIndex(reader.readElementContentAsInt("Index"));
            reader.readEndElement("MonitoredValue");
        }
        ArrayList<GXDLMSActionSet> list = new ArrayList<GXDLMSActionSet>();
        if (reader.isStartElement("Actions", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSActionSet it = new GXDLMSActionSet();
                list.add(it);
                if (reader.isStartElement("Up", true)) {
                    it.getActionUp().setLogicalName(reader.readElementContentAsString("LN", null));
                    it.getActionUp().setScriptSelector(reader.readElementContentAsInt("Selector"));
                    reader.readEndElement("Up");
                }
                if (!reader.isStartElement("Down", true)) continue;
                it.getActionUp().setLogicalName(reader.readElementContentAsString("LN", null));
                it.getActionUp().setScriptSelector(reader.readElementContentAsInt("Selector"));
                reader.readEndElement("Down");
            }
            reader.readEndElement("Actions");
        }
        this.actions = list.toArray(new GXDLMSActionSet[list.size()]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.thresholds != null) {
            writer.writeStartElement("Thresholds");
            for (Object object : this.thresholds) {
                writer.writeElementObject("Value", object);
            }
            writer.writeEndElement();
        }
        if (this.monitoredValue != null) {
            writer.writeStartElement("MonitoredValue");
            writer.writeElementString("ObjectType", this.monitoredValue.getObjectType().getValue());
            writer.writeElementString("LN", this.monitoredValue.getLogicalName());
            writer.writeElementString("Index", this.monitoredValue.getAttributeIndex());
            writer.writeEndElement();
        }
        if (this.actions != null) {
            writer.writeStartElement("Actions");
            for (GXDLMSActionSet gXDLMSActionSet : this.actions) {
                writer.writeStartElement("Item");
                writer.writeStartElement("Up");
                writer.writeElementString("LN", gXDLMSActionSet.getActionUp().getLogicalName());
                writer.writeElementString("Selector", gXDLMSActionSet.getActionUp().getScriptSelector());
                writer.writeEndElement();
                writer.writeStartElement("Down");
                writer.writeElementString("LN", gXDLMSActionSet.getActionDown().getLogicalName());
                writer.writeElementString("Selector", gXDLMSActionSet.getActionDown().getScriptSelector());
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Thresholds", "Monitored Value", "Actions"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

