/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSCoAPException;
import gurux.dlms.GXDLMSConfirmedServiceError;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSExceptionResponse;
import gurux.dlms.GXDLMSLNCommandHandler;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXFCS16;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXReplyData;
import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt8;
import gurux.dlms.HdlcControlFrame;
import gurux.dlms.HdlcFrameType;
import gurux.dlms.MBusCommand;
import gurux.dlms.MBusControlInfo;
import gurux.dlms.MBusEncryptionMode;
import gurux.dlms.MBusMeterType;
import gurux.dlms.ServiceError;
import gurux.dlms.TranslatorSimpleTags;
import gurux.dlms.TranslatorStandardTags;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Integer;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.asn.enums.Ecc;
import gurux.dlms.ecdsa.GXEcdsa;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.ConfirmedServiceError;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.CryptoKeyType;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.ExceptionStateError;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.RequestTypes;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.Signing;
import gurux.dlms.enums.Standard;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.internal.CoAPClass;
import gurux.dlms.internal.CoAPClientError;
import gurux.dlms.internal.CoAPContentType;
import gurux.dlms.internal.CoAPMethod;
import gurux.dlms.internal.CoAPOptionType;
import gurux.dlms.internal.CoAPServerError;
import gurux.dlms.internal.CoAPSignaling;
import gurux.dlms.internal.CoAPSuccess;
import gurux.dlms.internal.CoAPType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSAccount;
import gurux.dlms.objects.GXDLMSActionSchedule;
import gurux.dlms.objects.GXDLMSActivityCalendar;
import gurux.dlms.objects.GXDLMSArbitrator;
import gurux.dlms.objects.GXDLMSArrayManager;
import gurux.dlms.objects.GXDLMSAssociationLogicalName;
import gurux.dlms.objects.GXDLMSAssociationShortName;
import gurux.dlms.objects.GXDLMSAutoAnswer;
import gurux.dlms.objects.GXDLMSAutoConnect;
import gurux.dlms.objects.GXDLMSCharge;
import gurux.dlms.objects.GXDLMSClock;
import gurux.dlms.objects.GXDLMSCoAPDiagnostic;
import gurux.dlms.objects.GXDLMSCoAPSetup;
import gurux.dlms.objects.GXDLMSCommunicationPortProtection;
import gurux.dlms.objects.GXDLMSCompactData;
import gurux.dlms.objects.GXDLMSCredit;
import gurux.dlms.objects.GXDLMSData;
import gurux.dlms.objects.GXDLMSDemandRegister;
import gurux.dlms.objects.GXDLMSDisconnectControl;
import gurux.dlms.objects.GXDLMSExtendedRegister;
import gurux.dlms.objects.GXDLMSFunctionControl;
import gurux.dlms.objects.GXDLMSG3Plc6LoWPan;
import gurux.dlms.objects.GXDLMSG3PlcMacLayerCounters;
import gurux.dlms.objects.GXDLMSG3PlcMacSetup;
import gurux.dlms.objects.GXDLMSGSMDiagnostic;
import gurux.dlms.objects.GXDLMSGprsSetup;
import gurux.dlms.objects.GXDLMSHdlcSetup;
import gurux.dlms.objects.GXDLMSIECLocalPortSetup;
import gurux.dlms.objects.GXDLMSIec6205541Attributes;
import gurux.dlms.objects.GXDLMSIec8802LlcType1Setup;
import gurux.dlms.objects.GXDLMSIec8802LlcType2Setup;
import gurux.dlms.objects.GXDLMSIec8802LlcType3Setup;
import gurux.dlms.objects.GXDLMSIecTwistedPairSetup;
import gurux.dlms.objects.GXDLMSImageTransfer;
import gurux.dlms.objects.GXDLMSIp4Setup;
import gurux.dlms.objects.GXDLMSIp6Setup;
import gurux.dlms.objects.GXDLMSLimiter;
import gurux.dlms.objects.GXDLMSLlcSscsSetup;
import gurux.dlms.objects.GXDLMSLteMonitoring;
import gurux.dlms.objects.GXDLMSMBusClient;
import gurux.dlms.objects.GXDLMSMBusDiagnostic;
import gurux.dlms.objects.GXDLMSMBusMasterPortSetup;
import gurux.dlms.objects.GXDLMSMBusPortSetup;
import gurux.dlms.objects.GXDLMSMBusSlavePortSetup;
import gurux.dlms.objects.GXDLMSMacAddressSetup;
import gurux.dlms.objects.GXDLMSModemConfiguration;
import gurux.dlms.objects.GXDLMSNtpSetup;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSParameterMonitor;
import gurux.dlms.objects.GXDLMSPppSetup;
import gurux.dlms.objects.GXDLMSPrimeNbOfdmPlcApplicationsIdentification;
import gurux.dlms.objects.GXDLMSPrimeNbOfdmPlcMacCounters;
import gurux.dlms.objects.GXDLMSPrimeNbOfdmPlcMacFunctionalParameters;
import gurux.dlms.objects.GXDLMSPrimeNbOfdmPlcMacNetworkAdministrationData;
import gurux.dlms.objects.GXDLMSPrimeNbOfdmPlcMacSetup;
import gurux.dlms.objects.GXDLMSPrimeNbOfdmPlcPhysicalLayerCounters;
import gurux.dlms.objects.GXDLMSProfileGeneric;
import gurux.dlms.objects.GXDLMSPushSetup;
import gurux.dlms.objects.GXDLMSRegister;
import gurux.dlms.objects.GXDLMSRegisterActivation;
import gurux.dlms.objects.GXDLMSRegisterMonitor;
import gurux.dlms.objects.GXDLMSSFSKActiveInitiator;
import gurux.dlms.objects.GXDLMSSFSKMacCounters;
import gurux.dlms.objects.GXDLMSSFSKMacSynchronizationTimeouts;
import gurux.dlms.objects.GXDLMSSFSKPhyMacSetUp;
import gurux.dlms.objects.GXDLMSSFSKReportingSystemList;
import gurux.dlms.objects.GXDLMSSapAssignment;
import gurux.dlms.objects.GXDLMSSchedule;
import gurux.dlms.objects.GXDLMSScriptTable;
import gurux.dlms.objects.GXDLMSSecuritySetup;
import gurux.dlms.objects.GXDLMSSpecialDaysTable;
import gurux.dlms.objects.GXDLMSTcpUdpSetup;
import gurux.dlms.objects.GXDLMSTokenGateway;
import gurux.dlms.objects.GXDLMSUtilityTables;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.plc.enums.PlcDataLinkData;
import gurux.dlms.plc.enums.PlcDestinationAddress;
import gurux.dlms.plc.enums.PlcHdlcSourceAddress;
import gurux.dlms.plc.enums.PlcSourceAddress;
import gurux.dlms.secure.AesGcmParameter;
import gurux.dlms.secure.GXCiphering;
import gurux.dlms.secure.GXSecure;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;

abstract class GXDLMS {
    static final byte HDLC_FRAME_START_END = 126;
    static final byte CIPHERING_HEADER_SIZE = 22;
    static final int DATA_TYPE_OFFSET = 0xFF0000;

    static boolean useHdlc(InterfaceType type) {
        return type == InterfaceType.HDLC || type == InterfaceType.HDLC_WITH_MODE_E || type == InterfaceType.PLC_HDLC;
    }

    private GXDLMS() {
    }

    static byte getInvokeIDPriority(GXDLMSSettings settings, boolean increase) {
        byte value = 0;
        if (settings.getPriority() == Priority.HIGH) {
            value = (byte)(value | 0x80);
        }
        if (settings.getServiceClass() == ServiceClass.CONFIRMED) {
            value = (byte)(value | 0x40);
        }
        if (increase) {
            settings.setInvokeID(settings.getInvokeID() + 1 & 0xF);
        }
        value = (byte)(value | settings.getInvokeID());
        return value;
    }

    private static long getLongInvokeIDPriority(GXDLMSSettings settings) {
        long value = 0L;
        if (settings.getPriority() == Priority.HIGH) {
            value = Integer.MIN_VALUE;
        }
        if (settings.getServiceClass() == ServiceClass.CONFIRMED) {
            value |= 0x40000000L;
        }
        settings.setLongInvokeID(settings.getLongInvokeID() + 1L);
        return value |= (long)((int)(settings.getLongInvokeID() & 0xFFFFFFL));
    }

    static GXDLMSObject createObject(GXDLMSSettings settings, ObjectType type, int classID, int version) {
        if (type == null || type == ObjectType.NONE) {
            GXDLMSObject obj = null;
            if (settings != null && settings.getCustomObjectNotifier() != null) {
                obj = settings.getCustomObjectNotifier().onObjectCreate(classID, version);
            }
            if (obj == null) {
                obj = new GXDLMSObject();
            }
            return obj;
        }
        switch (type) {
            case ACTION_SCHEDULE: {
                return new GXDLMSActionSchedule();
            }
            case ACTIVITY_CALENDAR: {
                return new GXDLMSActivityCalendar();
            }
            case ASSOCIATION_LOGICAL_NAME: {
                return new GXDLMSAssociationLogicalName();
            }
            case ASSOCIATION_SHORT_NAME: {
                return new GXDLMSAssociationShortName();
            }
            case AUTO_ANSWER: {
                return new GXDLMSAutoAnswer();
            }
            case AUTO_CONNECT: {
                return new GXDLMSAutoConnect();
            }
            case CLOCK: {
                return new GXDLMSClock();
            }
            case DATA: {
                return new GXDLMSData();
            }
            case DEMAND_REGISTER: {
                return new GXDLMSDemandRegister();
            }
            case MAC_ADDRESS_SETUP: {
                return new GXDLMSMacAddressSetup();
            }
            case EXTENDED_REGISTER: {
                return new GXDLMSExtendedRegister();
            }
            case GPRS_SETUP: {
                return new GXDLMSGprsSetup();
            }
            case IEC_HDLC_SETUP: {
                return new GXDLMSHdlcSetup();
            }
            case IEC_LOCAL_PORT_SETUP: {
                return new GXDLMSIECLocalPortSetup();
            }
            case IEC_TWISTED_PAIR_SETUP: {
                return new GXDLMSIecTwistedPairSetup();
            }
            case IP4_SETUP: {
                return new GXDLMSIp4Setup();
            }
            case IP6_SETUP: {
                return new GXDLMSIp6Setup();
            }
            case MBUS_SLAVE_PORT_SETUP: {
                return new GXDLMSMBusSlavePortSetup();
            }
            case IMAGE_TRANSFER: {
                return new GXDLMSImageTransfer();
            }
            case SECURITY_SETUP: {
                return new GXDLMSSecuritySetup();
            }
            case DISCONNECT_CONTROL: {
                return new GXDLMSDisconnectControl();
            }
            case LIMITER: {
                return new GXDLMSLimiter();
            }
            case MBUS_CLIENT: {
                return new GXDLMSMBusClient();
            }
            case MODEM_CONFIGURATION: {
                return new GXDLMSModemConfiguration();
            }
            case PPP_SETUP: {
                return new GXDLMSPppSetup();
            }
            case PROFILE_GENERIC: {
                return new GXDLMSProfileGeneric();
            }
            case REGISTER: {
                return new GXDLMSRegister();
            }
            case REGISTER_ACTIVATION: {
                return new GXDLMSRegisterActivation();
            }
            case REGISTER_MONITOR: {
                return new GXDLMSRegisterMonitor();
            }
            case REGISTER_TABLE: {
                return new GXDLMSObject();
            }
            case ZIG_BEE_SAS_STARTUP: {
                return new GXDLMSObject();
            }
            case ZIG_BEE_SAS_JOIN: {
                return new GXDLMSObject();
            }
            case SAP_ASSIGNMENT: {
                return new GXDLMSSapAssignment();
            }
            case SCHEDULE: {
                return new GXDLMSSchedule();
            }
            case SCRIPT_TABLE: {
                return new GXDLMSScriptTable();
            }
            case SPECIAL_DAYS_TABLE: {
                return new GXDLMSSpecialDaysTable();
            }
            case STATUS_MAPPING: {
                return new GXDLMSObject();
            }
            case TCP_UDP_SETUP: {
                return new GXDLMSTcpUdpSetup();
            }
            case ZIG_BEE_SAS_APS_FRAGMENTATION: {
                return new GXDLMSObject();
            }
            case UTILITY_TABLES: {
                return new GXDLMSUtilityTables();
            }
            case PUSH_SETUP: {
                return new GXDLMSPushSetup();
            }
            case MBUS_MASTER_PORT_SETUP: {
                return new GXDLMSMBusMasterPortSetup();
            }
            case GSM_DIAGNOSTIC: {
                return new GXDLMSGSMDiagnostic();
            }
            case ACCOUNT: {
                return new GXDLMSAccount();
            }
            case CREDIT: {
                return new GXDLMSCredit();
            }
            case CHARGE: {
                return new GXDLMSCharge();
            }
            case TOKEN_GATEWAY: {
                return new GXDLMSTokenGateway();
            }
            case PARAMETER_MONITOR: {
                return new GXDLMSParameterMonitor();
            }
            case COMPACT_DATA: {
                return new GXDLMSCompactData();
            }
            case LLC_SSCS_SETUP: {
                return new GXDLMSLlcSscsSetup();
            }
            case PRIME_NB_OFDM_PLC_PHYSICAL_LAYER_COUNTERS: {
                return new GXDLMSPrimeNbOfdmPlcPhysicalLayerCounters();
            }
            case PRIME_NB_OFDM_PLC_MAC_SETUP: {
                return new GXDLMSPrimeNbOfdmPlcMacSetup();
            }
            case PRIME_NB_OFDM_PLC_MAC_FUNCTIONAL_PARAMETERS: {
                return new GXDLMSPrimeNbOfdmPlcMacFunctionalParameters();
            }
            case PRIME_NB_OFDM_PLC_MAC_COUNTERS: {
                return new GXDLMSPrimeNbOfdmPlcMacCounters();
            }
            case PRIME_NB_OFDM_PLC_MAC_NETWORK_ADMINISTRATION_DATA: {
                return new GXDLMSPrimeNbOfdmPlcMacNetworkAdministrationData();
            }
            case PRIME_NB_OFDM_PLC_APPLICATIONS_IDENTIFICATION: {
                return new GXDLMSPrimeNbOfdmPlcApplicationsIdentification();
            }
            case IEC_8802_LLC_TYPE1_SETUP: {
                return new GXDLMSIec8802LlcType1Setup();
            }
            case IEC_8802_LLC_TYPE2_SETUP: {
                return new GXDLMSIec8802LlcType2Setup();
            }
            case IEC_8802_LLC_TYPE3_SETUP: {
                return new GXDLMSIec8802LlcType3Setup();
            }
            case SFSK_REPORTING_SYSTEM_LIST: {
                return new GXDLMSSFSKReportingSystemList();
            }
            case ARBITRATOR: {
                return new GXDLMSArbitrator();
            }
            case SFSK_MAC_COUNTERS: {
                return new GXDLMSSFSKMacCounters();
            }
            case SFSK_MAC_SYNCHRONIZATION_TIMEOUTS: {
                return new GXDLMSSFSKMacSynchronizationTimeouts();
            }
            case SFSK_ACTIVE_INITIATOR: {
                return new GXDLMSSFSKActiveInitiator();
            }
            case SFSK_PHY_MAC_SETUP: {
                return new GXDLMSSFSKPhyMacSetUp();
            }
            case NTP_SETUP: {
                return new GXDLMSNtpSetup();
            }
            case COMMUNICATION_PORT_PROTECTION: {
                return new GXDLMSCommunicationPortProtection();
            }
            case G3_PLC_MAC_LAYER_COUNTERS: {
                return new GXDLMSG3PlcMacLayerCounters();
            }
            case G3_PLC6_LO_WPAN: {
                return new GXDLMSG3Plc6LoWPan();
            }
            case G3_PLC_MAC_SETUP: {
                return new GXDLMSG3PlcMacSetup();
            }
            case ARRAY_MANAGER: {
                return new GXDLMSArrayManager();
            }
            case LTE_MONITORING: {
                return new GXDLMSLteMonitoring();
            }
            case FUNCTION_CONTROL: {
                return new GXDLMSFunctionControl();
            }
            case COAP_SETUP: {
                return new GXDLMSCoAPSetup();
            }
            case COAP_DIAGNOSTIC: {
                return new GXDLMSCoAPDiagnostic();
            }
            case MBUS_PORT_SETUP: {
                return new GXDLMSMBusPortSetup();
            }
            case MBUS_DIAGNOSTIC: {
                return new GXDLMSMBusDiagnostic();
            }
            case IEC_6205541_ATTRIBUTES: {
                return new GXDLMSIec6205541Attributes();
            }
        }
        return new GXDLMSObject();
    }

    public static byte[] receiverReady(GXDLMSSettings settings, RequestTypes type) {
        HashSet<RequestTypes> tmp = new HashSet<RequestTypes>();
        tmp.add(type);
        try {
            return GXDLMS.receiverReady(settings, tmp);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] receiverReady(GXDLMSSettings settings, Set<RequestTypes> type) {
        GXReplyData reply = new GXReplyData();
        reply.getMoreData().addAll(type);
        reply.setWindowSize(settings.getGbtWindowSize());
        reply.setBlockNumberAck(settings.getBlockNumberAck());
        reply.setBlockNumber(settings.getBlockIndex());
        try {
            return GXDLMS.receiverReady(settings, reply);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] receiverReady(GXDLMSSettings settings, GXReplyData reply) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> data;
        if (reply.getMoreData().isEmpty()) {
            byte id = settings.getKeepAlive();
            if (settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
                return GXDLMS.getMacHdlcFrame(settings, id, 0, null);
            }
            return GXDLMS.getHdlcFrame(settings, id, null);
        }
        if (reply.getMoreData().contains((Object)RequestTypes.FRAME)) {
            byte id = settings.getReceiverReady();
            if (settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
                return GXDLMS.getMacHdlcFrame(settings, id, 0, null);
            }
            if (settings.getInterfaceType() == InterfaceType.COAP) {
                return GXDLMS.getCoAPFrame(settings, 192, null, 0);
            }
            return GXDLMS.getHdlcFrame(settings, id, null);
        }
        int cmd = settings.getCommand();
        if (reply.getMoreData().contains((Object)RequestTypes.GBT)) {
            GXDLMSLNParameters p = new GXDLMSLNParameters(settings, 0L, 224, 0, null, null, 255, 0);
            p.setWindowSize(reply.getWindowSize());
            p.setBlockNumberAck(reply.getBlockNumber());
            p.setBlockIndex(settings.getBlockIndex());
            data = GXDLMS.getLnMessages(p);
        } else {
            GXByteBuffer bb = new GXByteBuffer(4);
            if (settings.getUseLogicalNameReferencing()) {
                bb.setUInt32(settings.getBlockIndex());
            } else {
                bb.setUInt16(settings.getBlockIndex());
            }
            settings.increaseBlockIndex();
            if (settings.getUseLogicalNameReferencing()) {
                GXDLMSLNParameters p = new GXDLMSLNParameters(settings, 0L, cmd, 2, bb, null, 255, 0);
                data = GXDLMS.getLnMessages(p);
            } else {
                GXDLMSSNParameters p = new GXDLMSSNParameters(settings, cmd, 1, 5, bb, null);
                data = GXDLMS.getSnMessages(p);
            }
        }
        return data.get(0);
    }

    static String getDescription(int errCode) {
        String str;
        ErrorCode errorCode = ErrorCode.forValue(errCode);
        if (errorCode != null) {
            switch (errorCode) {
                case REJECTED: {
                    str = "Rejected";
                    break;
                }
                case OK: {
                    str = "";
                    break;
                }
                case HARDWARE_FAULT: {
                    str = "Access Error : Device reports a hardware fault.";
                    break;
                }
                case TEMPORARY_FAILURE: {
                    str = "Access Error : Device reports a temporary failure.";
                    break;
                }
                case READ_WRITE_DENIED: {
                    str = "Access Error : Device reports Read-Write denied.";
                    break;
                }
                case UNDEFINED_OBJECT: {
                    str = "Access Error : Device reports a undefined object.";
                    break;
                }
                case INCONSISTENT_CLASS: {
                    str = "Access Error : Device reports a inconsistent Class or object.";
                    break;
                }
                case UNAVAILABLE_OBJECT: {
                    str = "Access Error : Device reports a unavailable object.";
                    break;
                }
                case UNMATCHED_TYPE: {
                    str = "Access Error : Device reports a unmatched type.";
                    break;
                }
                case ACCESS_VIOLATED: {
                    str = "Access Error : Device reports scope of access violated.";
                    break;
                }
                case DATA_BLOCK_UNAVAILABLE: {
                    str = "Access Error : Data Block Unavailable.";
                    break;
                }
                case LONG_GET_OR_READ_ABORTED: {
                    str = "Access Error : Long Get Or Read Aborted.";
                    break;
                }
                case NO_LONG_GET_OR_READ_IN_PROGRESS: {
                    str = "Access Error : No Long Get Or Read In Progress.";
                    break;
                }
                case LONG_SET_OR_WRITE_ABORTED: {
                    str = "Access Error : Long Set Or Write Aborted.";
                    break;
                }
                case NO_LONG_SET_OR_WRITE_IN_PROGRESS: {
                    str = "Access Error : No Long Set Or Write In Progress.";
                    break;
                }
                case DATA_BLOCK_NUMBER_INVALID: {
                    str = "Access Error : Data Block Number Invalid.";
                    break;
                }
                case OTHER_REASON: {
                    str = "Access Error : Other Reason.";
                    break;
                }
                default: {
                    str = "Access Error : Unknown error.";
                    break;
                }
            }
        } else {
            str = "Access Error : Invalid error code " + String.valueOf(errCode);
        }
        return str;
    }

    static void checkInit(GXDLMSSettings settings) {
        if (settings.getClientAddress() == 0) {
            throw new IllegalArgumentException("Invalid Client Address.");
        }
        if (settings.getServerAddress() == 0) {
            throw new IllegalArgumentException("Invalid Server Address.");
        }
    }

    static void appendData(GXDLMSObject obj, int index, GXByteBuffer bb, Object value) {
        DataType ui;
        DataType tp = obj.getDataType(index);
        if (tp == DataType.ARRAY) {
            if (value instanceof byte[] && tp != DataType.OCTET_STRING) {
                bb.set((byte[])value);
                return;
            }
        } else if (tp == DataType.NONE) {
            tp = GXDLMSConverter.getDLMSDataType(value);
            if (tp == DataType.DATETIME) {
                tp = DataType.OCTET_STRING;
            }
        } else if (value instanceof String && tp == DataType.OCTET_STRING && (ui = obj.getUIDataType(index)) == DataType.STRING) {
            GXCommon.setData(null, bb, tp, ((String)value).getBytes());
            return;
        }
        GXCommon.setData(null, bb, tp, value);
    }

    private static int getGloMessage(int command) {
        int cmd;
        switch (command) {
            case 5: {
                cmd = 37;
                break;
            }
            case 192: {
                cmd = 200;
                break;
            }
            case 6: {
                cmd = 38;
                break;
            }
            case 193: {
                cmd = 201;
                break;
            }
            case 195: {
                cmd = 203;
                break;
            }
            case 12: {
                cmd = 44;
                break;
            }
            case 196: {
                cmd = 204;
                break;
            }
            case 13: {
                cmd = 45;
                break;
            }
            case 197: {
                cmd = 205;
                break;
            }
            case 199: {
                cmd = 207;
                break;
            }
            case 15: {
                cmd = 219;
                break;
            }
            case 98: {
                cmd = 98;
                break;
            }
            case 99: {
                cmd = 99;
                break;
            }
            default: {
                throw new GXDLMSException("Invalid GLO command.");
            }
        }
        return cmd;
    }

    private static int getDedMessage(int command) {
        int cmd;
        switch (command) {
            case 192: {
                cmd = 208;
                break;
            }
            case 193: {
                cmd = 209;
                break;
            }
            case 195: {
                cmd = 211;
                break;
            }
            case 196: {
                cmd = 212;
                break;
            }
            case 197: {
                cmd = 213;
                break;
            }
            case 199: {
                cmd = 215;
                break;
            }
            case 15: {
                cmd = 220;
                break;
            }
            case 98: {
                cmd = 98;
                break;
            }
            case 99: {
                cmd = 99;
                break;
            }
            default: {
                throw new GXDLMSException("Invalid DED command.");
            }
        }
        return cmd;
    }

    static void addLLCBytes(GXDLMSSettings settings, GXByteBuffer data) {
        byte[] tmp = data.array();
        data.clear();
        if (settings.isServer()) {
            data.set(GXCommon.LLC_REPLY_BYTES);
        } else {
            data.set(GXCommon.LLC_SEND_BYTES);
        }
        data.set(tmp);
    }

    static void multipleBlocks(GXDLMSLNParameters p, GXByteBuffer reply, boolean ciphering) {
        int len = 0;
        if (p.getData() != null) {
            len = p.getData().size() - p.getData().position();
        }
        if (p.getAttributeDescriptor() != null) {
            len += p.getAttributeDescriptor().size();
        }
        if (ciphering) {
            len += 22;
        }
        if ((Conformance.toInteger(p.getSettings().getNegotiatedConformance()) & Conformance.GENERAL_PROTECTION.getValue()) != 0) {
            len += 9;
        }
        len += GXDLMS.getSigningSize(p);
        if (!p.isMultipleBlocks()) {
            p.setMultipleBlocks(2 + reply.size() + len > p.getSettings().getMaxPduSize());
        }
        if (p.isMultipleBlocks()) {
            p.setLastBlock(8 + reply.size() + len <= p.getSettings().getMaxPduSize());
        }
        if (p.isLastBlock()) {
            p.setLastBlock(8 + reply.size() + len <= p.getSettings().getMaxPduSize());
        }
    }

    private static byte getSigningSize(GXDLMSLNParameters p) {
        int size = 0;
        if (p.getSettings().getCipher() != null && p.getSettings().getCipher().getSigning() == Signing.GENERAL_SIGNING) {
            if (p.getSettings().getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                size = 65;
            } else if (p.getSettings().getCipher().getSecuritySuite() == SecuritySuite.SUITE_2) {
                size = 99;
            }
        }
        return (byte)size;
    }

    public static void getLNPdu(GXDLMSLNParameters p, GXByteBuffer reply) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        boolean ciphering = p.getCommand() != 96 && p.getCommand() != 97 && (p.getSettings().isCiphered(true) || p.cipheredCommand != 0);
        int len = 0;
        if (p.getCommand() == 96) {
            if (p.getSettings().getGateway() != null && p.getSettings().getGateway().getPhysicalDeviceAddress() != null) {
                reply.setUInt8(230);
                reply.setUInt8(p.getSettings().getGateway().getNetworkId());
                reply.setUInt8(p.getSettings().getGateway().getPhysicalDeviceAddress().length);
                reply.set(p.getSettings().getGateway().getPhysicalDeviceAddress());
            }
            reply.set(p.getAttributeDescriptor());
        } else {
            boolean sign;
            if (p.getCommand() != 224) {
                reply.setUInt8(p.getCommand());
            }
            if (p.getCommand() == 194 || p.getCommand() == 15 || p.getCommand() == 217 || p.getCommand() == 218) {
                if (p.getCommand() != 194) {
                    if (p.getInvokeId() != 0L) {
                        reply.setUInt32(p.getInvokeId());
                    } else {
                        reply.setUInt32(GXDLMS.getLongInvokeIDPriority(p.getSettings()));
                    }
                }
                if (p.getTime() == null) {
                    reply.setUInt8(DataType.NONE.getValue());
                } else {
                    int pos = reply.size();
                    GXCommon.setData(null, reply, DataType.OCTET_STRING, p.getTime());
                    if (p.getCommand() != 194) {
                        reply.move(pos + 1, pos, reply.size() - pos - 1);
                    }
                }
                GXDLMS.multipleBlocks(p, reply, ciphering);
            } else if (p.getCommand() != 98) {
                if (p.getCommand() != 192 && p.getData() != null && p.getData().size() != 0) {
                    GXDLMS.multipleBlocks(p, reply, ciphering);
                }
                if (p.getCommand() == 193) {
                    if (p.isMultipleBlocks() && !p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER)) {
                        if (p.getRequestType() == 1) {
                            p.setRequestType(2);
                        } else if (p.getRequestType() == 2) {
                            p.setRequestType(3);
                        }
                    }
                } else if (p.getCommand() == 195) {
                    if (p.isMultipleBlocks() && !p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER)) {
                        if (p.getRequestType() == 1) {
                            p.getAttributeDescriptor().size(p.getAttributeDescriptor().size() - 1);
                            p.setRequestType(4);
                        } else if (p.getRequestType() == 4) {
                            p.setRequestType(6);
                        }
                    }
                } else if (p.getCommand() == 199) {
                    if (p.isMultipleBlocks() && !p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER)) {
                        if (p.getRequestType() == 1) {
                            p.getData().position(2 + p.getData().position());
                            p.setRequestType(2);
                            p.setStatus(255);
                        } else if (p.getRequestType() == 2) {
                            p.setRequestType(4);
                        }
                    }
                } else if (p.getCommand() == 196 && p.isMultipleBlocks() && !p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER) && p.getRequestType() == 1) {
                    p.setRequestType(2);
                }
                if (p.getCommand() != 224) {
                    reply.setUInt8(p.getRequestType());
                    if (p.getInvokeId() != 0L) {
                        reply.setUInt8((byte)p.getInvokeId());
                    } else {
                        reply.setUInt8(GXDLMS.getInvokeIDPriority(p.getSettings(), p.getSettings().getAutoIncreaseInvokeID()));
                    }
                }
            }
            reply.set(p.getAttributeDescriptor());
            if (p.isMultipleBlocks() && !p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER)) {
                if (p.command != 197 && p.command != 199) {
                    if (p.isLastBlock()) {
                        reply.setUInt8(1);
                        p.getSettings().setCount(0L);
                        p.getSettings().setIndex(0L);
                    } else {
                        reply.setUInt8(0);
                    }
                }
                reply.setUInt32(p.getBlockIndex());
                p.setBlockIndex(p.getBlockIndex() + 1);
                if (p.getStatus() != 255) {
                    if (p.getStatus() != 0 && p.getCommand() == 196) {
                        reply.setUInt8(1);
                    }
                    reply.setUInt8(p.getStatus());
                }
                len = p.getData() != null ? p.getData().size() - p.getData().position() : 0;
                int totalLength = len + reply.size();
                if (ciphering) {
                    totalLength += 22;
                }
                if (totalLength > p.getSettings().getMaxPduSize()) {
                    len = p.getSettings().getMaxPduSize() - reply.size();
                    if (ciphering) {
                        len -= 22;
                    }
                    len -= GXCommon.getObjectCountSizeInBytes(len);
                }
                if (len != 0 || p.command != 199 || p.getRequestType() != 4) {
                    GXCommon.setObjectCount(len, reply);
                    reply.set(p.getData(), len);
                }
            }
            if (len == 0) {
                if (p.getStatus() != 255 && p.getCommand() != 224) {
                    if (p.getStatus() != 0 && p.getCommand() == 196) {
                        reply.setUInt8(1);
                    }
                    reply.setUInt8(p.getStatus());
                }
                if (p.getData() != null && p.getData().size() != 0) {
                    len = p.getData().size() - p.getData().position();
                    if (p.getSettings().getGateway() != null && p.getSettings().getGateway().getPhysicalDeviceAddress() != null) {
                        if (3 + len + p.getSettings().getGateway().getPhysicalDeviceAddress().length > p.getSettings().getMaxPduSize()) {
                            len -= 3 + p.getSettings().getGateway().getPhysicalDeviceAddress().length;
                        }
                        GXByteBuffer tmp = new GXByteBuffer(reply);
                        reply.size(0);
                        reply.setUInt8(230);
                        reply.setUInt8(p.getSettings().getGateway().getNetworkId());
                        reply.setUInt8(p.getSettings().getGateway().getPhysicalDeviceAddress().length);
                        reply.set(p.getSettings().getGateway().getPhysicalDeviceAddress());
                        reply.set(tmp);
                    }
                    if (p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER)) {
                        if (7 + len + reply.size() > p.getSettings().getMaxPduSize()) {
                            len = p.getSettings().getMaxPduSize() - reply.size() - 7;
                        }
                        if (ciphering && p.command != 224) {
                            reply.set(p.getData());
                            sign = GXDLMS.shoudSign(p);
                            byte[] tmp = (p.getSettings().getConnected() & 2) == 0 || !sign ? GXDLMS.cipher0(p, reply.array()) : GXDLMS.cipher1(p, reply.array(), sign);
                            p.getData().size(0);
                            p.getData().set(tmp);
                            reply.size(0);
                            len = p.getData().size();
                            if (7 + len > p.getSettings().getMaxPduSize()) {
                                len = p.getSettings().getMaxPduSize() - 7;
                            }
                            if (len + GXDLMS.getSigningSize(p) > p.getSettings().getMaxPduSize()) {
                                len -= GXDLMS.getSigningSize(p);
                            }
                            ciphering = false;
                        }
                    } else if (p.getCommand() != 192 && len + reply.size() > p.getSettings().getMaxPduSize()) {
                        len = p.getSettings().getMaxPduSize() - reply.size();
                        len -= GXDLMS.getSigningSize(p);
                    }
                    reply.set(p.getData(), len);
                } else if (!(p.getSettings().getGateway() == null || p.getSettings().getGateway().getPhysicalDeviceAddress() == null || p.getCommand() == 224 || p.isMultipleBlocks() && p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER))) {
                    if (3 + len + p.getSettings().getGateway().getPhysicalDeviceAddress().length > p.getSettings().getMaxPduSize()) {
                        len -= 3 + p.getSettings().getGateway().getPhysicalDeviceAddress().length;
                    }
                    GXByteBuffer tmp = new GXByteBuffer(reply);
                    reply.size(0);
                    reply.setUInt8(230);
                    reply.setUInt8(p.getSettings().getGateway().getNetworkId());
                    reply.setUInt8(p.getSettings().getGateway().getPhysicalDeviceAddress().length);
                    reply.set(p.getSettings().getGateway().getPhysicalDeviceAddress());
                    reply.set(tmp);
                }
            }
            if (!(!ciphering || reply.size() == 0 || p.getCommand() == 98 || p.isMultipleBlocks() && p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER))) {
                sign = GXDLMS.shoudSign(p);
                byte[] tmp = (p.getSettings().getConnected() & 2) == 0 || !sign ? GXDLMS.cipher0(p, reply.array()) : GXDLMS.cipher1(p, reply.array(), sign);
                reply.size(0);
                reply.set(tmp);
            }
        }
        if (p.getCommand() == 224 || p.isMultipleBlocks() && p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER)) {
            GXByteBuffer bb = new GXByteBuffer();
            bb.set(reply);
            reply.clear();
            reply.setUInt8(224);
            int value = 0;
            if (p.isLastBlock()) {
                value = 128;
            } else if (p.streaming) {
                value |= 0x40;
            }
            reply.setUInt8(value |= p.windowSize);
            reply.setUInt16(p.getBlockIndex());
            ++p.blockIndex;
            if (p.getCommand() != 15 && p.blockNumberAck != 0) {
                reply.setUInt16(p.blockNumberAck);
                ++p.blockNumberAck;
            } else {
                p.blockNumberAck = -1;
                reply.setUInt16(0);
            }
            GXCommon.setObjectCount(bb.size(), reply);
            reply.set(bb);
            if (p.getCommand() != 224) {
                p.command = 224;
                ++p.blockNumberAck;
            }
            if (p.getSettings().getGateway() != null && p.getSettings().getGateway().getPhysicalDeviceAddress() != null) {
                if (3 + len + p.getSettings().getGateway().getPhysicalDeviceAddress().length > p.getSettings().getMaxPduSize()) {
                    // empty if block
                }
                GXByteBuffer tmp = new GXByteBuffer(reply);
                reply.size(0);
                reply.setUInt8(230);
                reply.setUInt8(p.getSettings().getGateway().getNetworkId());
                reply.setUInt8(p.getSettings().getGateway().getPhysicalDeviceAddress().length);
                reply.set(p.getSettings().getGateway().getPhysicalDeviceAddress());
                reply.set(tmp);
            }
        }
        if (GXDLMS.useHdlc(p.getSettings().getInterfaceType())) {
            GXDLMS.addLLCBytes(p.getSettings(), reply);
        }
    }

    private static boolean shoudSign(GXDLMSLNParameters p) {
        boolean signing;
        boolean bl = signing = p.getSettings().getCipher().getSigning() == Signing.GENERAL_SIGNING;
        if (!signing) {
            signing = p.getSettings().isServer() ? (p.accessMode & AccessMode3.DIGITALLY_SIGNED_RESPONSE.getValue()) != 0 : (p.accessMode & AccessMode3.DIGITALLY_SIGNED_REQUEST.getValue()) != 0;
        }
        return signing;
    }

    static AesGcmParameter getCipheringParameters(GXDLMSLNParameters p) {
        byte[] key;
        int cmd;
        GXICipher cipher = p.getSettings().getCipher();
        if (p.cipheredCommand == 0) {
            if (!((p.getSettings().getConnected() & 2) != 0 && (Conformance.toInteger(p.getSettings().getNegotiatedConformance()) & Conformance.GENERAL_PROTECTION.getValue()) != 0 || p.getSettings().getPreEstablishedSystemTitle() != null && p.getSettings().getPreEstablishedSystemTitle().length != 0 && (Conformance.toInteger(p.getSettings().getProposedConformance()) & Conformance.GENERAL_PROTECTION.getValue()) != 0)) {
                if (cipher.getDedicatedKey() != null && (p.getSettings().getConnected() & 2) != 0) {
                    cmd = GXDLMS.getDedMessage(p.getCommand());
                    key = cipher.getDedicatedKey();
                } else {
                    cmd = GXDLMS.getGloMessage(p.getCommand());
                    key = GXDLMS.getBlockCipherKey(p.getSettings());
                }
            } else if (p.getSettings().getCipher().getDedicatedKey() != null) {
                cmd = 220;
                key = cipher.getDedicatedKey();
            } else {
                cmd = 220;
                key = GXDLMS.getBlockCipherKey(p.getSettings());
            }
        } else if (p.cipheredCommand == 220) {
            cmd = -36;
            key = cipher.getDedicatedKey();
        } else if (p.cipheredCommand == 219) {
            cmd = 219;
            key = GXDLMS.getBlockCipherKey(p.getSettings());
        } else if (p.getSettings().getCipher().getDedicatedKey() == null || GXDLMS.isGloMessage(p.cipheredCommand)) {
            cmd = GXDLMS.getGloMessage(p.command);
            key = GXDLMS.getBlockCipherKey(p.getSettings());
        } else {
            cmd = GXDLMS.getDedMessage(p.command);
            key = cipher.getDedicatedKey();
        }
        AesGcmParameter s = new AesGcmParameter(p.getSettings(), cmd, cipher.getSecurity(), cipher.getSecuritySuite(), cipher.getInvocationCounter(), cipher.getSystemTitle(), key, GXDLMS.getAuthenticationKey(p.getSettings()));
        s.setIgnoreSystemTitle(p.getSettings().getStandard() == Standard.ITALY);
        s.setRecipientSystemTitle(p.getSettings().getSourceSystemTitle());
        return s;
    }

    private static byte[] cipher1(GXDLMSLNParameters p, byte[] data, boolean sign) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        byte[] tmp;
        AesGcmParameter s;
        int keyDataLen;
        String algID;
        String alg;
        int keyid;
        if (!sign && p.getSettings().getCipher().getSigning() == Signing.GENERAL_SIGNING) {
            sign = true;
        }
        switch (p.getSettings().getCipher().getSigning()) {
            case ONE_PASS_DIFFIE_HELLMAN: {
                keyid = 1;
                break;
            }
            case STATIC_UNIFIED_MODEL: {
                keyid = 2;
                break;
            }
            default: {
                keyid = 0;
            }
        }
        int sc = 0;
        GXICipher c = p.getSettings().getCipher();
        if (p.getSettings().getSourceSystemTitle() == null && p.getSettings().getPreEstablishedSystemTitle() == null) {
            throw new IllegalArgumentException("Invalid Recipient System Title.");
        }
        if (c.getSystemTitle() == null) {
            throw new IllegalArgumentException("Invalid System Title.");
        }
        Security security = c.getSecurity();
        switch (security) {
            case AUTHENTICATION: {
                sc = 16;
                break;
            }
            case AUTHENTICATION_ENCRYPTION: {
                sc = 48;
                break;
            }
            case ENCRYPTION: {
                sc = 32;
                break;
            }
            default: {
                if (c.getSigning() == Signing.GENERAL_SIGNING) break;
                throw new IllegalArgumentException("Invalid security.");
            }
        }
        switch (c.getSecuritySuite()) {
            case SUITE_1: {
                sc = (byte)(sc | 1);
                alg = "SHA-256";
                algID = "60857405080300";
                keyDataLen = 256;
                break;
            }
            case SUITE_2: {
                sc = (byte)(sc | 2);
                alg = "SHA-384";
                algID = "60857405080301";
                keyDataLen = 384;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid security suite.");
            }
        }
        GXByteBuffer tmp2 = new GXByteBuffer();
        byte[] z = null;
        PrivateKey key = null;
        PublicKey pub = null;
        if (!sign) {
            byte[] ret = GXCommon.crypt(p.getSettings(), CertificateType.KEY_AGREEMENT, data, true, CryptoKeyType.ECDSA, 0, c.getSecurity(), c.getSecuritySuite(), c.getInvocationCounter());
            if (ret != null) {
                p.getSettings().getCipher().setInvocationCounter(1L + p.getSettings().getCipher().getInvocationCounter());
                return ret;
            }
            if (c.getKeyAgreementKeyPair() != null) {
                key = c.getKeyAgreementKeyPair().getPrivate();
                pub = c.getKeyAgreementKeyPair().getPublic();
            }
            if (key == null) {
                key = (PrivateKey)p.getSettings().getKey(CertificateType.KEY_AGREEMENT, c.getSystemTitle(), true);
                c.setKeyAgreementKeyPair(new KeyPair(pub, key));
            }
            if (pub == null) {
                pub = (PublicKey)p.getSettings().getKey(CertificateType.KEY_AGREEMENT, p.getSettings().getSourceSystemTitle(), false);
                c.setKeyAgreementKeyPair(new KeyPair(pub, key));
            }
            if (keyid == 1) {
                KeyPair kp = GXEcdsa.generateKeyPair(Ecc.P256);
                c.setEphemeralKeyPair(kp);
                KeyAgreement ka = KeyAgreement.getInstance("ECDH");
                ka.init(kp.getPrivate());
                ka.doPhase(c.getKeyAgreementKeyPair().getPublic(), true);
                z = ka.generateSecret();
                Logger.getLogger(GXSecure.class.getName()).log(Level.FINEST, "Private ephemeral{0}", GXCommon.toHex(GXAsn1Converter.rawValue(kp.getPrivate()), true));
                Logger.getLogger(GXSecure.class.getName()).log(Level.FINEST, "Public ephemeral: {0}", GXCommon.toHex(GXAsn1Converter.rawValue(kp.getPublic()), true));
                Logger.getLogger(GXSecure.class.getName()).log(Level.FINEST, "Public agreement key: {0}", GXCommon.toHex(GXAsn1Converter.rawValue(c.getKeyAgreementKeyPair().getPublic()), true));
            } else if (keyid == 2) {
                Logger.getLogger(GXSecure.class.getName()).log(Level.FINEST, "Private agreement key {0}", GXCommon.toHex(GXAsn1Converter.rawValue(key), true));
                Logger.getLogger(GXSecure.class.getName()).log(Level.FINEST, "Public ephemeral key: {0}", GXCommon.toHex(GXAsn1Converter.rawValue(pub), true));
                KeyAgreement ka = KeyAgreement.getInstance("ECDH");
                ka.init(c.getKeyAgreementKeyPair().getPrivate());
                ka.doPhase(c.getKeyAgreementKeyPair().getPublic(), true);
                z = ka.generateSecret();
                if (c.getTransactionId() == null) {
                    tmp2.setUInt8(0);
                } else {
                    tmp2.setUInt8(c.getTransactionId().length);
                    tmp2.set(c.getTransactionId());
                }
            }
        } else {
            if (c.getSigningKeyPair() != null) {
                key = c.getSigningKeyPair().getPrivate();
                pub = c.getSigningKeyPair().getPublic();
            }
            if (key == null) {
                key = (PrivateKey)p.getSettings().getKey(CertificateType.DIGITAL_SIGNATURE, p.getSettings().getCipher().getSystemTitle(), true);
                c.setSigningKeyPair(new KeyPair(pub, key));
            }
            if (pub == null) {
                pub = (PublicKey)p.getSettings().getKey(CertificateType.DIGITAL_SIGNATURE, p.getSettings().getSourceSystemTitle(), false);
                c.setSigningKeyPair(new KeyPair(pub, key));
            }
            Logger.getLogger(GXDLMS.class.getName()).log(Level.FINEST, "Private signing key: {0}" + GXCommon.toHex(key.getEncoded()));
            Logger.getLogger(GXDLMS.class.getName()).log(Level.FINEST, "Public signing key: {0}" + GXCommon.toHex(pub.getEncoded()));
        }
        tmp2.set(p.getSettings().getSourceSystemTitle());
        if (z != null) {
            Logger.getLogger(GXSecure.class.getName()).log(Level.FINEST, "Shared secret {0}", GXCommon.toHex(z));
        }
        if (sign) {
            s = GXDLMS.getCipheringParameters(p);
        } else {
            GXByteBuffer kdf = new GXByteBuffer();
            kdf.set(GXSecure.generateKDF(alg, z, keyDataLen, GXCommon.hexToBytes(algID), c.getSystemTitle(), tmp2.array(), null, null));
            Logger.getLogger(GXDLMS.class.getName()).log(Level.FINEST, "kdf: {0}", kdf);
            s = new AesGcmParameter(49, p.getSettings(), security, c.getSecuritySuite(), 0L, kdf.subArray(0, 16), c.getAuthenticationKey(), c.getSystemTitle(), p.getSettings().getSourceSystemTitle(), null, null);
        }
        GXByteBuffer reply = new GXByteBuffer();
        if (sign) {
            reply.setUInt8(223);
        } else {
            reply.setUInt8(221);
        }
        if (c.getTransactionId() == null) {
            GXCommon.setObjectCount(0, reply);
        } else {
            GXCommon.setObjectCount(c.getTransactionId().length, reply);
            reply.set(c.getTransactionId());
        }
        GXCommon.setObjectCount(s.getSystemTitle().length, reply);
        reply.set(s.getSystemTitle());
        GXCommon.setObjectCount(s.getRecipientSystemTitle().length, reply);
        reply.set(s.getRecipientSystemTitle());
        reply.setUInt8(0);
        reply.setUInt8(0);
        if (!sign) {
            reply.setUInt8(1);
            reply.setUInt8(2);
            reply.setUInt8(1);
            reply.setUInt8(keyid);
        }
        if (keyid == 1) {
            try {
                if (c.getSigningKeyPair() != null) {
                    key = c.getSigningKeyPair().getPrivate();
                    pub = c.getSigningKeyPair().getPublic();
                } else {
                    key = null;
                    pub = null;
                }
                if (key == null) {
                    key = (PrivateKey)p.getSettings().getKey(CertificateType.DIGITAL_SIGNATURE, p.getSettings().getCipher().getSystemTitle(), true);
                    c.setSigningKeyPair(new KeyPair(pub, key));
                }
                if (pub == null) {
                    pub = (PublicKey)p.getSettings().getKey(CertificateType.DIGITAL_SIGNATURE, p.getSettings().getSourceSystemTitle(), false);
                    c.setSigningKeyPair(new KeyPair(pub, key));
                }
                GXCommon.setObjectCount(128, reply);
                tmp = GXAsn1Converter.rawValue(c.getEphemeralKeyPair().getPublic());
                reply.set(tmp);
                reply.set(GXSecure.getEphemeralPublicKeySignature(keyid, c.getEphemeralKeyPair().getPublic(), c.getSigningKeyPair().getPrivate()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if (!sign) {
            reply.setUInt8(0);
        }
        s.setType(3);
        tmp = GXCiphering.encrypt(s, data);
        GXByteBuffer signedData = new GXByteBuffer();
        signedData.set(reply.getData(), 1, reply.size() - 1);
        if (c.getSecurity() != Security.NONE) {
            if (sign) {
                GXCommon.setObjectCount(6 + GXCommon.getObjectCountSizeInBytes(5 + tmp.length) + tmp.length, reply);
                if (p.getSettings().getCipher().getDedicatedKey() == null) {
                    reply.setUInt8(GXDLMS.getGloMessage(p.command));
                    signedData.setUInt8(GXDLMS.getGloMessage(p.command));
                } else {
                    reply.setUInt8(GXDLMS.getDedMessage(p.command));
                    signedData.setUInt8(GXDLMS.getDedMessage(p.command));
                }
            }
            GXCommon.setObjectCount(5 + tmp.length, reply);
            GXCommon.setObjectCount(5 + tmp.length, signedData);
            reply.setUInt8(sc);
            signedData.setUInt8(sc);
            reply.setUInt32(p.getSettings().getCipher().getInvocationCounter());
            signedData.setUInt32(p.getSettings().getCipher().getInvocationCounter());
        } else if (!sign) {
            GXCommon.setObjectCount(tmp.length, reply);
        }
        p.getSettings().getCipher().setInvocationCounter(1L + p.getSettings().getCipher().getInvocationCounter());
        reply.set(tmp);
        signedData.set(tmp);
        if (sign) {
            Signature sig;
            if (p.getSettings().getCipher().getSecuritySuite() == SecuritySuite.SUITE_1) {
                sig = Signature.getInstance("SHA256withECDSA");
            } else if (p.getSettings().getCipher().getSecuritySuite() == SecuritySuite.SUITE_2) {
                sig = Signature.getInstance("SHA384withECDSA");
            } else {
                throw new IllegalArgumentException("Invalid security suite.");
            }
            if (c.getSigningKeyPair() == null) {
                throw new IllegalArgumentException("SigningKeyPair is empty.");
            }
            sig.initSign(key);
            sig.update(signedData.array());
            GXAsn1Sequence seq = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(sig.sign());
            GXByteBuffer bb = new GXByteBuffer();
            bb.set(((GXAsn1Integer)seq.get(0)).getByteArray());
            if (bb.size() != 32) {
                bb.move(1, 0, 32);
            }
            bb.set(((GXAsn1Integer)seq.get(1)).getByteArray());
            if (bb.size() != 64) {
                bb.move(33, 32, 32);
            }
            byte[] signature = bb.array();
            GXCommon.setObjectCount(signature.length, reply);
            reply.set(signature);
        }
        return reply.array();
    }

    static boolean isGloMessage(int cmd) {
        return cmd == 200 || cmd == 201 || cmd == 203;
    }

    private static byte[] getBlockCipherKey(GXDLMSSettings settings) {
        if (settings.getEphemeralBlockCipherKey() != null) {
            return settings.getEphemeralBlockCipherKey();
        }
        return settings.getCipher().getBlockCipherKey();
    }

    private static byte[] getAuthenticationKey(GXDLMSSettings settings) {
        if (settings.getEphemeralAuthenticationKey() != null) {
            return settings.getEphemeralAuthenticationKey();
        }
        return settings.getCipher().getAuthenticationKey();
    }

    static byte[] cipher0(GXDLMSLNParameters p, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] key;
        int cmd;
        GXICipher cipher = p.getSettings().getCipher();
        if (p.getCipheredCommand() == 0) {
            if (!((p.getSettings().getConnected() & 2) != 0 && p.getSettings().getNegotiatedConformance().contains((Object)Conformance.GENERAL_PROTECTION) || p.getSettings().getPreEstablishedSystemTitle() != null && p.getSettings().getPreEstablishedSystemTitle().length != 0 && p.getSettings().getProposedConformance().contains((Object)Conformance.GENERAL_PROTECTION))) {
                if (cipher.getDedicatedKey() != null && (p.getSettings().getConnected() & 2) != 0) {
                    cmd = GXDLMS.getDedMessage(p.command);
                    key = cipher.getDedicatedKey();
                } else {
                    cmd = GXDLMS.getGloMessage(p.getCommand());
                    key = GXDLMS.getBlockCipherKey(p.getSettings());
                }
            } else if (cipher.getDedicatedKey() != null) {
                cmd = 220;
                key = cipher.getDedicatedKey();
            } else {
                cmd = 219;
                key = GXDLMS.getBlockCipherKey(p.getSettings());
            }
        } else if (p.getCipheredCommand() == 220) {
            cmd = 220;
            key = cipher.getDedicatedKey();
        } else if (p.getCipheredCommand() == 219) {
            cmd = 219;
            key = GXDLMS.getBlockCipherKey(p.getSettings());
        } else if (GXDLMS.isGloMessage(p.getCipheredCommand())) {
            cmd = GXDLMS.getGloMessage(p.command);
            key = GXDLMS.getBlockCipherKey(p.getSettings());
        } else {
            cmd = GXDLMS.getDedMessage(p.command);
            key = cipher.getDedicatedKey();
        }
        switch (cipher.getSecurity()) {
            case AUTHENTICATION: {
                CryptoKeyType keyType = CryptoKeyType.AUTHENTICATION;
                break;
            }
            case ENCRYPTION: {
                CryptoKeyType keyType = CryptoKeyType.BLOCK_CIPHER;
                break;
            }
            case AUTHENTICATION_ENCRYPTION: {
                CryptoKeyType keyType = CryptoKeyType.forValue(CryptoKeyType.AUTHENTICATION.getValue() | CryptoKeyType.BLOCK_CIPHER.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Security");
            }
        }
        AesGcmParameter s = new AesGcmParameter(p.getSettings(), cmd, cipher.getSecurity(), cipher.getSecuritySuite(), cipher.getInvocationCounter(), cipher.getSystemTitle(), key, GXDLMS.getAuthenticationKey(p.getSettings()));
        byte[] tmp = GXCiphering.encrypt(s, data);
        cipher.setInvocationCounter(1L + cipher.getInvocationCounter());
        return tmp;
    }

    public static List<byte[]> getLnMessages(GXDLMSLNParameters p) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer reply = new GXByteBuffer();
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        int frame = 0;
        if (p.getCommand() == 15 || p.getCommand() == 194) {
            frame = 19;
        }
        do {
            GXDLMS.getLNPdu(p, reply);
            p.setLastBlock(true);
            if (p.getAttributeDescriptor() == null) {
                p.getSettings().increaseBlockIndex();
            }
            block10: while (reply.position() != reply.size()) {
                switch (p.getSettings().getInterfaceType()) {
                    case WRAPPER: {
                        messages.add(GXDLMS.getWrapperFrame(p.getSettings(), p.getCommand(), reply));
                        continue block10;
                    }
                    case HDLC: 
                    case HDLC_WITH_MODE_E: {
                        messages.add(GXDLMS.getHdlcFrame(p.getSettings(), frame, reply));
                        if (reply.position() == reply.size()) continue block10;
                        frame = p.getSettings().getNextSend(false);
                        continue block10;
                    }
                    case PDU: {
                        messages.add(reply.array());
                        reply.position(reply.size());
                        continue block10;
                    }
                    case PLC: {
                        messages.add(GXDLMS.getPlcFrame(p.getSettings(), (byte)-112, reply));
                        continue block10;
                    }
                    case PLC_HDLC: {
                        messages.add(GXDLMS.getMacHdlcFrame(p.getSettings(), frame, 0, reply));
                        continue block10;
                    }
                    case SMS: {
                        messages.add(GXDLMS.getSMSFrame(p.getSettings(), p.command, reply));
                        continue block10;
                    }
                    case COAP: {
                        messages.add(GXDLMS.getCoAPFrame(p.getSettings(), p.command, reply, 0));
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("InterfaceType");
            }
            reply.clear();
            frame = 0;
        } while (p.getData() != null && p.getData().position() != p.getData().size());
        return messages;
    }

    public static List<byte[]> getSnMessages(GXDLMSSNParameters p) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer reply = new GXByteBuffer();
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        int frame = 0;
        if (p.getCommand() == 24 || p.getCommand() == 15) {
            frame = 19;
        }
        do {
            GXDLMS.getSNPdu(p, reply);
            while (reply.position() != reply.size()) {
                if (p.getSettings().getInterfaceType() == InterfaceType.WRAPPER) {
                    messages.add(GXDLMS.getWrapperFrame(p.getSettings(), p.getCommand(), reply));
                    continue;
                }
                if (p.getSettings().getInterfaceType() == InterfaceType.HDLC || p.getSettings().getInterfaceType() == InterfaceType.HDLC_WITH_MODE_E) {
                    messages.add(GXDLMS.getHdlcFrame(p.getSettings(), frame, reply));
                    if (reply.position() == reply.size()) continue;
                    frame = p.getSettings().getNextSend(false);
                    continue;
                }
                if (p.getSettings().getInterfaceType() == InterfaceType.PDU) {
                    messages.add(reply.array());
                    break;
                }
                throw new IllegalArgumentException("InterfaceType");
            }
            reply.clear();
            frame = 0;
        } while (p.getData() != null && p.getData().position() != p.getData().size());
        return messages;
    }

    private static int appendMultipleSNBlocks(GXDLMSSNParameters p, GXByteBuffer reply) {
        boolean ciphering = p.getSettings().isCiphered(false);
        int hSize = reply.size() + 3;
        if (p.getCommand() == 6 || p.getCommand() == 5) {
            hSize += 1 + GXCommon.getObjectCountSizeInBytes(p.getCount());
        }
        int maxSize = p.getSettings().getMaxPduSize() - hSize;
        if (ciphering) {
            maxSize -= 22;
            if (GXDLMS.useHdlc(p.getSettings().getInterfaceType())) {
                maxSize -= 3;
            }
        }
        maxSize -= GXCommon.getObjectCountSizeInBytes(maxSize);
        if (p.getData().size() - p.getData().position() > maxSize) {
            reply.setUInt8(0);
        } else {
            reply.setUInt8(1);
            maxSize = p.getData().size() - p.getData().position();
        }
        reply.setUInt16(p.getBlockIndex());
        if (p.getCommand() == 6) {
            p.setBlockIndex(p.getBlockIndex() + 1);
            GXCommon.setObjectCount(p.getCount(), reply);
            reply.setUInt8(DataType.OCTET_STRING.getValue());
        } else if (p.getCommand() == 5) {
            p.setBlockIndex(p.getBlockIndex() + 1);
        }
        GXCommon.setObjectCount(maxSize, reply);
        return maxSize;
    }

    public static void getSNPdu(GXDLMSSNParameters p, GXByteBuffer reply) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        boolean ciphering;
        boolean bl = ciphering = p.getCommand() != 96 && p.getCommand() != 97 && p.getSettings().isCiphered(false);
        if ((!ciphering || p.getCommand() == 96 || p.getCommand() == 97) && GXDLMS.useHdlc(p.getSettings().getInterfaceType())) {
            if (p.getSettings().isServer()) {
                reply.set(GXCommon.LLC_REPLY_BYTES);
            } else if (reply.size() == 0) {
                reply.set(GXCommon.LLC_SEND_BYTES);
            }
        }
        int cnt = 0;
        int cipherSize = 0;
        if (ciphering) {
            cipherSize = 22;
        }
        if (p.getData() != null) {
            cnt = p.getData().size() - p.getData().position();
        }
        if (p.getCommand() == 24) {
            reply.setUInt8(p.getCommand());
            if (p.getTime() == null) {
                reply.setUInt8(DataType.NONE.getValue());
            } else {
                int pos = reply.size();
                GXCommon.setData(null, reply, DataType.OCTET_STRING, p.getTime());
                reply.move(pos + 1, pos, reply.size() - pos - 1);
            }
            GXCommon.setObjectCount(p.getCount(), reply);
            reply.set(p.getAttributeDescriptor());
        } else if (p.getCommand() != 96 && p.getCommand() != 97) {
            reply.setUInt8(p.getCommand());
            if (p.getCount() != 255) {
                GXCommon.setObjectCount(p.getCount(), reply);
            }
            if (p.getRequestType() != 255) {
                reply.setUInt8(p.getRequestType());
            }
            reply.set(p.getAttributeDescriptor());
            if (!p.isMultipleBlocks()) {
                p.setMultipleBlocks(reply.size() + cipherSize + cnt > p.getSettings().getMaxPduSize());
                if (p.isMultipleBlocks()) {
                    reply.size(0);
                    if (!ciphering && GXDLMS.useHdlc(p.getSettings().getInterfaceType())) {
                        if (p.getSettings().isServer()) {
                            reply.set(GXCommon.LLC_REPLY_BYTES);
                        } else if (reply.size() == 0) {
                            reply.set(GXCommon.LLC_SEND_BYTES);
                        }
                    }
                    if (p.getCommand() == 6) {
                        p.setRequestType(7);
                    } else if (p.getCommand() == 5) {
                        p.setRequestType(6);
                    } else if (p.getCommand() == 12) {
                        p.setRequestType(2);
                    } else {
                        throw new IllegalArgumentException("Invalid command.");
                    }
                    reply.setUInt8(p.getCommand());
                    reply.setUInt8(1);
                    if (p.getRequestType() != 255) {
                        reply.setUInt8(p.getRequestType());
                    }
                    cnt = GXDLMS.appendMultipleSNBlocks(p, reply);
                }
            } else {
                cnt = GXDLMS.appendMultipleSNBlocks(p, reply);
            }
        }
        reply.set(p.getData(), cnt);
        if (p.getData() != null && p.getData().position() == p.getData().size()) {
            p.getSettings().setIndex(0L);
            p.getSettings().setCount(0L);
        }
        if (ciphering && p.getCommand() != 96 && p.getCommand() != 97) {
            GXICipher cipher = p.getSettings().getCipher();
            AesGcmParameter s = new AesGcmParameter(p.getSettings(), GXDLMS.getGloMessage(p.getCommand()), cipher.getSecurity(), cipher.getSecuritySuite(), cipher.getInvocationCounter(), cipher.getSystemTitle(), GXDLMS.getBlockCipherKey(p.getSettings()), GXDLMS.getAuthenticationKey(p.getSettings()));
            byte[] tmp = GXCiphering.encrypt(s, reply.array());
            reply.size(0);
            if (GXDLMS.useHdlc(p.getSettings().getInterfaceType())) {
                if (p.getSettings().isServer()) {
                    reply.set(GXCommon.LLC_REPLY_BYTES);
                } else if (reply.size() == 0) {
                    reply.set(GXCommon.LLC_SEND_BYTES);
                }
            }
            reply.set(tmp);
        }
    }

    static Object getAddress(long value, int size) {
        if (size < 2 && value < 128L) {
            return (byte)(value << 1 | 1L);
        }
        if (size < 4 && value < 16384L) {
            return (short)((value & 0x3F80L) << 2 | (value & 0x7FL) << 1 | 1L);
        }
        if (value < 0x10000000L) {
            return (int)((value & 0xFE00000L) << 4 | (value & 0x1FC000L) << 3 | (value & 0x3F80L) << 2 | (value & 0x7FL) << 1 | 1L);
        }
        throw new IllegalArgumentException("Invalid address.");
    }

    private static byte[] getAddressBytes(int value, int size) {
        Object tmp = GXDLMS.getAddress(value, size);
        GXByteBuffer bb = new GXByteBuffer();
        if (tmp instanceof Byte) {
            bb.setUInt8(((Byte)tmp).byteValue());
        } else if (tmp instanceof Short) {
            bb.setUInt16(((Short)tmp).intValue());
        } else if (tmp instanceof Integer) {
            bb.setUInt32(((Integer)tmp).intValue());
        } else if (tmp instanceof GXUInt8) {
            bb.setUInt8(((GXUInt8)tmp).byteValue());
        } else if (tmp instanceof GXUInt16) {
            bb.setUInt16(((GXUInt16)tmp).intValue());
        } else if (tmp instanceof GXUInt32) {
            bb.setUInt32(((GXUInt32)tmp).intValue());
        } else {
            throw new IllegalArgumentException("Invalid address type.");
        }
        return bb.array();
    }

    static byte[] getWrapperFrame(GXDLMSSettings settings, int command, GXByteBuffer data) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt16(1);
        if (settings.isServer()) {
            bb.setUInt16(settings.getServerAddress());
            if (settings.getPushClientAddress() != 0 && (command == 15 || command == 194)) {
                bb.setUInt16(settings.getPushClientAddress());
            } else {
                bb.setUInt16(settings.getClientAddress());
            }
        } else {
            bb.setUInt16(settings.getClientAddress());
            bb.setUInt16(settings.getServerAddress());
        }
        if (data == null) {
            bb.setUInt16(0);
        } else {
            bb.setUInt16(data.size());
            bb.set(data);
        }
        if (settings.isServer() && data != null) {
            if (data.size() == data.position()) {
                data.clear();
            } else {
                data.move(data.position(), 0, data.size() - data.position());
                data.position(0);
            }
        }
        return bb.array();
    }

    public static byte[] getSMSFrame(GXDLMSSettings settings, int command, GXByteBuffer data) {
        GXByteBuffer bb = new GXByteBuffer();
        if (settings.isServer()) {
            bb.setUInt8((byte)settings.getServerAddress());
            if (settings.getPushClientAddress() != 0 && (command == 15 || command == 194)) {
                bb.setUInt8(settings.getPushClientAddress());
            } else {
                bb.setUInt8(settings.getClientAddress());
            }
        } else {
            bb.setUInt8(settings.getClientAddress());
            bb.setUInt8(settings.getServerAddress());
        }
        bb.set(data);
        if (settings.isServer()) {
            data.clear();
        }
        return bb.array();
    }

    private static int addOpt(GXByteBuffer bb, int type, int last, Object data) {
        int len;
        if (type < last) {
            last = 0;
        }
        GXByteBuffer value = new GXByteBuffer();
        if (data instanceof Byte) {
            len = 1;
            value.setUInt8(((Byte)data).byteValue());
        } else if (data instanceof Integer) {
            len = 2;
            value.setUInt16((Integer)data);
        } else if (data instanceof Long) {
            len = 4;
            value.setUInt32((Long)data);
        } else if (data instanceof byte[]) {
            value.set((byte[])data);
            len = ((byte[])data).length;
        } else if (data instanceof String) {
            value.set(((String)data).getBytes());
            len = ((String)data).length();
        } else {
            throw new IllegalArgumentException("Invalid CoAP option type.");
        }
        if (type - last < 13) {
            bb.setUInt8(len |= type - last << 4);
        } else if (type - last < 269) {
            bb.setUInt8(len |= 0xD0);
            int delta = type - last + 1;
            bb.setUInt8(delta);
        } else {
            bb.setUInt8(len |= 0xFFFFFFE0);
            int delta = type;
            bb.setUInt16(delta -= 269 + last);
        }
        bb.set(value);
        return type;
    }

    static byte[] getCoAPFrame(GXDLMSSettings settings, int command, GXByteBuffer data, int moreData) {
        int code;
        int type;
        GXByteBuffer bb = new GXByteBuffer();
        int version = 1;
        int tokenLen = settings.getCoap().getToken().longValue() < 256L ? 1 : (settings.getCoap().getToken().longValue() < 65536L ? 2 : (settings.getCoap().getToken().longValue() < 0x100000000L ? 4 : 8));
        if ((moreData & RequestTypes.FRAME.getValue()) != 0) {
            type = CoAPType.ACKNOWLEDGEMENT.getValue();
            code = (byte)CoAPClass.SUCCESS.getValue() << 5 | CoAPSuccess.CONTINUE.getValue();
        } else if (!settings.isServer() || command == 15 || command == 194) {
            code = CoAPClass.METHOD.getValue() << 5 | CoAPMethod.POST.getValue();
            type = CoAPType.CONFIRMABLE.getValue();
        } else {
            type = CoAPType.ACKNOWLEDGEMENT.getValue();
            code = CoAPClass.SUCCESS.getValue() << 5 | CoAPSuccess.CREATED.getValue();
        }
        bb.setUInt8(version << 6 | type << 4 | tokenLen);
        bb.setUInt8(code);
        if ((moreData & RequestTypes.FRAME.getValue()) == 0) {
            settings.getCoap().setMessageId(1 + settings.getCoap().getMessageId());
        }
        bb.setUInt16(settings.getCoap().getMessageId());
        if (settings.getCoap().getToken().longValue() < 256L) {
            bb.setUInt8((byte)settings.getCoap().getToken().longValue());
        } else if (settings.getCoap().getToken().longValue() < 65536L) {
            bb.setUInt16((short)settings.getCoap().getToken().longValue());
        } else if (settings.getCoap().getToken().longValue() < 0x100000000L) {
            bb.setUInt32((int)settings.getCoap().getToken().longValue());
        } else {
            bb.setUInt64(settings.getCoap().getToken().longValue());
        }
        int lastOptionType = 14;
        if (type == CoAPType.CONFIRMABLE.getValue()) {
            if (settings.getCoap().getHost() != null && !settings.getCoap().getHost().equals("")) {
                lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.URI_HOST.getValue(), lastOptionType, settings.getCoap().getHost());
            }
            if (settings.getCoap().getPort() != 0) {
                lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.URI_PORT.getValue(), lastOptionType, settings.getCoap().getPort());
            }
            if (settings.getCoap().getPath() != null && !settings.getCoap().getPath().equals("")) {
                lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.URI_PATH.getValue(), lastOptionType, settings.getCoap().getPath());
            }
        }
        if ((moreData & RequestTypes.FRAME.getValue()) == 0) {
            lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.CONTENT_FORMAT.getValue(), lastOptionType, settings.getCoap().getContentFormat().getValue());
        }
        if (settings.getCoap().getMaxAge() != 0) {
            lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.MAX_AGE.getValue(), lastOptionType, settings.getCoap().getMaxAge());
        }
        if ((moreData & RequestTypes.FRAME.getValue()) != 0) {
            lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.BLOCK1.getValue(), lastOptionType, (byte)(settings.getCoap().getBlockNumber() << 4 | 0xE));
        }
        if (settings.getCoap().getBlockNumber() != 0) {
            lastOptionType = GXDLMS.addOpt(bb, CoAPOptionType.BLOCK2.getValue(), lastOptionType, (byte)(settings.getCoap().getBlockNumber() << 4 | 0xE));
        }
        for (int it : settings.getCoap().getOptions().keySet()) {
            lastOptionType = GXDLMS.addOpt(bb, it, lastOptionType, settings.getCoap().getOptions().get(it));
        }
        bb.setUInt8(255);
        bb.set(data);
        if (settings.isServer()) {
            if (data.size() == data.position()) {
                data.clear();
            } else {
                data.move(data.position(), 0, data.size() - data.position());
                data.position(0);
            }
        }
        return bb.array();
    }

    static byte[] getHdlcFrame(GXDLMSSettings settings, int frame, GXByteBuffer data) {
        byte[] secondaryAddress;
        byte[] primaryAddress;
        GXByteBuffer bb = new GXByteBuffer();
        int len = 0;
        if (settings.isServer()) {
            primaryAddress = frame == 19 && settings.getPushClientAddress() != 0 ? GXDLMS.getAddressBytes(settings.getPushClientAddress(), 0) : GXDLMS.getAddressBytes(settings.getClientAddress(), 0);
            secondaryAddress = GXDLMS.getAddressBytes(settings.getServerAddress(), settings.getServerAddressSize());
            len = secondaryAddress.length;
        } else {
            primaryAddress = GXDLMS.getAddressBytes(settings.getServerAddress(), settings.getServerAddressSize());
            secondaryAddress = GXDLMS.getAddressBytes(settings.getClientAddress(), 0);
            len = primaryAddress.length;
        }
        bb.setUInt8(126);
        int frameSize = settings.getHdlcSettings().getMaxInfoTX();
        if (settings.getHdlcSettings().isUseFrameSize()) {
            frameSize -= 10 + len;
        } else if (data != null && data.position() == 0) {
            frameSize -= 3;
        }
        if (data == null || data.size() == 0) {
            len = 0;
            bb.setUInt8(160);
        } else if (data.size() - data.position() <= frameSize) {
            len = data.size() - data.position();
            bb.setUInt8(0xA0 | 7 + primaryAddress.length + secondaryAddress.length + len >> 8 & 7);
        } else {
            len = frameSize;
            bb.setUInt8(0xA8 | 7 + primaryAddress.length + secondaryAddress.length + len >> 8 & 7);
        }
        if (len == 0) {
            bb.setUInt8((byte)(5 + primaryAddress.length + secondaryAddress.length + len));
        } else {
            bb.setUInt8((byte)(7 + primaryAddress.length + secondaryAddress.length + len));
        }
        bb.set(primaryAddress);
        bb.set(secondaryAddress);
        if (frame == 0) {
            bb.setUInt8(settings.getNextSend(true));
        } else {
            bb.setUInt8(frame);
        }
        int crc = GXFCS16.countFCS16(bb.getData(), 1, bb.size() - 1);
        bb.setUInt16(crc);
        if (len != 0) {
            bb.set(data, len);
            crc = GXFCS16.countFCS16(bb.getData(), 1, bb.size() - 1);
            bb.setUInt16(crc);
        }
        bb.setUInt8(126);
        if (settings.isServer() && data != null) {
            if (data.size() == data.position()) {
                data.clear();
            } else {
                data.move(data.position(), 0, data.size() - data.position());
                data.position(0);
            }
        }
        return bb.array();
    }

    public static byte[] getMacFrame(GXDLMSSettings settings, byte frame, byte creditFields, GXByteBuffer data) {
        if (settings.getInterfaceType() == InterfaceType.PLC) {
            return GXDLMS.getPlcFrame(settings, creditFields, data);
        }
        return GXDLMS.getMacHdlcFrame(settings, frame, creditFields, data);
    }

    private static byte[] getPlcFrame(GXDLMSSettings settings, byte creditFields, GXByteBuffer data) {
        int padLen;
        int frameSize = data.available();
        if (frameSize > 134) {
            frameSize = 134;
        }
        GXByteBuffer bb = new GXByteBuffer();
        bb.capacity(15 + frameSize + padLen);
        bb.setUInt8(2);
        bb.setUInt8((byte)(11 + frameSize));
        bb.setUInt8(80);
        bb.setUInt8(creditFields);
        bb.setUInt8((byte)(settings.getPlc().getMacSourceAddress() >> 4));
        int val = settings.getPlc().getMacSourceAddress() << 12;
        bb.setUInt16(val |= settings.getPlc().getMacDestinationAddress() & 0xFFF);
        bb.setUInt8((byte)padLen);
        bb.setUInt8(PlcDataLinkData.REQUEST.getValue());
        bb.setUInt8(settings.getServerAddress());
        bb.setUInt8(settings.getClientAddress());
        bb.set(data, frameSize);
        for (padLen = (36 - (11 + frameSize) % 36) % 36; padLen != 0; --padLen) {
            bb.setUInt8(0);
        }
        int crc = GXFCS16.countFCS16(bb.getData(), 0, bb.size());
        bb.setUInt16(crc);
        if (settings.isServer()) {
            if (data.size() == data.position()) {
                data.clear();
            } else {
                data.move(data.position(), 0, data.available());
                data.position(0);
            }
        }
        return bb.array();
    }

    static byte[] getMacHdlcFrame(GXDLMSSettings settings, int frame, int creditFields, GXByteBuffer data) {
        int padLen;
        if (settings.getHdlcSettings().getMaxInfoTX() > 126) {
            settings.getHdlcSettings().setMaxInfoTX(86);
        }
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt16(0);
        bb.setUInt8(creditFields);
        bb.setUInt8(settings.getPlc().getMacSourceAddress() >> 4);
        int val = settings.getPlc().getMacSourceAddress() << 12;
        bb.setUInt16(val |= settings.getPlc().getMacDestinationAddress() & 0xFFF);
        byte[] tmp = GXDLMS.getHdlcFrame(settings, frame, data);
        bb.setUInt8((byte)padLen);
        bb.set(tmp);
        for (padLen = (36 - (10 + tmp.length) % 36) % 36; padLen != 0; --padLen) {
            bb.setUInt8(0);
        }
        int crc = GXFCS16.countFCS24(bb.getData(), 2, bb.size() - 2 - padLen);
        bb.setUInt8((byte)(crc >> 16));
        bb.setUInt16(crc);
        val = bb.size() / 36;
        if (bb.size() % 36 != 0) {
            ++val;
        }
        if (val == 1) {
            val = 27756;
        } else if (val == 2) {
            val = 14906;
        } else if (val == 3) {
            val = 22102;
        } else if (val == 4) {
            val = 29041;
        } else if (val == 5) {
            val = 7453;
        } else if (val == 6) {
            val = 19275;
        } else if (val == 7) {
            val = 10023;
        } else {
            throw new IllegalArgumentException("Data length is too high.");
        }
        bb.setUInt16(0, val);
        return bb.array();
    }

    private static boolean getLLCBytes(boolean server, GXByteBuffer data) {
        if (server) {
            return data.compare(GXCommon.LLC_SEND_BYTES);
        }
        return data.compare(GXCommon.LLC_REPLY_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getHdlcAddressInfo(GXByteBuffer reply, int[] target, int[] source, short[] type) {
        int position = reply.position();
        source[0] = 0;
        target[0] = 0;
        type[0] = 0;
        try {
            short ch;
            int packetStartID = reply.position();
            int frameLen = 0;
            if (reply.size() - reply.position() < 9) {
                return;
            }
            for (int pos = reply.position(); pos < reply.size(); ++pos) {
                ch = reply.getUInt8();
                if (ch != 126) continue;
                packetStartID = pos;
                break;
            }
            if (reply.position() == reply.size()) {
                return;
            }
            short frame = reply.getUInt8();
            if ((frame & 7) != 0) {
                frameLen = (frame & 7) << 8;
            }
            ch = reply.getUInt8();
            if (reply.size() - reply.position() + 1 < (frameLen += ch)) {
                reply.position(packetStartID);
                return;
            }
            int eopPos = frameLen + packetStartID + 1;
            ch = reply.getUInt8(eopPos);
            if (ch != 126) {
                throw new IllegalArgumentException("Invalid data format.");
            }
            target[0] = GXCommon.getHDLCAddress(reply);
            source[0] = GXCommon.getHDLCAddress(reply);
            type[0] = reply.getUInt8();
        }
        finally {
            reply.position(position);
        }
    }

    static short getHdlcData(boolean server, GXDLMSSettings settings, GXByteBuffer reply, GXReplyData data, GXReplyData notify) {
        int crcRead;
        boolean ret;
        short ch;
        int packetStartID = reply.position();
        int frameLen = 0;
        if (reply.size() - reply.position() < 9) {
            data.setComplete(false);
            return 0;
        }
        data.setComplete(true);
        if (notify != null) {
            notify.setComplete(true);
        }
        boolean isNotify = false;
        for (int pos = reply.position(); pos < reply.size(); ++pos) {
            ch = reply.getUInt8();
            if (ch != 126) continue;
            packetStartID = pos;
            break;
        }
        if (reply.position() == reply.size()) {
            data.setComplete(false);
            return 0;
        }
        short frame = reply.getUInt8();
        if ((frame & 0xF0) != 160) {
            reply.position(reply.position() - 1);
            return GXDLMS.getHdlcData(server, settings, reply, data, notify);
        }
        if ((frame & 7) != 0) {
            frameLen = (frame & 7) << 8;
        }
        ch = reply.getUInt8();
        if (reply.size() - reply.position() + 1 < (frameLen += ch)) {
            data.setComplete(false);
            reply.position(packetStartID);
            return 0;
        }
        int eopPos = frameLen + packetStartID + 1;
        ch = reply.getUInt8(eopPos);
        if (ch != 126) {
            reply.position(reply.position() - 2);
            return GXDLMS.getHdlcData(server, settings, reply, data, notify);
        }
        int[] addresses = new int[2];
        try {
            ret = GXDLMS.checkHdlcAddress(server, settings, reply, eopPos, addresses);
        }
        catch (Exception ex) {
            ret = false;
        }
        if (!ret) {
            if (reply.position() >= reply.size() || reply.getUInt8(reply.position()) != 19) {
                reply.position(1 + eopPos);
                return GXDLMS.getHdlcData(server, settings, reply, data, notify);
            }
            if (notify != null) {
                isNotify = true;
                notify.setClientAddress(addresses[1]);
                notify.setServerAddress(addresses[0]);
            }
        }
        boolean moreData = (frame & 8) != 0;
        frame = reply.getUInt8();
        if (frame == 19 && !isNotify && notify != null) {
            isNotify = true;
            notify.setClientAddress(addresses[1]);
            notify.setServerAddress(addresses[0]);
        }
        if (moreData) {
            if (isNotify) {
                notify.getMoreData().add(RequestTypes.FRAME);
            } else {
                data.getMoreData().add(RequestTypes.FRAME);
            }
        } else if (isNotify) {
            notify.getMoreData().remove((Object)RequestTypes.FRAME);
        } else {
            data.getMoreData().remove((Object)RequestTypes.FRAME);
        }
        if (data.getXml() == null && !settings.checkFrame(frame)) {
            reply.position(eopPos + 1);
            return GXDLMS.getHdlcData(server, settings, reply, data, notify);
        }
        int crc = GXFCS16.countFCS16(reply.getData(), packetStartID + 1, reply.position() - packetStartID - 1);
        if (crc != (crcRead = reply.getUInt16())) {
            if (reply.size() - reply.position() > 8) {
                return GXDLMS.getHdlcData(server, settings, reply, data, notify);
            }
            throw new GXDLMSException("Wrong CRC.");
        }
        if (reply.position() != packetStartID + frameLen + 1) {
            crc = GXFCS16.countFCS16(reply.getData(), packetStartID + 1, frameLen - 2);
            if (crc != (crcRead = reply.getUInt16(packetStartID + frameLen - 1))) {
                throw new GXDLMSException("Wrong CRC.");
            }
            if (isNotify) {
                notify.setPacketLength(eopPos - 2);
            } else {
                data.setPacketLength(eopPos - 2);
            }
        } else if (isNotify) {
            notify.setPacketLength(reply.position() + 1);
        } else {
            data.setPacketLength(reply.position() + 1);
        }
        if (frame != 19 && (frame & HdlcFrameType.U_FRAME.getValue()) == HdlcFrameType.U_FRAME.getValue()) {
            if (reply.position() == packetStartID + frameLen + 1) {
                reply.getUInt8();
            }
            if (frame == 151) {
                data.setError((short)ErrorCode.UNACCEPTABLE_FRAME.getValue());
            } else if (frame == 31) {
                data.setError((short)ErrorCode.DISCONNECT_MODE.getValue());
            }
            data.setCommand(frame);
        } else if (frame != 19 && (frame & HdlcFrameType.S_FRAME.getValue()) == HdlcFrameType.S_FRAME.getValue()) {
            int tmp = frame >> 2 & 3;
            if (tmp == HdlcControlFrame.REJECT.getValue()) {
                data.setError((short)ErrorCode.REJECTED.getValue());
            } else if (tmp == HdlcControlFrame.RECEIVE_NOT_READY.getValue()) {
                data.setError((short)ErrorCode.RECEIVE_NOT_READY.getValue());
            } else if (tmp == HdlcControlFrame.RECEIVE_READY.getValue()) {
                data.setError((short)ErrorCode.OK.getValue());
            }
            if (reply.position() == packetStartID + frameLen + 1) {
                reply.getUInt8();
            }
        } else if (reply.position() == packetStartID + frameLen + 1) {
            reply.getUInt8();
            if ((frame & 1) == 1) {
                data.getMoreData().add(RequestTypes.FRAME);
            }
        } else if (!GXDLMS.getLLCBytes(server, reply) && data.getXml() != null) {
            GXDLMS.getLLCBytes(!server, reply);
        }
        return frame;
    }

    private static void getServerAddress(int address, int[] logical, int[] physical) {
        if (address < 16384) {
            logical[0] = address >>> 7;
            physical[0] = address & 0x7F;
        } else {
            logical[0] = address >>> 14;
            physical[0] = address & 0x3FFF;
        }
    }

    public static Object getHdlcAddress(int value, int size) {
        if (size < 2 && value < 128) {
            return (byte)(value << 1 | 1);
        }
        if (size < 4 && value < 16384) {
            return (short)((value & 0x3F80) << 2 | (value & 0x7F) << 1 | 1);
        }
        if (value < 0x10000000) {
            return (value & 0xFE00000) << 4 | (value & 0x1FC000) << 3 | (value & 0x3F80) << 2 | (value & 0x7F) << 1 | 1;
        }
        throw new IllegalArgumentException("Invalid address.");
    }

    public static byte[] getHdlcAddressBytes(int value, int size) {
        Object tmp = GXDLMS.getHdlcAddress(value, size);
        GXByteBuffer bb = new GXByteBuffer();
        if (tmp instanceof Byte && size < 2) {
            bb.setUInt8(((Byte)tmp).byteValue());
        } else if (tmp instanceof Short && size < 4) {
            bb.setUInt16(((Short)tmp).shortValue());
        } else if (tmp instanceof Integer) {
            bb.setUInt32(((Integer)tmp).intValue());
        } else {
            throw new IllegalArgumentException("Invalid address type.");
        }
        return bb.array();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkHdlcAddress(boolean server, GXDLMSSettings settings, GXByteBuffer reply, int index, int[] addresses) {
        int source;
        int target = GXCommon.getHDLCAddress(reply);
        addresses[0] = source = GXCommon.getHDLCAddress(reply);
        addresses[1] = target;
        if (server) {
            if (settings.getServerAddress() != 0 && settings.getServerAddress() != target) {
                if (reply.getUInt8(reply.position()) != 147) throw new GXDLMSException("Server addresses do not match. It is " + String.valueOf(target) + ". It should be " + String.valueOf(settings.getServerAddress()) + ".");
                settings.setServerAddress(target);
            } else {
                settings.setServerAddress(target);
            }
            if (settings.getClientAddress() != 0 && settings.getClientAddress() != source) {
                if (reply.getUInt8(reply.position()) != 147) throw new GXDLMSException("Client addresses do not match. It is " + String.valueOf(source) + ". It should be " + String.valueOf(settings.getClientAddress()) + ".");
                settings.setClientAddress(source);
                return true;
            } else {
                settings.setClientAddress(source);
            }
            return true;
        } else {
            if (settings.getClientAddress() != target) {
                if (settings.getClientAddress() != source || settings.getServerAddress() != target) throw new GXDLMSException("Destination addresses do not match. It is " + String.valueOf(target) + ". It should be " + String.valueOf(settings.getClientAddress()) + ".");
                reply.position(index + 1);
                return false;
            }
            if (settings.getServerAddress() == source || (settings.getServerAddress() & 0x7F) == 127 || (settings.getServerAddress() & 0x3FFF) == 16383) return true;
            int[] readLogical = new int[1];
            int[] readPhysical = new int[1];
            int[] logical = new int[1];
            int[] physical = new int[1];
            GXDLMS.getServerAddress(source, readLogical, readPhysical);
            GXDLMS.getServerAddress(settings.getServerAddress(), logical, physical);
            if (readLogical[0] == logical[0] && readPhysical[0] == physical[0]) return true;
            throw new GXDLMSException("Source addresses do not match. It is " + String.valueOf(source) + ". It should be " + String.valueOf(settings.getServerAddress()) + ".");
        }
    }

    static boolean getTcpData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data, GXReplyData notify) {
        GXReplyData target = data;
        if (buff.size() - buff.position() < 8) {
            target.setComplete(false);
            return true;
        }
        boolean isData = true;
        int pos = buff.position();
        target.setComplete(false);
        if (notify != null) {
            notify.setComplete(false);
        }
        while (buff.position() < buff.size() - 1) {
            int value = buff.getUInt16();
            if (value == 1) {
                boolean complete;
                if (buff.available() < 6) {
                    isData = false;
                    break;
                }
                if (!GXDLMS.checkWrapperAddress(settings, buff, target)) {
                    if (notify != null) {
                        target = notify;
                    }
                    isData = false;
                }
                value = buff.getUInt16();
                boolean bl = complete = buff.size() - buff.position() >= value;
                if (complete && buff.size() - buff.position() != value && data.getXml() != null) {
                    data.getXml().appendComment("Data length is " + String.valueOf(value) + " and there are " + String.valueOf(buff.size() - buff.position()) + " bytes.");
                }
                target.setComplete(complete);
                if (!complete) {
                    buff.position(pos);
                    break;
                }
                target.setPacketLength(buff.position() + value);
                break;
            }
            buff.position(buff.position() - 1);
        }
        return isData;
    }

    public static boolean checkSMSAddress(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data, GXReplyData notify) {
        boolean ret = true;
        if (settings.isServer()) {
            short value = buff.getUInt8();
            data.setSourceAddress(value);
            if (data.getXml() == null && settings.getClientAddress() != 0 && settings.getClientAddress() != value) {
                throw new RuntimeException("Source addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getClientAddress()));
            }
            settings.setClientAddress(value);
            value = buff.getUInt8();
            data.setTargetAddress(value);
            if (data.getXml() == null && settings.getServerAddress() != 0 && settings.getServerAddress() != value) {
                throw new RuntimeException("Destination addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getServerAddress()) + ".");
            }
            settings.setServerAddress(value);
        } else {
            short value = buff.getUInt8();
            data.setTargetAddress(value);
            if (data.getXml() == null && settings.getServerAddress() != 0 && settings.getServerAddress() != value) {
                if (notify == null) {
                    throw new RuntimeException("Source addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getServerAddress()) + ".");
                }
                notify.setSourceAddress(value);
                ret = false;
            } else {
                settings.setServerAddress(value);
            }
            value = buff.getUInt8();
            data.setSourceAddress(value);
            if (data.getXml() == null && settings.getClientAddress() != 0 && settings.getClientAddress() != value) {
                if (notify == null) {
                    throw new RuntimeException("Destination addresses do not match. It is " + new Integer(value).toString() + ". It should be " + settings.getClientAddress() + ".");
                }
                ret = false;
                notify.setTargetAddress(value);
            } else {
                settings.setClientAddress(value);
            }
        }
        return ret;
    }

    private static boolean getSmsData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data, GXReplyData notify) {
        if (buff.size() - buff.position() < 3) {
            data.setComplete(false);
            return true;
        }
        boolean isData = true;
        int pos = buff.position();
        data.setComplete(false);
        if (notify != null) {
            notify.setComplete(false);
            notify.setComplete(false);
        }
        if (!GXDLMS.checkSMSAddress(settings, buff, data, notify)) {
            data = notify;
            isData = false;
        }
        data.setComplete(buff.available() != 0);
        if (!data.isComplete()) {
            buff.position(pos);
        } else {
            data.setPacketLength(buff.size());
        }
        return isData;
    }

    private static BigInteger getCoAPValueAsInteger(GXByteBuffer buff, int len) {
        BigInteger token;
        switch (len) {
            case 1: {
                token = BigInteger.valueOf(buff.getUInt8());
                break;
            }
            case 2: {
                token = BigInteger.valueOf(buff.getUInt16());
                break;
            }
            case 4: {
                token = BigInteger.valueOf(buff.getUInt32());
                break;
            }
            case 8: {
                token = buff.getUInt64();
                break;
            }
            default: {
                throw new RuntimeException("Invalid Coap data.");
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findNextToken(GXDLMSSettings settings, GXByteBuffer buff, int origPos, GXReplyData data, GXReplyData notify, boolean nextCoAPPacket) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        int orig = buff.position();
        try {
            int pos;
            for (pos = buff.position(); pos < buff.size(); ++pos) {
                try {
                    buff.position(pos);
                    if (!GXDLMS.getCoAPData(settings, buff, null, notify)) continue;
                    data.setComplete(true);
                    if (nextCoAPPacket) {
                        data.setPacketLength(buff.position());
                        break;
                    }
                    data.setPacketLength(pos);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (pos == buff.size()) {
                data.setPacketLength(pos);
                data.setComplete(true);
            }
        }
        finally {
            buff.position(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getCoAPData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data, GXReplyData notify) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        short cmd;
        byte version;
        if (data != null) {
            data.setComplete(false);
        }
        if (buff.size() - buff.position() < 8) {
            return false;
        }
        boolean isData = true;
        int origPos = buff.position();
        if (notify != null) {
            notify.setComplete(false);
        }
        if ((version = (byte)((cmd = buff.getUInt8()) >> 6 & 3)) != 1) {
            return false;
        }
        int coapType = cmd >> 4 & 3;
        if (coapType != CoAPType.CONFIRMABLE.getValue() && coapType != CoAPType.NON_CONFIRMABLE.getValue() && coapType != CoAPType.ACKNOWLEDGEMENT.getValue() && coapType != CoAPType.RESET.getValue()) {
            return false;
        }
        int len = cmd & 0xF;
        if (len == 0) {
            return false;
        }
        short ch = buff.getUInt8();
        int coapClass = ch >>> 5;
        int msgId = buff.getUInt16();
        if (data != null && data.getXml() == null && settings.getCoap().getMessageId() != 0 && settings.getCoap().getMessageId() != msgId) {
            return false;
        }
        BigInteger token = GXDLMS.getCoAPValueAsInteger(buff, len);
        int moreData = 0;
        int type = 0;
        int frameSize = 0;
        if (coapClass != CoAPClass.CLIENT_ERROR.getValue()) {
            short option;
            while (buff.available() != 0 && (option = buff.getUInt8()) != 255) {
                if (option == 97 || option == 65) {
                    buff.position(buff.position() - 1);
                    break;
                }
                byte delta = (byte)(option >>> 4);
                if (delta == 13) {
                    type += buff.getUInt8();
                    type += 13;
                } else if (delta == 14) {
                    type += buff.getUInt16();
                    type += 269;
                } else {
                    type += delta;
                }
                byte optionLen = (byte)(option & 0xF);
                if (type == CoAPOptionType.URI_PORT.getValue()) {
                    int tmp = buff.getUInt16();
                    if (data == null) continue;
                    settings.getCoap().setPort(tmp);
                    continue;
                }
                if (type == CoAPOptionType.IF_NONE_MATCH.getValue()) {
                    int tmp = buff.getUInt16();
                    if (data == null) continue;
                    settings.getCoap().setIfNoneMatch(CoAPContentType.forValue(tmp));
                    continue;
                }
                if (type == CoAPOptionType.CONTENT_FORMAT.getValue()) {
                    int tmp = buff.getUInt16();
                    if (data == null) continue;
                    settings.getCoap().setContentFormat(CoAPContentType.forValue(tmp));
                    continue;
                }
                if (type == CoAPOptionType.BLOCK1.getValue()) {
                    int tmp = GXDLMS.getCoAPValueAsInteger(buff, optionLen).intValue();
                    if ((tmp & 8) != 0) {
                        moreData |= RequestTypes.DATABLOCK.getValue();
                    }
                    if (data != null) {
                        settings.getCoap().setBlockNumber(tmp >> 8);
                        data.getMoreData().addAll(RequestTypes.forValue(moreData));
                    }
                    frameSize = (int)Math.pow(2.0, (tmp & 7) + 4);
                    continue;
                }
                if (type == CoAPOptionType.BLOCK2.getValue()) {
                    int tmp = GXDLMS.getCoAPValueAsInteger(buff, optionLen).intValue();
                    byte blockNumber = (byte)(tmp >> 4);
                    if ((tmp & 8) != 0) {
                        moreData = RequestTypes.DATABLOCK.getValue();
                    }
                    frameSize = (int)Math.pow(2.0, (tmp & 7) + 4);
                    if (data == null) continue;
                    if (settings != null && blockNumber != settings.getCoap().getBlockNumber() && settings.getCoap().getBlockNumber() != 0 && data.getXml() == null) {
                        if (blockNumber < settings.getCoap().getBlockNumber()) {
                            buff.position(buff.size());
                            return false;
                        }
                        throw new IllegalArgumentException(String.format("Invalid CoAP block number. It is %1$s and it should be %2$s.", blockNumber, settings.getCoap().getBlockNumber()));
                    }
                    if (settings != null) {
                        settings.getCoap().setBlockNumber((byte)(1 + blockNumber));
                    }
                    if (coapType != CoAPType.ACKNOWLEDGEMENT.getValue()) continue;
                    if (moreData == 0) {
                        if (data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                            data.getMoreData().remove((Object)RequestTypes.FRAME);
                        }
                        data.setPacketLength(buff.size());
                        data.setComplete(true);
                        settings.getCoap().setBlockNumber(0);
                        continue;
                    }
                    data.getMoreData().add(RequestTypes.FRAME);
                    continue;
                }
                if (type == CoAPOptionType.MAX_AGE.getValue()) {
                    int tmp = buff.getUInt16();
                    if (data == null) continue;
                    settings.getCoap().setMaxAge(tmp);
                    continue;
                }
                byte[] value = new byte[optionLen];
                buff.get(value);
                if (type == CoAPOptionType.URI_HOST.getValue()) {
                    if (data == null) continue;
                    settings.getCoap().setHost(new String(value));
                    continue;
                }
                if (type == CoAPOptionType.MAX_AGE.getValue() || data == null || !settings.isServer() && data.getXml() == null) continue;
                settings.getCoap().getOptions().put(type, value);
            }
        }
        if (settings != null && data != null) {
            settings.getCoap().setVersion(version);
            settings.getCoap().setType(CoAPType.forValue(coapType));
            settings.getCoap().setClassCode(CoAPClass.forValue(coapClass));
            settings.getCoap().setMessageId(msgId);
            settings.getCoap().setToken(token);
            block1 : switch (CoAPClass.forValue(coapClass)) {
                case METHOD: {
                    settings.getCoap().setMethod(CoAPMethod.forValue(ch & 0x1F));
                    switch (settings.getCoap().getMethod()) {
                        case GET: 
                        case POST: 
                        case PUT: 
                        case DELETE: 
                        case FETCH: 
                        case PATCH: {
                            break block1;
                        }
                    }
                    return false;
                }
                case SUCCESS: {
                    settings.getCoap().setSuccess(CoAPSuccess.forValue(ch & 0x1F));
                    switch (settings.getCoap().getSuccess()) {
                        case NONE: 
                        case CREATED: 
                        case DELETED: 
                        case VALID: 
                        case CONTINUE: {
                            break block1;
                        }
                    }
                    return false;
                }
                case CLIENT_ERROR: {
                    settings.getCoap().setClientError(CoAPClientError.forValue(ch & 0x1F));
                    switch (settings.getCoap().getClientError()) {
                        case BAD_REQUEST: 
                        case UNAUTHORIZED: 
                        case BAD_OPTION: 
                        case FORBIDDEN: 
                        case NOT_FOUND: 
                        case METHOD_NOT_ALLOWED: 
                        case NOT_ACCEPTABLE: 
                        case REQUEST_ENTITY_INCOMPLETE: 
                        case CONFLICT: 
                        case PRECONDITION_FAILED: 
                        case REQUEST_ENTITY_TOO_LARGE: 
                        case UNSUPPORTED_CONTENT_FORMAT: {
                            if (data != null && data.getXml() != null) break block1;
                            throw new GXDLMSCoAPException(settings.getCoap().getClientError());
                        }
                        default: {
                            return false;
                        }
                    }
                }
                case SERVER_ERROR: {
                    settings.getCoap().setServerError(CoAPServerError.forValue(ch & 0x1F));
                    switch (settings.getCoap().getServerError()) {
                        case INTERNAL: 
                        case NOT_IMPLEMENTED: 
                        case BAD_GATEWAY: 
                        case SERVICE_UNAVAILABLE: 
                        case GATEWAY_TIMEOUT: 
                        case PROXYING_NOT_SUPPORTED: {
                            if (data != null && data.getXml() != null) break block1;
                            throw new GXDLMSCoAPException(settings.getCoap().getServerError());
                        }
                        default: {
                            return false;
                        }
                    }
                }
                case SIGNALING: {
                    settings.getCoap().setSignaling(CoAPSignaling.forValue(ch & 0x1F));
                    switch (settings.getCoap().getSignaling()) {
                        case UNASSIGNED: 
                        case CSM: 
                        case PING: 
                        case PONG: 
                        case RELEASE: 
                        case ABORT: {
                            break block1;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (data.getXml() != null) {
                if (!data.isMoreData() && data.getPacketLength() == buff.size()) {
                    return true;
                }
                if (data.isMoreData()) {
                    GXDLMS.findNextToken(settings, buff, origPos, data, notify, false);
                } else if (coapType == CoAPType.CONFIRMABLE.getValue() && moreData != 0) {
                    data.setComplete(true);
                    data.setPacketLength(buff.position());
                } else {
                    GXByteBuffer origData = data.getData();
                    int orig = buff.position();
                    int xmlLen = 0;
                    if (data.getXml() != null) {
                        xmlLen = data.getXml().getXmlLength();
                    }
                    data.setData(buff);
                    try {
                        GXDLMS.getPdu(settings, data);
                        data.setComplete(true);
                        if (!data.isComplete()) {
                            buff.position(origPos);
                        }
                        if (data.getCommand() == 96 || data.getCommand() == 97) {
                            GXDLMS.findNextToken(settings, buff, origPos, data, notify, true);
                            data.setPacketLength(data.getPacketLength() - orig);
                        }
                        data.setPacketLength(buff.position());
                    }
                    finally {
                        data.setData(origData);
                        buff.position(orig);
                        if (data.getXml() != null) {
                            data.getXml().setXmlLength(xmlLen);
                        }
                    }
                }
            } else {
                data.setComplete(true);
                if (!data.isComplete()) {
                    buff.position(origPos);
                } else {
                    data.setPacketLength(buff.size());
                }
            }
        }
        return isData;
    }

    private static boolean validateCheckSum(GXByteBuffer bb, int count) {
        short value = 0;
        for (int pos = 0; pos != count; ++pos) {
            value = (byte)(value + bb.getUInt8(bb.position() + pos));
        }
        return value == bb.getUInt8(bb.position() + count);
    }

    private static void getWiredMBusData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data) {
        int packetStartID = buff.position();
        if (buff.getUInt8() != 104 || buff.available() < 5) {
            data.setComplete(false);
            buff.position(buff.position() - 1);
        } else {
            short len = buff.getUInt8();
            if (buff.getUInt8() != len || buff.available() < 3 + len || buff.getUInt8() != 104) {
                data.setComplete(false);
                buff.position(packetStartID);
            } else {
                boolean crc = GXDLMS.validateCheckSum(buff, len);
                if (!crc && data.getXml() == null) {
                    data.setComplete(false);
                    buff.position(packetStartID);
                } else {
                    if (!crc) {
                        data.getXml().appendComment("Invalid checksum.");
                    }
                    if (buff.getUInt8(buff.position() + len + 1) != 22) {
                        data.setComplete(false);
                        buff.position(packetStartID);
                        return;
                    }
                    data.setPacketLength(buff.position() + len);
                    data.setComplete(true);
                    int index = data.getData().position();
                    short tmp = buff.getUInt8();
                    MBusCommand cmd = MBusCommand.forValue(tmp & 0xF);
                    short id = buff.getUInt8();
                    short ci = buff.getUInt8();
                    if (ci == 0) {
                        data.getMoreData().add(RequestTypes.FRAME);
                    } else if (ci >>> 4 == (ci & 0xF)) {
                        data.getMoreData().remove((Object)RequestTypes.FRAME);
                    }
                    if (ci != 0) {
                        // empty if block
                    }
                    if ((tmp & 0x40) != 0) {
                        settings.setClientAddress(buff.getUInt8());
                        settings.setServerAddress(buff.getUInt8());
                    } else {
                        settings.setServerAddress(buff.getUInt8());
                        settings.setClientAddress(buff.getUInt8());
                    }
                    if (data.getXml() != null && data.getXml().isComments()) {
                        data.getXml().appendComment("Command: " + (Object)((Object)cmd));
                        data.getXml().appendComment("A-Field: " + id);
                        data.getXml().appendComment("CI-Field: " + ci);
                        if ((tmp & 0x40) != 0) {
                            data.getXml().appendComment("Primary station: " + settings.getServerAddress());
                            data.getXml().appendComment("Secondary station: " + settings.getClientAddress());
                        } else {
                            data.getXml().appendComment("Primary station: " + settings.getClientAddress());
                            data.getXml().appendComment("Secondary station: " + settings.getServerAddress());
                        }
                    }
                }
            }
        }
    }

    static void getWirelessMBusData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data) {
        int len = buff.getUInt8();
        if (buff.size() < len - 1) {
            data.setComplete(false);
            buff.position(buff.position() - 1);
        } else {
            if (buff.size() < len) {
                --len;
            }
            data.setPacketLength(len);
            data.setComplete(true);
            MBusCommand cmd = MBusCommand.forValue(buff.getUInt8());
            int manufacturerID = buff.getUInt16();
            String man = GXCommon.decryptManufacturer(manufacturerID);
            buff.getUInt32();
            short meterVersion = buff.getUInt8();
            MBusMeterType type = MBusMeterType.forValue(buff.getUInt8());
            MBusControlInfo ci = MBusControlInfo.forValue(buff.getUInt8());
            buff.getUInt8();
            buff.getUInt8();
            int configurationWord = buff.getUInt16();
            MBusEncryptionMode encryption = MBusEncryptionMode.forValue(configurationWord & 7);
            settings.setClientAddress(buff.getUInt8());
            settings.setServerAddress(buff.getUInt8());
            if (data.getXml() != null && data.getXml().isComments()) {
                data.getXml().appendComment("Command: " + (Object)((Object)cmd));
                data.getXml().appendComment("Manufacturer: " + man);
                data.getXml().appendComment("Meter Version: " + meterVersion);
                data.getXml().appendComment("Meter Type: " + (Object)((Object)type));
                data.getXml().appendComment("Control Info: " + (Object)((Object)ci));
                data.getXml().appendComment("Encryption: " + (Object)((Object)encryption));
            }
        }
    }

    static short getPlcSfskFrameSize(GXByteBuffer buff) {
        int ret;
        if (buff.available() < 2) {
            ret = 0;
        } else {
            int len = buff.getUInt16(buff.position());
            switch (len) {
                case 27756: {
                    ret = 36;
                    break;
                }
                case 14906: {
                    ret = 72;
                    break;
                }
                case 22102: {
                    ret = 108;
                    break;
                }
                case 29041: {
                    ret = 144;
                    break;
                }
                case 7453: {
                    ret = 180;
                    break;
                }
                case 19275: {
                    ret = 216;
                    break;
                }
                case 10023: {
                    ret = 252;
                    break;
                }
                default: {
                    ret = 0;
                }
            }
        }
        return (short)ret;
    }

    private static void getPlcData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data) {
        if (buff.available() < 9) {
            data.setComplete(false);
            return;
        }
        int packetStartID = buff.position();
        for (int pos = buff.position(); pos < buff.size(); ++pos) {
            short stx = buff.getUInt8();
            if (stx != 2) continue;
            packetStartID = pos;
            break;
        }
        if (buff.position() == buff.size()) {
            data.setComplete(false);
            buff.position(packetStartID);
            return;
        }
        short len = buff.getUInt8();
        buff.position();
        if (buff.available() < len) {
            data.setComplete(false);
            buff.position(buff.position() - 2);
        } else {
            buff.getUInt8();
            buff.getUInt8();
            int mac = buff.getUInt24();
            short macSa = (short)(mac >> 12);
            short macDa = (short)(mac & 0xFFF);
            short padLen = buff.getUInt8();
            if (buff.size() < len + padLen + 2) {
                data.setComplete(false);
                buff.position(buff.position() - 6);
            } else {
                short ch = buff.getUInt8();
                if (ch != PlcDataLinkData.REQUEST.getValue()) {
                    throw new RuntimeException("Parsing MAC LLC data failed. Invalid DataLink data request.");
                }
                buff.getUInt8();
                buff.getUInt8();
                if (settings.isServer()) {
                    data.setComplete(data.getXml() != null || (macDa == (short)PlcDestinationAddress.ALL_PHYSICAL.getValue() || macDa == settings.getPlc().getMacSourceAddress()) && (macSa == (short)PlcSourceAddress.INITIATOR.getValue() || macSa == settings.getPlc().getMacDestinationAddress()));
                    data.setServerAddress(macDa);
                    data.setClientAddress(macSa);
                } else {
                    data.setComplete(data.getXml() != null || macDa == (short)PlcDestinationAddress.ALL_PHYSICAL.getValue() || macDa == (short)PlcSourceAddress.INITIATOR.getValue() || macDa == settings.getPlc().getMacDestinationAddress());
                    data.setClientAddress(macDa);
                    data.setServerAddress(macSa);
                }
                if (data.isComplete()) {
                    int crcCount = GXFCS16.countFCS16(buff.getData(), 0, len + padLen);
                    int crc = buff.getUInt16(len + padLen);
                    if (crc != crcCount) {
                        if (data.getXml() == null) {
                            throw new RuntimeException("Invalid data checksum.");
                        }
                        data.getXml().appendComment("Invalid data checksum.");
                    }
                    data.setPacketLength(len);
                } else {
                    buff.position(packetStartID);
                }
            }
        }
    }

    private static short getPlcHdlcData(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData data) {
        if (buff.available() < 2) {
            data.setComplete(false);
            return 0;
        }
        short frame = 0;
        short frameLen = GXDLMS.getPlcSfskFrameSize(buff);
        if (frameLen == 0) {
            throw new RuntimeException("Invalid PLC frame size.");
        }
        if (buff.available() < frameLen) {
            data.setComplete(false);
        } else {
            buff.position(2 + buff.position());
            int index = buff.position();
            buff.getUInt8();
            int mac = buff.getUInt24();
            short sa = (short)(mac >> 12);
            short da = (short)(mac & 0xFFF);
            if (settings.isServer()) {
                data.setComplete(data.getXml() != null || (da == PlcDestinationAddress.ALL_PHYSICAL.getValue() || da == settings.getPlc().getMacSourceAddress()) && (sa == (short)PlcHdlcSourceAddress.INITIATOR.getValue() || sa == settings.getPlc().getMacDestinationAddress()));
                data.setServerAddress(da);
                data.setClientAddress(sa);
            } else {
                data.setComplete(data.getXml() != null || da == PlcHdlcSourceAddress.INITIATOR.getValue() || da == settings.getPlc().getMacDestinationAddress());
                data.setClientAddress(sa);
                data.setServerAddress(da);
            }
            if (data.isComplete()) {
                short padLen = buff.getUInt8();
                frame = GXDLMS.getHdlcData(settings.isServer(), settings, buff, data, null);
                GXDLMS.getDataFromFrame(buff, data, true);
                buff.position(buff.position() + padLen);
                int crcCount = GXFCS16.countFCS24(buff.getData(), index, buff.position() - index);
                int crc = buff.getUInt24(buff.position());
                if (crc != crcCount) {
                    if (data.getXml() == null) {
                        throw new RuntimeException("Invalid data checksum.");
                    }
                    data.getXml().appendComment("Invalid data checksum.");
                }
                data.setPacketLength(2 + buff.position() - index);
            } else {
                buff.position(buff.position() + frameLen - index - 4);
            }
        }
        return frame;
    }

    public static boolean isWirelessMBusData(GXByteBuffer buff) {
        if (buff.available() < 2) {
            return false;
        }
        short cmd = buff.getUInt8(buff.position() + 1);
        return (cmd & MBusCommand.SND_NR.getValue()) != 0 || (cmd & MBusCommand.SND_UD.getValue()) != 0 || (cmd & MBusCommand.RSP_UD.getValue()) != 0;
    }

    public static boolean isWiredMBusData(GXByteBuffer buff) {
        if (buff.available() < 1) {
            return false;
        }
        return buff.getUInt8(buff.position()) == 104;
    }

    static boolean isCoAPData(GXByteBuffer buff) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (buff.size() - buff.position() < 8) {
            return false;
        }
        int pos = buff.position();
        try {
            boolean bl = GXDLMS.getCoAPData(null, buff, null, null);
            return bl;
        }
        finally {
            buff.position(pos);
        }
    }

    public static int GetPlcSfskFrameSize(GXByteBuffer buff) {
        int ret;
        if (buff.available() < 2) {
            ret = 0;
        } else {
            int len = buff.getUInt16(buff.position());
            switch (len) {
                case 27756: {
                    ret = 36;
                    break;
                }
                case 14906: {
                    ret = 72;
                    break;
                }
                case 22102: {
                    ret = 108;
                    break;
                }
                case 29041: {
                    ret = 144;
                    break;
                }
                case 7453: {
                    ret = 180;
                    break;
                }
                case 19275: {
                    ret = 216;
                    break;
                }
                case 10023: {
                    ret = 252;
                    break;
                }
                default: {
                    ret = 0;
                }
            }
        }
        return ret;
    }

    private static boolean checkWrapperAddress(GXDLMSSettings settings, GXByteBuffer buff, GXReplyData notify) {
        boolean ret = true;
        if (settings.isServer()) {
            int value = buff.getUInt16();
            if (settings.getClientAddress() != 0 && settings.getClientAddress() != value) {
                throw new GXDLMSException("Source addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getClientAddress()) + ".");
            }
            settings.setClientAddress(value);
            value = buff.getUInt16();
            if (settings.getServerAddress() != 0 && settings.getServerAddress() != value) {
                throw new GXDLMSException("Destination addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getServerAddress()) + ".");
            }
            settings.setServerAddress(value);
        } else {
            int value = buff.getUInt16();
            if (settings.getServerAddress() != 0 && settings.getServerAddress() != value) {
                if (notify == null) {
                    throw new GXDLMSException("Source addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getServerAddress()) + ".");
                }
                notify.setServerAddress(value);
                ret = false;
            } else {
                settings.setServerAddress(value);
            }
            value = buff.getUInt16();
            if (settings.getClientAddress() != 0 && settings.getClientAddress() != value) {
                if (notify == null) {
                    throw new GXDLMSException("Destination addresses do not match. It is " + String.valueOf(value) + ". It should be " + String.valueOf(settings.getClientAddress()) + ".");
                }
                ret = false;
                notify.setClientAddress(value);
            } else {
                settings.setClientAddress(value);
            }
        }
        return ret;
    }

    static boolean readResponseDataBlockResult(GXDLMSSettings settings, GXReplyData reply, int index) {
        int expectedIndex;
        reply.setError(0);
        short lastBlock = reply.getData().getUInt8();
        int number = reply.getData().getUInt16();
        int blockLength = GXCommon.getObjectCount(reply.getData());
        if (lastBlock == 0) {
            reply.getMoreData().add(RequestTypes.DATABLOCK);
        } else {
            reply.getMoreData().remove((Object)RequestTypes.DATABLOCK);
        }
        if (number != 1 && settings.getBlockIndex() == 1) {
            settings.setBlockIndex(number);
        }
        if (number != (expectedIndex = settings.getBlockIndex())) {
            throw new GXDLMSException("Invalid Block number. It is " + number + " and it should be " + expectedIndex + ".");
        }
        if (reply.getMoreData().contains((Object)RequestTypes.FRAME)) {
            GXDLMS.getDataFromBlock(reply.getData(), index);
            return false;
        }
        if (blockLength != reply.getData().size() - reply.getData().position()) {
            throw new IllegalArgumentException("Invalid block length.");
        }
        reply.setCommand(0);
        if (reply.getXml() != null) {
            reply.getData().trim();
            reply.getXml().appendStartTag(12, (byte)2);
            reply.getXml().appendLine(65297, "Value", (Object)reply.getXml().integerToHex(lastBlock, 2));
            reply.getXml().appendLine(65298, "Value", (Object)reply.getXml().integerToHex(number, 4));
            reply.getXml().appendLine(65299, "Value", (Object)GXCommon.toHex(reply.getData().getData(), false, 0, reply.getData().size()));
            reply.getXml().appendEndTag(12, (byte)2);
            return false;
        }
        GXDLMS.getDataFromBlock(reply.getData(), index);
        reply.setTotalCount(0);
        if (reply.getMoreData().isEmpty()) {
            settings.resetBlockIndex();
        }
        return true;
    }

    static boolean handleReadResponse(GXDLMSSettings settings, GXReplyData reply, int index) {
        boolean first;
        int cnt = reply.getTotalCount();
        boolean bl = first = cnt == 0 || reply.getCommandType() == 2;
        if (first) {
            cnt = GXCommon.getObjectCount(reply.getData());
            reply.setTotalCount(cnt);
        }
        ArrayList<Object> values = null;
        if (cnt != 1) {
            if (reply.isMoreData()) {
                GXDLMS.getDataFromBlock(reply.getData(), 0);
                return false;
            }
            if (!first) {
                reply.getData().position(0);
            }
            values = new ArrayList<Object>();
            if (reply.getValue() instanceof List) {
                values.addAll((List)reply.getValue());
            }
            reply.setValue(null);
        }
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(12, "Qty", reply.getXml().integerToHex(cnt, 2));
        }
        block6: for (int pos = 0; pos != cnt; ++pos) {
            int type;
            if (first) {
                type = reply.getData().getUInt8();
                reply.setCommandType(type);
            } else {
                type = reply.getCommandType();
            }
            boolean standardXml = reply.getXml() != null && reply.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML;
            switch (type) {
                case 0: {
                    reply.setError(0);
                    if (reply.getXml() != null) {
                        if (standardXml) {
                            reply.getXml().appendStartTag(65319);
                        }
                        reply.getXml().appendStartTag(12, (byte)0);
                        GXDataInfo di = new GXDataInfo();
                        di.setXml(reply.getXml());
                        GXCommon.getData(settings, reply.getData(), di);
                        reply.getXml().appendEndTag(12, (byte)0);
                        if (!standardXml) continue block6;
                        reply.getXml().appendEndTag(65319);
                        continue block6;
                    }
                    if (cnt == 1) {
                        GXDLMS.getDataFromBlock(reply.getData(), 0);
                        continue block6;
                    }
                    reply.setReadPosition(reply.getData().position());
                    GXDLMS.getValueFromData(settings, reply);
                    reply.getData().position(reply.getReadPosition());
                    values.add(reply.getValue());
                    reply.setValue(null);
                    continue block6;
                }
                case 1: {
                    reply.setError(reply.getData().getUInt8());
                    if (reply.getXml() == null) continue block6;
                    if (standardXml) {
                        reply.getXml().appendStartTag(65319);
                    }
                    reply.getXml().appendLine(3073, null, (Object)GXDLMSTranslator.errorCodeToString(reply.getXml().getOutputType(), ErrorCode.forValue(reply.getError())));
                    if (!standardXml) continue block6;
                    reply.getXml().appendEndTag(65319);
                    continue block6;
                }
                case 2: {
                    if (GXDLMS.readResponseDataBlockResult(settings, reply, index)) continue block6;
                    if (reply.getXml() != null) {
                        reply.getXml().appendEndTag(12);
                    }
                    return false;
                }
                case 3: {
                    int number = reply.getData().getUInt16();
                    if (number != settings.getBlockIndex()) {
                        throw new GXDLMSException("Invalid Block number. It is " + number + " and it should be " + settings.getBlockIndex() + ".");
                    }
                    settings.increaseBlockIndex();
                    reply.getMoreData().add(RequestTypes.DATABLOCK);
                    continue block6;
                }
                default: {
                    throw new GXDLMSException("HandleReadResponse failed. Invalid tag.");
                }
            }
        }
        if (reply.getXml() != null) {
            reply.getXml().appendEndTag(12);
            return true;
        }
        if (values != null) {
            reply.setValue(values);
        }
        return cnt == 1;
    }

    private static void handleActionResponseNormal(GXDLMSSettings settings, GXReplyData data) {
        boolean standardXml = data.getXml() != null && data.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML;
        short ret = data.getData().getUInt8();
        if (ret != 0) {
            data.setError(ret);
        }
        if (data.getXml() != null) {
            if (standardXml) {
                data.getXml().appendStartTag(65337);
            }
            data.getXml().appendLine(65302, null, (Object)GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(data.getError())));
        }
        if (ret == 0 && data.getData().position() < data.getData().size()) {
            ret = data.getData().getUInt8();
            if (ret == 0) {
                GXDLMS.getDataFromBlock(data.getData(), 0);
            } else if (ret == 1) {
                ret = (byte)data.getData().getUInt8();
                if (ret != 0) {
                    data.setError(data.getData().getUInt8());
                    if (ret == 9 && data.getError() == 16) {
                        data.getData().position(data.getData().position() - 2);
                        GXDLMS.getDataFromBlock(data.getData(), 0);
                        data.setError(0);
                        ret = 0;
                    }
                } else {
                    GXDLMS.getDataFromBlock(data.getData(), 0);
                }
            } else {
                throw new GXDLMSException("HandleActionResponseNormal failed. Invalid tag.");
            }
            if (data.getXml() != null && (ret != 0 || data.getData().position() < data.getData().size())) {
                data.getXml().appendStartTag(65303);
                if (ret != 0) {
                    data.getXml().appendLine(65289, null, (Object)GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(data.getError())));
                } else {
                    data.getXml().appendStartTag(12, (byte)0);
                    GXDataInfo di = new GXDataInfo();
                    di.setXml(data.getXml());
                    GXCommon.getData(settings, data.getData(), di);
                    data.getXml().appendEndTag(12, (byte)0);
                }
                data.getXml().appendEndTag(65303);
                if (standardXml) {
                    data.getXml().appendEndTag(65337);
                }
            }
        }
    }

    private static boolean handleActionResponseFirstBlock(GXDLMSSettings settings, GXReplyData reply, int index) {
        int blockLength;
        boolean ret = true;
        short ch = reply.getData().getUInt8();
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(65413);
            reply.getXml().appendLine(65297, "Value", (Object)reply.getXml().integerToHex(ch, 2));
        }
        if (ch == 0) {
            reply.getMoreData().add(RequestTypes.DATABLOCK);
        } else {
            reply.getMoreData().remove((Object)RequestTypes.DATABLOCK);
        }
        long number = reply.getData().getUInt32();
        if (reply.getXml() != null) {
            reply.getXml().appendLine(65298, "Value", (Object)reply.getXml().integerToHex(number, 8));
        } else {
            int expectedIndex;
            if (number == 1L) {
                settings.resetBlockIndex();
            }
            if (number != (long)(expectedIndex = settings.getBlockIndex())) {
                throw new IllegalArgumentException("Invalid Block number. It is " + number + " and it should be " + expectedIndex + ".");
            }
        }
        if (reply.getXml() != null) {
            if (reply.getData().available() != 0) {
                blockLength = GXCommon.getObjectCount(reply.getData());
                if (!reply.getMoreData().contains((Object)RequestTypes.FRAME) && blockLength > reply.getData().available()) {
                    reply.getXml().appendComment("Block is not complete." + String.valueOf(reply.getData().available()) + "/" + String.valueOf(blockLength) + ".");
                }
                reply.getXml().appendLine(65299, "Value", (Object)GXCommon.toHex(reply.getData().getData(), false, reply.getData().position(), reply.getData().available()));
            }
            reply.getXml().appendEndTag(65413);
        } else if (reply.getData().available() != 0) {
            blockLength = GXCommon.getObjectCount(reply.getData());
            if (!reply.getMoreData().contains((Object)RequestTypes.FRAME)) {
                if (blockLength > reply.getData().size() - reply.getData().position()) {
                    throw new IllegalArgumentException("Invalid block length.");
                }
                if (reply.getMoreData().contains((Object)RequestTypes.DATABLOCK)) {
                    reply.setCommand(0);
                }
            }
            if (blockLength == 0) {
                reply.getData().size(index);
            } else {
                GXDLMS.getDataFromBlock(reply.getData(), index);
            }
            if (reply.getMoreData().isEmpty()) {
                reply.getData().position(0);
                settings.resetBlockIndex();
            }
        }
        if (reply.getMoreData().isEmpty() && settings != null && settings.getCommand() == 192 && settings.getCommandType() == 3) {
            GXDLMS.handleGetResponseWithList(settings, reply);
            ret = false;
        }
        return ret;
    }

    static void handleMethodResponse(GXDLMSSettings settings, GXReplyData data, int index) {
        byte type = (byte)data.getData().getUInt8();
        data.setInvokeId(data.getData().getUInt8());
        GXDLMS.verifyInvokeId(settings, data);
        GXDLMS.addInvokeId(data.getXml(), 199, type, data.getInvokeId());
        if (type == 1) {
            GXDLMS.handleActionResponseNormal(settings, data);
        } else if (type == 2) {
            GXDLMS.handleActionResponseFirstBlock(settings, data, index);
        } else {
            if (type == 3) {
                throw new IllegalArgumentException("Invalid Command.");
            }
            if (type == 4) {
                long number = data.getData().getUInt32();
                if (data.getXml() != null) {
                    data.getXml().appendLine(65298, "Value", (Object)data.getXml().integerToHex(number, 8));
                }
                settings.increaseBlockIndex();
            } else {
                throw new IllegalArgumentException("Invalid Command.");
            }
        }
        if (data.getXml() != null) {
            data.getXml().appendEndTag(199, type);
            data.getXml().appendEndTag(199);
        }
    }

    static void handlePush(GXReplyData reply) {
        int index = reply.getData().position() - 1;
        short last = reply.getData().getUInt8();
        if ((last & 0x80) == 0) {
            reply.getMoreData().add(RequestTypes.DATABLOCK);
        } else {
            reply.getMoreData().remove((Object)RequestTypes.DATABLOCK);
        }
        reply.getData().getUInt8();
        reply.getData().getUInt8();
        reply.getData().getUInt8();
        reply.getData().getUInt8();
        if ((reply.getData().getUInt8() & 0xF) == 0) {
            throw new IllegalArgumentException("Invalid data.");
        }
        reply.getData().getUInt32();
        short len = reply.getData().getUInt8();
        if (len != 0) {
            reply.getData().position(reply.getData().position() + len);
        }
        GXDLMS.getDataFromBlock(reply.getData(), index);
    }

    private static void handleAccessResponse(GXDLMSSettings settings, GXReplyData reply) {
        long invokeId = reply.getData().getUInt32();
        int len = reply.getData().getUInt8();
        byte[] tmp = null;
        if (len != 0) {
            tmp = new byte[len];
            reply.getData().get(tmp);
            reply.setTime((GXDateTime)GXDLMSClient.changeType(tmp, DataType.DATETIME, settings));
        }
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(218);
            reply.getXml().appendLine(65320, null, (Object)reply.getXml().integerToHex(invokeId, 8));
            if (reply.getTime() != null) {
                reply.getXml().appendComment(reply.getTime().toString());
            }
            reply.getXml().appendLine(65314, "Value", (Object)GXCommon.toHex(tmp, false));
            reply.getData().getUInt8();
            len = GXCommon.getObjectCount(reply.getData());
            reply.getXml().appendStartTag(65333);
            reply.getXml().appendStartTag(65336, "Qty", reply.getXml().integerToHex(len, 2));
            for (int pos = 0; pos != len; ++pos) {
                if (reply.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML) {
                    reply.getXml().appendStartTag(6, (byte)0);
                }
                GXDataInfo di = new GXDataInfo();
                di.setXml(reply.getXml());
                GXCommon.getData(settings, reply.getData(), di);
                if (reply.getXml().getOutputType() != TranslatorOutputType.STANDARD_XML) continue;
                reply.getXml().appendEndTag(6, (byte)0);
            }
            reply.getXml().appendEndTag(65336);
            len = GXCommon.getObjectCount(reply.getData());
            reply.getXml().appendStartTag(65334, "Qty", reply.getXml().integerToHex(len, 2));
            for (int pos = 0; pos != len; ++pos) {
                byte type = (byte)reply.getData().getUInt8();
                short err = reply.getData().getUInt8();
                if (err != 0) {
                    err = reply.getData().getUInt8();
                }
                reply.getXml().appendStartTag(65335);
                reply.getXml().appendStartTag(218, type);
                reply.getXml().appendLine(65302, null, (Object)GXDLMSTranslator.errorCodeToString(reply.getXml().getOutputType(), ErrorCode.forValue(err)));
                reply.getXml().appendEndTag(218, type);
                reply.getXml().appendEndTag(65335);
            }
            reply.getXml().appendEndTag(65334);
            reply.getXml().appendEndTag(65333);
            reply.getXml().appendEndTag(218);
        } else {
            reply.getData().getUInt8();
        }
    }

    private static void handleDataNotification(GXDLMSSettings settings, GXReplyData reply) {
        int start = reply.getData().position() - 1;
        long invokeId = reply.getData().getUInt32();
        reply.setTime(null);
        short len = reply.getData().getUInt8();
        byte[] tmp = null;
        if (len != 0) {
            tmp = new byte[len];
            reply.getData().get(tmp);
            DataType dt = DataType.DATETIME;
            if (len == 4) {
                dt = DataType.TIME;
            } else if (len == 5) {
                dt = DataType.DATE;
            }
            GXDataInfo info = new GXDataInfo();
            info.setType(dt);
            Object ret = GXCommon.getData(settings, new GXByteBuffer(tmp), info);
            reply.setTime((GXDateTime)ret);
        }
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(15);
            reply.getXml().appendLine(65320, null, (Object)reply.getXml().integerToHex(invokeId, 8));
            if (reply.getTime() != null) {
                reply.getXml().appendComment(String.valueOf(reply.getTime()));
            }
            reply.getXml().appendLine(65314, null, (Object)GXCommon.toHex(tmp, false));
            reply.getXml().appendStartTag(65321);
            reply.getXml().appendStartTag(65328);
            GXDataInfo di = new GXDataInfo();
            di.setXml(reply.getXml());
            GXCommon.getData(settings, reply.getData(), di);
            reply.getXml().appendEndTag(65328);
            reply.getXml().appendEndTag(65321);
            reply.getXml().appendEndTag(15);
        } else {
            GXDLMS.getDataFromBlock(reply.getData(), start);
            GXDLMS.getValueFromData(settings, reply);
        }
    }

    static void handleSetResponse(GXDLMSSettings settings, GXReplyData data) {
        byte type = (byte)data.getData().getUInt8();
        data.setInvokeId(data.getData().getUInt8());
        GXDLMS.verifyInvokeId(settings, data);
        GXDLMS.addInvokeId(data.getXml(), 197, type, data.getInvokeId());
        if (type == 1) {
            data.setError(data.getData().getUInt8());
            if (data.getXml() != null) {
                data.getXml().appendLine(65302, "Value", (Object)GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(data.getError())));
            }
        } else if (type == 2) {
            long number = data.getData().getUInt32();
            if (data.getXml() != null) {
                data.getXml().appendLine(65298, "Value", (Object)data.getXml().integerToHex(number, 8));
            }
        } else if (type == 3) {
            data.setError(data.getData().getUInt8());
            long number = data.getData().getUInt32();
            if (data.getXml() != null) {
                data.getXml().appendLine(65302, "Value", (Object)GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(data.getError())));
                data.getXml().appendLine(65298, "Value", (Object)data.getXml().integerToHex(number, 8));
            }
        } else if (type == 5) {
            int cnt = GXCommon.getObjectCount(data.getData());
            if (data.getXml() != null) {
                data.getXml().appendStartTag(65302, "Qty", String.valueOf(cnt));
                for (int pos = 0; pos != cnt; ++pos) {
                    short err = data.getData().getUInt8();
                    data.getXml().appendLine(65379, "Value", (Object)GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(err)));
                }
                data.getXml().appendEndTag(65302);
            } else {
                for (int pos = 0; pos != cnt; ++pos) {
                    short err = data.getData().getUInt8();
                    if (data.getError() != 0 || err == 0) continue;
                    data.setError(err);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid data type.");
        }
        if (data.getXml() != null) {
            data.getXml().appendEndTag(197, type);
            data.getXml().appendEndTag(197);
        }
    }

    static void handleWriteResponse(GXReplyData data) {
        boolean standardXml;
        int cnt = GXCommon.getObjectCount(data.getData());
        boolean bl = standardXml = data.getXml() != null && data.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML;
        if (data.getXml() != null) {
            data.getXml().appendStartTag(13, "Qty", data.getXml().integerToHex(cnt, 2));
        }
        for (int pos = 0; pos != cnt; ++pos) {
            short ret = data.getData().getUInt8();
            if (standardXml) {
                data.getXml().appendStartTag(65319);
            }
            if (ret == 0) {
                if (data.getXml() != null) {
                    data.getXml().appendLine("<" + GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(ret)) + " />");
                }
            } else if (ret == 1) {
                ret = data.getData().getUInt8();
                if (data.getXml() != null) {
                    data.getXml().appendLine(65289, null, (Object)GXDLMSTranslator.errorCodeToString(data.getXml().getOutputType(), ErrorCode.forValue(ret)));
                } else {
                    data.setError(ret);
                }
            } else if (ret == 2) {
                data.setBlockNumber(data.getData().getUInt16());
                if (data.getXml() != null) {
                    data.getXml().appendLine(65298, null, (Object)data.getXml().integerToHex(data.getBlockNumber(), 4));
                }
            }
            if (!standardXml) continue;
            data.getXml().appendEndTag(65319);
        }
        if (data.getXml() != null) {
            data.getXml().appendEndTag(13);
        }
    }

    static void handleGetResponseWithList(GXDLMSSettings settings, GXReplyData reply) {
        short ch = 0;
        GXByteBuffer data = reply.getData();
        int cnt = GXCommon.getObjectCount(data);
        ArrayList<Object> values = new ArrayList<Object>(cnt);
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(65302, "Qty", reply.getXml().integerToHex(cnt, 2));
        }
        for (int pos = 0; pos != cnt; ++pos) {
            ch = data.getUInt8();
            if (ch != 0) {
                reply.setError(data.getUInt8());
                continue;
            }
            if (reply.getXml() != null) {
                GXDataInfo di = new GXDataInfo();
                di.setXml(reply.getXml());
                reply.getXml().appendStartTag(12, (byte)0);
                GXCommon.getData(settings, reply.getData(), di);
                reply.getXml().appendEndTag(12, (byte)0);
                continue;
            }
            reply.setReadPosition(reply.getData().position());
            GXDLMS.getValueFromData(settings, reply);
            if (reply.getValue() == null) {
                reply.setReadPosition(1 + reply.getReadPosition());
            }
            reply.getData().position(reply.getReadPosition());
            values.add(reply.getValue());
            reply.setValue(null);
        }
        reply.setValue(values);
    }

    private static void verifyInvokeId(GXDLMSSettings settings, GXReplyData reply) {
        if (reply.getXml() == null && settings.getAutoIncreaseInvokeID() && (byte)reply.getInvokeId() != GXDLMS.getInvokeIDPriority(settings, false)) {
            throw new RuntimeException(String.format("Invalid invoke ID. Expected: %s Actual: %s", Integer.toHexString(GXDLMS.getInvokeIDPriority(settings, false)), Long.toHexString(reply.getInvokeId())));
        }
    }

    private static boolean handleGetResponseNormal(GXDLMSSettings settings, GXReplyData reply, GXByteBuffer data) {
        boolean empty = false;
        if (data.available() == 0) {
            empty = true;
            GXDLMS.getDataFromBlock(data, 0);
        } else {
            short ch = data.getUInt8();
            if (ch != 0) {
                reply.setError(data.getUInt8());
            }
            if (reply.getXml() != null) {
                reply.getXml().appendStartTag(65302);
                if (reply.getError() != 0) {
                    reply.getXml().appendLine(65289, "Value", (Object)GXDLMSTranslator.errorCodeToString(reply.getXml().getOutputType(), ErrorCode.forValue(reply.getError())));
                } else {
                    reply.getXml().appendStartTag(65312);
                    GXDataInfo di = new GXDataInfo();
                    di.setXml(reply.getXml());
                    GXCommon.getData(settings, reply.getData(), di);
                    reply.getXml().appendEndTag(65312);
                }
            } else {
                GXDLMS.getDataFromBlock(data, 0);
            }
        }
        return empty;
    }

    private static boolean handleGetResponseNextDataBlock(GXDLMSSettings settings, GXReplyData reply, int index, GXByteBuffer data) {
        int blockLength;
        boolean ret = true;
        short ch = data.getUInt8();
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(65302);
            reply.getXml().appendLine(65297, "Value", (Object)reply.getXml().integerToHex(ch, 2));
        }
        if (ch == 0) {
            reply.getMoreData().add(RequestTypes.DATABLOCK);
        } else {
            reply.getMoreData().remove((Object)RequestTypes.DATABLOCK);
        }
        long number = data.getUInt32();
        if (reply.getXml() != null) {
            reply.getXml().appendLine(65298, "Value", (Object)reply.getXml().integerToHex(number, 8));
        } else {
            int expectedIndex;
            if (number != 1L && settings.getBlockIndex() == 1) {
                settings.setBlockIndex((int)number);
            }
            if (number != (long)(expectedIndex = settings.getBlockIndex())) {
                throw new IllegalArgumentException("Invalid Block number. It is " + number + " and it should be " + expectedIndex + ".");
            }
        }
        ch = data.getUInt8();
        if (ch != 0) {
            reply.setError(data.getUInt8());
        }
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(65302);
            if (reply.getError() != 0) {
                reply.getXml().appendLine(65379, "Value", (Object)GXDLMSTranslator.errorCodeToString(reply.getXml().getOutputType(), ErrorCode.forValue(reply.getError())));
            } else if (reply.getData().available() != 0) {
                blockLength = GXCommon.getObjectCount(data);
                if (!reply.getMoreData().contains((Object)RequestTypes.FRAME) && blockLength > data.size() - data.position()) {
                    reply.getXml().appendComment("Block is not complete." + String.valueOf(data.size() - data.position()) + "/" + String.valueOf(blockLength) + ".");
                }
                reply.getXml().appendLine(65299, "Value", (Object)GXCommon.toHex(reply.getData().getData(), false, data.position(), reply.getData().available()));
            }
            reply.getXml().appendEndTag(65302);
        } else if (data.position() != data.size()) {
            blockLength = GXCommon.getObjectCount(data);
            if (!reply.getMoreData().contains((Object)RequestTypes.FRAME)) {
                if (blockLength > data.size() - data.position()) {
                    throw new IllegalArgumentException("Invalid block length.");
                }
                reply.setCommand(0);
            }
            if (blockLength == 0) {
                data.size(index);
            } else {
                GXDLMS.getDataFromBlock(data, index);
            }
            if (reply.getMoreData().isEmpty() && !reply.getPeek()) {
                data.position(0);
                settings.resetBlockIndex();
            }
        }
        if (reply.getMoreData().isEmpty() && settings != null && settings.getCommand() == 192 && settings.getCommandType() == 3) {
            GXDLMS.handleGetResponseWithList(settings, reply);
            ret = false;
        }
        return ret;
    }

    static boolean handleGetResponse(GXDLMSSettings settings, GXReplyData reply, int index) {
        boolean ret = true;
        boolean empty = false;
        GXByteBuffer data = reply.getData();
        byte type = (byte)data.getUInt8();
        reply.setInvokeId(data.getUInt8());
        GXDLMS.verifyInvokeId(settings, reply);
        GXDLMS.addInvokeId(reply.getXml(), 196, type, reply.getInvokeId());
        switch (type) {
            case 1: {
                empty = GXDLMS.handleGetResponseNormal(settings, reply, data);
                break;
            }
            case 2: {
                ret = GXDLMS.handleGetResponseNextDataBlock(settings, reply, index, data);
                break;
            }
            case 3: {
                GXDLMS.handleGetResponseWithList(settings, reply);
                ret = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Get response.");
            }
        }
        if (reply.getXml() != null) {
            if (!empty) {
                reply.getXml().appendEndTag(65302);
            }
            reply.getXml().appendEndTag(196, type);
            reply.getXml().appendEndTag(196);
        }
        return ret;
    }

    private static void handleGbt(GXDLMSSettings settings, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        int index = data.getData().position() - 1;
        data.setWindowSize(settings.getGbtWindowSize());
        short bc = data.getData().getUInt8();
        data.setStreaming((bc & 0x40) != 0);
        byte windowSize = (byte)(bc & 0x3F);
        int bn = data.getData().getUInt16();
        int bna = data.getData().getUInt16();
        if (data.getXml() == null) {
            if (bn == 1) {
                index = 0;
            } else if (bna != settings.getBlockIndex() - 1) {
                data.getData().size(index);
                data.setCommand(0);
                return;
            }
        }
        data.setBlockNumber(bn);
        data.setBlockNumberAck(bna);
        settings.setBlockNumberAck(data.getBlockNumber());
        data.setCommand(0);
        int len = GXCommon.getObjectCount(data.getData());
        if (len > data.getData().size() - data.getData().position()) {
            data.setComplete(false);
            return;
        }
        if (data.getXml() != null) {
            if (data.getData().size() - data.getData().position() != len) {
                data.getXml().appendComment("Data length is " + String.valueOf(len) + " and there are " + String.valueOf(data.getData().size() - data.getData().position()) + " bytes.");
            }
            data.getXml().appendStartTag(224);
            if (data.getXml().isComments()) {
                data.getXml().appendComment("Last block: " + ((bc & 0x80) != 0));
                data.getXml().appendComment("Streaming: " + data.getStreaming());
                data.getXml().appendComment("Window size: " + windowSize);
            }
            data.getXml().appendLine(65381, null, (Object)data.getXml().integerToHex(bc, 2));
            data.getXml().appendLine(65298, null, (Object)data.getXml().integerToHex(data.getBlockNumber(), 4));
            data.getXml().appendLine(65382, null, (Object)data.getXml().integerToHex(data.getBlockNumberAck(), 4));
            if ((bc & 0x80) != 0 && data.getXml().isComments() && data.getData().available() != 0) {
                int pos = data.getData().position();
                int len2 = data.getXml().getXmlLength();
                try {
                    GXReplyData reply = new GXReplyData();
                    reply.setData(data.getData());
                    reply.setXml(data.getXml());
                    reply.getXml().startComment("");
                    GXDLMS.getPdu(settings, reply);
                    reply.getXml().endComment();
                }
                catch (Exception ex) {
                    data.getXml().setXmlLength(len2);
                }
                data.getData().position(pos);
            }
            data.getXml().appendLine(65383, null, (Object)GXCommon.toHex(data.getData().getData(), false, data.getData().position(), len));
            data.getXml().appendEndTag(224);
            return;
        }
        GXDLMS.getDataFromBlock(data.getData(), index);
        if ((bc & 0x80) == 0) {
            data.getMoreData().add(RequestTypes.GBT);
        } else {
            data.getMoreData().remove((Object)RequestTypes.GBT);
            if (data.getData().size() != 0) {
                data.getData().position(0);
                GXDLMS.getPdu(settings, data);
            }
            if (data.getData().position() != data.getData().size() && (data.getCommand() == 12 || data.getCommand() == 196) && (data.getMoreData().isEmpty() || data.getPeek())) {
                data.getData().position(0);
                GXDLMS.getValueFromData(settings, data);
            }
        }
    }

    public static void getPdu(GXDLMSSettings settings, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        int cmd;
        block54: {
            block53: {
                cmd = data.getCommand();
                if (data.getCommand() != 0) break block53;
                if (data.getData().size() - data.getData().position() == 0) {
                    throw new IllegalArgumentException("Invalid PDU.");
                }
                int index = data.getData().position();
                cmd = data.getData().getUInt8();
                data.setCommand(cmd);
                switch (cmd) {
                    case 12: {
                        if (!GXDLMS.handleReadResponse(settings, data, index)) {
                            return;
                        }
                        break block54;
                    }
                    case 196: {
                        if (!GXDLMS.handleGetResponse(settings, data, index)) {
                            return;
                        }
                        break block54;
                    }
                    case 197: {
                        GXDLMS.handleSetResponse(settings, data);
                        break;
                    }
                    case 13: {
                        GXDLMS.handleWriteResponse(data);
                        break;
                    }
                    case 199: {
                        GXDLMS.handleMethodResponse(settings, data, index);
                        break;
                    }
                    case 217: {
                        if (data.getXml() != null || !settings.isServer() && !data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                            GXDLMSLNCommandHandler.handleAccessRequest(settings, null, data.getData(), null, data.getXml(), 0);
                            break;
                        }
                        break block54;
                    }
                    case 218: {
                        GXDLMS.handleAccessResponse(settings, data);
                        break;
                    }
                    case 224: {
                        if (data.getXml() != null || !settings.isServer() && !data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                            GXDLMS.handleGbt(settings, data);
                            break;
                        }
                        break block54;
                    }
                    case 96: 
                    case 97: {
                        data.getData().position(data.getData().position() - 1);
                        break;
                    }
                    case 99: {
                        break;
                    }
                    case 14: {
                        GXDLMS.handleConfirmedServiceError(data);
                        break;
                    }
                    case 216: {
                        GXDLMS.handleExceptionResponse(data);
                        break;
                    }
                    case 192: {
                        if (data.getXml() != null || !settings.isServer() && !data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                            GXDLMSLNCommandHandler.handleGetRequest(settings, null, data.getData(), null, data.getXml(), 0);
                            break;
                        }
                        break block54;
                    }
                    case 5: 
                    case 6: 
                    case 98: 
                    case 193: 
                    case 195: {
                        if (data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                            break;
                        }
                        break block54;
                    }
                    case 37: 
                    case 38: 
                    case 200: 
                    case 201: 
                    case 203: 
                    case 208: 
                    case 209: 
                    case 211: {
                        GXDLMS.handleGloDedRequest(settings, data);
                        break;
                    }
                    case 44: 
                    case 45: 
                    case 202: 
                    case 204: 
                    case 205: 
                    case 207: 
                    case 210: 
                    case 212: 
                    case 213: 
                    case 215: {
                        GXDLMS.handleGloDedResponse(settings, data, index);
                        break;
                    }
                    case 219: 
                    case 220: {
                        if (settings.isServer()) {
                            GXDLMS.handleGloDedRequest(settings, data);
                            break;
                        }
                        GXDLMS.handleGloDedResponse(settings, data, index);
                        break;
                    }
                    case 223: {
                        if (settings.isServer()) {
                            GXDLMS.handleGloDedRequest(settings, data);
                            break;
                        }
                        GXDLMS.handleGloDedResponse(settings, data, index);
                        break;
                    }
                    case 15: {
                        GXDLMS.handleDataNotification(settings, data);
                        break;
                    }
                    case 194: {
                        break;
                    }
                    case 24: {
                        break;
                    }
                    case 221: {
                        GXDLMS.handleGeneralCiphering(settings, data);
                        break;
                    }
                    case 230: 
                    case 231: {
                        data.getData().getUInt8();
                        int len = GXCommon.getObjectCount(data.getData());
                        byte[] pda = new byte[len];
                        data.getData().get(pda);
                        GXDLMS.getDataFromBlock(data.getData(), index);
                        data.setCommand(0);
                        GXDLMS.getPdu(settings, data);
                        break;
                    }
                    case 26: 
                    case 28: 
                    case 29: 
                    case 30: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Command.");
                    }
                }
                break block54;
            }
            if (!data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                if (!data.getPeek() && data.getMoreData().isEmpty()) {
                    if (data.getCommand() == 97 || data.getCommand() == 96) {
                        data.getData().position(0);
                    } else {
                        data.getData().position(1);
                    }
                }
                if (cmd == 224) {
                    data.getData().position(data.getCipherIndex() + 1);
                    GXDLMS.handleGbt(settings, data);
                    data.setCipherIndex(data.getData().size());
                    data.setCommand(0);
                } else if (settings.isServer()) {
                    switch (cmd) {
                        case 37: 
                        case 38: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 221: 
                        case 223: {
                            data.setCommand(0);
                            data.getData().position(data.getCipherIndex());
                            GXDLMS.getPdu(settings, data);
                            break;
                        }
                    }
                } else {
                    if (data.isMoreData()) {
                        data.setCommand(0);
                    }
                    switch (cmd) {
                        case 44: 
                        case 45: 
                        case 204: 
                        case 205: 
                        case 207: 
                        case 212: 
                        case 213: 
                        case 215: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 223: {
                            data.setCommand(0);
                            data.getData().position(data.getCipherIndex());
                            GXDLMS.getPdu(settings, data);
                            break;
                        }
                    }
                    if (cmd == 12 && data.getTotalCount() > 1 && !GXDLMS.handleReadResponse(settings, data, 0)) {
                        return;
                    }
                }
            }
        }
        if (cmd == 12 && data.getCommandType() == 2 && data.getMoreData().contains((Object)RequestTypes.FRAME)) {
            return;
        }
        if (data.getError() == 0 && data.getXml() == null && data.getData().position() != data.getData().size() && (cmd == 12 || cmd == 196 || cmd == 199 || cmd == 15) && (data.getMoreData().isEmpty() || data.getPeek())) {
            GXDLMS.getValueFromData(settings, data);
        }
    }

    static void handleConfirmedServiceError(GXReplyData data) {
        if (data.getXml() != null) {
            data.getXml().appendStartTag(14);
            if (data.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML) {
                data.getData().getUInt8();
                data.getXml().appendStartTag(65346);
                ServiceError type = ServiceError.forValue(data.getData().getUInt8());
                String tag = TranslatorStandardTags.serviceErrorToString(type);
                String value = TranslatorStandardTags.getServiceErrorValue(type, (byte)data.getData().getUInt8());
                data.getXml().appendLine("x:" + tag, null, (Object)value);
                data.getXml().appendEndTag(65346);
            } else {
                data.getXml().appendLine(65344, "Value", (Object)data.getXml().integerToHex(data.getData().getUInt8(), 2));
                ServiceError type = ServiceError.forValue(data.getData().getUInt8());
                data.getXml().appendStartTag(65345);
                data.getXml().appendLine(TranslatorSimpleTags.serviceErrorToString(type), "Value", (Object)TranslatorSimpleTags.getServiceErrorValue(type, (byte)data.getData().getUInt8()));
                data.getXml().appendEndTag(65345);
            }
        } else {
            ConfirmedServiceError service = ConfirmedServiceError.forValue(data.getData().getUInt8());
            ServiceError type = ServiceError.forValue(data.getData().getUInt8());
            throw new GXDLMSConfirmedServiceError(service, type, data.getData().getUInt8());
        }
        data.getXml().appendEndTag(14);
    }

    static void handleExceptionResponse(GXReplyData data) {
        ExceptionStateError state = ExceptionStateError.forValue(data.getData().getUInt8());
        ExceptionServiceError error = ExceptionServiceError.forValue(data.getData().getUInt8());
        Long value = null;
        if (error == ExceptionServiceError.INVOCATION_COUNTER_ERROR && data.getData().available() > 3) {
            value = data.getData().getUInt32();
        }
        if (data.getXml() != null) {
            data.getXml().appendStartTag(216);
            if (data.getXml().getOutputType() == TranslatorOutputType.STANDARD_XML) {
                data.getXml().appendLine(65412, null, (Object)TranslatorStandardTags.stateErrorToString(state));
                data.getXml().appendLine(65345, null, (Object)TranslatorStandardTags.exceptionServiceErrorToString(error));
            } else {
                data.getXml().appendLine(65412, null, (Object)TranslatorSimpleTags.stateErrorToString(state));
                data.getXml().appendLine(65345, null, (Object)TranslatorSimpleTags.exceptionServiceErrorToString(error));
            }
        } else {
            throw new GXDLMSExceptionResponse(state, error, value);
        }
        data.getXml().appendEndTag(216);
    }

    private static void handleGloDedRequest(GXDLMSSettings settings, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (data.getXml() != null) {
            data.getData().position(data.getData().position() - 1);
        } else {
            if (settings.getCipher() == null) {
                throw new IllegalArgumentException("Secure connection is not supported.");
            }
            if (!data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                data.getData().position(data.getData().position() - 1);
                GXICipher cipher = settings.getCipher();
                AesGcmParameter p = data.getCommand() == 220 ? new AesGcmParameter(settings, settings.getSourceSystemTitle(), cipher.getDedicatedKey(), GXDLMS.getAuthenticationKey(settings)) : (data.getCommand() == 219 ? new AesGcmParameter(settings, settings.getSourceSystemTitle(), GXDLMS.getBlockCipherKey(settings), GXDLMS.getAuthenticationKey(settings)) : (cipher.getDedicatedKey() == null || GXDLMS.isGloMessage(data.getCommand()) ? new AesGcmParameter(settings, settings.getSourceSystemTitle(), GXDLMS.getBlockCipherKey(settings), GXDLMS.getAuthenticationKey(settings)) : new AesGcmParameter(settings, settings.getSourceSystemTitle(), cipher.getDedicatedKey(), GXDLMS.getAuthenticationKey(settings))));
                byte[] tmp = GXCiphering.decrypt(settings.getCipher(), p, data.getData());
                cipher.setSecuritySuite(p.getSecuritySuite());
                cipher.setSecurity(p.getSecurity());
                data.getData().clear();
                data.getData().set(tmp);
                data.setCipheredCommand(data.getCommand());
                data.setCommand(data.getData().getUInt8());
                if (data.getCommand() == 15 || data.getCommand() == 24) {
                    data.setCommand(0);
                    data.getData().position(data.getData().position() - 1);
                    GXDLMS.getPdu(settings, data);
                }
            } else {
                data.getData().position(data.getData().position() - 1);
            }
        }
    }

    private static void handleGloDedResponse(GXDLMSSettings settings, GXReplyData data, int index) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (data.getXml() != null) {
            data.getData().position(data.getData().position() - 1);
        } else {
            if (settings.getCipher() == null) {
                throw new IllegalArgumentException("Secure connection is not supported.");
            }
            if (!data.getMoreData().contains((Object)RequestTypes.FRAME)) {
                data.getData().position(data.getData().position() - 1);
                GXByteBuffer bb = new GXByteBuffer(data.getData());
                data.getData().position(index);
                data.getData().size(index);
                AesGcmParameter p = settings.getCipher().getDedicatedKey() != null && settings.getConnected() == 2 ? new AesGcmParameter(settings, settings.getSourceSystemTitle(), settings.getCipher().getDedicatedKey(), GXDLMS.getAuthenticationKey(settings)) : (settings.getPreEstablishedSystemTitle() != null && (settings.getConnected() & 2) == 0 ? new AesGcmParameter(settings, settings.getPreEstablishedSystemTitle(), GXDLMS.getBlockCipherKey(settings), GXDLMS.getAuthenticationKey(settings)) : new AesGcmParameter(settings, settings.getSourceSystemTitle(), GXDLMS.getBlockCipherKey(settings), GXDLMS.getAuthenticationKey(settings)));
                data.getData().set(GXCiphering.decrypt(settings.getCipher(), p, bb));
                data.setCipheredCommand(data.getCommand());
                data.setCommand(0);
                if (!settings.isDecryptOnly()) {
                    GXDLMS.getPdu(settings, data);
                    data.setCipherIndex(data.getData().size());
                } else {
                    data.setCipherIndex(data.getCipherIndex() + bb.position());
                }
            }
        }
    }

    private static void handleGeneralCiphering(GXDLMSSettings settings, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (settings.getCipher() == null) {
            throw new IllegalArgumentException("Secure connection is not supported.");
        }
        if (!data.getMoreData().contains((Object)RequestTypes.FRAME)) {
            int origPos = 0;
            if (data.getXml() != null) {
                origPos = data.getXml().getXmlLength();
            }
            data.getData().position(data.getData().position() - 1);
            AesGcmParameter p = new AesGcmParameter(settings, settings.getSourceSystemTitle(), GXDLMS.getBlockCipherKey(settings), GXDLMS.getAuthenticationKey(settings));
            p.setXml(data.getXml());
            try {
                byte[] tmp = GXCiphering.decrypt(settings.getCipher(), p, data.getData());
                data.getData().clear();
                data.getData().set(tmp);
                data.setCipheredCommand(221);
                data.setCommand(0);
                if (p.getSecurity() != null) {
                    GXDLMS.getPdu(settings, data);
                }
            }
            catch (Exception ex) {
                if (data.getXml() == null) {
                    Logger.getLogger(GXSecure.class.getName()).log(Level.SEVERE, "handleGeneralCiphering failed. {0}", ex.getMessage());
                    throw ex;
                }
                data.getXml().setXmlLength(origPos);
            }
            if (data.getXml() != null) {
                data.getXml().appendStartTag(221);
                data.getXml().appendLine(65350, null, (Object)data.getXml().integerToHex(p.getInvocationCounter(), 16, true));
                data.getXml().appendLine(65351, null, (Object)GXCommon.toHex(p.getSystemTitle(), false));
                data.getXml().appendLine(65352, null, (Object)GXCommon.toHex(p.getRecipientSystemTitle(), false));
                data.getXml().appendLine(65314, null, (Object)GXCommon.toHex(p.getDateTime(), false));
                data.getXml().appendLine(65353, null, (Object)GXCommon.toHex(p.getOtherInformation(), false));
                data.getXml().appendStartTag(65360);
                data.getXml().appendStartTag(65361);
                data.getXml().appendLine(65362, null, (Object)data.getXml().integerToHex(p.getKeyParameters(), 2, true));
                data.getXml().appendLine(65363, null, (Object)GXCommon.toHex(p.getKeyCipheredData(), false));
                data.getXml().appendEndTag(65361);
                data.getXml().appendEndTag(65360);
                data.getXml().appendLine(65364, null, (Object)GXCommon.toHex(p.getCipheredContent(), false));
                data.getXml().appendEndTag(221);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getValueFromData(GXDLMSSettings settings, GXReplyData reply) {
        GXByteBuffer data = reply.getData();
        GXDataInfo info = new GXDataInfo();
        if (reply.getValue() instanceof List) {
            info.setType(DataType.ARRAY);
            info.setCount(reply.getTotalCount());
            info.setIndex(reply.getCount());
        }
        int index = data.position();
        data.position(reply.getReadPosition());
        try {
            Object value = GXCommon.getData(settings, data, info);
            if (value != null) {
                if (!(value instanceof List)) {
                    reply.setValueType(info.getType());
                    reply.setValue(value);
                    reply.setTotalCount(0);
                    reply.setReadPosition(data.position());
                } else {
                    if (!((List)value).isEmpty()) {
                        if (reply.getValue() == null) {
                            reply.setValue(value);
                        } else {
                            ((List)reply.getValue()).addAll((List)value);
                        }
                    }
                    reply.setReadPosition(data.position());
                    reply.setTotalCount(info.getCount());
                }
            } else if (info.isComplete() && reply.getCommand() == 15) {
                reply.setReadPosition(data.position());
            }
        }
        finally {
            data.position(index);
        }
        if (reply.getCommand() != 15 && info.isComplete() && reply.getMoreData().isEmpty()) {
            if (settings != null) {
                settings.resetBlockIndex();
            }
            data.position(0);
        }
    }

    public static boolean getData(GXDLMSSettings settings, GXByteBuffer reply, GXReplyData data, GXReplyData notify) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        short frame = 0;
        boolean isLast = true;
        boolean isNotify = false;
        GXReplyData target = data;
        switch (settings.getInterfaceType()) {
            case HDLC: 
            case HDLC_WITH_MODE_E: {
                frame = GXDLMS.getHdlcData(settings.isServer(), settings, reply, target, notify);
                boolean bl = isLast = (frame & 0x10) != 0;
                if (notify != null && (frame == 19 || frame == 3)) {
                    target = notify;
                    isNotify = true;
                }
                target.setFrameId(frame);
                break;
            }
            case WRAPPER: 
            case PRIME_DC_WRAPPER: {
                if (GXDLMS.getTcpData(settings, reply, target, notify) || notify == null) break;
                target = notify;
                isNotify = true;
                break;
            }
            case WIRELESS_MBUS: {
                GXDLMS.getWirelessMBusData(settings, reply, target);
                break;
            }
            case PDU: {
                target.setPacketLength(reply.size());
                target.setComplete(reply.size() != 0);
                break;
            }
            case PLC: {
                GXDLMS.getPlcData(settings, reply, data);
                break;
            }
            case PLC_HDLC: {
                frame = GXDLMS.getPlcHdlcData(settings, reply, data);
                break;
            }
            case WIRED_MBUS: {
                GXDLMS.getWiredMBusData(settings, reply, data);
                break;
            }
            case SMS: {
                if (GXDLMS.getSmsData(settings, reply, target, notify)) break;
                if (notify != null) {
                    target = notify;
                }
                isNotify = true;
                break;
            }
            case COAP: {
                if (GXDLMS.getCoAPData(settings, reply, target, notify)) break;
                if (notify != null) {
                    target = notify;
                }
                isNotify = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Interface type.");
            }
        }
        if (!target.isComplete()) {
            return false;
        }
        if (settings.getInterfaceType() != InterfaceType.PLC_HDLC) {
            GXDLMS.getDataFromFrame(reply, target, GXDLMS.useHdlc(settings.getInterfaceType()));
        }
        if (target.getXml() != null || (frame != 19 && frame != 3 || data.isMoreData()) && (frame & 1) != 0) {
            if (frame == 3 && data.isMoreData()) {
                boolean tmp = GXDLMS.getData(settings, reply, data, notify);
                data.getData().position(0);
                return tmp;
            }
            return true;
        }
        if (frame == 19 && !data.isMoreData()) {
            data.getData().position(0);
        }
        try {
            if (settings.getInterfaceType() == InterfaceType.COAP) {
                if (target.getMoreData().isEmpty()) {
                    target.getData().position(0);
                    GXDLMS.getPdu(settings, target);
                }
            } else {
                GXDLMS.getPdu(settings, target);
            }
        }
        catch (Exception ex) {
            if (!isNotify) {
                throw ex;
            }
            isLast = false;
            data.setCommand(0);
        }
        if (notify != null && !isNotify) {
            switch (target.getCommand()) {
                case 15: 
                case 24: 
                case 194: 
                case 202: 
                case 210: {
                    isNotify = true;
                    notify.setComplete(data.isComplete());
                    notify.getMoreData().addAll(data.getMoreData());
                    data.getMoreData().clear();
                    notify.setCommand(data.getCommand());
                    data.setCommand(0);
                    notify.setTime(data.getTime());
                    data.setTime(null);
                    notify.getData().set(data.getData());
                    data.getData().trim();
                    notify.setValue(data.getValue());
                    data.setValue(null);
                    break;
                }
            }
        }
        if (!isLast) {
            return GXDLMS.getData(settings, reply, data, notify);
        }
        return !isNotify;
    }

    private static void getDataFromFrame(GXByteBuffer reply, GXReplyData info, boolean hdlc) {
        GXByteBuffer data = info.getData();
        int offset = data.size();
        int cnt = info.getPacketLength() - reply.position();
        if (cnt != 0) {
            data.capacity(offset + cnt);
            data.set(reply.getData(), reply.position(), cnt);
            reply.position(reply.position() + cnt);
            if (hdlc) {
                reply.position(reply.position() + 3);
            }
        }
        data.position(offset);
    }

    private static int getDataFromBlock(GXByteBuffer data, int index) {
        if (data.size() == data.position()) {
            data.clear();
            return 0;
        }
        int len = data.position() - index;
        System.arraycopy(data.getData(), data.position(), data.getData(), data.position() - len, data.size() - data.position());
        data.position(data.position() - len);
        data.size(data.size() - len);
        return len;
    }

    static void getActionInfo(ObjectType objectType, int[] value, int[] count) {
        switch (objectType) {
            case ACTION_SCHEDULE: 
            case AUTO_ANSWER: 
            case AUTO_CONNECT: 
            case DATA: 
            case MAC_ADDRESS_SETUP: 
            case GPRS_SETUP: 
            case IEC_HDLC_SETUP: 
            case IEC_LOCAL_PORT_SETUP: 
            case IEC_TWISTED_PAIR_SETUP: 
            case MODEM_CONFIGURATION: 
            case PPP_SETUP: 
            case REGISTER_MONITOR: 
            case ZIG_BEE_SAS_STARTUP: 
            case ZIG_BEE_SAS_JOIN: 
            case SCHEDULE: 
            case STATUS_MAPPING: 
            case TCP_UDP_SETUP: 
            case ZIG_BEE_SAS_APS_FRAGMENTATION: 
            case UTILITY_TABLES: 
            case NONE: {
                value[0] = 0;
                count[0] = 0;
                break;
            }
            case IMAGE_TRANSFER: {
                value[0] = 64;
                count[0] = 4;
                break;
            }
            case ACTIVITY_CALENDAR: {
                value[0] = 80;
                count[0] = 1;
                break;
            }
            case ASSOCIATION_LOGICAL_NAME: {
                value[0] = 96;
                count[0] = 4;
                break;
            }
            case ASSOCIATION_SHORT_NAME: {
                value[0] = 32;
                count[0] = 8;
                break;
            }
            case CLOCK: {
                value[0] = 96;
                count[0] = 6;
                break;
            }
            case DEMAND_REGISTER: {
                value[0] = 72;
                count[0] = 2;
                break;
            }
            case EXTENDED_REGISTER: {
                value[0] = 56;
                count[0] = 1;
                break;
            }
            case IP4_SETUP: {
                value[0] = 96;
                count[0] = 3;
                break;
            }
            case MBUS_SLAVE_PORT_SETUP: {
                value[0] = 96;
                count[0] = 8;
                break;
            }
            case PROFILE_GENERIC: {
                value[0] = 88;
                count[0] = 4;
                break;
            }
            case REGISTER: {
                value[0] = 40;
                count[0] = 1;
                break;
            }
            case REGISTER_ACTIVATION: {
                value[0] = 48;
                count[0] = 3;
                break;
            }
            case REGISTER_TABLE: {
                value[0] = 40;
                count[0] = 2;
                break;
            }
            case SAP_ASSIGNMENT: 
            case SCRIPT_TABLE: {
                value[0] = 32;
                count[0] = 1;
                break;
            }
            case SPECIAL_DAYS_TABLE: {
                value[0] = 16;
                count[0] = 2;
                break;
            }
            case SECURITY_SETUP: {
                value[0] = 48;
                count[0] = 8;
                break;
            }
            case DISCONNECT_CONTROL: {
                value[0] = 32;
                count[0] = 2;
                break;
            }
            case PUSH_SETUP: {
                value[0] = 56;
                count[0] = 1;
                break;
            }
            case NTP_SETUP: {
                value[0] = 56;
                count[0] = 3;
                break;
            }
            default: {
                count[0] = 0;
                value[0] = 0;
            }
        }
    }

    static void parseSnrmUaResponse(GXByteBuffer data, GXDLMSSettings settings) {
        GXHdlcSettings limits = settings.getHdlcSettings();
        if (data.available() == 0) {
            limits.setMaxInfoTX(128);
            limits.setMaxInfoRX(128);
            limits.setWindowSizeTX(1);
            limits.setWindowSizeRX(1);
        } else {
            data.getUInt8();
            data.getUInt8();
            data.getUInt8();
            block11: while (data.position() < data.size()) {
                int val;
                short id = data.getUInt8();
                short len = data.getUInt8();
                switch (len) {
                    case 1: {
                        val = data.getUInt8();
                        break;
                    }
                    case 2: {
                        val = data.getUInt16();
                        break;
                    }
                    case 4: {
                        val = (int)data.getUInt32();
                        break;
                    }
                    default: {
                        throw new GXDLMSException("Invalid Exception.");
                    }
                }
                switch (id) {
                    case 6: {
                        limits.setMaxInfoTX(val);
                        if (!limits.isUseFrameSize()) continue block11;
                        byte[] secondaryAddress = GXDLMS.getHdlcAddressBytes(settings.getClientAddress(), 0);
                        limits.setMaxInfoTX(limits.getMaxInfoTX() + 10 + secondaryAddress.length);
                        continue block11;
                    }
                    case 5: {
                        limits.setMaxInfoRX(val);
                        continue block11;
                    }
                    case 8: {
                        limits.setWindowSizeTX(val);
                        continue block11;
                    }
                    case 7: {
                        limits.setWindowSizeRX(val);
                        continue block11;
                    }
                }
                throw new GXDLMSException("Invalid UA response.");
            }
        }
    }

    static void appendHdlcParameter(GXByteBuffer data, int value) {
        if (value < 256) {
            data.setUInt8(1);
            data.setUInt8(value);
        } else {
            data.setUInt8(2);
            data.setUInt16(value);
        }
    }

    protected static void addInvokeId(GXDLMSTranslatorStructure xml, int command, byte type, long invokeID) {
        if (xml != null) {
            xml.appendStartTag(command);
            xml.appendStartTag(command, type);
            if (xml.isComments()) {
                StringBuilder sb = new StringBuilder();
                if ((invokeID & 0x80L) != 0L) {
                    sb.append("Priority: HIGH ");
                } else {
                    sb.append("Priority: NORMAL ");
                }
                if ((invokeID & 0x40L) != 0L) {
                    sb.append("ServiceClass: CONFIRMED ");
                } else {
                    sb.append("ServiceClass: UN_CONFIRMED ");
                }
                sb.append("InvokeID: " + String.valueOf(invokeID & 0xFL));
                xml.appendComment(sb.toString());
            }
            xml.appendLine(65313, null, (Object)xml.integerToHex(invokeID, 2));
        }
    }
}

