/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSLimits;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXReplyData;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.IGXCryptoNotifier;
import gurux.dlms.IGXCustomObjectNotifier;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.GXDLMSPushSetup;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class GXDLMSNotify {
    private final GXDLMSSettings settings;

    public GXDLMSNotify(boolean useLogicalNameReferencing, int clientAddress, int serverAddress, InterfaceType interfaceType) {
        IGXCryptoNotifier notifier1 = this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null;
        IGXCustomObjectNotifier notifier2 = this instanceof IGXCustomObjectNotifier ? (IGXCustomObjectNotifier)((Object)this) : null;
        this.settings = new GXDLMSSettings(true, notifier1, notifier2);
        this.setUseLogicalNameReferencing(useLogicalNameReferencing);
        this.settings.setClientAddress(clientAddress);
        this.settings.setServerAddress(serverAddress);
        this.settings.setInterfaceType(interfaceType);
    }

    public final Set<Conformance> getConformance() {
        return this.settings.getNegotiatedConformance();
    }

    public final void setConformance(Set<Conformance> value) {
        this.settings.setNegotiatedConformance(value);
    }

    protected final void setCipher(GXICipher value) {
        this.settings.setCipher(value);
    }

    public final GXDLMSObjectCollection getObjects() {
        return this.settings.getObjects();
    }

    public final GXDLMSLimits getLimits() {
        return (GXDLMSLimits)this.settings.getHdlcSettings();
    }

    public final GXHdlcSettings getHdlcSettings() {
        return this.settings.getHdlcSettings();
    }

    public final int getMaxReceivePDUSize() {
        return this.settings.getMaxPduSize();
    }

    public final void setMaxReceivePDUSize(int value) {
        this.settings.setMaxPduSize(value);
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.settings.getUseLogicalNameReferencing();
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        this.settings.setUseLogicalNameReferencing(value);
    }

    public final Priority getPriority() {
        return this.settings.getPriority();
    }

    public final void setPriority(Priority value) {
        this.settings.setPriority(value);
    }

    public final ServiceClass getServiceClass() {
        return this.settings.getServiceClass();
    }

    public final void setServiceClass(ServiceClass value) {
        this.settings.setServiceClass(value);
    }

    public final int getInvokeID() {
        return this.settings.getInvokeID();
    }

    public final void setInvokeID(byte value) {
        this.settings.setInvokeID(value);
    }

    public final boolean getData(GXByteBuffer reply, GXReplyData data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return GXDLMS.getData(this.settings, reply, data, null);
    }

    public final void addData(GXDLMSObject obj, int index, GXByteBuffer buff) {
        ValueEventArgs e = new ValueEventArgs(this.settings, obj, index, 0, null);
        Object value = obj.getValue(this.settings, e);
        DataType dt = obj.getDataType(index);
        if (dt == DataType.NONE && value != null) {
            dt = GXDLMSConverter.getDLMSDataType(value);
        }
        GXCommon.setData(this.settings, buff, dt, value);
    }

    public final void addData(Object value, DataType type, GXByteBuffer buff) {
        GXCommon.setData(this.settings, buff, type, value);
    }

    public final byte[][] generateDataNotificationMessages(Date time, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.generateDataNotificationMessages(time, new GXByteBuffer(data));
    }

    public final byte[][] generateDataNotificationMessages(Date time, GXByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (this.getUseLogicalNameReferencing()) {
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 15, 0, null, data, 255, 0);
            if (time == null) {
                p.setTime(null);
            } else {
                p.setTime(new GXDateTime(time));
            }
            reply = GXDLMS.getLnMessages(p);
        } else {
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 15, 1, 0, data, null);
            reply = GXDLMS.getSnMessages(p);
        }
        if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.GENERAL_BLOCK_TRANSFER) && reply.size() != 1) {
            throw new IllegalArgumentException("Data is not fit to one PDU. Use general block transfer.");
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }

    public final byte[][] generateDataNotificationMessages(Date date, List<Map.Entry<GXDLMSObject, Integer>> objects) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (objects == null) {
            throw new IllegalArgumentException("objects");
        }
        GXByteBuffer buff = new GXByteBuffer();
        buff.setUInt8((byte)DataType.STRUCTURE.getValue());
        GXCommon.setObjectCount(objects.size(), buff);
        for (Map.Entry<GXDLMSObject, Integer> it : objects) {
            this.addData(it.getKey(), it.getValue(), buff);
        }
        return this.generateDataNotificationMessages(date, buff);
    }

    public final byte[][] generatePushSetupMessages(Date date, GXDLMSPushSetup push) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (push == null) {
            throw new IllegalArgumentException("push");
        }
        GXByteBuffer buff = new GXByteBuffer();
        buff.setUInt8((byte)DataType.STRUCTURE.getValue());
        GXCommon.setObjectCount(push.getPushObjectList().size(), buff);
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : push.getPushObjectList()) {
            this.addData(it.getKey(), it.getValue().getAttributeIndex(), buff);
        }
        return this.generateDataNotificationMessages(date, buff);
    }

    public final List<Map.Entry<GXDLMSObject, Integer>> parsePush(List<?> data) {
        ArrayList<Map.Entry<GXDLMSObject, Integer>> items = new ArrayList<Map.Entry<GXDLMSObject, Integer>>();
        if (data != null) {
            GXDLMSConverter c = new GXDLMSConverter();
            for (Object it : (List)data.get(0)) {
                List tmp = (List)it;
                int classID = ((Number)tmp.get(0)).intValue() & 0xFFFF;
                if (classID <= 0) continue;
                GXDLMSObject comp = this.getObjects().findByLN(ObjectType.forValue(classID), GXCommon.toLogicalName((byte[])tmp.get(1)));
                if (comp == null) {
                    comp = GXDLMSClient.createDLMSObject(this.settings, classID, 0, 0, tmp.get(1), null, 2);
                    this.settings.getObjects().add(comp);
                    c.updateOBISCodeInformation(comp);
                }
                if (comp.getClass() != GXDLMSObject.class) {
                    items.add(new GXSimpleEntry<GXDLMSObject, Integer>(comp, ((Number)tmp.get(2)).intValue()));
                    continue;
                }
                Logger.getLogger(GXDLMS.class.getName()).log(Level.INFO, "Unknown object: " + String.valueOf(classID) + " " + GXCommon.toLogicalName((byte[])tmp.get(1)));
            }
            boolean useUtc = this.settings != null ? this.settings.getUseUtc2NormalTime() : false;
            for (int pos = 0; pos < data.size(); ++pos) {
                DataType dt;
                GXDLMSObject obj = (GXDLMSObject)((Map.Entry)items.get(pos)).getKey();
                Object value = data.get(pos);
                int index = (Integer)((Map.Entry)items.get(pos)).getValue();
                if (value instanceof byte[] && (dt = obj.getUIDataType(index)) != DataType.NONE) {
                    value = GXDLMSClient.changeType((byte[])value, dt, useUtc);
                }
                ValueEventArgs e = new ValueEventArgs(this.settings, obj, index, 0, null);
                e.setValue(value);
                obj.setValue(this.settings, e);
                e.setValue(value);
                e = new ValueEventArgs(this.settings, (GXDLMSObject)((Map.Entry)items.get(pos)).getKey(), (int)((Integer)((Map.Entry)items.get(pos)).getValue()), 0, null);
                e.setValue(data.get(pos));
                ((GXDLMSObject)((Map.Entry)items.get(pos)).getKey()).setValue(this.settings, e);
            }
        }
        return items;
    }

    public final void parsePush(List<Map.Entry<GXDLMSObject, Integer>> objects, List<?> data) {
        if (data == null) {
            throw new IllegalArgumentException("Invalid push message.");
        }
        if (data.size() != objects.size()) {
            throw new IllegalArgumentException("Push arguments do not match.");
        }
        for (int pos = 0; pos < data.size(); ++pos) {
            DataType dt;
            GXDLMSObject obj = objects.get(pos).getKey();
            Object value = data.get(pos);
            int index = objects.get(pos).getValue();
            if (value instanceof byte[] && (dt = obj.getUIDataType(index)) != DataType.NONE) {
                value = GXDLMSClient.changeType((byte[])value, dt, this.settings.getUseUtc2NormalTime());
            }
            ValueEventArgs e = new ValueEventArgs(this.settings, obj, index, 0, null);
            e.setValue(value);
            obj.setValue(this.settings, e);
            e.setValue(value);
        }
    }

    public byte[][] generateReport(GXDateTime time, List<Map.Entry<GXDLMSObject, Integer>> list) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        List<byte[]> reply;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("list");
        }
        if (this.getUseLogicalNameReferencing() && list.size() != 1) {
            throw new IllegalArgumentException("Only one object can send with Event Notification request.");
        }
        GXByteBuffer buff = new GXByteBuffer();
        if (this.getUseLogicalNameReferencing()) {
            for (Map.Entry<GXDLMSObject, Integer> it : list) {
                buff.setUInt16(it.getKey().getObjectType().getValue());
                buff.set(GXCommon.logicalNameToBytes(it.getKey().getLogicalName()));
                buff.setUInt8(it.getValue());
                this.addData(it.getKey(), it.getValue(), buff);
            }
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, 194, 0, null, buff, 255, 0);
            p.setTime(time);
            reply = GXDLMS.getLnMessages(p);
        } else {
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, 24, list.size(), 255, null, buff);
            for (Map.Entry<GXDLMSObject, Integer> it : list) {
                buff.setUInt8(2);
                int sn = it.getKey().getShortName();
                buff.setUInt16(sn += (it.getValue() - 1) * 8);
            }
            GXCommon.setObjectCount(list.size(), buff);
            for (Map.Entry<GXDLMSObject, Integer> it : list) {
                this.addData(it.getKey(), it.getValue(), buff);
            }
            reply = GXDLMS.getSnMessages(p);
        }
        return (byte[][])reply.toArray((T[])new byte[0][0]);
    }
}

