/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

import java.util.HashMap;

public enum Unit {
    NONE(0),
    YEAR(1),
    MONTH(2),
    WEEK(3),
    DAY(4),
    HOUR(5),
    MINUTE(6),
    SECOND(7),
    PHASE_ANGLE_DEGREE(8),
    TEMPERATURE(9),
    LOCAL_CURRENCY(10),
    LENGTH(11),
    SPEED(12),
    VOLUME_CUBIC_METER(13),
    CORRECTED_VOLUME(14),
    VOLUME_FLUX_HOUR(15),
    CORRECTED_VOLUME_FLUX_HOUR(16),
    VOLUME_FLUX_DAY(17),
    CORRECTED_VOLUME_FLUX_DAY(18),
    VOLUME_LITER(19),
    MASS_KG(20),
    FORCE(21),
    ENERGY(22),
    PRESSURE_PASCAL(23),
    PRESSURE_BAR(24),
    ENERGY_JOULE(25),
    THERMAL_POWER(26),
    ACTIVE_POWER(27),
    APPARENT_POWER(28),
    REACTIVE_POWER(29),
    ACTIVE_ENERGY(30),
    APPARENT_ENERGY(31),
    REACTIVE_ENERGY(32),
    CURRENT(33),
    ELECTRICAL_CHARGE(34),
    VOLTAGE(35),
    ELECTRICAL_FIELD_STRENGTH(36),
    CAPACITY(37),
    RESISTANCE(38),
    RESISTIVITY(39),
    MAGNETIC_FLUX(40),
    INDUCTION(41),
    MAGNETIC(42),
    INDUCTIVITY(43),
    FREQUENCY(44),
    ACTIVE(45),
    REACTIVE(46),
    APPARENT(47),
    V260(48),
    A260(49),
    MASS_KG_PER_SECOND(50),
    CONDUCTANCE(51),
    KELVIN(52),
    RU2H(53),
    RI2H(54),
    CUBIC_METER_RV(55),
    PERCENTAGE(56),
    AMPERE_HOURS(57),
    ENERGY_PER_VOLUME(60),
    WOBBE(61),
    MOLE_PERCENT(62),
    MASS_DENSITY(63),
    PASCAL_SECOND(64),
    JOULE_KILOGRAM(65),
    PRESSURE_GRAM_PER_SQUARE_CENTIMETER(66),
    PRESSURE_ATMOSPHERE(67),
    SIGNAL_STRENGTH_MILLI_WATT(70),
    SIGNAL_STRENGTH_MICRO_VOLT(71),
    DB(72),
    INCH(128),
    FOOT(129),
    POUND(130),
    FAHRENHEIT(131),
    RANKINE(132),
    SQUARE_INCH(133),
    SQUARE_FOOT(134),
    ACRE(135),
    CUBIC_INCH(136),
    CUBIC_FOOT(137),
    ACRE_FOOT(138),
    GALLON_IMPERIAL(139),
    GALLON_US(140),
    POUND_FORCE(141),
    POUND_FORCE_PER_SQUARE_INCH(142),
    POUND_PER_CUBIC_FOOT(143),
    POUND_PER_FOOT_SECOND(144),
    SQUARE_FOOT_PER_SECOND(145),
    BRITISH_THERMAL_UNIT(146),
    THERM_EU(147),
    THERM_US(148),
    BRITISH_THERMAL_UNIT_PER_POUND(149),
    BRITISH_THERMAL_UNIT_PER_CUBIC_FOOT(150),
    CUBIC_FEET(151),
    FOOT_PER_SECOND(152),
    CUBIC_FOOT_PER_SECOND(153),
    CUBIC_FOOT_PER_MIN(154),
    CUBIC_FOOT_PER_HOUR(155),
    CUBIC_FOOT_PER_DAY(156),
    ACRE_FOOT_PER_SECOND(157),
    ACRE_FOOT_PER_MIN(158),
    ACRE_FOOT_PER_HOUR(159),
    ACRE_FOOT_PER_DAY(160),
    IMPERIAL_GALLON(161),
    IMPERIAL_GALLON_PER_SECOND(162),
    IMPERIAL_GALLON_PER_MIN(163),
    IMPERIAL_GALLON_PER_HOUR(164),
    IMPERIAL_GALLON_PER_DAY(165),
    US_GALLON(166),
    US_GALLON_PER_SECOND(167),
    US_GALLON_PER_MIN(168),
    US_GALLON_PER_HOUR(169),
    US_GALLON_PER_DAY(170),
    BRITISH_THERMAL_UNIT_PER_SECOND(171),
    BRITISH_THERMAL_UNIT_PER_MINUTE(172),
    BRITISH_THERMAL_UNIT_PER_HOUR(173),
    BRITISH_THERMAL_UNIT_PER_DAY(174),
    OTHER_UNIT(254),
    NO_UNIT(255);

    private int intValue;
    private static HashMap<Integer, Unit> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, Unit> getMappings() {
        Class<Unit> clazz = Unit.class;
        synchronized (Unit.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private Unit(int value) {
        this.intValue = value;
        Unit.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static Unit forValue(int value) {
        return Unit.getMappings().get(value);
    }

    public String toString() {
        String str;
        switch (Unit.forValue(this.intValue).ordinal()) {
            case 0: {
                str = "None";
                break;
            }
            case 1: {
                str = "Year";
                break;
            }
            case 2: {
                str = "Month";
                break;
            }
            case 3: {
                str = "Week";
                break;
            }
            case 4: {
                str = "Day";
                break;
            }
            case 5: {
                str = "Hour";
                break;
            }
            case 6: {
                str = "Minute";
                break;
            }
            case 7: {
                str = "Second";
                break;
            }
            case 8: {
                str = "PhaseAngle";
                break;
            }
            case 9: {
                str = "Temperature";
                break;
            }
            case 10: {
                str = "LocalCurrency";
                break;
            }
            case 11: {
                str = "Length";
                break;
            }
            case 12: {
                str = "Speed";
                break;
            }
            case 13: {
                str = "Volume Cubic Meter";
                break;
            }
            case 14: {
                str = "Corrected volume";
                break;
            }
            case 15: {
                str = "Volume flux hour";
                break;
            }
            case 16: {
                str = "Corrected volume flux hour";
                break;
            }
            case 17: {
                str = "Volume flux day";
                break;
            }
            case 18: {
                str = "Corrected volume flux day";
                break;
            }
            case 19: {
                str = "Volume liter";
                break;
            }
            case 20: {
                str = "Mass Kg";
                break;
            }
            case 21: {
                str = "Force";
                break;
            }
            case 22: {
                str = "Energy";
                break;
            }
            case 23: {
                str = "Pressure pascal";
                break;
            }
            case 24: {
                str = "Pressure Bar";
                break;
            }
            case 25: {
                str = "Energy joule";
                break;
            }
            case 26: {
                str = "Thermal power";
                break;
            }
            case 27: {
                str = "Active power";
                break;
            }
            case 28: {
                str = "Apparent power";
                break;
            }
            case 29: {
                str = "Reactive power";
                break;
            }
            case 30: {
                str = "Active energy";
                break;
            }
            case 31: {
                str = "Apparent energy";
                break;
            }
            case 32: {
                str = "Reactive energy";
                break;
            }
            case 33: {
                str = "Current";
                break;
            }
            case 34: {
                str = "ElectricalCharge";
                break;
            }
            case 35: {
                str = "Voltage";
                break;
            }
            case 36: {
                str = "Electrical field strength E V/m";
                break;
            }
            case 37: {
                str = "Capacity C farad C/V = As/V";
                break;
            }
            case 38: {
                str = "Resistance";
                break;
            }
            case 39: {
                str = "Resistivity";
                break;
            }
            case 40: {
                str = "Magnetic flux F weber Wb = Vs";
                break;
            }
            case 41: {
                str = "Induction T tesla Wb/m2";
                break;
            }
            case 42: {
                str = "Magnetic field strength H A/m";
                break;
            }
            case 43: {
                str = "Inductivity L henry H = Wb/A";
                break;
            }
            case 44: {
                str = "Frequency";
                break;
            }
            case 45: {
                str = "Active energy";
                break;
            }
            case 46: {
                str = "Reactive energy";
                break;
            }
            case 47: {
                str = "Apparent energy";
                break;
            }
            case 48: {
                str = "V260*60s";
                break;
            }
            case 49: {
                str = "A260*60s";
                break;
            }
            case 50: {
                str = "Mass";
                break;
            }
            case 51: {
                str = "Conductance siemens";
                break;
            }
            case 52: {
                str = "Kelvin";
                break;
            }
            case 53: {
                str = "RU2h";
                break;
            }
            case 54: {
                str = "RI2h";
                break;
            }
            case 55: {
                str = "Cubic meter RV";
                break;
            }
            case 56: {
                str = "Percentage";
                break;
            }
            case 57: {
                str = "Ampere hours";
                break;
            }
            case 58: {
                str = "Energy per volume";
                break;
            }
            case 59: {
                str = "Wobbe";
                break;
            }
            case 60: {
                str = "Mole percent";
                break;
            }
            case 61: {
                str = "Mass density";
                break;
            }
            case 62: {
                str = "Pascal second";
                break;
            }
            case 63: {
                str = "Joule kilogram";
                break;
            }
            case 64: {
                str = "Pressure, gram per square centimeter.";
                break;
            }
            case 65: {
                str = "Pressure, atmosphere.";
                break;
            }
            case 66: {
                str = "Signal strength, dB milliwatt";
                break;
            }
            case 67: {
                str = "Signal strength, dB microvolt";
                break;
            }
            case 68: {
                str = "dB";
                break;
            }
            case 69: {
                str = "Inch";
                break;
            }
            case 70: {
                str = "Foot";
                break;
            }
            case 71: {
                str = "Pound";
                break;
            }
            case 72: {
                str = "Fahrenheit";
                break;
            }
            case 73: {
                str = "Rankine";
                break;
            }
            case 74: {
                str = "Square inch";
                break;
            }
            case 75: {
                str = "Square foot";
                break;
            }
            case 76: {
                str = "Acre";
                break;
            }
            case 77: {
                str = "Cubic inch";
                break;
            }
            case 78: {
                str = "Cubic foot";
                break;
            }
            case 79: {
                str = "Acre foot";
                break;
            }
            case 80: {
                str = "Gallon Imperial";
                break;
            }
            case 81: {
                str = "GallonUS";
                break;
            }
            case 82: {
                str = "Pound force";
                break;
            }
            case 83: {
                str = "Pound force per square inch";
                break;
            }
            case 84: {
                str = "Pound per cubic foot";
                break;
            }
            case 85: {
                str = "Pound per foot second";
                break;
            }
            case 87: {
                str = "British thermal unit";
                break;
            }
            case 88: {
                str = "Therm EU";
                break;
            }
            case 89: {
                str = "Therm US";
                break;
            }
            case 90: {
                str = "British thermal unit per pound";
                break;
            }
            case 91: {
                str = "British thermal unit per cubic foot";
                break;
            }
            case 92: {
                str = "Cubic feet";
                break;
            }
            case 93: {
                str = "Foot per second";
                break;
            }
            case 95: {
                str = "Foot per min";
                break;
            }
            case 97: {
                str = "Foot per day";
                break;
            }
            case 98: {
                str = "Acre foot per second";
                break;
            }
            case 99: {
                str = "Acre foot per min";
                break;
            }
            case 100: {
                str = "Acre foot per hour";
                break;
            }
            case 101: {
                str = "Acre foot per day";
                break;
            }
            case 102: {
                str = "Imperial gallon";
                break;
            }
            case 103: {
                str = "Imperial gallon per second";
                break;
            }
            case 104: {
                str = "Imperial gallon per min";
                break;
            }
            case 105: {
                str = "Imperial gallon per hour";
                break;
            }
            case 106: {
                str = "Imperial gallon per day";
                break;
            }
            case 107: {
                str = "US Gallon";
                break;
            }
            case 108: {
                str = "US gallon per second";
                break;
            }
            case 109: {
                str = "US gallon per min";
                break;
            }
            case 110: {
                str = "US gallon per hour";
                break;
            }
            case 111: {
                str = "US gallon per day";
                break;
            }
            case 112: {
                str = "British thermal unit per second";
                break;
            }
            case 113: {
                str = "British thermal unit per min";
                break;
            }
            case 114: {
                str = "British thermal unit per hour";
                break;
            }
            case 115: {
                str = "British thermal unit per day";
                break;
            }
            case 116: {
                str = "Other unit";
                break;
            }
            case 117: {
                str = "NoUnit";
                break;
            }
            default: {
                str = "Unknown :" + String.valueOf(this.intValue);
            }
        }
        return str;
    }
}

