/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.internal;

import java.util.HashMap;

public enum CoAPOptionType {
    IF_MATCH(1),
    URI_HOST(3),
    E_TAG(4),
    IF_NONE_MATCH(5),
    URI_PORT(7),
    LOCATION_PATH(8),
    URI_PATH(11),
    CONTENT_FORMAT(12),
    MAX_AGE(14),
    URI_QUERY(15),
    ACCEPT(17),
    LOCATION_QUERY(20),
    BLOCK2(23),
    BLOCK1(27),
    PROXY_URI(35),
    PROXY_SCHEME(39),
    SIZE1(60);

    private int intValue;
    private static HashMap<Integer, CoAPOptionType> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, CoAPOptionType> getMappings() {
        if (mappings != null) return mappings;
        Class<CoAPOptionType> clazz = CoAPOptionType.class;
        synchronized (CoAPOptionType.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private CoAPOptionType(int value) {
        this.intValue = value;
        CoAPOptionType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static CoAPOptionType forValue(int value) {
        CoAPOptionType ret = CoAPOptionType.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid CoAP option type enum value.");
        }
        return ret;
    }
}

