/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.CreditConfiguration;
import gurux.dlms.objects.enums.CreditStatus;
import gurux.dlms.objects.enums.CreditType;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSCredit
extends GXDLMSObject
implements IGXDLMSBase {
    private int currentCreditAmount;
    private CreditType type;
    private byte priority;
    private int warningThreshold;
    private int limit;
    private Set<CreditConfiguration> creditConfiguration = new HashSet<CreditConfiguration>();
    private CreditStatus status;
    private int presetCreditAmount;
    private int creditAvailableThreshold;
    private GXDateTime period;

    public GXDLMSCredit() {
        this("0.0.19.10.0.255", 0);
    }

    public GXDLMSCredit(String ln) {
        this(ln, 0);
    }

    public GXDLMSCredit(String ln, int sn) {
        super(ObjectType.CREDIT, ln, sn);
        this.type = CreditType.TOKEN;
        this.status = CreditStatus.ENABLED;
    }

    public final int getCurrentCreditAmount() {
        return this.currentCreditAmount;
    }

    public final void setCurrentCreditAmount(int value) {
        this.currentCreditAmount = value;
    }

    public final CreditType getType() {
        return this.type;
    }

    public final void setType(CreditType value) {
        this.type = value;
    }

    public final byte getPriority() {
        return this.priority;
    }

    public final void setPriority(byte value) {
        this.priority = value;
    }

    public final int getWarningThreshold() {
        return this.warningThreshold;
    }

    public final void setWarningThreshold(int value) {
        this.warningThreshold = value;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int value) {
        this.limit = value;
    }

    public final Set<CreditConfiguration> getCreditConfiguration() {
        return this.creditConfiguration;
    }

    public final void setCreditConfiguration(Set<CreditConfiguration> value) {
        this.creditConfiguration = value;
    }

    public final CreditStatus getStatus() {
        return this.status;
    }

    public final void setStatus(CreditStatus value) {
        this.status = value;
    }

    public final int getPresetCreditAmount() {
        return this.presetCreditAmount;
    }

    public final void setPresetCreditAmount(int value) {
        this.presetCreditAmount = value;
    }

    public final int getCreditAvailableThreshold() {
        return this.creditAvailableThreshold;
    }

    public final void setCreditAvailableThreshold(int value) {
        this.creditAvailableThreshold = value;
    }

    public final GXDateTime getPeriod() {
        return this.period;
    }

    public final void setPeriod(GXDateTime value) {
        this.period = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.currentCreditAmount, this.type, this.priority, this.warningThreshold, this.limit, this.creditConfiguration, this.status, this.presetCreditAmount, this.creditAvailableThreshold, this.period};
    }

    public final byte[][] updateAmount(GXDLMSClient client, int value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, value, DataType.INT32);
    }

    public final byte[][] setAmountToValue(GXDLMSClient client, int value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, value, DataType.INT32);
    }

    public final byte[][] invokeCredit(GXDLMSClient client, CreditStatus value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, value.getValue(), DataType.UINT8);
    }

    @Override
    public byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.currentCreditAmount += ((Number)e.getValue()).intValue();
                break;
            }
            case 2: {
                this.currentCreditAmount = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                if (!this.creditConfiguration.contains((Object)CreditConfiguration.CONFIRMATION) || this.status != CreditStatus.SELECTABLE) break;
                this.status = CreditStatus.INVOKED;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 11;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.INT32;
            }
            case 3: {
                return DataType.ENUM;
            }
            case 4: {
                return DataType.UINT8;
            }
            case 5: {
                return DataType.INT32;
            }
            case 6: {
                return DataType.INT32;
            }
            case 7: {
                return DataType.BITSTRING;
            }
            case 8: {
                return DataType.ENUM;
            }
            case 9: {
                return DataType.INT32;
            }
            case 10: {
                return DataType.INT32;
            }
            case 11: {
                return DataType.OCTET_STRING;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.currentCreditAmount;
            }
            case 3: {
                return this.type.getValue();
            }
            case 4: {
                return this.priority;
            }
            case 5: {
                return this.warningThreshold;
            }
            case 6: {
                return this.limit;
            }
            case 7: {
                return new GXBitString(CreditConfiguration.toInteger(this.creditConfiguration), 5);
            }
            case 8: {
                return this.status.getValue();
            }
            case 9: {
                return this.presetCreditAmount;
            }
            case 10: {
                return this.creditAvailableThreshold;
            }
            case 11: {
                return this.period;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.currentCreditAmount = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                this.type = CreditType.forValue(((Number)e.getValue()).intValue());
                break;
            }
            case 4: {
                this.priority = ((Number)e.getValue()).byteValue();
                break;
            }
            case 5: {
                this.warningThreshold = ((Number)e.getValue()).intValue();
                break;
            }
            case 6: {
                this.limit = ((Number)e.getValue()).intValue();
                break;
            }
            case 7: {
                this.creditConfiguration = CreditConfiguration.forValue(((GXBitString)e.getValue()).toInteger());
                break;
            }
            case 8: {
                this.status = CreditStatus.forValue(((Number)e.getValue()).intValue());
                break;
            }
            case 9: {
                this.presetCreditAmount = ((Number)e.getValue()).intValue();
                break;
            }
            case 10: {
                this.creditAvailableThreshold = ((Number)e.getValue()).intValue();
                break;
            }
            case 11: {
                if (e.getValue() == null) {
                    this.period = new GXDateTime();
                    break;
                }
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.period = tmp;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.currentCreditAmount = reader.readElementContentAsInt("CurrentCreditAmount");
        this.type = CreditType.forValue(reader.readElementContentAsInt("Type"));
        this.priority = (byte)reader.readElementContentAsInt("Priority");
        this.warningThreshold = reader.readElementContentAsInt("WarningThreshold");
        this.limit = reader.readElementContentAsInt("Limit");
        this.creditConfiguration = CreditConfiguration.forValue(reader.readElementContentAsInt("CreditConfiguration"));
        this.status = CreditStatus.forValue(reader.readElementContentAsInt("Status"));
        this.presetCreditAmount = reader.readElementContentAsInt("PresetCreditAmount");
        this.creditAvailableThreshold = reader.readElementContentAsInt("CreditAvailableThreshold");
        this.period = reader.readElementContentAsDateTime("Period");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("CurrentCreditAmount", this.currentCreditAmount);
        if (this.type != null) {
            writer.writeElementString("Type", this.type.getValue());
        }
        writer.writeElementString("Priority", this.priority);
        writer.writeElementString("WarningThreshold", this.warningThreshold);
        writer.writeElementString("Limit", this.limit);
        writer.writeElementString("CreditConfiguration", CreditConfiguration.toInteger(this.creditConfiguration));
        if (this.status != null) {
            writer.writeElementString("Status", this.status.getValue());
        }
        writer.writeElementString("PresetCreditAmount", this.presetCreditAmount);
        writer.writeElementString("CreditAvailableThreshold", this.creditAvailableThreshold);
        writer.writeElementString("Period", this.period);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "CurrentCreditAmount", "Type", "Priority", "WarningThreshold", "Limit", "CreditConfiguration", "Status", "PresetCreditAmount", "CreditAvailableThreshold", "Period"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Update amount", "Set amount to value", "Invoke credit"};
    }
}

